/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.resources;

import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.image.EXImageTooBig;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DecoratedImage {
    public Image baseImage;
    public Image decorator;
    public Alignment positionOnBase;
    public Alignment layoutDirection;
    public int offsetX;
    public int offsetY;

    public DecoratedImage(Image baseImage, Image decorator, Alignment position) {
        this.baseImage = baseImage;
        this.decorator = decorator;
        this.positionOnBase = position;
        this.layoutDirection = position.getInverse();
        this.offsetX = 0;
        this.offsetY = 0;
    }

    public DecoratedImage(Image baseImage, Image decorator, Alignment positionOnBase, Alignment layoutDirection, int offsetX, int offsetY) {
        this.baseImage = baseImage;
        this.decorator = decorator;
        this.positionOnBase = positionOnBase;
        this.layoutDirection = layoutDirection;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public boolean equals(Object obj) {
        DecoratedImage decoratedImage = (DecoratedImage)obj;
        return this.baseImage.equals((Object)decoratedImage.baseImage) && this.decorator.equals((Object)decoratedImage.decorator) && this.positionOnBase.equalsAlignment(decoratedImage.positionOnBase) && this.layoutDirection.equalsAlignment(decoratedImage.layoutDirection) && this.offsetX == decoratedImage.offsetX && this.offsetY == decoratedImage.offsetY;
    }

    public int hashCode() {
        int hash = 0;
        hash = this.baseImage.hashCode();
        hash ^= this.decorator.hashCode();
        hash ^= this.positionOnBase.hashCodeEqualsAlignment();
        hash ^= this.layoutDirection.hashCodeEqualsAlignment();
        hash ^= Integer.valueOf(this.offsetX).hashCode();
        return hash ^= Integer.valueOf(this.offsetY).hashCode();
    }

    public static final Image createImage(Display display, DecoratedImage decoratedImage) {
        Image canvas;
        Image baseImage = decoratedImage.baseImage;
        Image decorator = decoratedImage.decorator;
        Alignment baseAlignment = decoratedImage.positionOnBase;
        int baseX = 0;
        int baseY = 0;
        if (baseAlignment.h == 2) {
            baseX = baseImage.getBounds().width / 2;
        } else if (baseAlignment.h == 4) {
            baseX = baseImage.getBounds().width;
        }
        if (baseAlignment.v == 16) {
            baseY = baseImage.getBounds().height / 2;
        } else if (baseAlignment.v == 32) {
            baseY = baseImage.getBounds().height;
        }
        Alignment layoutDirection = decoratedImage.layoutDirection;
        int targetX = 0;
        int targetY = 0;
        if (layoutDirection.h == 1) {
            targetX = -decorator.getBounds().width;
        } else if (layoutDirection.h == 2) {
            targetX = -decorator.getBounds().width / 2;
        }
        if (layoutDirection.v == 8) {
            targetY = -decorator.getBounds().height;
        } else if (layoutDirection.v == 16) {
            targetY = -decorator.getBounds().height / 2;
        }
        int x = baseX + targetX + decoratedImage.offsetX;
        int y = baseY + targetY + decoratedImage.offsetY;
        try {
            canvas = SWTOffscreenBitmap.createSWTImage((Device)display, baseImage.getBounds().width, baseImage.getBounds().height, Color.TRANSPARENT);
        }
        catch (EXImageTooBig e) {
            return baseImage;
        }
        catch (EXNoMoreHandles e) {
            return baseImage;
        }
        GC gc = new GC((Drawable)canvas);
        gc.drawImage(baseImage, 0, 0);
        gc.drawImage(decorator, x, y);
        gc.dispose();
        Image decoratedSWTImage = new Image((Device)display, canvas.getImageData());
        canvas.dispose();
        return decoratedSWTImage;
    }
}

