/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.resources;

import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public class ColorConstant {
    public static final ColorConstant PLANTYPESELECTIONCOLOR_SELECTED_BACKGROUND = new ColorConstant(167, 190, 216);
    private static final HashMap<Device, HashMap<ColorConstant, Color>> colorMaps = new HashMap();
    private final int r;
    private final int g;
    private final int b;

    private ColorConstant(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.b;
        result = 31 * result + this.g;
        result = 31 * result + this.r;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorConstant other = (ColorConstant)obj;
        if (this.b != other.b) {
            return false;
        }
        if (this.g != other.g) {
            return false;
        }
        return this.r == other.r;
    }

    public static synchronized Color getColor(Device device, ColorConstant color) {
        Color deviceColor;
        HashMap<ColorConstant, Object> deviceColorMap = colorMaps.get(device);
        if (deviceColorMap == null) {
            deviceColorMap = new HashMap();
            colorMaps.put(device, deviceColorMap);
        }
        if ((deviceColor = deviceColorMap.get(color)) == null) {
            deviceColor = new Color(device, color.r, color.g, color.b);
            deviceColorMap.put(color, deviceColor);
        }
        assert (!device.isDisposed());
        return deviceColor;
    }
}

