/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.widgets.browser;

import com.arcway.lib.eclipse.gui.widgets.browser.BrowserSubstitute;
import com.arcway.lib.eclipse.gui.widgets.browser.BrowserWrapper;
import com.arcway.lib.eclipse.gui.widgets.browser.IBrowser;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;

public class BrowserFactory {
    private static final ILogger LOGGER = Logger.getLogger(BrowserFactory.class);
    private static final String TEST_HTML_PAGE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\r\n       \"http://www.w3.org/TR/html4/loose.dtd\">\r\n<html>\r\n<head>\r\n<title>Beschreibung der Seite</title>\r\n</head>\r\n<body>\r\nrudi\r\n</body>\r\n</html>";
    private static boolean browserWidgetUnuseable = false;

    public static synchronized IBrowser createBrowserOrSubstituteWidget(Composite parent, int style) {
        if (!browserWidgetUnuseable) {
            try {
                Browser browser = new Browser(parent, style);
                try {
                    browser.setText(TEST_HTML_PAGE);
                }
                catch (SWTError swte) {
                    try {
                        browser.dispose();
                    }
                    catch (Throwable th) {
                        LOGGER.debug("Problem while disposing unuseable Browser widget ", th);
                    }
                    throw swte;
                }
                return new BrowserWrapper(browser);
            }
            catch (SWTError swte) {
                if (swte.code == 2) {
                    LOGGER.debug("SWT Browser widget not useable due to missing or inappropriate browser installation");
                } else {
                    LOGGER.error((Throwable)swte);
                }
                browserWidgetUnuseable = true;
            }
        }
        return new BrowserSubstitute(parent, style | 2 | 0x200 | 0x100);
    }
}

