/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.widgets.attributemapping;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.AttributeMappingWidget;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValue;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingWidgetSettings_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IEnumerationValueCreator;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription_forEnumValueMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EnumValueMappingDialogue<SourceEnumValueKey, TargetEnumValueKey>
extends TitleAreaDialog {
    private final ISourceAttributeDescription_forEnumValueMapping<SourceEnumValueKey> sourceAttribute;
    private final ITargetAttributeDescription_forEnumValueMapping<TargetEnumValueKey> mappedTargetAttribute;
    private EnumValueMapping<SourceEnumValueKey, TargetEnumValueKey> enumValueMapping;
    private final IAttributeMappingWidgetSettings_forEnumValueMapping<SourceEnumValueKey, TargetEnumValueKey> settings;
    private final IEnumerationValueCreator<TargetEnumValueKey> enumValueCreator;
    private List<EnumValue<SourceEnumValueKey>> sourceEnumValueRange;
    private List<EnumValue<TargetEnumValueKey>> targetEnumValueRange;
    private String dlgMessage;
    private List<Combo> combos;
    private Point preferredContentSize;

    public EnumValueMappingDialogue(ISourceAttributeDescription_forEnumValueMapping<SourceEnumValueKey> sourceAttribute, ITargetAttributeDescription_forEnumValueMapping<TargetEnumValueKey> mappedTargetAttribute, EnumValueMapping<SourceEnumValueKey, TargetEnumValueKey> enumValueMapping, IAttributeMappingWidgetSettings_forEnumValueMapping<SourceEnumValueKey, TargetEnumValueKey> settings, IEnumerationValueCreator<TargetEnumValueKey> enumValueCreator, Shell shell) {
        super(shell);
        this.sourceAttribute = sourceAttribute;
        this.mappedTargetAttribute = mappedTargetAttribute;
        this.enumValueMapping = enumValueMapping;
        this.settings = settings;
        this.enumValueCreator = enumValueCreator;
        this.sourceEnumValueRange = sourceAttribute.getValueRange();
        this.targetEnumValueRange = mappedTargetAttribute.getValueRange();
    }

    protected Control createDialogArea(Composite parent) {
        parent.getShell().setText(this.settings.getShellTitleForEnumValueMappingDialogue());
        this.setTitle(this.settings.getTitleForEnumValueMappingDialogue());
        this.dlgMessage = NLS.bind((String)this.settings.getMessageForEnumValueMappingDialogue(), (Object)this.sourceAttribute.getName(), (Object)this.mappedTargetAttribute.getName());
        this.setMessage(this.dlgMessage);
        ScrolledComposite scroller = new ScrolledComposite(parent, 768);
        scroller.getVerticalBar().setIncrement(10);
        GridData baseData = new GridData(4, 4, true, true);
        scroller.setLayoutData((Object)baseData);
        Composite base = new Composite((Composite)scroller, 0);
        scroller.setContent((Control)base);
        GridLayout baseLayout = new GridLayout(2, false);
        baseLayout.marginWidth = 15;
        baseLayout.marginHeight = 15;
        baseLayout.verticalSpacing = 10;
        baseLayout.horizontalSpacing = 20;
        base.setLayout((Layout)baseLayout);
        AttributeMappingWidget.createColumnHeading(base, this.settings.getSourceEnumValuesName());
        AttributeMappingWidget.createColumnHeading(base, this.settings.getTargetEnumValuesName());
        this.combos = new ArrayList<Combo>(this.sourceEnumValueRange.size());
        for (EnumValue<SourceEnumValueKey> sourceEnumValue : this.sourceEnumValueRange) {
            Control dataPotEnumLabel = this.createSourceEnumValueLabel(base, sourceEnumValue);
            GridData dataPotEnumLabelGridData = new GridData(4, 2, false, false);
            dataPotEnumLabelGridData.minimumWidth = 30;
            dataPotEnumLabel.setLayoutData((Object)dataPotEnumLabelGridData);
            Combo valueDropDown = this.createTargetEnumValueDropDown(base, this.targetEnumValueRange);
            GridData valueDropDownGridData = new GridData(4, 2, false, false);
            valueDropDownGridData.minimumWidth = 30;
            valueDropDown.setLayoutData((Object)valueDropDownGridData);
            valueDropDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EnumValueMappingDialogue.this.check();
                }
            });
            this.combos.add(valueDropDown);
        }
        this.setComboSelections();
        if (this.mappedTargetAttribute.mayExtendValueRange()) {
            new Label(base, 0);
            new Label(base, 0);
            Button changeVRButton = new Button(base, 8);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            changeVRButton.setLayoutData((Object)data);
            changeVRButton.setText(this.settings.getLabelForCreateNewEnumValueButton());
            changeVRButton.setToolTipText(this.settings.getTooltipForCreateNewEnumValueButton());
            changeVRButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean createdNewValue = EnumValueMappingDialogue.this.enumValueCreator.createNewEnumValue(EnumValueMappingDialogue.this.mappedTargetAttribute, EnumValueMappingDialogue.this.getShell());
                    if (createdNewValue) {
                        EnumValueMappingDialogue.this.fillMapping(EnumValueMappingDialogue.this.getCurrentComboSelectionIndices());
                        EnumValueMappingDialogue.this.targetEnumValueRange = EnumValueMappingDialogue.this.mappedTargetAttribute.getValueRange();
                        for (Combo combo : EnumValueMappingDialogue.this.combos) {
                            combo.removeAll();
                            for (EnumValue possibleTargetEnumValue : EnumValueMappingDialogue.this.targetEnumValueRange) {
                                combo.add(possibleTargetEnumValue.getLabel());
                            }
                        }
                        EnumValueMappingDialogue.this.setComboSelections();
                        EnumValueMappingDialogue.this.check();
                    }
                }
            });
        }
        base.pack();
        base.layout();
        base.redraw();
        Point baseSize = base.computeSize(-1, -1);
        Point preferredScrollerSize = new Point(Math.max(baseSize.x, 250), Math.min(baseSize.y, 300));
        scroller.setExpandHorizontal(false);
        scroller.setExpandVertical(false);
        scroller.setMinSize(preferredScrollerSize);
        scroller.setOrigin(0, 0);
        this.preferredContentSize = preferredScrollerSize;
        return base;
    }

    protected Point getInitialSize() {
        Point preferredDialogueSize = new Point(this.preferredContentSize.x + 25, this.preferredContentSize.y + 150);
        return preferredDialogueSize;
    }

    public void create() {
        super.create();
        this.check();
    }

    private Control createSourceEnumValueLabel(Composite parent, EnumValue<SourceEnumValueKey> sourceEnumValue) {
        Label label = new Label(parent, 0);
        label.setText(sourceEnumValue.getLabel());
        String tooltip = sourceEnumValue.getTooltip();
        if (tooltip != null) {
            label.setToolTipText(tooltip);
        }
        return label;
    }

    private Combo createTargetEnumValueDropDown(Composite parent, List<EnumValue<TargetEnumValueKey>> possibleValues_) {
        Combo combo = new Combo(parent, 12);
        for (EnumValue<TargetEnumValueKey> possibleValue : possibleValues_) {
            combo.add(possibleValue.getLabel());
        }
        return combo;
    }

    private void check() {
        for (Combo combo : this.combos) {
            if (combo.getSelectionIndex() >= 0) continue;
            this.setMessage(Messages.getString("DiscreteEnumMappingDlg.ErrMissingMapping"), 3);
            this.getButton(0).setEnabled(false);
            return;
        }
        int sourceEnumValuesCount = this.sourceEnumValueRange.size();
        int targetEnumValuesCount = this.targetEnumValueRange.size();
        if (targetEnumValuesCount >= sourceEnumValuesCount) {
            HashSet<Integer> indices = new HashSet<Integer>(this.combos.size());
            for (Combo combo : this.combos) {
                indices.add(combo.getSelectionIndex());
            }
            if (indices.size() < sourceEnumValuesCount) {
                this.setMessage(Messages.getString("DiscreteEnumMappingDlg.WarnDouplMapping"), 2);
            } else {
                this.setMessage(this.dlgMessage);
            }
        } else {
            this.setMessage(this.dlgMessage);
        }
        this.getButton(0).setEnabled(true);
    }

    public EnumValueMapping<SourceEnumValueKey, TargetEnumValueKey> getEnumValueMapping() {
        return this.enumValueMapping;
    }

    private void setComboSelections() {
        int[] updatedSelectionIndices = this.getUpdatedComboSelectionIndices(this.getCurrentComboSelectionIndices());
        int comboIndex = 0;
        for (Combo combo : this.combos) {
            combo.select(updatedSelectionIndices[comboIndex]);
            ++comboIndex;
        }
    }

    private int[] getUpdatedComboSelectionIndices(int[] currentSelectionIndices) {
        EnumValue<SourceEnumValueKey> sourceEnumValue;
        int sourceEnumValueIndex;
        int[] updatedSelectionIndices = new int[currentSelectionIndices.length];
        System.arraycopy(currentSelectionIndices, 0, updatedSelectionIndices, 0, currentSelectionIndices.length);
        if (this.enumValueMapping != null) {
            sourceEnumValueIndex = 0;
            while (sourceEnumValueIndex < currentSelectionIndices.length) {
                sourceEnumValue = this.sourceEnumValueRange.get(sourceEnumValueIndex);
                Object mappedTargetEnumValueID = this.enumValueMapping.getByKey(sourceEnumValue.getId());
                if (mappedTargetEnumValueID != null) {
                    int possibleTargetEnumValueIndex = 0;
                    for (EnumValue<TargetEnumValueKey> possibleTargetEnumValue : this.targetEnumValueRange) {
                        if (this.settings.getTargetEnumValueKeyHasher().isEqual(possibleTargetEnumValue.getId(), mappedTargetEnumValueID)) {
                            updatedSelectionIndices[sourceEnumValueIndex] = possibleTargetEnumValueIndex;
                            break;
                        }
                        ++possibleTargetEnumValueIndex;
                    }
                }
                ++sourceEnumValueIndex;
            }
        }
        sourceEnumValueIndex = 0;
        while (sourceEnumValueIndex < currentSelectionIndices.length) {
            if (updatedSelectionIndices[sourceEnumValueIndex] < 0) {
                sourceEnumValue = this.sourceEnumValueRange.get(sourceEnumValueIndex);
                int possibleTargetEnumValueIndex = 0;
                for (EnumValue<TargetEnumValueKey> targetEnumValue : this.targetEnumValueRange) {
                    if (targetEnumValue.getCompareValue().equals(sourceEnumValue.getCompareValue())) {
                        updatedSelectionIndices[sourceEnumValueIndex] = possibleTargetEnumValueIndex;
                        break;
                    }
                    ++possibleTargetEnumValueIndex;
                }
            }
            ++sourceEnumValueIndex;
        }
        return updatedSelectionIndices;
    }

    protected void okPressed() {
        this.fillMapping(this.getCurrentComboSelectionIndices());
        super.okPressed();
    }

    private int[] getCurrentComboSelectionIndices() {
        int[] currentSelectionIndices = new int[this.combos.size()];
        int comboIndex = 0;
        for (Combo combo : this.combos) {
            currentSelectionIndices[comboIndex] = combo.getSelectionIndex();
            ++comboIndex;
        }
        return currentSelectionIndices;
    }

    private void fillMapping(int[] selectionIndices) {
        List<EnumValue<SourceEnumValueKey>> sourceValueRange = this.sourceEnumValueRange;
        int sourceValueRangeSize = sourceValueRange.size();
        this.enumValueMapping = new EnumValueMapping(sourceValueRangeSize, this.settings.getSourceEnumValueKeyHasher());
        int index = 0;
        while (index < sourceValueRangeSize) {
            int selectionIndex = selectionIndices[index];
            if (selectionIndex >= 0) {
                EnumValue<SourceEnumValueKey> sourceEnumValue = sourceValueRange.get(index);
                EnumValue<TargetEnumValueKey> selectedTargetEnumValue = this.targetEnumValueRange.get(selectionIndex);
                this.enumValueMapping.put(sourceEnumValue.getId(), selectedTargetEnumValue.getId());
            }
            ++index;
        }
    }

    public EnumValueMapping<SourceEnumValueKey, TargetEnumValueKey> updateEnumValueMapping() {
        this.sourceEnumValueRange = this.sourceAttribute.getValueRange();
        this.targetEnumValueRange = this.mappedTargetAttribute.getValueRange();
        int[] defaultSelectionIndices = new int[this.sourceEnumValueRange.size()];
        Arrays.fill(defaultSelectionIndices, -1);
        int[] updatedSelectionIndices = this.getUpdatedComboSelectionIndices(defaultSelectionIndices);
        this.fillMapping(updatedSelectionIndices);
        return this.getEnumValueMapping();
    }
}

