/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.widgets.attributemapping;

import com.arcway.lib.eclipse.gui.widgets.attributemapping.AttributeAndEnumValueMappings;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValue;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMappingDialogue;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingChangedListener;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingPersistencyHelper;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingWidgetSettings;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IAttributeMappingWidgetSettings_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.IEnumValueMappingPersistencyHelper;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeAndEnumerationValueCreator;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription_forEnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.SourceAttributeInfoWidget;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.memento.ArcwayMementoHelper;
import com.arcway.lib.memento.IArcwayMemento;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AttributeMappingWidget<SourceKey, SourceDataTypeKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> {
    private static final String MEMENTO_ID_ATTRIBUTEMAPPING = "ATTRIBUTE-MAPPING";
    private static final String MEMENTO_ID_ENUMVALUEMAPPINGS = "ENUM-VALUE-MAPPINGS";
    private final ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey> NO_MAPPING = new ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>(){

        @Override
        public TargetKey getKey() {
            return null;
        }

        @Override
        public TargetDataTypeKey getDataTypeKey() {
            return null;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean isAttributeMandatory() {
            return false;
        }

        @Override
        public boolean mayAttributeHaveMultipleMappings() {
            return false;
        }

        @Override
        public boolean isEnumType() {
            return false;
        }

        @Override
        public List<EnumValue<TargetEnumValueKey>> getValueRange() {
            return null;
        }

        @Override
        public boolean mayExtendValueRange() {
            return false;
        }
    };
    private final IList_<ISourceAttributeDescription<SourceKey, SourceDataTypeKey, SourceEnumValueKey>> sourceAttributes;
    private final IListRW_<ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> targetAttributes;
    private final IAttributeMappingPersistencyHelper<SourceKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> persistencyHelper;
    private final IAttributeMappingWidgetSettings<SourceKey, SourceDataTypeKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> settings;
    private final ITargetAttributeAndEnumerationValueCreator<SourceDataTypeKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> targetAttributeAndEnumerationValueCreator;
    private final IAttributeMappingChangedListener changeListener;
    private final IMapRW_<SourceKey, EnumValueMapping<SourceEnumValueKey, TargetEnumValueKey>> map_sourceAttribute_enumValueMapping;
    private final IMapRW_<SourceKey, ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> map_sourceAttribute_targetAttribute;
    private final IMapRW_<SourceKey, List<ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>>> map_sourceAttribute_appropriateTargetAttributes;
    private boolean initialised = false;
    private final IMapRW_<SourceKey, Combo> map_sourceAttribute_dropDown;
    private final IMapRW_<SourceKey, Button> map_sourceAttribute_mapEnumValuesButton;
    private ScrolledComposite scrollableBaseComposite;
    private Composite backgroundComposite;

    public AttributeMappingWidget(IList_<? extends ISourceAttributeDescription<SourceKey, SourceDataTypeKey, SourceEnumValueKey>> sourceAttributes, IList_<? extends ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> targetAttributes, IArcwayMemento memento, IAttributeMappingPersistencyHelper<SourceKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> persistencyHelper, IAttributeMappingChangedListener changeListener, IAttributeMappingWidgetSettings<SourceKey, SourceDataTypeKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> settings, ITargetAttributeAndEnumerationValueCreator<SourceDataTypeKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> targetAttributeAndEnumerationValueCreator) {
        this.targetAttributes = new ArrayList_(targetAttributes);
        this.sourceAttributes = new ArrayList_(sourceAttributes);
        this.persistencyHelper = persistencyHelper;
        this.settings = settings;
        this.targetAttributeAndEnumerationValueCreator = targetAttributeAndEnumerationValueCreator;
        this.changeListener = changeListener;
        this.map_sourceAttribute_enumValueMapping = new HashMap_(settings.getSourceKeyHasher());
        this.map_sourceAttribute_targetAttribute = new HashMap_(settings.getSourceKeyHasher());
        this.map_sourceAttribute_appropriateTargetAttributes = new HashMap_(settings.getSourceKeyHasher());
        this.map_sourceAttribute_dropDown = new HashMap_(settings.getSourceKeyHasher());
        this.map_sourceAttribute_mapEnumValuesButton = new HashMap_(settings.getSourceKeyHasher());
        if (memento != null) {
            this.loadMappingsFromMemento(memento);
        }
    }

    public Control createControl(Composite parent) {
        this.initialised = false;
        if (this.scrollableBaseComposite != null) {
            this.scrollableBaseComposite.dispose();
        }
        this.scrollableBaseComposite = new ScrolledComposite(parent, 768);
        this.scrollableBaseComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.backgroundComposite = new Composite((Composite)this.scrollableBaseComposite, 0);
        int columnCount = this.settings.mayCreateNewTargetAttributes() ? 4 : 3;
        GridLayout baseLayout = new GridLayout(columnCount, false);
        baseLayout.verticalSpacing = 10;
        baseLayout.horizontalSpacing = 20;
        baseLayout.marginWidth = 0;
        baseLayout.marginHeight = 0;
        baseLayout.marginRight = 5;
        this.backgroundComposite.setLayout((Layout)baseLayout);
        AttributeMappingWidget.createColumnHeading(this.backgroundComposite, this.settings.getSourceDataName());
        AttributeMappingWidget.createColumnHeading(this.backgroundComposite, this.settings.getTargetDataName());
        new Label(this.backgroundComposite, 0);
        if (this.settings.mayCreateNewTargetAttributes()) {
            new Label(this.backgroundComposite, 0);
        }
        for (ISourceAttributeDescription sourceAttribute : this.sourceAttributes) {
            this.createMappingWidgetForSourceAttribute(this.backgroundComposite, sourceAttribute, (IList_<ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>>)this.targetAttributes, this.settings.getAllowedMappings());
        }
        this.initialised = true;
        this.scrollableBaseComposite.setContent((Control)this.backgroundComposite);
        Point p = this.backgroundComposite.computeSize(-1, -1);
        p.x = p.x <= 600 ? p.x : 600;
        p.y = p.y <= 700 ? p.y : 700;
        this.scrollableBaseComposite.setMinSize(p);
        this.scrollableBaseComposite.setExpandHorizontal(true);
        this.scrollableBaseComposite.setExpandVertical(true);
        return this.scrollableBaseComposite;
    }

    private void createMappingWidgetForSourceAttribute(Composite parent, final ISourceAttributeDescription<SourceKey, SourceDataTypeKey, SourceEnumValueKey> sourceAttribute, IList_<ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> targetAttributes_, IMap_<SourceDataTypeKey, ISet_<TargetDataTypeKey>> allowedMappings_) {
        int index;
        SourceKey sourceAttributeKey = sourceAttribute.getKey();
        SourceAttributeInfoWidget sourceAttributeInfoWidget = new SourceAttributeInfoWidget(parent, sourceAttribute);
        sourceAttributeInfoWidget.setLayoutData(new GridData(4, 0, false, false));
        final Combo targetAttributesDropDown = new Combo(parent, 8);
        targetAttributesDropDown.setLayoutData((Object)new GridData(4, 0, true, false));
        final ArrayList<ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> appropriateTargetAttributes = new ArrayList<ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>>(targetAttributes_.size());
        for (ITargetAttributeDescription targetAttribute : targetAttributes_) {
            ISet_ allowedTargetDataTypes = (ISet_)allowedMappings_.getByKey(sourceAttribute.getDataTypeKey());
            if (allowedTargetDataTypes == null || !allowedTargetDataTypes.contains(targetAttribute.getDataTypeKey()) || this.doesSourceAttributeValueRangeContainEmptyValue(sourceAttribute) && targetAttribute.isAttributeMandatory() && !targetAttribute.isEnumType()) continue;
            appropriateTargetAttributes.add(targetAttribute);
        }
        this.map_sourceAttribute_appropriateTargetAttributes.put(sourceAttributeKey, appropriateTargetAttributes);
        targetAttributesDropDown.add("");
        for (ITargetAttributeDescription targetAttribute : appropriateTargetAttributes) {
            targetAttributesDropDown.add(targetAttribute.getName());
        }
        targetAttributesDropDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeMappingWidget.this.handleSelectionChangedForTargetAttributesDropDown(sourceAttribute, targetAttributesDropDown, appropriateTargetAttributes);
            }
        });
        this.map_sourceAttribute_dropDown.put(sourceAttributeKey, (Object)targetAttributesDropDown);
        if (this.settings.mayCreateNewTargetAttributes()) {
            this.createCustomPropertyButton(parent, sourceAttribute, appropriateTargetAttributes);
        }
        Button mapEnumValuesButton = this.getMapEnumValuesButton(this.backgroundComposite, sourceAttribute);
        mapEnumValuesButton.setLayoutData((Object)new GridData());
        mapEnumValuesButton.setEnabled(false);
        this.map_sourceAttribute_mapEnumValuesButton.put(sourceAttributeKey, (Object)mapEnumValuesButton);
        ITargetAttributeDescription configuredTargetAttribute = (ITargetAttributeDescription)this.map_sourceAttribute_targetAttribute.getByKey(sourceAttributeKey);
        if (configuredTargetAttribute != null && configuredTargetAttribute != this.NO_MAPPING && (index = this.indexOf(appropriateTargetAttributes, configuredTargetAttribute)) != -1) {
            targetAttributesDropDown.select(index + 1);
            this.handleSelectionChangedForTargetAttributesDropDown(sourceAttribute, targetAttributesDropDown, appropriateTargetAttributes);
        }
        if (targetAttributesDropDown.getSelectionIndex() <= 0 && configuredTargetAttribute != this.NO_MAPPING) {
            int appropriateAttributeIndex = 0;
            for (ITargetAttributeDescription appropriateAttribute : appropriateTargetAttributes) {
                if (appropriateAttribute.getName().equals(sourceAttribute.getName())) {
                    targetAttributesDropDown.select(appropriateAttributeIndex + 1);
                    this.map_sourceAttribute_targetAttribute.put(sourceAttributeKey, (Object)appropriateAttribute);
                    this.handleSelectionChangedForTargetAttributesDropDown(sourceAttribute, targetAttributesDropDown, appropriateTargetAttributes);
                    break;
                }
                ++appropriateAttributeIndex;
            }
        }
        if (targetAttributesDropDown.getSelectionIndex() <= 0) {
            this.map_sourceAttribute_targetAttribute.removeAsEntry(sourceAttributeKey);
        }
    }

    private void createCustomPropertyButton(final Composite parent, final ISourceAttributeDescription<SourceKey, SourceDataTypeKey, SourceEnumValueKey> sourceAttribute, final List<ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> appropriateTargetAttributes) {
        Button customPropertyButton = new Button(parent, 8);
        customPropertyButton.setText(this.settings.getLabelForCreateTargetAttributeButton());
        customPropertyButton.setToolTipText(this.settings.getTooltipForCreateTargetAttributeButton());
        final ISet_ possibleTargetDataTypes = (ISet_)this.settings.getAllowedMappings().getByKey(sourceAttribute.getDataTypeKey());
        customPropertyButton.setEnabled(this.targetAttributeAndEnumerationValueCreator.hasAttributeCreationPermission() && this.targetAttributeAndEnumerationValueCreator.canCreateTargetAttributeForDataTypes((ICollection_<TargetDataTypeKey>)possibleTargetDataTypes));
        customPropertyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITargetAttributeDescription newTargetAttribute = AttributeMappingWidget.this.targetAttributeAndEnumerationValueCreator.createTargetAttributeForDataTypes(possibleTargetDataTypes, parent.getShell());
                if (newTargetAttribute != null) {
                    AttributeMappingWidget.this.targetAttributes.add(newTargetAttribute);
                    for (ISourceAttributeDescription sourceAttributeInConsideration : AttributeMappingWidget.this.sourceAttributes) {
                        if (!((ISet_)AttributeMappingWidget.this.settings.getAllowedMappings().getByKey(sourceAttributeInConsideration.getDataTypeKey())).contains(newTargetAttribute.getDataTypeKey())) continue;
                        List appropriateTargetAttributesForSourceAttribute = (List)AttributeMappingWidget.this.map_sourceAttribute_appropriateTargetAttributes.getByKey(sourceAttributeInConsideration.getKey());
                        appropriateTargetAttributesForSourceAttribute.add(newTargetAttribute);
                        Combo combo = (Combo)AttributeMappingWidget.this.map_sourceAttribute_dropDown.getByKey(sourceAttributeInConsideration.getKey());
                        combo.add(newTargetAttribute.getName());
                    }
                    Combo currentDropDown = (Combo)AttributeMappingWidget.this.map_sourceAttribute_dropDown.getByKey(sourceAttribute.getKey());
                    currentDropDown.select(currentDropDown.getItemCount() - 1);
                    AttributeMappingWidget.this.map_sourceAttribute_targetAttribute.put(sourceAttribute.getKey(), newTargetAttribute);
                    AttributeMappingWidget.this.handleSelectionChangedForTargetAttributesDropDown(sourceAttribute, currentDropDown, appropriateTargetAttributes);
                    AttributeMappingWidget.this.changeListener.attributeMappingChanged();
                }
            }
        });
    }

    private Button getMapEnumValuesButton(Composite parent, final ISourceAttributeDescription<SourceKey, SourceDataTypeKey, SourceEnumValueKey> sourceAttribute) {
        Button mapEnumValuesButton = new Button(parent, 8);
        mapEnumValuesButton.setText(this.settings.getLabelForMapEnumValuesButton());
        mapEnumValuesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITargetAttributeDescription currentlyMappedTargetAttribute = (ITargetAttributeDescription)AttributeMappingWidget.this.map_sourceAttribute_targetAttribute.getByKey(sourceAttribute.getKey());
                EnumValueMappingDialogue valueMappingDialogue = new EnumValueMappingDialogue(sourceAttribute, currentlyMappedTargetAttribute, (EnumValueMapping)((Object)AttributeMappingWidget.this.map_sourceAttribute_enumValueMapping.getByKey(sourceAttribute.getKey())), AttributeMappingWidget.this.settings, AttributeMappingWidget.this.targetAttributeAndEnumerationValueCreator, AttributeMappingWidget.this.scrollableBaseComposite.getShell());
                if (valueMappingDialogue.open() == 0) {
                    AttributeMappingWidget.this.map_sourceAttribute_enumValueMapping.put(sourceAttribute.getKey(), valueMappingDialogue.getEnumValueMapping());
                    AttributeMappingWidget.this.changeListener.attributeMappingChanged();
                }
            }
        });
        return mapEnumValuesButton;
    }

    public ThreeTuple<Boolean, String, String> isAttributeMappingComplete() {
        if (!this.initialised) {
            return new ThreeTuple((Object)Boolean.FALSE, (Object)"Not yet initialised!", null);
        }
        return AttributeMappingWidget.isAttributeMappingComplete(this.map_sourceAttribute_targetAttribute, this.map_sourceAttribute_enumValueMapping, this.sourceAttributes, this.targetAttributes, this.settings, this.NO_MAPPING);
    }

    public static final <SourceKey, SourceDataTypeKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> ThreeTuple<Boolean, String, String> isAttributeMappingComplete(IMap_<SourceKey, ? extends ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> map_sourceAttribute_targetAttribute, IMap_<SourceKey, EnumValueMapping<SourceEnumValueKey, TargetEnumValueKey>> map_sourceAttribute_enumValueMapping, IList_<? extends ISourceAttributeDescription<SourceKey, SourceDataTypeKey, SourceEnumValueKey>> sourceAttributes, IList_<? extends ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> targetAttributes, IAttributeMappingWidgetSettings<SourceKey, SourceDataTypeKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> settings, ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey> NO_MAPPING) {
        ITargetAttributeDescription mappedTargetAttribute;
        String errMsg = null;
        String warningMsg = null;
        HashSet_ mappedExistingAttributes = new HashSet_(settings.getTargetKeyHasher());
        for (ISourceAttributeDescription sourceAttribute : sourceAttributes) {
            String warningForMapping;
            mappedTargetAttribute = (ITargetAttributeDescription)map_sourceAttribute_targetAttribute.getByKey(sourceAttribute.getKey());
            if (mappedTargetAttribute == null || mappedTargetAttribute == NO_MAPPING) continue;
            if (!mappedTargetAttribute.mayAttributeHaveMultipleMappings()) {
                Object targetKey = mappedTargetAttribute.getKey();
                if (mappedExistingAttributes.contains(targetKey)) {
                    errMsg = settings.getTextForSeveralSourceAttributesMappedToSameTargetAttributeError();
                    break;
                }
                mappedExistingAttributes.add(targetKey);
            }
            Object sourceDataTypeKey = sourceAttribute.getDataTypeKey();
            Object targetDataTypeKey = mappedTargetAttribute.getDataTypeKey();
            IMap_ warningMapForSourceDataType = (IMap_)settings.getWarningsForMappings().getByKey(sourceDataTypeKey);
            if (warningMapForSourceDataType == null || (warningForMapping = (String)warningMapForSourceDataType.getByKey(targetDataTypeKey)) == null) continue;
            warningForMapping = NLS.bind((String)warningForMapping, (Object)sourceAttribute.getName(), (Object)mappedTargetAttribute.getName());
            String string = warningMsg = warningMsg == null ? warningForMapping : String.valueOf(warningMsg) + "\n" + warningForMapping;
        }
        if (errMsg == null && settings.mustMapAllSourceAttributes()) {
            for (ISourceAttributeDescription sourceAttribute : sourceAttributes) {
                mappedTargetAttribute = (ITargetAttributeDescription)map_sourceAttribute_targetAttribute.getByKey(sourceAttribute.getKey());
                if (mappedTargetAttribute != null && mappedTargetAttribute != NO_MAPPING) continue;
                errMsg = NLS.bind((String)settings.getTextForNotAllSourceAttributesMappedError(), (Object)sourceAttribute.getName());
                break;
            }
        }
        if (errMsg == null) {
            for (ISourceAttributeDescription sourceAttribute : sourceAttributes) {
                ITargetAttributeDescription targetAttribute = (ITargetAttributeDescription)map_sourceAttribute_targetAttribute.getByKey(sourceAttribute.getKey());
                if (targetAttribute == null || targetAttribute == NO_MAPPING || !targetAttribute.isEnumType()) continue;
                EnumValueMapping valueMapping = (EnumValueMapping)((Object)map_sourceAttribute_enumValueMapping.getByKey(sourceAttribute.getKey()));
                if (valueMapping == null) {
                    errMsg = NLS.bind((String)settings.getTextForMissingEnumValueMappingError(), (Object)sourceAttribute.getName());
                    break;
                }
                int index = 0;
                for (EnumValue sourceEnumValue : sourceAttribute.getValueRange()) {
                    if (!valueMapping.containsKey(sourceEnumValue.getId())) {
                        errMsg = NLS.bind((String)settings.getTextForMissingEnumValueMappingError(), (Object)sourceAttribute.getName());
                    }
                    ++index;
                }
            }
        }
        if (errMsg == null) {
            for (ITargetAttributeDescription targetAttribute : targetAttributes) {
                Object attributeID;
                if (!targetAttribute.isAttributeMandatory() || mappedExistingAttributes.contains(attributeID = targetAttribute.getKey())) continue;
                errMsg = NLS.bind((String)settings.getTextForMandatoryTargetAttributeNotMappedError(), (Object)targetAttribute.getName());
            }
        }
        if (errMsg != null) {
            return new ThreeTuple((Object)Boolean.FALSE, errMsg, warningMsg);
        }
        return new ThreeTuple((Object)Boolean.TRUE, null, warningMsg);
    }

    public boolean isMappingConfiguredForTargetAttribute(TargetKey targetAttributeInQuestion) {
        for (ISourceAttributeDescription sourceAttribute : this.sourceAttributes) {
            ITargetAttributeDescription mappedTargetAttribute = (ITargetAttributeDescription)this.map_sourceAttribute_targetAttribute.getByKey(sourceAttribute.getKey());
            if (mappedTargetAttribute == null || mappedTargetAttribute == this.NO_MAPPING || !this.settings.getTargetKeyHasher().isEqual(mappedTargetAttribute.getKey(), targetAttributeInQuestion)) continue;
            return true;
        }
        return false;
    }

    public IMap_<SourceKey, ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> getAttributeMapping() {
        HashMap_ outputMap = new HashMap_(this.settings.getSourceKeyHasher());
        for (IEntry_ entry : this.map_sourceAttribute_targetAttribute) {
            Object sourceAttributeKey = entry.getKey();
            ITargetAttributeDescription mappedTargetAttribute = (ITargetAttributeDescription)entry.getValue();
            if (mappedTargetAttribute == this.NO_MAPPING) continue;
            outputMap.put(sourceAttributeKey, (Object)mappedTargetAttribute);
        }
        return outputMap;
    }

    public IMap_<SourceKey, EnumValueMapping<SourceEnumValueKey, TargetEnumValueKey>> getEnumerationMappings() {
        return this.map_sourceAttribute_enumValueMapping;
    }

    public static <SourceKey, SourceDataTypeKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> AttributeAndEnumValueMappings<SourceKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> loadAttributeMappingsFromMemento(IArcwayMemento memento, IList_<? extends ISourceAttributeDescription<SourceKey, SourceDataTypeKey, SourceEnumValueKey>> sourceAttributes, IList_<? extends ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> targetAttributes, IAttributeMappingWidgetSettings<SourceKey, SourceDataTypeKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> settings, IAttributeMappingPersistencyHelper<SourceKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> persistencyHelper, ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey> NO_MAPPING) {
        HashMap_ map_sourcekey_targetAttribute = new HashMap_(settings.getSourceKeyHasher());
        HashMap_ map_sourcekey_enumValueMapping = new HashMap_(settings.getSourceKeyHasher());
        AttributeAndEnumValueMappings attributeAndEnumValueMappings = new AttributeAndEnumValueMappings(map_sourcekey_targetAttribute, map_sourcekey_enumValueMapping);
        if (memento == null) {
            return attributeAndEnumValueMappings;
        }
        IArcwayMemento attributeMappingStore = memento.getChild(MEMENTO_ID_ATTRIBUTEMAPPING);
        if (attributeMappingStore == null) {
            return attributeAndEnumValueMappings;
        }
        IArcwayMemento enumValueMappingsStore = memento.getChild(MEMENTO_ID_ENUMVALUEMAPPINGS);
        if (enumValueMappingsStore == null) {
            return attributeAndEnumValueMappings;
        }
        for (ISourceAttributeDescription sourceAttribute : sourceAttributes) {
            IArcwayMemento enumValueMappingMemento;
            ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey> targetAttribute;
            IArcwayMemento sourceAttributeAssignment = persistencyHelper.getChildMementoForAttributeAssignment(attributeMappingStore, sourceAttribute.getKey());
            if (sourceAttributeAssignment == null || (targetAttribute = persistencyHelper.getTargetKeyOfMemento(sourceAttributeAssignment, (ICollection_<ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>>)targetAttributes, NO_MAPPING)) == null || targetAttribute != NO_MAPPING && !((ISet_)settings.getAllowedMappings().getByKey(sourceAttribute.getDataTypeKey())).contains(targetAttribute.getDataTypeKey())) continue;
            map_sourcekey_targetAttribute.put(sourceAttribute.getKey(), targetAttribute);
            if (targetAttribute == NO_MAPPING || !targetAttribute.isEnumType() || (enumValueMappingMemento = persistencyHelper.getChildMementoForEnumValueMapping(enumValueMappingsStore, sourceAttribute.getKey())) == null || !persistencyHelper.isMatchingTargetAttributeConstraintsForEnumValueMappingOfMemento(enumValueMappingMemento, targetAttribute)) continue;
            EnumValueMapping<SourceEnumValueKey, TargetEnumValueKey> enumValueMapping = AttributeMappingWidget.loadEnumValueMapping(enumValueMappingMemento, sourceAttribute, targetAttribute, settings, persistencyHelper);
            map_sourcekey_enumValueMapping.put(sourceAttribute.getKey(), enumValueMapping);
        }
        return attributeAndEnumValueMappings;
    }

    public static <SourceEnumValueKey, TargetEnumValueKey> EnumValueMapping<SourceEnumValueKey, TargetEnumValueKey> loadEnumValueMapping(IArcwayMemento enumValueMappingsStore, ISourceAttributeDescription_forEnumValueMapping<SourceEnumValueKey> sourceAttribute, ITargetAttributeDescription_forEnumValueMapping<TargetEnumValueKey> targetAttribute, IAttributeMappingWidgetSettings_forEnumValueMapping<SourceEnumValueKey, TargetEnumValueKey> settings, IEnumValueMappingPersistencyHelper<SourceEnumValueKey, TargetEnumValueKey> persistencyHelper) {
        EnumValueMapping enumValueMapping = new EnumValueMapping(settings.getSourceEnumValueKeyHasher());
        for (EnumValue<SourceEnumValueKey> sourceEnumValue : sourceAttribute.getValueRange()) {
            TargetEnumValueKey targetEnumValueKey;
            IArcwayMemento enumValueAssignment = persistencyHelper.getChildMementoForEnumValueAssignment(enumValueMappingsStore, sourceEnumValue.getId());
            if (enumValueAssignment == null || (targetEnumValueKey = persistencyHelper.getTargetEnumKeyOfMemento(enumValueAssignment, targetAttribute)) == null) continue;
            enumValueMapping.put(sourceEnumValue.getId(), targetEnumValueKey);
        }
        return enumValueMapping;
    }

    private void loadMappingsFromMemento(IArcwayMemento memento) {
        if (memento == null) {
            return;
        }
        AttributeAndEnumValueMappings<SourceKey, SourceEnumValueKey, TargetKey, TargetDataTypeKey, TargetEnumValueKey> attributeAndEnumValueMappings = AttributeMappingWidget.loadAttributeMappingsFromMemento(memento, this.sourceAttributes, this.targetAttributes, this.settings, this.persistencyHelper, this.NO_MAPPING);
        this.map_sourceAttribute_targetAttribute.clear();
        this.map_sourceAttribute_targetAttribute.addAll(attributeAndEnumValueMappings.getAttributeMap());
        this.map_sourceAttribute_enumValueMapping.clear();
        this.map_sourceAttribute_enumValueMapping.addAll(attributeAndEnumValueMappings.getEnumValueMappingMap());
    }

    public void save(IArcwayMemento memento) {
        if (memento == null) {
            return;
        }
        IArcwayMemento attributeMappingStore = ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)memento, (String)MEMENTO_ID_ATTRIBUTEMAPPING);
        for (IEntry_ entry : this.map_sourceAttribute_targetAttribute) {
            Object sourceAttributeKey = entry.getKey();
            ITargetAttributeDescription mappedTargetAttribute = (ITargetAttributeDescription)entry.getValue();
            IArcwayMemento mapping = this.persistencyHelper.createChildMementoForAttributeAssignment(attributeMappingStore, sourceAttributeKey);
            Object targetKey = null;
            if (mappedTargetAttribute != null && mappedTargetAttribute != this.NO_MAPPING) {
                targetKey = mappedTargetAttribute.getKey();
            }
            this.persistencyHelper.storeTargetKeyIntoMemento(mapping, targetKey);
        }
        IArcwayMemento enumValueMappingsStore = ArcwayMementoHelper.getOrCreateChild((IArcwayMemento)memento, (String)MEMENTO_ID_ENUMVALUEMAPPINGS);
        for (IEntry_ entry : this.map_sourceAttribute_enumValueMapping) {
            Object sourceAttributeKey = entry.getKey();
            EnumValueMapping enumValueMapping = (EnumValueMapping)((Object)this.map_sourceAttribute_enumValueMapping.getByKey(sourceAttributeKey));
            ITargetAttributeDescription mappedTargetAttribute = (ITargetAttributeDescription)this.map_sourceAttribute_targetAttribute.getByKey(sourceAttributeKey);
            if (mappedTargetAttribute == null || mappedTargetAttribute == this.NO_MAPPING) continue;
            IArcwayMemento enumValueMappingStore = this.persistencyHelper.createChildMementoForEnumValueMapping(enumValueMappingsStore, sourceAttributeKey);
            this.persistencyHelper.storeTargetAttributeConstraintsForEnumValueMappingIntoMemento(enumValueMappingStore, (ITargetAttributeDescription)this.map_sourceAttribute_targetAttribute.getByKey(sourceAttributeKey));
            AttributeMappingWidget.storeEnumValueMappingIntoMemento(enumValueMapping, enumValueMappingStore, this.persistencyHelper);
        }
    }

    public static final <SourceEnumValueKey_, TargetEnumValueKey_> void storeEnumValueMappingIntoMemento(EnumValueMapping<SourceEnumValueKey_, TargetEnumValueKey_> enumValueMapping, IArcwayMemento memento, IEnumValueMappingPersistencyHelper<SourceEnumValueKey_, TargetEnumValueKey_> persistencyHelper) {
        Iterator iterator = enumValueMapping.iterator();
        while (iterator.hasNext()) {
            IEntry_ enumValueMappingEntry = (IEntry_)iterator.next();
            Object sourceEnumValueKey = enumValueMappingEntry.getKey();
            Object targetEnumValueKey = enumValueMappingEntry.getValue();
            IArcwayMemento valueAssignment = persistencyHelper.createChildMementoForEnumValueAssignment(memento, sourceEnumValueKey);
            persistencyHelper.storeTargetEnumKeyIntoMemento(valueAssignment, targetEnumValueKey);
        }
    }

    public void dispose() {
        this.scrollableBaseComposite.dispose();
    }

    private void handleSelectionChangedForTargetAttributesDropDown(ISourceAttributeDescription<SourceKey, SourceDataTypeKey, SourceEnumValueKey> sourceAttribute, Combo targetAttributesDropDown, List<ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> appropriateTargetAttributes) {
        if (targetAttributesDropDown.getSelectionIndex() > 0) {
            ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey> mappedAttribute = appropriateTargetAttributes.get(targetAttributesDropDown.getSelectionIndex() - 1);
            this.map_sourceAttribute_targetAttribute.put(sourceAttribute.getKey(), mappedAttribute);
            Button mapEnumValuesButton = (Button)this.map_sourceAttribute_mapEnumValuesButton.getByKey(sourceAttribute.getKey());
            if (mappedAttribute.isEnumType()) {
                EnumValueMappingDialogue mapper = new EnumValueMappingDialogue(sourceAttribute, mappedAttribute, (EnumValueMapping)((Object)this.map_sourceAttribute_enumValueMapping.getByKey(sourceAttribute.getKey())), this.settings, this.targetAttributeAndEnumerationValueCreator, this.scrollableBaseComposite.getShell());
                EnumValueMapping updatedValueMapping = mapper.updateEnumValueMapping();
                this.map_sourceAttribute_enumValueMapping.put(sourceAttribute.getKey(), updatedValueMapping);
                mapEnumValuesButton.setEnabled(true);
            } else {
                mapEnumValuesButton.setEnabled(false);
            }
        } else {
            Button mapEnumValuesButton = (Button)this.map_sourceAttribute_mapEnumValuesButton.getByKey(sourceAttribute.getKey());
            mapEnumValuesButton.setEnabled(false);
            this.map_sourceAttribute_targetAttribute.put(sourceAttribute.getKey(), this.NO_MAPPING);
        }
        if (this.changeListener != null) {
            this.changeListener.attributeMappingChanged();
        }
    }

    private int indexOf(List<ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey>> targetAttributes_, ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey> wantedTargetAttribute) {
        int index = 0;
        for (ITargetAttributeDescription<TargetKey, TargetDataTypeKey, TargetEnumValueKey> targetAttribute : targetAttributes_) {
            if (this.settings.getTargetKeyHasher().isEqual(targetAttribute.getKey(), wantedTargetAttribute.getKey())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private boolean doesSourceAttributeValueRangeContainEmptyValue(ISourceAttributeDescription<SourceKey, SourceDataTypeKey, SourceEnumValueKey> sourceAttribute) {
        List<EnumValue<SourceEnumValueKey>> valueRange = sourceAttribute.getValueRange();
        if (valueRange != null) {
            for (EnumValue<SourceEnumValueKey> enumValue : valueRange) {
                if (enumValue.getCompareValue().length() != 0) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected static final void createColumnHeading(Composite parent, String label) {
        StyledText sourceAttributesColumnLabel = new StyledText(parent, 0);
        sourceAttributesColumnLabel.setText(label);
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = label.length();
        styleRange.fontStyle = 1;
        sourceAttributesColumnLabel.setStyleRange(styleRange);
        sourceAttributesColumnLabel.setBackground(parent.getDisplay().getSystemColor(22));
        GridData gridData = new GridData();
        gridData.heightHint = 30;
        sourceAttributesColumnLabel.setLayoutData((Object)gridData);
    }
}

