/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.viewers.filters;

import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ViewerFilterMultiplexer {
    private final StructuredViewer viewer;
    private final boolean retainTreeStructures;
    private final Set<String> contributorIDs;
    private final SetMap<String, ViewerFilter> filtersByContributor;
    private TreeRetainingFilterPostProcessor currentTreeRetainingFilterPostProcessor;
    private int viewerUpdateSuspendedCounter;

    public ViewerFilterMultiplexer(StructuredViewer viewer, boolean retainTreeStructures) {
        this.viewer = viewer;
        this.retainTreeStructures = retainTreeStructures;
        this.contributorIDs = new HashSet<String>();
        this.filtersByContributor = new SetMap();
        this.currentTreeRetainingFilterPostProcessor = null;
        this.viewerUpdateSuspendedCounter = 0;
    }

    public String registerContributor() {
        String id = UUIDGenerator.getUniqueID();
        while (this.contributorIDs.contains(id)) {
            id = UUIDGenerator.getUniqueID();
        }
        this.contributorIDs.add(id);
        return id;
    }

    public void addFilter(String contributorID, ViewerFilter filter) {
        this.filtersByContributor.add((Object)contributorID, (Object)filter);
        if (this.viewerUpdateSuspendedCounter == 0) {
            this.updateViewer();
        }
    }

    public void removeFilter(String contributorID, ViewerFilter filter) {
        this.filtersByContributor.remove((Object)contributorID, (Object)filter);
        if (this.viewerUpdateSuspendedCounter == 0) {
            this.updateViewer();
        }
    }

    public void setFilters(String contributorID, Collection<? extends ViewerFilter> filters) {
        this.filtersByContributor.remove((Object)contributorID);
        this.filtersByContributor.addAll((Object)contributorID, new HashSet<ViewerFilter>(filters));
        if (this.viewerUpdateSuspendedCounter == 0) {
            this.updateViewer();
        }
    }

    public void resetFilters(String contributorID) {
        this.filtersByContributor.remove((Object)contributorID);
        if (this.viewerUpdateSuspendedCounter == 0) {
            this.updateViewer();
        }
    }

    public synchronized void suspendViewerUpdates() {
        ++this.viewerUpdateSuspendedCounter;
    }

    public synchronized void resumeViewerUpdates() {
        --this.viewerUpdateSuspendedCounter;
        if (this.viewerUpdateSuspendedCounter == 0) {
            this.updateViewer();
        }
    }

    public void updateViewer() {
        Set<Object> allFilters = new HashSet<ViewerFilter>();
        for (String contributorID : this.filtersByContributor.keySet()) {
            allFilters.addAll(this.filtersByContributor.get((Object)contributorID));
        }
        if (this.retainTreeStructures && this.viewer.getContentProvider() instanceof ITreeContentProvider) {
            this.currentTreeRetainingFilterPostProcessor = new TreeRetainingFilterPostProcessor((ITreeContentProvider)this.viewer.getContentProvider(), allFilters);
            allFilters = Collections.singleton(this.currentTreeRetainingFilterPostProcessor);
        } else {
            this.currentTreeRetainingFilterPostProcessor = null;
        }
        this.viewer.setFilters(allFilters.toArray(new ViewerFilter[allFilters.size()]));
    }

    public void resetCaches() {
        if (this.currentTreeRetainingFilterPostProcessor != null) {
            this.currentTreeRetainingFilterPostProcessor.resetCache();
        }
    }

    private static class TreeRetainingFilterPostProcessor
    extends ViewerFilter {
        private final ITreeContentProvider contentProvider;
        private final Collection<ViewerFilter> filters;
        private final Map<Object, Boolean> filterResultCache;

        public TreeRetainingFilterPostProcessor(ITreeContentProvider contentProvider, Collection<ViewerFilter> filters) {
            this.contentProvider = contentProvider;
            this.filters = filters;
            this.filterResultCache = new HashMap<Object, Boolean>();
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Boolean filterResult = this.filterResultCache.get(element);
            if (filterResult == null) {
                boolean passesThroughItself = true;
                for (ViewerFilter filter : this.filters) {
                    if (filter.select(viewer, parentElement, element)) continue;
                    passesThroughItself = false;
                    break;
                }
                if (!passesThroughItself) {
                    Object[] childElements = this.contentProvider.getChildren(element);
                    if (childElements != null) {
                        Object[] objectArray = childElements;
                        int n = childElements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object childElement = objectArray[n2];
                            if (this.select(viewer, element, childElement)) {
                                filterResult = Boolean.TRUE;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (filterResult == null) {
                        filterResult = Boolean.FALSE;
                    }
                } else {
                    filterResult = Boolean.TRUE;
                }
                this.filterResultCache.put(element, filterResult);
            }
            return filterResult;
        }

        public void resetCache() {
            this.filterResultCache.clear();
        }
    }
}

