/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.viewers;

import com.arcway.lib.eclipse.gui.viewers.FixedColumnTable;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;

public class FixedColumTableViewer
extends ContentViewer {
    private final FixedColumnTable table;
    private final TableViewer fixedTableHeaderViewer;
    private final TableViewer fixedTableViewer;
    private final TableViewer scrolledTableViewer;

    public FixedColumTableViewer(FixedColumnTable table) {
        this.table = table;
        this.fixedTableHeaderViewer = new TableViewer(table.getFixedTableHeader());
        this.fixedTableViewer = new TableViewer(table.getFixedTable());
        this.scrolledTableViewer = new TableViewer(table.getScrollableTable());
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.fixedTableViewer.setContentProvider(contentProvider);
        this.scrolledTableViewer.setContentProvider(contentProvider);
    }

    public void setInput(Object input) {
        this.fixedTableViewer.setInput(input);
        this.scrolledTableViewer.setInput(input);
    }

    public IContentProvider getContentProvider() {
        return this.fixedTableViewer.getContentProvider();
    }

    public Control getControl() {
        return this.table;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        assert (labelProvider instanceof ITableLabelProvider);
        ITableLabelProvider baseLabelProvider = (ITableLabelProvider)labelProvider;
        this.fixedTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(baseLabelProvider, true));
        this.scrolledTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(baseLabelProvider, false));
        super.setLabelProvider((IBaseLabelProvider)baseLabelProvider);
    }

    public ISelection getSelection() {
        IStructuredSelection fixedSelection = (IStructuredSelection)this.fixedTableViewer.getSelection();
        IStructuredSelection scrolledSelection = (IStructuredSelection)this.scrolledTableViewer.getSelection();
        ArrayList together = new ArrayList(fixedSelection.toList());
        for (Object o : scrolledSelection) {
            if (together.contains(o)) continue;
            together.add(o);
        }
        return new StructuredSelection(together);
    }

    public void refresh() {
        this.fixedTableHeaderViewer.refresh();
        this.fixedTableViewer.refresh();
        this.scrolledTableViewer.refresh();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.fixedTableViewer.setSelection(selection, reveal);
        this.scrolledTableViewer.setSelection(selection, reveal);
    }

    public void setCellEditors(CellEditor[] editors) {
        CellEditor[] fixedEditors = new CellEditor[this.table.getNumberOfFixedCols()];
        int i = 0;
        while (i < this.table.getNumberOfFixedCols()) {
            fixedEditors[i] = editors[i];
            ++i;
        }
        CellEditor[] scrolledEditors = new CellEditor[editors.length - this.table.getNumberOfFixedCols()];
        int i2 = this.table.getNumberOfFixedCols();
        while (i2 < editors.length) {
            scrolledEditors[i2 - this.table.getNumberOfFixedCols()] = editors[i2];
            ++i2;
        }
        this.fixedTableViewer.setCellEditors(fixedEditors);
        this.scrolledTableViewer.setCellEditors(scrolledEditors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.scrolledTableViewer.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        String[] fixedProps = new String[this.table.getNumberOfFixedCols()];
        int i = 0;
        while (i < this.table.getNumberOfFixedCols()) {
            fixedProps[i] = columnProperties[i];
            ++i;
        }
        String[] scrolledProps = new String[columnProperties.length - this.table.getNumberOfFixedCols()];
        int i2 = this.table.getNumberOfFixedCols();
        while (i2 < columnProperties.length) {
            scrolledProps[i2 - this.table.getNumberOfFixedCols()] = columnProperties[i2];
            ++i2;
        }
        this.fixedTableHeaderViewer.setColumnProperties(fixedProps);
        this.fixedTableViewer.setColumnProperties(fixedProps);
        this.scrolledTableViewer.setColumnProperties(scrolledProps);
    }

    public Object[] getColumnProperties() {
        ArrayList<Object> together = new ArrayList<Object>();
        together.addAll(Arrays.asList(this.fixedTableViewer.getColumnProperties()));
        together.addAll(Arrays.asList(this.scrolledTableViewer.getColumnProperties()));
        return together.toArray();
    }

    public void setSorter(ViewerSorter sorter) {
        this.fixedTableViewer.setSorter(sorter);
        this.scrolledTableViewer.setSorter(sorter);
    }

    public void setContextMenu(MenuManager menuManager) {
        Menu menu = menuManager.createContextMenu((Control)this.table.getFixedTable());
        this.table.getFixedTable().setMenu(menu);
        menu = menuManager.createContextMenu((Control)this.table.getScrollableTable());
        this.table.getScrollableTable().setMenu(menu);
    }

    public TableColumn getColumn(int index) {
        if (index < this.table.getNumberOfFixedCols()) {
            return this.fixedTableViewer.getTable().getColumn(index);
        }
        return this.scrolledTableViewer.getTable().getColumn(index - this.table.getNumberOfFixedCols());
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private final ITableLabelProvider baseLabelProvider;
        private final boolean forFixed;

        public LabelProvider(ITableLabelProvider baseLabelProvider, boolean forFixed) {
            this.baseLabelProvider = baseLabelProvider;
            this.forFixed = forFixed;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (this.forFixed) {
                return this.baseLabelProvider.getColumnImage(element, columnIndex);
            }
            return this.baseLabelProvider.getColumnImage(element, columnIndex + FixedColumTableViewer.this.table.getNumberOfFixedCols());
        }

        public String getColumnText(Object element, int columnIndex) {
            if (this.forFixed) {
                return this.baseLabelProvider.getColumnText(element, columnIndex);
            }
            return this.baseLabelProvider.getColumnText(element, columnIndex + FixedColumTableViewer.this.table.getNumberOfFixedCols());
        }

        public void addListener(ILabelProviderListener listener) {
            this.baseLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.baseLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.baseLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.baseLabelProvider.removeListener(listener);
        }
    }
}

