/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.viewers;

import com.arcway.lib.eclipse.gui.viewers.ICachedItem;
import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class CachingLabelProvider
implements ILabelProvider {
    private final ILabelProvider baseLabelProvider;
    private int initialCacheMapCapacity;
    private HashMap<LabelCacheEntry, LabelCacheEntry> cachedBaseLabelProviderData;

    public CachingLabelProvider(ILabelProvider baseLabelProvider) {
        this.baseLabelProvider = baseLabelProvider;
        this.initialCacheMapCapacity = 100;
        this.clearLabelCaches();
    }

    public void clearLabelCaches() {
        if (this.cachedBaseLabelProviderData != null) {
            this.initialCacheMapCapacity = Math.max(this.initialCacheMapCapacity, 2 * this.cachedBaseLabelProviderData.size());
        }
        this.cachedBaseLabelProviderData = new HashMap(this.initialCacheMapCapacity, 0.6f);
    }

    private LabelCacheEntry getCacheEntry(Object o) {
        LabelCacheEntry key = new LabelCacheEntry(o);
        LabelCacheEntry result = this.cachedBaseLabelProviderData.get(key);
        if (result == null) {
            result = key;
            this.cachedBaseLabelProviderData.put(result, result);
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
        this.baseLabelProvider.addListener(listener);
    }

    public void dispose() {
        this.baseLabelProvider.dispose();
        this.clearLabelCaches();
    }

    public Image getImage(Object element) {
        Image image;
        ICachedItem frameDataItem;
        String categoryID;
        LabelCacheEntry cacheEntry = this.getCacheEntry(element);
        if (element instanceof ICachedItem && (cacheEntry.categoryID != (categoryID = (frameDataItem = (ICachedItem)element).getIconID()) || cacheEntry.categoryID != null && categoryID != null && !cacheEntry.categoryID.equals(categoryID))) {
            cacheEntry.image = LabelCacheEntry.NOT_YET_INITIALISED;
        }
        if (cacheEntry.image != LabelCacheEntry.NOT_YET_INITIALISED) {
            image = (Image)cacheEntry.image;
        } else {
            image = this.baseLabelProvider.getImage(element);
            cacheEntry.image = image;
        }
        return image;
    }

    public String getText(Object element) {
        String text;
        LabelCacheEntry cacheEntry = this.getCacheEntry(element);
        if (cacheEntry.text != LabelCacheEntry.NOT_YET_INITIALISED) {
            text = (String)cacheEntry.text;
        } else {
            text = this.baseLabelProvider.getText(element);
            cacheEntry.text = text;
        }
        return text;
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.baseLabelProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.baseLabelProvider.removeListener(listener);
    }

    private static final class LabelCacheEntry {
        private static final Object NOT_YET_INITIALISED = new Object();
        final Object o;
        Object text = NOT_YET_INITIALISED;
        Object image = NOT_YET_INITIALISED;
        String categoryID = null;

        private LabelCacheEntry(Object o) {
            this.o = o;
        }

        public boolean equals(Object obj) {
            assert (obj instanceof LabelCacheEntry);
            return ((LabelCacheEntry)obj).o == this.o;
        }

        public int hashCode() {
            return System.identityHashCode(this.o);
        }
    }
}

