/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.print;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Control;

public class SWTControlPrinter {
    private static final ILogger LOGGER = Logger.getLogger(SWTControlPrinter.class);
    private static final String DEFAULT_JOB_NAME = "ARCWAY Cockpit Print Job";
    private static PrinterData lastPrinterData = null;

    public static void printSWTComposite(Control c, String jobName) {
        String job = jobName == null ? DEFAULT_JOB_NAME : jobName;
        if (c != null && !c.isDisposed()) {
            String osName;
            PrintDialog dialog = new PrintDialog(c.getShell(), 0);
            dialog.setText(Messages.getString("SWTControlPrinter.PrintDialogText"));
            if (lastPrinterData != null && !(osName = System.getProperty("os.name")).contains("Vista")) {
                dialog.setPrinterData(lastPrinterData);
            }
            dialog.setScope(0);
            dialog.setStartPage(1);
            dialog.setEndPage(1);
            PrinterData printerData = dialog.open();
            if (printerData != null) {
                lastPrinterData = printerData;
                Printer printer = new Printer(printerData);
                Point size = c.getSize();
                Image image = new Image((Device)c.getDisplay(), size.x, size.y);
                GC gc = new GC((Drawable)c);
                gc.copyArea(image, 1, 1);
                gc.dispose();
                ImageData imageData = image.getImageData();
                Image printImage = new Image((Device)printer, imageData);
                Point screenDPI = c.getDisplay().getDPI();
                Point printerDPI = printer.getDPI();
                int scaleFactor = printerDPI.x / screenDPI.x;
                Rectangle trim = printer.computeTrim(0, 0, 0, 0);
                if (printer.startJob(job)) {
                    if (printer.startPage()) {
                        gc = new GC((Drawable)printer);
                        gc.drawImage(printImage, 0, 0, imageData.width, imageData.height, -trim.x, -trim.y, scaleFactor * imageData.width, scaleFactor * imageData.height);
                        gc.dispose();
                        printer.endPage();
                    }
                    printer.endJob();
                }
                printer.dispose();
                image.dispose();
                printImage.dispose();
            }
        }
    }
}

