/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.dialogs;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class StyledTextMessageDialog
extends MessageDialog {
    private static final ILogger logger = Logger.getLogger(StyledTextMessageDialog.class);
    IStyledMessageTextWriter styledTextWriter;

    public StyledTextMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, IStyledMessageTextWriter styledMessageWriter, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.styledTextWriter = styledMessageWriter;
    }

    protected Control createCustomArea(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        StyledText st = new StyledText(parent, 8);
        this.styledTextWriter.write(st);
        return st;
    }

    public static void showStyledTextMessageDialog(Shell parentShell, final String dialogTitle, final Image dialogTitleImage, final String dialogMessage, final IStyledMessageTextWriter styledMessageWriter, final int dialogImageType, final String[] dialogButtonLabels, final int defaultIndex) {
        Shell wwShell = null;
        if (parentShell == null) {
            IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (ww == null) {
                ww = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
            }
            wwShell = ww.getShell();
        }
        final Shell shell = parentShell != null ? parentShell : wwShell;
        Runnable showDialogRunnable = new Runnable(){

            @Override
            public void run() {
                StyledTextMessageDialog dlg = new StyledTextMessageDialog(shell, dialogTitle, dialogTitleImage, dialogMessage, styledMessageWriter, dialogImageType, dialogButtonLabels, defaultIndex);
                dlg.open();
            }
        };
        if (shell != null) {
            shell.getDisplay().syncExec(showDialogRunnable);
        } else {
            logger.error("Can't open styled text message - no shell available");
        }
    }

    public static void test() {
        StyledTextMessageDialog.showStyledTextMessageDialog(null, "StyledTextMessageDialog - Title", null, "StyledTextMessageDialog - Message", new IStyledMessageTextWriter(){

            @Override
            public void write(StyledText targetCanvas) {
                String text = "Styled Text - line 1\nStyled Text - line 2\nStyled Text - line 3\nStyled Text - line 4\nStyled Text - line 5\nStyled Text - line 6";
                targetCanvas.setText(text);
                StyleRange style1 = new StyleRange();
                style1.start = 0;
                style1.length = text.length();
                style1.fontStyle = 1;
                style1.foreground = targetCanvas.getDisplay().getSystemColor(3);
                targetCanvas.setStyleRange(style1);
            }
        }, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    public static interface IStyledMessageTextWriter {
        public void write(StyledText var1);
    }
}

