/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.dialogs;

import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.eclipse.gui.ImageInCanvasPainter;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.eclipse.gui.dialogs.Messages;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.ImageFileType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ImageDialog
extends Dialog {
    private static final double PPMM = 2.8346456692913384;
    private static final ILogger logger = Logger.getLogger(ImageDialog.class);
    private final Image image;
    private final String title;

    public ImageDialog(Image image, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.image = image;
        ImageData imageData = image.getImageData();
        String depth = Integer.toString(imageData.depth);
        String width = Integer.toString(imageData.width);
        String height = Integer.toString(imageData.height);
        Object[] bindings = new String[]{width, height, depth};
        this.title = NLS.bind((String)Messages.getString("ImageDialog.title"), (Object[])bindings);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Point getInitialSize() {
        Rectangle displayRec = Display.getDefault().getBounds();
        Rectangle rec = this.image.getBounds();
        int x = Math.min(rec.width, displayRec.width);
        int y = Math.min(rec.height, displayRec.height);
        Point min = this.getShell().computeSize(-1, -1, true);
        x = Math.max(x, min.x);
        y = Math.max(y, min.y);
        return new Point(x, y);
    }

    protected Control createDialogArea(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout());
        Canvas imageArea = new Canvas(base, 0);
        GridData gridData = new GridData(1808);
        imageArea.setLayoutData((Object)gridData);
        ImageInCanvasPainter paintListener = new ImageInCanvasPainter(imageArea, false, true);
        paintListener.setImage(this.image);
        imageArea.addPaintListener((PaintListener)paintListener);
        return base;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 13, Messages.getString("ImageDialog.save_as"), false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            try {
                FileChooserDialog dialog = new FileChooserDialog(new String[]{".png"}, this.getShell());
                File file = dialog.openForSave();
                if (file != null) {
                    SWTOffscreenBitmap swtOffscreenBitmap = new SWTOffscreenBitmap(this.image, false, null);
                    ImageCoDec.encodeIntoFile((IOffscreenBitmap)swtOffscreenBitmap, (double)2.8346456692913384, (double)2.8346456692913384, (File)file, (ImageFileType)ImageCoDec.PNG);
                }
            }
            catch (Exception e) {
                logger.error("could not execute", (Throwable)e);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }
}

