/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.dialogs;

import com.arcway.lib.eclipse.gui.dialogs.Messages;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.progress.UIJob;

public abstract class FilteredItemsSelectionDialog
extends SelectionStatusDialog {
    private static final String DIALOG_BOUNDS_SETTINGS = "DialogBoundsSettings";
    private static final String SHOW_STATUS_LINE = "ShowStatusLine";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private Text pattern;
    private TableViewer list;
    private DetailsContentViewer details;
    private ILabelProvider detailsLabelProvider;
    private ItemsListLabelProvider itemsListLabelProvider;
    private MenuManager menuManager;
    private final boolean multi;
    private ToolBar toolBar;
    private ToolItem toolItem;
    private Label progressLabel;
    private ToggleStatusLineAction toggleStatusLineAction;
    private IStatus status;
    private final RefreshCacheJob refreshCacheJob;
    private final RefreshProgressMessageJob refreshProgressMessageJob = new RefreshProgressMessageJob();
    private Object[] lastSelection;
    private final ContentProvider contentProvider;
    private final FilterHistoryJob filterHistoryJob;
    private final FilterJob filterJob;
    private ItemsFilter filter;
    private List<Object> lastCompletedResult;
    private ItemsFilter lastCompletedFilter;
    private String initialPatternText;
    private int selectionMode;
    private static final String EMPTY_STRING = "";
    private boolean refreshWithLastSelection = false;

    public FilteredItemsSelectionDialog(Shell shell, boolean multi) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.multi = multi;
        this.filterHistoryJob = new FilterHistoryJob();
        this.filterJob = new FilterJob();
        this.contentProvider = new ContentProvider();
        this.refreshCacheJob = new RefreshCacheJob();
        this.selectionMode = 0;
    }

    public FilteredItemsSelectionDialog(Shell shell) {
        this(shell, false);
    }

    protected void addListFilter(ViewerFilter fltr) {
        this.contentProvider.addFilter(fltr);
    }

    public void setListLabelProvider(ILabelProvider listLabelProvider) {
        this.getItemsListLabelProvider().setProvider(listLabelProvider);
    }

    private ILabelDecorator getListSelectionLabelDecorator() {
        return this.getItemsListLabelProvider().getSelectionDecorator();
    }

    public void setListSelectionLabelDecorator(ILabelDecorator listSelectionLabelDecorator) {
        this.getItemsListLabelProvider().setSelectionDecorator(listSelectionLabelDecorator);
    }

    private ItemsListLabelProvider getItemsListLabelProvider() {
        if (this.itemsListLabelProvider == null) {
            this.itemsListLabelProvider = new ItemsListLabelProvider((ILabelProvider)new LabelProvider(), null);
        }
        return this.itemsListLabelProvider;
    }

    public void setDetailsLabelProvider(ILabelProvider detailsLabelProvider) {
        this.detailsLabelProvider = detailsLabelProvider;
        if (this.details != null) {
            this.details.setLabelProvider((IBaseLabelProvider)detailsLabelProvider);
        }
    }

    private ILabelProvider getDetailsLabelProvider() {
        if (this.detailsLabelProvider == null) {
            this.detailsLabelProvider = new LabelProvider();
        }
        return this.detailsLabelProvider;
    }

    public void create() {
        super.create();
        this.pattern.setFocus();
    }

    protected void restoreDialog(IDialogSettings settings) {
        boolean toggleStatusLine = true;
        if (settings.get(SHOW_STATUS_LINE) != null) {
            toggleStatusLine = settings.getBoolean(SHOW_STATUS_LINE);
        }
        this.toggleStatusLineAction.setChecked(toggleStatusLine);
        this.details.setVisible(toggleStatusLine);
    }

    public boolean close() {
        this.filterJob.cancel();
        this.refreshCacheJob.cancel();
        this.refreshProgressMessageJob.cancel();
        this.storeDialog(this.getDialogSettings());
        return super.close();
    }

    protected void storeDialog(IDialogSettings settings) {
        settings.put(SHOW_STATUS_LINE, this.toggleStatusLineAction.isChecked());
    }

    private void createHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        header.setLayout((Layout)layout);
        Label label = new Label(header, 0);
        label.setText(this.getMessage() != null && this.getMessage().trim().length() > 0 ? this.getMessage() : Messages.getString("FilteredItemsSelectionDialog_patternLabel"));
        label.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    FilteredItemsSelectionDialog.this.pattern.setFocus();
                }
            }
        });
        GridData gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.createViewMenu(header);
        header.setLayoutData((Object)gd);
    }

    private void createLabels(Composite parent) {
        Composite labels = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        labels.setLayout((Layout)layout);
        Label listLabel = new Label(labels, 0);
        listLabel.setText(Messages.getString("FilteredItemsSelectionDialog_listLabel"));
        listLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    FilteredItemsSelectionDialog.this.list.getTable().setFocus();
                }
            }
        });
        GridData gd = new GridData(768);
        listLabel.setLayoutData((Object)gd);
        this.progressLabel = new Label(labels, 131072);
        this.progressLabel.setLayoutData((Object)gd);
        labels.setLayoutData((Object)gd);
    }

    private void createViewMenu(Composite parent) {
        this.toolBar = new ToolBar(parent, 0x800000);
        this.toolItem = new ToolItem(this.toolBar, 8, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        this.toolBar.setLayoutData((Object)data);
        this.toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                FilteredItemsSelectionDialog.this.showViewMenu();
            }
        });
        this.toolItem.setImage(null);
        this.toolItem.setToolTipText(Messages.getString("FilteredItemsSelectionDialog_menu"));
        this.toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredItemsSelectionDialog.this.showViewMenu();
            }
        });
        this.menuManager = new MenuManager();
        this.fillViewMenu((IMenuManager)this.menuManager);
    }

    protected void fillViewMenu(IMenuManager menuMgr) {
        this.toggleStatusLineAction = new ToggleStatusLineAction();
        menuMgr.add((IAction)this.toggleStatusLineAction);
    }

    private void showViewMenu() {
        Menu menu = this.menuManager.createContextMenu((Control)this.getShell());
        Rectangle bounds = this.toolItem.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = this.toolBar.toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    protected abstract Control createExtendedContentArea(Composite var1);

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(area, 0);
        GridData gd = new GridData(1808);
        content.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        this.createHeader(content);
        this.pattern = new Text(content, 2052);
        gd = new GridData(768);
        this.pattern.setLayoutData((Object)gd);
        this.createLabels(content);
        this.list = new TableViewer(content, (this.multi ? 2 : 4) | 0x800 | 0x200 | 0x10000000);
        this.list.setContentProvider((IContentProvider)this.contentProvider);
        this.list.setLabelProvider((IBaseLabelProvider)this.getItemsListLabelProvider());
        this.list.setInput((Object)new Object[0]);
        this.list.setItemCount(this.contentProvider.getElements(null).length);
        gd = new GridData(1808);
        this.list.getTable().setLayoutData((Object)gd);
        this.pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredItemsSelectionDialog.this.applyFilter();
            }
        });
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && FilteredItemsSelectionDialog.this.list.getTable().getItemCount() > 0) {
                    FilteredItemsSelectionDialog.this.list.getTable().setFocus();
                }
            }
        });
        this.list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                FilteredItemsSelectionDialog.this.handleSelected(selection);
            }
        });
        this.list.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FilteredItemsSelectionDialog.this.handleDoubleClick();
            }
        });
        this.list.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                StructuredSelection selection;
                if (e.keyCode == 127) {
                    List selectedElements = ((StructuredSelection)FilteredItemsSelectionDialog.this.list.getSelection()).toList();
                    Object item2 = null;
                    boolean isSelectedHistory = true;
                    for (Object item2 : selectedElements) {
                        if (!(item2 instanceof ItemsListSeparator)) continue;
                        isSelectedHistory = false;
                        break;
                    }
                    if (isSelectedHistory) {
                        FilteredItemsSelectionDialog.this.removeSelectedItems(selectedElements);
                    }
                }
                if (e.keyCode == 0x1000001 && (e.stateMask & 0x20000) != 0 && (e.stateMask & SWT.MOD1) != 0 && (selection = (StructuredSelection)FilteredItemsSelectionDialog.this.list.getSelection()).size() == 1) {
                    Object element = selection.getFirstElement();
                    if (element.equals(FilteredItemsSelectionDialog.this.list.getElementAt(0))) {
                        FilteredItemsSelectionDialog.this.pattern.setFocus();
                    }
                    if (FilteredItemsSelectionDialog.this.list.getElementAt(FilteredItemsSelectionDialog.this.list.getTable().getSelectionIndex() - 1) instanceof ItemsListSeparator) {
                        FilteredItemsSelectionDialog.this.list.getTable().setSelection(FilteredItemsSelectionDialog.this.list.getTable().getSelectionIndex() - 1);
                    }
                    FilteredItemsSelectionDialog.this.list.getTable().notifyListeners(13, new Event());
                }
                if (e.keyCode == 0x1000002 && (e.stateMask & 0x20000) != 0 && (e.stateMask & SWT.MOD1) != 0) {
                    if (FilteredItemsSelectionDialog.this.list.getElementAt(FilteredItemsSelectionDialog.this.list.getTable().getSelectionIndex() + 1) instanceof ItemsListSeparator) {
                        FilteredItemsSelectionDialog.this.list.getTable().setSelection(FilteredItemsSelectionDialog.this.list.getTable().getSelectionIndex() + 1);
                    }
                    FilteredItemsSelectionDialog.this.list.getTable().notifyListeners(13, new Event());
                }
            }
        });
        this.createExtendedContentArea(content);
        this.details = new DetailsContentViewer(content, 0x800800);
        this.details.setVisible(this.toggleStatusLineAction.isChecked());
        this.details.setContentProvider(new NullContentProvider());
        this.details.setLabelProvider((IBaseLabelProvider)this.getDetailsLabelProvider());
        FilteredItemsSelectionDialog.applyDialogFont((Control)content);
        this.restoreDialog(this.getDialogSettings());
        if (this.initialPatternText != null) {
            this.pattern.setText(this.initialPatternText);
        }
        switch (this.selectionMode) {
            case 1: {
                this.pattern.setSelection(0, 0);
                break;
            }
            case 2: {
                this.pattern.setSelection(0, this.initialPatternText.length());
            }
        }
        this.applyFilter();
        return area;
    }

    protected void handleDoubleClick() {
        this.okPressed();
    }

    private void refreshDetails() {
        StructuredSelection selection = this.getSelectedItems();
        switch (selection.size()) {
            case 0: {
                this.details.setInput(null);
                break;
            }
            case 1: {
                this.details.setInput(selection.getFirstElement());
                break;
            }
            default: {
                this.details.setInput(NLS.bind((String)Messages.getString("FilteredItemsSelectionDialog_nItemsSelected"), (Object)new Integer(selection.size())));
            }
        }
    }

    protected void handleSelected(StructuredSelection selection) {
        Status stts = new Status(0, "org.eclipse.ui", 0, EMPTY_STRING, null);
        if (selection.size() == 0) {
            stts = new Status(4, "org.eclipse.ui", 4, EMPTY_STRING, null);
            if (this.lastSelection != null && this.getListSelectionLabelDecorator() != null) {
                this.list.update(this.lastSelection, null);
            }
            this.lastSelection = null;
        } else {
            stts = new Status(4, "org.eclipse.ui", 4, EMPTY_STRING, null);
            List items = selection.toList();
            Object item = null;
            IStatus tempStatus = null;
            for (Object o : items) {
                if (o instanceof ItemsListSeparator) continue;
                item = o;
                tempStatus = this.validateItem(item);
                if (tempStatus.isOK()) {
                    stts = new Status(0, "org.eclipse.ui", 0, EMPTY_STRING, null);
                    continue;
                }
                stts = tempStatus;
                break;
            }
            if (this.lastSelection != null && this.getListSelectionLabelDecorator() != null) {
                this.list.update(this.lastSelection, null);
            }
            if (this.getListSelectionLabelDecorator() != null) {
                this.list.update(items.toArray(), null);
            }
            this.lastSelection = items.toArray();
        }
        this.refreshDetails();
        this.updateStatus((IStatus)stts);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = this.getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_BOUNDS_SETTINGS);
        if (section == null) {
            section = settings.addNewSection(DIALOG_BOUNDS_SETTINGS);
            section.put(DIALOG_HEIGHT, 500);
            section.put(DIALOG_WIDTH, 600);
        }
        return section;
    }

    protected abstract IDialogSettings getDialogSettings();

    public void refresh() {
        if (this.list != null && !this.list.getTable().isDisposed()) {
            List lastRefreshSelection = ((StructuredSelection)this.list.getSelection()).toList();
            this.list.setItemCount(this.contentProvider.getElements(null).length);
            this.list.refresh();
            if (this.list.getTable().getItemCount() > 0) {
                if (this.refreshWithLastSelection && lastRefreshSelection != null && lastRefreshSelection.size() > 0) {
                    this.list.setSelection((ISelection)new StructuredSelection(lastRefreshSelection));
                } else {
                    this.refreshWithLastSelection = true;
                    this.list.getTable().setSelection(0);
                    this.list.getTable().notifyListeners(13, new Event());
                }
            } else {
                this.list.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
        this.scheduleProgressMessageRefresh();
    }

    @Deprecated
    public void updateProgressLabel() {
        this.scheduleProgressMessageRefresh();
    }

    public void reloadCache(boolean checkDuplicates, IProgressMonitor monitor) {
        if (this.list != null && !this.list.getTable().isDisposed() && this.contentProvider != null) {
            this.contentProvider.reloadCache(checkDuplicates, monitor);
        }
    }

    public void scheduleRefresh() {
        this.refreshCacheJob.cancelAll();
        this.refreshCacheJob.schedule();
    }

    public void scheduleProgressMessageRefresh() {
        if (this.filterJob.getState() != 4 && this.refreshProgressMessageJob.getState() != 4) {
            this.refreshProgressMessageJob.scheduleProgressRefresh(null);
        }
    }

    protected void computeResult() {
        List selectedElements = ((StructuredSelection)this.list.getSelection()).toList();
        ArrayList<Object> objectsToReturn = new ArrayList<Object>();
        Object item2 = null;
        for (Object item2 : selectedElements) {
            if (item2 instanceof ItemsListSeparator) continue;
            objectsToReturn.add(item2);
        }
        this.setResult(objectsToReturn);
    }

    protected void updateStatus(IStatus stts) {
        this.status = stts;
        super.updateStatus(stts);
    }

    protected void okPressed() {
        if (this.status != null && (this.status.isOK() || this.status.getCode() == 1)) {
            super.okPressed();
        }
    }

    public void setInitialPattern(String text) {
        this.setInitialPattern(text, 2);
    }

    public void setInitialPattern(String text, int selectionMode) {
        this.initialPatternText = text;
        this.selectionMode = selectionMode;
    }

    protected String getInitialPattern() {
        return this.initialPatternText;
    }

    protected StructuredSelection getSelectedItems() {
        StructuredSelection selection = (StructuredSelection)this.list.getSelection();
        List selectedItems = selection.toList();
        Object itemToRemove = null;
        for (Object item : selection) {
            if (!(item instanceof ItemsListSeparator)) continue;
            itemToRemove = item;
            break;
        }
        if (itemToRemove == null) {
            return new StructuredSelection(selectedItems);
        }
        ArrayList newItems = new ArrayList(selectedItems);
        newItems.remove(itemToRemove);
        return new StructuredSelection(newItems);
    }

    protected abstract IStatus validateItem(Object var1);

    protected abstract ItemsFilter createFilter();

    protected void applyFilter() {
        ItemsFilter newFilter = this.createFilter();
        if (this.filter != null && this.filter.equalsFilter(newFilter)) {
            return;
        }
        this.filterHistoryJob.cancel();
        this.filterJob.cancel();
        this.filter = newFilter;
        if (this.filter != null) {
            this.filterHistoryJob.schedule();
        }
    }

    protected abstract Comparator getItemsComparator();

    protected abstract void fillContentProvider(AbstractContentProvider var1, ItemsFilter var2, IProgressMonitor var3) throws CoreException;

    private void removeSelectedItems(List<?> items) {
        this.refreshWithLastSelection = false;
        this.contentProvider.refresh();
    }

    public boolean isDuplicateElement(Object item) {
        return this.contentProvider.isDuplicateElement(item);
    }

    public abstract String getElementName(Object var1);

    public Control getPatternControl() {
        return this.pattern;
    }

    protected abstract class AbstractContentProvider {
        protected AbstractContentProvider() {
        }

        public abstract void add(Object var1, ItemsFilter var2);
    }

    private class ContentProvider
    extends AbstractContentProvider
    implements IStructuredContentProvider,
    ILazyContentProvider {
        private final List<Object> items = Collections.synchronizedList(new ArrayList(2048));
        private final Set<Object> duplicates = Collections.synchronizedSet(new HashSet(256));
        private List<ViewerFilter> filters;
        private List<Object> lastFilteredItems = new ArrayList<Object>();
        private final List<Object> lastSortedItems = Collections.synchronizedList(new ArrayList(2048));
        private boolean reset;

        public void reset() {
            this.reset = true;
            this.items.clear();
            this.duplicates.clear();
            this.lastSortedItems.clear();
        }

        public void stopReloadingCache() {
            this.reset = true;
        }

        @Override
        public void add(Object item, ItemsFilter itemsFilter) {
            if (itemsFilter == FilteredItemsSelectionDialog.this.filter) {
                if (itemsFilter != null) {
                    if (itemsFilter.matchItem(item)) {
                        this.items.add(item);
                    }
                } else {
                    this.items.add(item);
                }
            }
        }

        public void refresh() {
            FilteredItemsSelectionDialog.this.scheduleRefresh();
        }

        public void setDuplicateElement(Object item, boolean isDuplicate) {
            if (this.items.contains(item)) {
                if (isDuplicate) {
                    this.duplicates.add(item);
                } else {
                    this.duplicates.remove(item);
                }
            }
        }

        public boolean isDuplicateElement(Object item) {
            return this.duplicates.contains(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] getSortedItems() {
            if (this.lastSortedItems.size() != this.items.size()) {
                List<Object> list = this.lastSortedItems;
                synchronized (list) {
                    this.lastSortedItems.clear();
                    this.lastSortedItems.addAll(this.items);
                    Comparator comparator = FilteredItemsSelectionDialog.this.getItemsComparator();
                    if (comparator != null) {
                        Collections.sort(this.lastSortedItems, comparator);
                    }
                }
            }
            return this.lastSortedItems.toArray();
        }

        public void rememberResult(ItemsFilter itemsFilter) {
            List<Object> itemsList = Collections.synchronizedList(Arrays.asList(this.getSortedItems()));
            if (itemsFilter == FilteredItemsSelectionDialog.this.filter) {
                FilteredItemsSelectionDialog.this.lastCompletedFilter = itemsFilter;
                FilteredItemsSelectionDialog.this.lastCompletedResult = itemsList;
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.lastFilteredItems.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void updateElement(int index) {
            FilteredItemsSelectionDialog.this.list.replace(this.lastFilteredItems.size() > index ? this.lastFilteredItems.get(index) : null, index);
        }

        public void reloadCache(boolean checkDuplicates, IProgressMonitor monitor) {
            this.reset = false;
            if (monitor != null) {
                int totalWork = checkDuplicates ? 200 : 100;
                monitor.beginTask(Messages.getString("FilteredItemsSelectionDialog_cacheRefreshJob"), totalWork);
            }
            this.lastFilteredItems = Arrays.asList(this.getFilteredItems(FilteredItemsSelectionDialog.this.list.getInput(), (IProgressMonitor)(monitor != null ? new SubProgressMonitor(monitor, 100) : null)));
            if (this.reset || monitor != null && monitor.isCanceled()) {
                if (monitor != null) {
                    monitor.done();
                }
                return;
            }
            if (checkDuplicates) {
                this.checkDuplicates(monitor);
            }
            if (monitor != null) {
                monitor.done();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkDuplicates(IProgressMonitor monitor) {
            List<Object> list = this.lastFilteredItems;
            synchronized (list) {
                SubProgressMonitor subMonitor = null;
                int reportEvery = this.lastFilteredItems.size() / 20;
                if (monitor != null) {
                    subMonitor = new SubProgressMonitor(monitor, 100);
                    subMonitor.beginTask(Messages.getString("FilteredItemsSelectionDialog_cacheRefreshJob_checkDuplicates"), 5);
                }
                HashMap<String, Object> helperMap = new HashMap<String, Object>();
                int i = 0;
                while (i < this.lastFilteredItems.size()) {
                    if (this.reset || subMonitor != null && subMonitor.isCanceled()) {
                        return;
                    }
                    Object item = this.lastFilteredItems.get(i);
                    if (!(item instanceof ItemsListSeparator)) {
                        Object previousItem = helperMap.put(FilteredItemsSelectionDialog.this.getElementName(item), item);
                        if (previousItem != null) {
                            this.setDuplicateElement(previousItem, true);
                            this.setDuplicateElement(item, true);
                        } else {
                            this.setDuplicateElement(item, false);
                        }
                    }
                    if (subMonitor != null && reportEvery != 0 && (i + 1) % reportEvery == 0) {
                        subMonitor.worked(1);
                    }
                    ++i;
                }
                helperMap.clear();
            }
        }

        protected Object[] getFilteredItems(Object parent, IProgressMonitor monitor) {
            int ticks = 100;
            if (monitor != null) {
                monitor.beginTask(Messages.getString("FilteredItemsSelectionDialog_cacheRefreshJob_getFilteredElements"), ticks);
                ticks = this.filters != null ? (ticks /= this.filters.size() + 2) : (ticks /= 2);
            }
            Object[] filteredElements = this.getSortedItems();
            if (monitor != null) {
                monitor.worked(ticks);
            }
            if (this.filters != null && filteredElements != null) {
                for (ViewerFilter f : this.filters) {
                    filteredElements = f.filter((Viewer)FilteredItemsSelectionDialog.this.list, parent, filteredElements);
                    if (monitor == null) continue;
                    monitor.worked(ticks);
                }
            }
            if (filteredElements == null || monitor != null && monitor.isCanceled()) {
                if (monitor != null) {
                    monitor.done();
                }
                return new Object[0];
            }
            ArrayList<Object> preparedElements = new ArrayList<Object>();
            int reportEvery = filteredElements.length / ticks;
            int i = 0;
            while (i < filteredElements.length) {
                Object item = filteredElements[i];
                preparedElements.add(item);
                if (monitor != null && reportEvery != 0 && (i + 1) % reportEvery == 0) {
                    monitor.worked(1);
                }
                ++i;
            }
            if (monitor != null) {
                monitor.done();
            }
            return preparedElements.toArray();
        }

        public void addFilter(ViewerFilter fltr) {
            if (this.filters == null) {
                this.filters = new ArrayList<ViewerFilter>();
            }
            this.filters.add(fltr);
        }
    }

    private class DetailsContentViewer
    extends ContentViewer {
        private final CLabel label;
        private final ViewForm viewForm;

        public DetailsContentViewer(Composite parent, int style) {
            this.viewForm = new ViewForm(parent, style);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.viewForm.setLayoutData((Object)gd);
            this.label = new CLabel((Composite)this.viewForm, 0x800000);
            this.label.setFont(parent.getFont());
            this.viewForm.setContent((Control)this.label);
            this.hookControl((Control)this.label);
        }

        public void setVisible(boolean visible) {
            GridData gd = (GridData)this.viewForm.getLayoutData();
            gd.exclude = !visible;
            this.viewForm.getParent().layout();
        }

        protected void inputChanged(Object input, Object oldInput) {
            if (oldInput == null) {
                if (input == null) {
                    return;
                }
                this.refresh();
                return;
            }
            this.refresh();
        }

        protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
            if (event != null) {
                this.refresh(event.getElements());
            }
        }

        public Control getControl() {
            return this.label;
        }

        public ISelection getSelection() {
            return null;
        }

        public void refresh() {
            Object input = this.getInput();
            if (input != null) {
                ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
                this.doRefresh(labelProvider.getText(input), labelProvider.getImage(input));
            } else {
                this.doRefresh(null, null);
            }
        }

        private void doRefresh(String text, Image image) {
            this.label.setText(text);
            this.label.setImage(image);
        }

        public void setSelection(ISelection selection, boolean reveal) {
        }

        private void refresh(Object[] objs) {
            if (objs == null || this.getInput() == null) {
                return;
            }
            Object input = this.getInput();
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj.equals(input)) {
                    this.refresh();
                    break;
                }
                ++n2;
            }
        }
    }

    private class FilterHistoryJob
    extends Job {
        private ItemsFilter itemsFilter;

        public FilterHistoryJob() {
            super(Messages.getString("FilteredItemsSelectionDialog_jobLabel"));
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.itemsFilter = FilteredItemsSelectionDialog.this.filter;
            FilteredItemsSelectionDialog.this.contentProvider.reset();
            FilteredItemsSelectionDialog.this.refreshWithLastSelection = false;
            if (FilteredItemsSelectionDialog.this.lastCompletedFilter == null || !FilteredItemsSelectionDialog.this.lastCompletedFilter.isSubFilter(this.itemsFilter)) {
                FilteredItemsSelectionDialog.this.contentProvider.refresh();
            }
            FilteredItemsSelectionDialog.this.filterJob.schedule();
            return Status.OK_STATUS;
        }
    }

    private class FilterJob
    extends Job {
        protected ItemsFilter itemsFilter;

        public FilterJob() {
            super(Messages.getString("FilteredItemsSelectionDialog_jobLabel"));
            this.setSystem(true);
        }

        protected final IStatus run(IProgressMonitor parent) {
            GranualProgressMonitor monitor = new GranualProgressMonitor(parent);
            return this.doRun(monitor);
        }

        protected IStatus doRun(GranualProgressMonitor monitor) {
            try {
                this.internalRun(monitor);
            }
            catch (CoreException e) {
                this.cancel();
                return new Status(4, "org.eclipse.ui", 4, Messages.getString("FilteredItemsSelectionDialog_jobError"), (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        private void internalRun(GranualProgressMonitor monitor) throws CoreException {
            try {
                if (monitor.isCanceled()) {
                    return;
                }
                this.itemsFilter = FilteredItemsSelectionDialog.this.filter;
                if (FilteredItemsSelectionDialog.this.filter.getPattern().length() != 0) {
                    this.filterContent(monitor);
                }
                if (monitor.isCanceled()) {
                    return;
                }
                FilteredItemsSelectionDialog.this.contentProvider.refresh();
            }
            finally {
                monitor.done();
            }
        }

        protected void filterContent(GranualProgressMonitor monitor) throws CoreException {
            if (FilteredItemsSelectionDialog.this.lastCompletedFilter != null && FilteredItemsSelectionDialog.this.lastCompletedFilter.isSubFilter(this.itemsFilter)) {
                int length = FilteredItemsSelectionDialog.this.lastCompletedResult.size() / 500;
                monitor.beginTask(Messages.getString("FilteredItemsSelectionDialog_cacheSearchJob_taskName"), length);
                int pos = 0;
                while (pos < FilteredItemsSelectionDialog.this.lastCompletedResult.size()) {
                    Object item = FilteredItemsSelectionDialog.this.lastCompletedResult.get(pos);
                    if (!monitor.isCanceled()) {
                        FilteredItemsSelectionDialog.this.contentProvider.add(item, this.itemsFilter);
                        if (pos % 500 == 0) {
                            monitor.worked(1);
                        }
                        ++pos;
                        continue;
                    }
                    break;
                }
            } else {
                FilteredItemsSelectionDialog.this.lastCompletedFilter = null;
                FilteredItemsSelectionDialog.this.lastCompletedResult = null;
                SubProgressMonitor subMonitor = null;
                if (monitor != null) {
                    monitor.beginTask(Messages.getString("FilteredItemsSelectionDialog_searchJob_taskName"), 100);
                    subMonitor = new SubProgressMonitor((IProgressMonitor)monitor, 95);
                }
                FilteredItemsSelectionDialog.this.fillContentProvider(FilteredItemsSelectionDialog.this.contentProvider, this.itemsFilter, (IProgressMonitor)subMonitor);
                if (monitor != null && !monitor.isCanceled()) {
                    monitor.worked(2);
                    FilteredItemsSelectionDialog.this.contentProvider.rememberResult(this.itemsFilter);
                    monitor.worked(3);
                }
            }
        }
    }

    private class GranualProgressMonitor
    extends ProgressMonitorWrapper {
        private String name;
        private String subName;
        private int totalWork;
        private double worked;
        private boolean done;

        public GranualProgressMonitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public boolean isDone() {
            return this.done;
        }

        public void setTaskName(String name) {
            super.setTaskName(name);
            this.name = name;
            this.subName = null;
        }

        public void subTask(String nm) {
            super.subTask(nm);
            this.subName = nm;
        }

        public void beginTask(String nm, int totalWrk) {
            super.beginTask(nm, totalWrk);
            if (this.name == null) {
                this.name = nm;
            }
            this.totalWork = totalWrk;
            FilteredItemsSelectionDialog.this.refreshProgressMessageJob.scheduleProgressRefresh(this);
        }

        public void worked(int work) {
            super.worked(work);
            this.internalWorked(work);
        }

        public void done() {
            this.done = true;
            super.done();
        }

        public void setCanceled(boolean b) {
            this.done = b;
            super.setCanceled(b);
        }

        public void internalWorked(double work) {
            this.worked += work;
        }

        private String getMessage() {
            String message;
            if (this.done) {
                return FilteredItemsSelectionDialog.EMPTY_STRING;
            }
            if (this.name == null) {
                message = this.subName == null ? FilteredItemsSelectionDialog.EMPTY_STRING : this.subName;
            } else {
                String string = message = this.subName == null ? this.name : NLS.bind((String)Messages.getString("FilteredItemsSelectionDialog_subtaskProgressMessage"), (Object[])new Object[]{this.name, this.subName});
            }
            if (this.totalWork == 0) {
                return message;
            }
            return NLS.bind((String)Messages.getString("FilteredItemsSelectionDialog_taskProgressMessage"), (Object[])new Object[]{message, new Integer((int)(this.worked * 100.0 / (double)this.totalWork))});
        }
    }

    protected abstract class ItemsFilter {
        protected SearchPattern patternMatcher;

        public ItemsFilter() {
            this(new SearchPattern());
        }

        public ItemsFilter(SearchPattern searchPattern) {
            this.patternMatcher = searchPattern;
            String stringPattern = FilteredItemsSelectionDialog.EMPTY_STRING;
            if (FilteredItemsSelectionDialog.this.pattern != null) {
                stringPattern = FilteredItemsSelectionDialog.this.pattern.getText();
            }
            if (FilteredItemsSelectionDialog.this.pattern == null || stringPattern.equals(FilteredItemsSelectionDialog.EMPTY_STRING)) {
                stringPattern = "?";
            }
            this.patternMatcher.setPattern(stringPattern);
        }

        public boolean isSubFilter(ItemsFilter fltr) {
            if (fltr != null) {
                return this.patternMatcher.isSubPattern(fltr.patternMatcher);
            }
            return false;
        }

        public boolean equalsFilter(ItemsFilter fltr) {
            return fltr != null && fltr.patternMatcher.equalsPattern(this.patternMatcher);
        }

        public boolean isCamelCasePattern() {
            return this.patternMatcher.getMatchRule() == 128;
        }

        public String getPattern() {
            return this.patternMatcher.getPattern();
        }

        public int getMatchRule() {
            return this.patternMatcher.getMatchRule();
        }

        protected boolean matches(String text) {
            return this.patternMatcher.matches(text);
        }

        public boolean matchesRawNamePattern(Object item) {
            int prefixLength;
            String prefix = this.patternMatcher.getPattern();
            String text = FilteredItemsSelectionDialog.this.getElementName(item);
            if (text == null) {
                return false;
            }
            int textLength = text.length();
            if (textLength < (prefixLength = prefix.length())) {
                return false;
            }
            int i = prefixLength - 1;
            while (i >= 0) {
                if (Character.toLowerCase(prefix.charAt(i)) != Character.toLowerCase(text.charAt(i))) {
                    return false;
                }
                --i;
            }
            return true;
        }

        public abstract boolean matchItem(Object var1);

        public abstract boolean isConsistentItem(Object var1);
    }

    private class ItemsListLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider,
    ILabelProviderListener {
        private ILabelProvider provider;
        private ILabelDecorator selectionDecorator;
        private final ListenerList listeners = new ListenerList();

        public ItemsListLabelProvider(ILabelProvider provider, ILabelDecorator selectionDecorator) {
            Assert.isNotNull((Object)provider);
            this.provider = provider;
            this.selectionDecorator = selectionDecorator;
            provider.addListener((ILabelProviderListener)this);
            if (selectionDecorator != null) {
                selectionDecorator.addListener((ILabelProviderListener)this);
            }
        }

        public void setSelectionDecorator(ILabelDecorator newSelectionDecorator) {
            if (this.selectionDecorator != null) {
                this.selectionDecorator.removeListener((ILabelProviderListener)this);
                this.selectionDecorator.dispose();
            }
            this.selectionDecorator = newSelectionDecorator;
            if (this.selectionDecorator != null) {
                this.selectionDecorator.addListener((ILabelProviderListener)this);
            }
        }

        public ILabelDecorator getSelectionDecorator() {
            return this.selectionDecorator;
        }

        public void setProvider(ILabelProvider newProvider) {
            Assert.isNotNull((Object)newProvider);
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            this.provider = newProvider;
            if (this.provider != null) {
                this.provider.addListener((ILabelProviderListener)this);
            }
        }

        public ILabelProvider getProvider() {
            return this.provider;
        }

        public Image getImage(Object element) {
            if (element instanceof ItemsListSeparator) {
                return null;
            }
            return this.provider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ItemsListSeparator) {
                return this.getSeparatorLabel(((ItemsListSeparator)element).getName());
            }
            String str = this.provider.getText(element);
            if (this.selectionDecorator != null && element != null) {
                int[] selectionIndices = FilteredItemsSelectionDialog.this.list.getTable().getSelectionIndices();
                List<Object> elements = Arrays.asList(FilteredItemsSelectionDialog.this.contentProvider.getElements(null));
                int[] nArray = selectionIndices;
                int n = selectionIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int selectionIndice = nArray[n2];
                    if (elements.size() > selectionIndice && element.equals(elements.get(selectionIndice))) {
                        str = this.selectionDecorator.decorateText(str, element);
                        break;
                    }
                    ++n2;
                }
            }
            return str;
        }

        private String getSeparatorLabel(String separatorLabel) {
            Rectangle rect = FilteredItemsSelectionDialog.this.list.getTable().getBounds();
            int borderWidth = ((FilteredItemsSelectionDialog)FilteredItemsSelectionDialog.this).list.getTable().computeTrim((int)0, (int)0, (int)0, (int)0).width;
            int imageWidth = 0;
            int width = rect.width - borderWidth - imageWidth;
            GC gc = new GC((Drawable)FilteredItemsSelectionDialog.this.list.getTable());
            gc.setFont(FilteredItemsSelectionDialog.this.list.getTable().getFont());
            int fSeparatorWidth = gc.getAdvanceWidth('-');
            int fMessageLength = gc.textExtent((String)separatorLabel).x;
            gc.dispose();
            StringBuffer dashes = new StringBuffer();
            int chars = (width - fMessageLength) / fSeparatorWidth / 2 - 2;
            int i = 0;
            while (i < chars) {
                dashes.append('-');
                ++i;
            }
            StringBuffer result = new StringBuffer();
            result.append(dashes);
            result.append(" " + separatorLabel + " ");
            result.append(dashes);
            return result.toString().trim();
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void dispose() {
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            if (this.selectionDecorator != null) {
                this.selectionDecorator.removeListener((ILabelProviderListener)this);
                this.selectionDecorator.dispose();
            }
            super.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            if (this.provider.isLabelProperty(element, property)) {
                return true;
            }
            return this.selectionDecorator != null && this.selectionDecorator.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        public Color getBackground(Object element) {
            if (element instanceof ItemsListSeparator) {
                return null;
            }
            if (this.provider instanceof IColorProvider) {
                return ((IColorProvider)this.provider).getBackground(element);
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof ItemsListSeparator) {
                return Display.getCurrent().getSystemColor(18);
            }
            if (this.provider instanceof IColorProvider) {
                return ((IColorProvider)this.provider).getForeground(element);
            }
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof ItemsListSeparator) {
                return null;
            }
            if (this.provider instanceof IFontProvider) {
                return ((IFontProvider)this.provider).getFont(element);
            }
            return null;
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    private class ItemsListSeparator {
        private final String name;

        public ItemsListSeparator(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private class NullContentProvider
    implements IContentProvider {
        private NullContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class RefreshCacheJob
    extends Job {
        private final RefreshJob refreshJob;

        public RefreshCacheJob() {
            super(Messages.getString("FilteredItemsSelectionDialog_cacheRefreshJob"));
            this.refreshJob = new RefreshJob();
            this.setSystem(true);
        }

        public void cancelAll() {
            this.cancel();
            this.refreshJob.cancel();
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return new Status(8, ARCWAYEclipseLibPlugin.getDefault().getPluginID(), 8, FilteredItemsSelectionDialog.EMPTY_STRING, null);
            }
            if (FilteredItemsSelectionDialog.this != null) {
                GranualProgressMonitor wrappedMonitor = new GranualProgressMonitor(monitor);
                FilteredItemsSelectionDialog.this.reloadCache(true, (IProgressMonitor)wrappedMonitor);
            }
            if (!monitor.isCanceled()) {
                this.refreshJob.schedule();
            }
            return new Status(0, "org.eclipse.ui", 0, FilteredItemsSelectionDialog.EMPTY_STRING, null);
        }

        protected void canceling() {
            super.canceling();
            FilteredItemsSelectionDialog.this.contentProvider.stopReloadingCache();
        }
    }

    private class RefreshJob
    extends UIJob {
        public RefreshJob() {
            super(FilteredItemsSelectionDialog.this.getParentShell().getDisplay(), Messages.getString("FilteredItemsSelectionDialog_refreshJob"));
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return new Status(0, ARCWAYEclipseLibPlugin.getDefault().getPluginID(), 0, FilteredItemsSelectionDialog.EMPTY_STRING, null);
            }
            if (FilteredItemsSelectionDialog.this != null) {
                FilteredItemsSelectionDialog.this.refresh();
            }
            return new Status(0, "org.eclipse.ui", 0, FilteredItemsSelectionDialog.EMPTY_STRING, null);
        }
    }

    private class RefreshProgressMessageJob
    extends UIJob {
        private GranualProgressMonitor progressMonitor;

        public RefreshProgressMessageJob() {
            super(FilteredItemsSelectionDialog.this.getParentShell().getDisplay(), Messages.getString("FilteredItemsSelectionDialog_progressRefreshJob"));
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!FilteredItemsSelectionDialog.this.progressLabel.isDisposed()) {
                FilteredItemsSelectionDialog.this.progressLabel.setText(this.progressMonitor != null ? this.progressMonitor.getMessage() : FilteredItemsSelectionDialog.EMPTY_STRING);
            }
            if (this.progressMonitor == null || this.progressMonitor.isDone()) {
                return new Status(8, "org.eclipse.ui", 8, FilteredItemsSelectionDialog.EMPTY_STRING, null);
            }
            this.schedule(500L);
            return new Status(0, "org.eclipse.ui", 0, FilteredItemsSelectionDialog.EMPTY_STRING, null);
        }

        public void scheduleProgressRefresh(GranualProgressMonitor progressMntr) {
            this.progressMonitor = progressMntr;
            this.schedule(200L);
        }
    }

    protected static abstract class SelectionHistory {
        private static final String DEFAULT_ROOT_NODE_NAME = "historyRootNode";
        private static final String DEFAULT_INFO_NODE_NAME = "infoNode";
        private static final int MAX_HISTORY_SIZE = 60;
        private final List<Object> historyList = Collections.synchronizedList(new LinkedList<Object>(){
            private static final long serialVersionUID = 0L;

            @Override
            public boolean add(Object arg0) {
                if (this.size() > 60) {
                    this.removeFirst();
                }
                if (!this.contains(arg0)) {
                    return super.add(arg0);
                }
                return false;
            }
        });
        private final String rootNodeName;
        private final String infoNodeName;

        private SelectionHistory(String rootNodeName, String infoNodeName) {
            this.rootNodeName = rootNodeName;
            this.infoNodeName = infoNodeName;
        }

        public SelectionHistory() {
            this(DEFAULT_ROOT_NODE_NAME, DEFAULT_INFO_NODE_NAME);
        }

        public synchronized void accessed(Object object) {
            this.historyList.add(object);
        }

        public synchronized boolean contains(Object object) {
            return this.historyList.contains(object);
        }

        public synchronized boolean isEmpty() {
            return this.historyList.isEmpty();
        }

        public synchronized boolean remove(Object element) {
            return this.historyList.remove(element);
        }

        public void load(IMemento memento) {
            IMemento[] mementoElements;
            XMLMemento historyMemento = (XMLMemento)memento.getChild(this.rootNodeName);
            if (historyMemento == null) {
                return;
            }
            IMemento[] iMementoArray = mementoElements = historyMemento.getChildren(this.infoNodeName);
            int n = mementoElements.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento mementoElement = iMementoArray[n2];
                Object object = this.restoreItemFromMemento(mementoElement);
                if (object != null) {
                    this.historyList.add(object);
                }
                ++n2;
            }
        }

        public void save(IMemento memento) {
            Object[] items;
            IMemento historyMemento = memento.createChild(this.rootNodeName);
            Object[] objectArray = items = this.getHistoryItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                IMemento elementMemento = historyMemento.createChild(this.infoNodeName);
                this.storeItemToMemento(item, elementMemento);
                ++n2;
            }
        }

        public synchronized Object[] getHistoryItems() {
            return this.historyList.toArray();
        }

        protected abstract Object restoreItemFromMemento(IMemento var1);

        protected abstract void storeItemToMemento(Object var1, IMemento var2);
    }

    private class ToggleStatusLineAction
    extends Action {
        public ToggleStatusLineAction() {
            super(Messages.getString("FilteredItemsSelectionDialog_toggleStatusAction"), 2);
        }

        public void run() {
            FilteredItemsSelectionDialog.this.details.setVisible(this.isChecked());
        }
    }
}

