/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.dialogs;

import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import java.io.File;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileChooserDialog {
    private final Shell parentShell;
    private final String[] extensions;
    private final boolean directory;
    private String startPath;
    private String startFileName;
    private static String lastUsedDirectory = null;

    public FileChooserDialog(String[] extensions, Shell parentShell) {
        assert (extensions != null);
        assert (parentShell != null);
        this.extensions = new String[extensions.length];
        int i = 0;
        while (i < extensions.length) {
            String extension = extensions[i];
            if (extension.indexOf(".") < 0) {
                extension = "*." + extension;
            }
            this.extensions[i] = extension;
            ++i;
        }
        this.parentShell = parentShell;
        this.directory = false;
        this.setStartPath(null, true);
    }

    public FileChooserDialog(String[] extensions, File startDirectory, Shell parentShell) {
        this(extensions, parentShell);
        if (startDirectory != null) {
            this.setStartPath(startDirectory.getAbsolutePath(), false);
        } else {
            this.setStartPath(null, true);
        }
    }

    public FileChooserDialog(String[] extensions, File startDirectory, boolean respectDefaultPathPreference, Shell parentShell) {
        this(extensions, parentShell);
        if (startDirectory != null) {
            this.setStartPath(startDirectory.getAbsolutePath(), respectDefaultPathPreference);
        } else {
            this.setStartPath(null, respectDefaultPathPreference);
        }
    }

    public FileChooserDialog(Shell parentShell) {
        this.parentShell = parentShell;
        this.extensions = null;
        this.setStartPath(null, true);
        this.directory = true;
    }

    public FileChooserDialog(File startDirectory, Shell parentShell) {
        this.parentShell = parentShell;
        this.extensions = null;
        if (startDirectory != null) {
            this.setStartPath(startDirectory.getAbsolutePath(), false);
        } else {
            this.setStartPath(null, true);
        }
        this.directory = true;
    }

    public FileChooserDialog(File startDirectory, boolean respectDefaultPathPreference, Shell parentShell) {
        this.parentShell = parentShell;
        this.extensions = null;
        if (startDirectory != null) {
            this.setStartPath(startDirectory.getAbsolutePath(), respectDefaultPathPreference);
        } else {
            this.setStartPath(null, respectDefaultPathPreference);
        }
        this.directory = true;
    }

    public File openForSave() {
        String fileName;
        String string = fileName = this.directory ? this.openDirectoryDialog(8192) : this.openFileDialog(8192);
        if (fileName != null && !fileName.trim().equals("")) {
            File file = new File(fileName);
            return file;
        }
        return null;
    }

    public File openForLoad() {
        String fileName;
        String string = fileName = this.directory ? this.openDirectoryDialog(4096) : this.openFileDialog(4096);
        if (fileName != null && !fileName.trim().equals("")) {
            File file = new File(fileName);
            return file;
        }
        return null;
    }

    public void setStartFileName(String filename) {
        this.startFileName = filename;
    }

    private String openFileDialog(int style) {
        String fileName = null;
        FileDialog dialog = new FileDialog(this.parentShell, style);
        if (this.startFileName != null) {
            dialog.setFileName(this.startFileName);
        }
        dialog.setFilterPath(this.startPath);
        dialog.setFilterExtensions(this.extensions);
        String result = dialog.open();
        if (result != null) {
            fileName = dialog.getFileName().trim();
            if (!fileName.equals("")) {
                fileName = String.valueOf(dialog.getFilterPath()) + File.separatorChar + fileName;
            }
            lastUsedDirectory = dialog.getFilterPath();
        }
        return fileName;
    }

    private String openDirectoryDialog(int style) {
        DirectoryDialog dialog = new DirectoryDialog(this.parentShell, style);
        dialog.setFilterPath(String.valueOf(this.startPath) + (this.startFileName != null ? String.valueOf(File.separator) + this.startFileName : ""));
        String result = dialog.open();
        if (result != null) {
            lastUsedDirectory = dialog.getFilterPath();
        }
        return result;
    }

    public static String getLastUsedDirectory() {
        return lastUsedDirectory;
    }

    private void setStartPath(String path, boolean considerPreferences) {
        if (!considerPreferences || !ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getBoolean("defaultFileSystemPath.IsEnabled")) {
            if (path != null && path.length() > 0) {
                this.startPath = path;
            } else if (lastUsedDirectory != null) {
                this.startPath = lastUsedDirectory;
            }
        }
        if (this.startPath == null) {
            this.startPath = ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getString("defaultFileSystemPath.Path");
        }
    }
}

