/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.dialogs;

import com.arcway.lib.eclipse.gui.dialogs.IArcwayWizard;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardContainer2;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ArcwayWizardDialog
extends TitleAreaDialog
implements IWizardContainer2,
IPageChangeProvider {
    public static final String WIZ_IMG_ERROR = "dialog_title_error_image";
    private IWizard wizard;
    private final ArrayList createdWizards = new ArrayList();
    private final ArrayList nestedWizards = new ArrayList();
    private IWizardPage currentPage = null;
    private long activeRunningOperations = 0L;
    private String pageMessage;
    private int pageMessageType = 0;
    private String pageDescription;
    private ProgressMonitorPart progressMonitorPart;
    private Cursor waitCursor;
    private Cursor arrowCursor;
    private MessageDialog windowClosingDialog;
    private Button backButton;
    private Button nextButton;
    private Button finishButton;
    private Button cancelButton;
    private Button helpButton;
    private final SelectionAdapter cancelListener;
    private boolean isMovingToPreviousPage = false;
    private Composite pageContainer;
    private final PageContainerFillLayout pageContainerLayout = new PageContainerFillLayout(5, 5, 300, 225);
    private int pageWidth = -1;
    private int pageHeight = -1;
    private static final String FOCUS_CONTROL = "focusControl";
    private boolean lockedUI = false;
    private final ListenerList pageChangedListeners = new ListenerList(1);

    public ArcwayWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell);
        this.setShellStyle(0x10870 | ArcwayWizardDialog.getDefaultOrientation());
        this.setWizard(newWizard);
        this.cancelListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArcwayWizardDialog.this.cancelPressed();
            }
        };
    }

    public void setHelpEnabled(boolean enabled) {
        if (this.helpButton != null) {
            this.helpButton.setEnabled(enabled);
        }
    }

    private Object aboutToStart(boolean enableCancelButton) {
        Map savedState = null;
        if (this.getShell() != null) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            boolean needsProgressMonitor = this.wizard.needsProgressMonitor();
            this.cancelButton.removeSelectionListener((SelectionListener)this.cancelListener);
            Display d = this.getShell().getDisplay();
            this.waitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(this.waitCursor);
            this.arrowCursor = new Cursor((Device)d, 0);
            this.cancelButton.setCursor(this.arrowCursor);
            savedState = this.saveUIState(needsProgressMonitor && enableCancelButton);
            if (focusControl != null) {
                savedState.put(FOCUS_CONTROL, focusControl);
            }
            if (needsProgressMonitor) {
                this.progressMonitorPart.attachToCancelComponent((Control)this.cancelButton);
                this.progressMonitorPart.setVisible(true);
            }
        }
        return savedState;
    }

    protected void backPressed() {
        IWizardPage page = this.currentPage.getPreviousPage();
        if (page == null) {
            return;
        }
        this.isMovingToPreviousPage = true;
        this.showPage(page);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 17: {
                this.helpPressed();
                break;
            }
            case 14: {
                this.backPressed();
                break;
            }
            case 15: {
                this.nextPressed();
                break;
            }
            case 16: {
                this.finishPressed();
            }
        }
    }

    private Point calculatePageSizeDelta(IWizardPage page) {
        Control pageControl = page.getControl();
        if (pageControl == null) {
            return new Point(0, 0);
        }
        Point contentSize = pageControl.computeSize(-1, -1, true);
        Rectangle rect = this.pageContainerLayout.getClientArea(this.pageContainer);
        Point containerSize = new Point(rect.width, rect.height);
        return new Point(Math.max(0, contentSize.x - containerSize.x), Math.max(0, contentSize.y - containerSize.y));
    }

    protected void cancelPressed() {
        if (this.activeRunningOperations <= 0L) {
            this.setReturnCode(1);
            this.close();
        } else {
            this.cancelButton.setEnabled(false);
        }
    }

    public boolean close() {
        if (this.okToClose()) {
            return this.hardClose();
        }
        return false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                if (ArcwayWizardDialog.this.currentPage != null) {
                    ArcwayWizardDialog.this.currentPage.performHelp();
                }
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        if (this.wizard.isHelpAvailable()) {
            this.helpButton = this.createButton(parent, 17, IDialogConstants.HELP_LABEL, false);
            this.helpButton.setEnabled(false);
        }
        if (this.wizard.needsPreviousAndNextButtons()) {
            this.createPreviousAndNextButtons(parent);
        }
        if (Display.getDefault().getDismissalAlignment() == 16384) {
            this.finishButton = this.createButton(parent, 16, IDialogConstants.FINISH_LABEL, true);
            this.cancelButton = this.createCancelButton(parent);
        } else {
            this.cancelButton = this.createCancelButton(parent);
            this.finishButton = this.createButton(parent, 16, IDialogConstants.FINISH_LABEL, true);
        }
    }

    private Button createCancelButton(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(IDialogConstants.CANCEL_LABEL);
        button.setFont(parent.getFont());
        button.setData((Object)new Integer(1));
        button.addSelectionListener((SelectionListener)this.cancelListener);
        this.setButtonLayoutData(button);
        return button;
    }

    protected Button getButton(int id) {
        if (id == 1) {
            return this.cancelButton;
        }
        return super.getButton(id);
    }

    protected Control createContents(Composite parent) {
        this.wizard.addPages();
        Control contents = super.createContents(parent);
        this.createPageControls();
        this.showStartingPage();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.pageContainer = this.createPageContainer(composite);
        GridData gd = new GridData(1808);
        gd.widthHint = this.pageWidth;
        gd.heightHint = this.pageHeight;
        this.pageContainer.setLayoutData((Object)gd);
        this.pageContainer.setFont(parent.getFont());
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        this.progressMonitorPart = this.createProgressMonitorPart(composite, pmlayout);
        this.progressMonitorPart.setLayoutData((Object)new GridData(768));
        this.progressMonitorPart.setVisible(false);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(768));
        ArcwayWizardDialog.applyDialogFont((Control)this.progressMonitorPart);
        return composite;
    }

    protected ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
        return new ProgressMonitorPart(composite, (Layout)pmlayout, -1){
            String currentTask;
            {
                this.currentTask = null;
            }

            public void setBlocked(IStatus reason) {
                super.setBlocked(reason);
                if (!ArcwayWizardDialog.this.lockedUI) {
                    ArcwayWizardDialog.getBlockedHandler().showBlocked(this.getShell(), (IProgressMonitor)this, reason, this.currentTask);
                }
            }

            public void clearBlocked() {
                super.clearBlocked();
                if (!ArcwayWizardDialog.this.lockedUI) {
                    ArcwayWizardDialog.getBlockedHandler().clearBlocked();
                }
            }

            public void beginTask(String name, int totalWork) {
                super.beginTask(name, totalWork);
                this.currentTask = name;
            }

            public void setTaskName(String name) {
                super.setTaskName(name);
                this.currentTask = name;
            }

            public void subTask(String name) {
                super.subTask(name);
                if (this.currentTask == null) {
                    this.currentTask = name;
                }
            }
        };
    }

    private Composite createPageContainer(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)this.pageContainerLayout);
        return result;
    }

    private void createPageControls() {
        IWizardPage[] pages;
        this.wizard.createPageControls(this.pageContainer);
        IWizardPage[] iWizardPageArray = pages = this.wizard.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page.getControl() != null) {
                page.getControl().setVisible(false);
            }
            ++n2;
        }
    }

    private void createPreviousAndNextButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(68);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.backButton = this.createButton(composite, 14, IDialogConstants.BACK_LABEL, false);
        this.nextButton = this.createButton(composite, 15, IDialogConstants.NEXT_LABEL, false);
    }

    private MessageDialog createWizardClosingDialog() {
        MessageDialog result = new MessageDialog(this.getShell(), JFaceResources.getString((String)"WizardClosingDialog.title"), null, JFaceResources.getString((String)"WizardClosingDialog.message"), 3, new String[]{IDialogConstants.OK_LABEL}, 0);
        return result;
    }

    protected void finishPressed() {
        if (this.wizard.performFinish()) {
            int i = 0;
            while (i < this.nestedWizards.size() - 1) {
                ((IWizard)this.nestedWizards.get(i)).performFinish();
                ++i;
            }
            this.setReturnCode(0);
            this.hardClose();
        }
    }

    public IWizardPage getCurrentPage() {
        return this.currentPage;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.progressMonitorPart;
    }

    protected IWizard getWizard() {
        return this.wizard;
    }

    private boolean hardClose() {
        int i = 0;
        while (i < this.createdWizards.size()) {
            IWizard createdWizard = (IWizard)this.createdWizards.get(i);
            createdWizard.dispose();
            createdWizard.setContainer(null);
            ++i;
        }
        return super.close();
    }

    protected void helpPressed() {
        if (this.currentPage != null) {
            this.currentPage.performHelp();
        }
    }

    protected void nextPressed() {
        IWizardPage page;
        if (this.wizard instanceof IArcwayWizard) {
            ((IArcwayWizard)this.wizard).nextPageRequested();
        }
        if ((page = this.currentPage.getNextPage()) == null) {
            return;
        }
        this.showPage(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean okToClose() {
        if (this.activeRunningOperations > 0L) {
            ArcwayWizardDialog arcwayWizardDialog = this;
            synchronized (arcwayWizardDialog) {
                this.windowClosingDialog = this.createWizardClosingDialog();
            }
            this.windowClosingDialog.open();
            arcwayWizardDialog = this;
            synchronized (arcwayWizardDialog) {
                this.windowClosingDialog = null;
            }
            return false;
        }
        if (this.wizard instanceof IArcwayWizard) {
            return ((IArcwayWizard)this.wizard).canCancel();
        }
        return this.wizard.performCancel();
    }

    private static void restoreEnableState(Control w, Map<String, Boolean> h, String key) {
        Boolean b;
        if (w != null && (b = h.get(key)) != null) {
            w.setEnabled(b.booleanValue());
        }
    }

    private void restoreUIState(Map<String, Boolean> state) {
        ArcwayWizardDialog.restoreEnableState((Control)this.backButton, state, "back");
        ArcwayWizardDialog.restoreEnableState((Control)this.nextButton, state, "next");
        ArcwayWizardDialog.restoreEnableState((Control)this.finishButton, state, "finish");
        ArcwayWizardDialog.restoreEnableState((Control)this.cancelButton, state, "cancel");
        ArcwayWizardDialog.restoreEnableState((Control)this.helpButton, state, "help");
        Boolean pageValue = state.get("page");
        if (pageValue != null) {
            ((ControlEnableState)pageValue).restore();
        }
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        Object state = null;
        if (this.activeRunningOperations == 0L) {
            state = this.aboutToStart(fork && cancelable);
        }
        ++this.activeRunningOperations;
        try {
            if (!fork) {
                this.lockedUI = true;
            }
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.getProgressMonitor(), (Display)this.getShell().getDisplay());
            this.lockedUI = false;
        }
        finally {
            --this.activeRunningOperations;
            if (state != null) {
                this.stopped(state);
            }
        }
    }

    private void saveEnableStateAndSet(Control w, Map h, String key, boolean enabled) {
        if (w != null) {
            h.put(key, w.getEnabled());
            w.setEnabled(enabled);
        }
    }

    private Map saveUIState(boolean keepCancelEnabled) {
        HashMap<String, ControlEnableState> savedState = new HashMap<String, ControlEnableState>(10);
        this.saveEnableStateAndSet((Control)this.backButton, savedState, "back", false);
        this.saveEnableStateAndSet((Control)this.nextButton, savedState, "next", false);
        this.saveEnableStateAndSet((Control)this.finishButton, savedState, "finish", false);
        this.saveEnableStateAndSet((Control)this.cancelButton, savedState, "cancel", keepCancelEnabled);
        this.saveEnableStateAndSet((Control)this.helpButton, savedState, "help", false);
        if (this.currentPage != null) {
            savedState.put("page", ControlEnableState.disable((Control)this.currentPage.getControl()));
        }
        return savedState;
    }

    private void setDisplayCursor(Cursor c) {
        Shell[] shells;
        Shell[] shellArray = shells = this.getShell().getDisplay().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell element = shellArray[n2];
            element.setCursor(c);
            ++n2;
        }
    }

    public void setMinimumPageSize(int minWidth, int minHeight) {
        Assert.isTrue((minWidth >= 0 && minHeight >= 0 ? 1 : 0) != 0);
        this.pageContainerLayout.minimumWidth = minWidth;
        this.pageContainerLayout.minimumHeight = minHeight;
    }

    public void setMinimumPageSize(Point size) {
        this.setMinimumPageSize(size.x, size.y);
    }

    public void setPageSize(int width, int height) {
        this.pageWidth = width;
        this.pageHeight = height;
    }

    public void setPageSize(Point size) {
        this.setPageSize(size.x, size.y);
    }

    protected void setWizard(IWizard newWizard) {
        this.wizard = newWizard;
        this.wizard.setContainer((IWizardContainer)this);
        if (!this.createdWizards.contains(this.wizard)) {
            this.createdWizards.add(this.wizard);
            this.nestedWizards.add(this.wizard);
            if (this.pageContainer != null) {
                this.createPageControls();
                this.updateSizeForWizard(this.wizard);
                this.pageContainer.layout(true);
            }
        } else {
            int size = this.nestedWizards.size();
            if (size >= 2 && this.nestedWizards.get(size - 2) == this.wizard) {
                this.nestedWizards.remove(size - 1);
            } else {
                this.nestedWizards.add(this.wizard);
            }
        }
    }

    public void showPage(IWizardPage page) {
        if (page == null || page == this.currentPage) {
            return;
        }
        if (!this.isMovingToPreviousPage) {
            page.setPreviousPage(this.currentPage);
        } else {
            this.isMovingToPreviousPage = false;
        }
        if (this.getContents() == null) {
            this.updateForPage(page);
        } else {
            final IWizardPage finalPage = page;
            BusyIndicator.showWhile((Display)this.getContents().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ArcwayWizardDialog.this.updateForPage(finalPage);
                }
            });
        }
        page.setWizard(this.wizard);
    }

    private void updateForPage(IWizardPage page) {
        if (this.wizard != page.getWizard()) {
            this.setWizard(page.getWizard());
        }
        if (page.getControl() == null) {
            page.createControl(this.pageContainer);
            Assert.isNotNull((Object)page.getControl());
            this.updateSize(page);
        }
        IWizardPage oldPage = this.currentPage;
        this.currentPage = page;
        this.currentPage.setVisible(true);
        if (oldPage != null) {
            oldPage.setVisible(false);
        }
        this.update();
    }

    private void showStartingPage() {
        this.currentPage = this.wizard.getStartingPage();
        if (this.currentPage == null) {
            return;
        }
        if (this.currentPage.getControl() == null) {
            this.currentPage.createControl(this.pageContainer);
            Assert.isNotNull((Object)this.currentPage.getControl());
        }
        this.currentPage.setVisible(true);
        this.update();
        this.currentPage.setWizard(this.wizard);
    }

    private void stopped(Object savedState) {
        if (this.getShell() != null) {
            if (this.wizard.needsProgressMonitor()) {
                this.progressMonitorPart.setVisible(false);
                this.progressMonitorPart.removeFromCancelComponent((Control)this.cancelButton);
            }
            Map state = (Map)savedState;
            this.restoreUIState(state);
            this.cancelButton.addSelectionListener((SelectionListener)this.cancelListener);
            this.setDisplayCursor(null);
            this.cancelButton.setCursor(null);
            this.waitCursor.dispose();
            this.waitCursor = null;
            this.arrowCursor.dispose();
            this.arrowCursor = null;
            Control focusControl = (Control)state.get(FOCUS_CONTROL);
            if (focusControl != null) {
                focusControl.setFocus();
            }
        }
    }

    protected void update() {
        this.updateWindowTitle();
        this.updateTitleBar();
        this.updateButtons();
        this.firePageChanged(new PageChangedEvent((IPageChangeProvider)this, (Object)this.getCurrentPage()));
    }

    public void updateButtons() {
        boolean canFlipToNextPage = false;
        boolean canFinish = this.wizard.canFinish();
        if (this.backButton != null) {
            this.backButton.setEnabled(this.currentPage.getPreviousPage() != null);
        }
        if (this.nextButton != null) {
            canFlipToNextPage = this.currentPage.canFlipToNextPage();
            this.nextButton.setEnabled(canFlipToNextPage);
        }
        this.finishButton.setEnabled(canFinish);
        if (canFlipToNextPage && !canFinish) {
            this.getShell().setDefaultButton(this.nextButton);
        } else {
            this.getShell().setDefaultButton(this.finishButton);
        }
        if (this.cancelButton != null && this.wizard instanceof IArcwayWizard) {
            this.cancelButton.setEnabled(((IArcwayWizard)this.wizard).canCancel());
        }
    }

    private void updateDescriptionMessage() {
        this.pageDescription = this.currentPage.getDescription();
        if (this.pageMessage == null) {
            this.setMessage(this.currentPage.getDescription());
        }
    }

    public void updateMessage() {
        if (this.currentPage == null) {
            return;
        }
        this.pageMessage = this.currentPage.getMessage();
        this.pageMessageType = this.pageMessage != null && this.currentPage instanceof IMessageProvider ? ((IMessageProvider)this.currentPage).getMessageType() : 0;
        if (this.pageMessage == null) {
            this.setMessage(this.pageDescription);
        } else {
            this.setMessage(this.pageMessage, this.pageMessageType);
        }
        this.setErrorMessage(this.currentPage.getErrorMessage());
    }

    private void setShellSize(int width, int height) {
        Rectangle size = this.getShell().getBounds();
        size.height = height;
        size.width = width;
        this.getShell().setBounds(this.getConstrainedShellBounds(size));
    }

    protected void updateSize(IWizardPage page) {
        if (page == null || page.getControl() == null) {
            return;
        }
        this.updateSizeForPage(page);
        this.pageContainerLayout.layoutPage(page.getControl());
    }

    public void updateSize() {
        this.updateSize(this.currentPage);
    }

    private void updateSizeForPage(IWizardPage page) {
        Point delta = this.calculatePageSizeDelta(page);
        if (delta.x > 0 || delta.y > 0) {
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + delta.x, shellSize.y + delta.y);
            this.constrainShellSize();
        }
    }

    private void updateSizeForWizard(IWizard sizingWizard) {
        IWizardPage[] pages;
        Point delta = new Point(0, 0);
        IWizardPage[] iWizardPageArray = pages = sizingWizard.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage element = iWizardPageArray[n2];
            Point pageDelta = this.calculatePageSizeDelta(element);
            delta.x = Math.max(delta.x, pageDelta.x);
            delta.y = Math.max(delta.y, pageDelta.y);
            ++n2;
        }
        if (delta.x > 0 || delta.y > 0) {
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + delta.x, shellSize.y + delta.y);
        }
    }

    public void updateTitleBar() {
        String s = null;
        if (this.currentPage != null) {
            s = this.currentPage.getTitle();
        }
        if (s == null) {
            s = "";
        }
        this.setTitle(s);
        if (this.currentPage != null) {
            this.setTitleImage(this.currentPage.getImage());
        }
        this.updateDescriptionMessage();
        this.updateMessage();
    }

    public void updateWindowTitle() {
        if (this.getShell() == null) {
            return;
        }
        String title = this.wizard.getWindowTitle();
        if (title == null) {
            title = "";
        }
        this.getShell().setText(title);
    }

    public Object getSelectedPage() {
        return this.getCurrentPage();
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangedListeners.remove((Object)listener);
    }

    protected void firePageChanged(final PageChangedEvent event) {
        Object[] listeners;
        Object[] objectArray = listeners = this.pageChangedListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPageChangedListener l = (IPageChangedListener)listener;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.pageChanged(event);
                }
            });
            ++n2;
        }
    }

    protected boolean canHandleShellCloseEvent() {
        boolean canhandleShellCloseEvent = true;
        if (this.wizard instanceof IArcwayWizard) {
            IArcwayWizard arcwayWizard = (IArcwayWizard)this.wizard;
            boolean wizardCanHandleShellCloseEvent = arcwayWizard.canClose();
            if (!wizardCanHandleShellCloseEvent && arcwayWizard.showHelpOnPreventedClose() && this.currentPage != null) {
                this.currentPage.performHelp();
            }
            canhandleShellCloseEvent &= wizardCanHandleShellCloseEvent;
        }
        return canhandleShellCloseEvent &= super.canHandleShellCloseEvent();
    }

    protected class PageContainerFillLayout
    extends Layout {
        public int marginWidth = 5;
        public int marginHeight = 5;
        public int minimumWidth = 0;
        public int minimumHeight = 0;

        public PageContainerFillLayout(int mw, int mh, int minW, int minH) {
            this.marginWidth = mw;
            this.marginHeight = mh;
            this.minimumWidth = minW;
            this.minimumHeight = minH;
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point result = null;
            Control[] children = composite.getChildren();
            if (children.length > 0) {
                result = new Point(0, 0);
                Control[] controlArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Control element = controlArray[n2];
                    Point cp = element.computeSize(wHint, hHint, force);
                    result.x = Math.max(result.x, cp.x);
                    result.y = Math.max(result.y, cp.y);
                    ++n2;
                }
                result.x += 2 * this.marginWidth;
                result.y += 2 * this.marginHeight;
            } else {
                Rectangle rect = composite.getClientArea();
                result = new Point(rect.width, rect.height);
            }
            result.x = Math.max(result.x, this.minimumWidth);
            result.y = Math.max(result.y, this.minimumHeight);
            if (wHint != -1) {
                result.x = wHint;
            }
            if (hHint != -1) {
                result.y = hHint;
            }
            return result;
        }

        public Rectangle getClientArea(Composite c) {
            Rectangle rect = c.getClientArea();
            rect.x += this.marginWidth;
            rect.y += this.marginHeight;
            rect.width -= 2 * this.marginWidth;
            rect.height -= 2 * this.marginHeight;
            return rect;
        }

        public void layout(Composite composite, boolean force) {
            Control[] children;
            Rectangle rect = this.getClientArea(composite);
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.setBounds(rect);
                ++n2;
            }
        }

        public void layoutPage(Control w) {
            w.setBounds(this.getClientArea(w.getParent()));
        }

        public void setPageLocation(Control w) {
            w.setLocation(this.marginWidth, this.marginHeight);
        }
    }
}

