/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.dialogs;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.gui.EclipseIcons16x16;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class ArcwayTitleAreaDialog
extends TitleAreaDialog {
    private final boolean withModificationProblemButton;
    private Collection<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();

    public ArcwayTitleAreaDialog(Shell shell, boolean createModificationProblemButton) {
        super(shell);
        this.withModificationProblemButton = createModificationProblemButton;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.withModificationProblemButton) {
            this.createButton(parent, 17, Messages.getString("ModificationProblem.Infos"), false);
            this.setModificationProblems(this.modificationProblems);
        }
        if (Display.getDefault().getDismissalAlignment() == 16384) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        } else {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
        this.dialogConstructed();
    }

    public boolean close() {
        boolean closed = super.close();
        if (closed) {
            this.dispose();
        }
        return closed;
    }

    public final void helpPressed() {
        ModificationProblemsDialog dialog = new ModificationProblemsDialog(this.modificationProblems, this.getShell());
        dialog.open();
    }

    public void setModificationProblems(Collection<IModificationProblem> modificationProblems) {
        this.modificationProblems = new ArrayList<IModificationProblem>(modificationProblems);
        Button btnHelp = this.getButton(17);
        if (btnHelp != null) {
            int severity = ModificationProblemsDialog.getSeverity(modificationProblems);
            btnHelp.setEnabled(!modificationProblems.isEmpty());
            if (severity >= 4) {
                btnHelp.setText(Messages.getString("ModificationProblem.Infos"));
                btnHelp.setImage(EclipseIcons16x16.INFO);
            } else if (severity == 3) {
                btnHelp.setText(Messages.getString("ModificationProblem.Warnings"));
                btnHelp.setImage(EclipseIcons16x16.WARNING);
            } else {
                btnHelp.setText(Messages.getString("ModificationProblem.Errors"));
                btnHelp.setImage(EclipseIcons16x16.ERROR);
            }
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 17) {
            this.helpPressed();
        }
        super.buttonPressed(buttonId);
    }

    protected void dialogConstructed() {
    }

    protected abstract void dispose();
}

