/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.gui.EclipseIcons16x16;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.ui.IModificationProblem;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ModificationProblemsDialog
extends TitleAreaDialog {
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 380;
    private final Map<String, Map<Integer, Set<String>>> cause2severity2consequences;
    private final String title;
    private int initialWidth = 400;
    private int initialHeight = 380;
    private final int messageType;
    private final String message;
    private Image titleImage;
    private final Color backgroundColor;

    public static void showModificationProblemsDialog(Collection<? extends IModificationProblem> modificationProblems, Shell parentShell) {
        ModificationProblemsDialog modificationProblemsDialog = new ModificationProblemsDialog(modificationProblems, null, null, parentShell);
        modificationProblemsDialog.open();
    }

    public static void showModificationProblemsDialog(Collection<? extends IModificationProblem> modificationProblems, String title, Shell parentShell) {
        ModificationProblemsDialog modificationProblemsDialog = new ModificationProblemsDialog(modificationProblems, title, null, parentShell);
        modificationProblemsDialog.open();
    }

    public static void showModificationProblemsDialog(Collection<? extends IModificationProblem> modificationProblems, String title, String message, Shell parentShell) {
        ModificationProblemsDialog modificationProblemsDialog = new ModificationProblemsDialog(modificationProblems, title, message, parentShell);
        modificationProblemsDialog.open();
    }

    public static void showModificationProblemsDialog(Collection<? extends IModificationProblem> modificationProblems, String title, String message, Shell parentShell, int initialWidth, int initialHeight) {
        ModificationProblemsDialog modificationProblemsDialog = new ModificationProblemsDialog(modificationProblems, title, message, parentShell);
        modificationProblemsDialog.initialWidth = initialWidth;
        modificationProblemsDialog.initialHeight = initialHeight;
        modificationProblemsDialog.open();
    }

    public static final int getMessageProviderLevel(int modificationProblemSeverity) {
        int messageProviderLevel = modificationProblemSeverity >= 4 ? 1 : (modificationProblemSeverity == 3 ? 2 : 3);
        return messageProviderLevel;
    }

    public static final int getSeverity(Collection<? extends IModificationProblem> modificationProblems) {
        int severity = 4;
        for (IModificationProblem iModificationProblem : modificationProblems) {
            severity = Math.min(severity, iModificationProblem.getSeverity());
        }
        return severity;
    }

    public ModificationProblemsDialog(Collection<? extends IModificationProblem> modificationProblems, Shell parentShell) {
        this(modificationProblems, null, parentShell);
    }

    public ModificationProblemsDialog(Collection<? extends IModificationProblem> modificationProblems, String title, Shell parentShell) {
        this(modificationProblems, title, null, parentShell);
    }

    public ModificationProblemsDialog(Collection<? extends IModificationProblem> modificationProblems, String title, String message, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        int severity = ModificationProblemsDialog.getSeverity(modificationProblems);
        this.title = title != null ? title : (severity == 2 ? Messages.getString("ModificationProblem.Errors") : (severity == 3 ? Messages.getString("ModificationProblem.Warnings") : Messages.getString("ModificationProblem.Infos")));
        this.message = message != null ? message : (severity == 2 ? Messages.getString("ModificationProblem.Message.Errors") : (severity == 3 ? Messages.getString("ModificationProblem.Message.Warnings") : Messages.getString("ModificationProblem.Message.Infos")));
        this.messageType = ModificationProblemsDialog.getMessageProviderLevel(severity);
        this.cause2severity2consequences = new HashMap<String, Map<Integer, Set<String>>>();
        for (IModificationProblem iModificationProblem : modificationProblems) {
            String consequence;
            Integer currentSeverity = iModificationProblem.getSeverity();
            String cause = iModificationProblem.getHumanReadableDescriptionOfCause();
            if (cause == null) {
                cause = "";
            }
            if ((consequence = iModificationProblem.getHumanReadableDescriptionOfConsequence()) == null) {
                consequence = "";
            }
            if (cause.length() <= 0 && consequence.length() <= 0) continue;
            Map<Integer, Set<String>> severity2consequences = this.cause2severity2consequences.get(cause);
            if (severity2consequences == null) {
                severity2consequences = new HashMap<Integer, Set<String>>();
                this.cause2severity2consequences.put(cause, severity2consequences);
            }
            if (consequence.length() <= 0) continue;
            Set<String> consequences = severity2consequences.get(currentSeverity);
            if (consequences == null) {
                consequences = new HashSet<String>();
                severity2consequences.put(currentSeverity, consequences);
            }
            consequences.add(consequence);
        }
        this.backgroundColor = new Color(null, 255, 255, 240);
    }

    public boolean close() {
        this.backgroundColor.dispose();
        this.titleImage.dispose();
        return super.close();
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.titleImage = this.createTitleImage(this.messageType);
        this.setTitleImage(this.titleImage);
    }

    private Image createTitleImage(int messageType_) {
        final Image wizardBannerBase = JFaceResources.getImage((String)"dialog_title_banner_image");
        Image severityImage = null;
        if (messageType_ == 1) {
            severityImage = this.getShell().getDisplay().getSystemImage(2);
        } else if (messageType_ == 2) {
            severityImage = this.getShell().getDisplay().getSystemImage(8);
        } else if (messageType_ == 3) {
            severityImage = this.getShell().getDisplay().getSystemImage(1);
        }
        final Image finalSeverityImage = severityImage;
        CompositeImageDescriptor titleImageDescriptor = new CompositeImageDescriptor(){

            protected Point getSize() {
                return new Point(wizardBannerBase.getImageData().width, wizardBannerBase.getImageData().height);
            }

            protected void drawCompositeImage(int width, int height) {
                this.drawImage(wizardBannerBase.getImageData(), 0, 0);
                if (finalSeverityImage != null) {
                    this.drawImage(finalSeverityImage.getImageData(), (wizardBannerBase.getImageData().width - finalSeverityImage.getImageData().width) / 2, (wizardBannerBase.getImageData().height - finalSeverityImage.getImageData().height) / 2);
                }
            }
        };
        return titleImageDescriptor.createImage();
    }

    protected Point getInitialSize() {
        return new Point(this.initialWidth, this.initialHeight);
    }

    protected Point getInitialLocation(Point initialSize) {
        return new Point(this.getParentShell().getLocation().x + (this.getParentShell().getSize().x - this.initialWidth) / 2, this.getParentShell().getLocation().y + (this.getParentShell().getSize().y - this.initialHeight) / 2);
    }

    protected Control createDialogArea(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridData baseGridData = new GridData(4, 4, true, true);
        base.setLayoutData((Object)baseGridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        base.setLayout((Layout)layout);
        Composite innerBase = new Composite(base, 2048);
        GridData innerBaseGridData = new GridData(4, 4, true, true);
        innerBase.setLayoutData((Object)innerBaseGridData);
        EclipseSWTHelper.createScrollableComposite(innerBase, -1, 200, new EclipseSWTHelper.IScrollableContentCreator(){

            @Override
            public void createContent(Composite contentComposite) {
                ModificationProblemsDialog.this.createWidgetForModificationProblems(contentComposite);
            }
        });
        return base;
    }

    private void createWidgetForModificationProblems(Composite contentComposite) {
        boolean first = true;
        GridLayout contentLayout = new GridLayout();
        contentLayout.marginWidth = 0;
        contentLayout.marginHeight = 0;
        contentLayout.verticalSpacing = 0;
        contentComposite.setLayout((Layout)contentLayout);
        contentComposite.setBackground(this.backgroundColor);
        for (Map.Entry<String, Map<Integer, Set<String>>> cause2severity2consequences_entry : this.cause2severity2consequences.entrySet()) {
            if (!first) {
                this.addHorizontalLineWidget(contentComposite);
            } else {
                first = false;
            }
            Control widget = this.createWidgetForCauseAndConsequences(cause2severity2consequences_entry.getKey(), cause2severity2consequences_entry.getValue(), contentComposite);
            widget.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        contentComposite.forceFocus();
    }

    private void addHorizontalLineWidget(Composite contentComposite) {
        LineSeparator separator = new LineSeparator(contentComposite, 0);
        separator.setBackground(this.backgroundColor);
        GridData gridData = new GridData(4, 1, true, false);
        separator.setLayoutData(gridData);
    }

    private Control createWidgetForCauseAndConsequences(String cause, Map<Integer, Set<String>> severity2consequences, Composite parent) {
        Composite outerGrid = new Composite(parent, 0);
        GridData outerGridData = new GridData(4, 4, true, false);
        outerGrid.setLayoutData((Object)outerGridData);
        GridLayout outerGridLayout = new GridLayout(2, false);
        outerGrid.setLayout((Layout)outerGridLayout);
        outerGrid.setBackground(this.backgroundColor);
        for (Map.Entry<Integer, Set<String>> severity2consequencesEntry : severity2consequences.entrySet()) {
            int currentSeverity = severity2consequencesEntry.getKey();
            Set<String> consequences = severity2consequencesEntry.getValue();
            this.createWidgetForConsequences(currentSeverity, consequences, outerGrid);
        }
        if (cause.length() > 0) {
            this.createWidgetForCause(cause, outerGrid);
        }
        return outerGrid;
    }

    private void createWidgetForCause(String cause, Composite outerGrid) {
        Label icon = new Label(outerGrid, 0);
        icon.setLayoutData((Object)new GridData(2, 1, false, false));
        icon.setBackground(this.backgroundColor);
        Composite innerGrid = new Composite(outerGrid, 0);
        innerGrid.setLayoutData((Object)new GridData(4, 1, true, false));
        innerGrid.setLayout((Layout)new GridLayout());
        innerGrid.setBackground(this.backgroundColor);
        StyledText line3 = new StyledText(innerGrid, 16456);
        line3.setBackground(this.backgroundColor);
        line3.setLayoutData((Object)new GridData(4, 1, true, false));
        line3.setText(Messages.getString("ModificationProblemDialog.Cause"));
        StyleRange styleRange3 = new StyleRange();
        styleRange3.length = line3.getText().length();
        styleRange3.fontStyle = 1;
        styleRange3.underline = true;
        line3.setStyleRange(styleRange3);
        StyledText line4 = new StyledText(innerGrid, 16456);
        line4.setBackground(this.backgroundColor);
        line4.setLayoutData((Object)new GridData(4, 1, true, false));
        line4.setText(cause);
    }

    private void createWidgetForConsequences(int currentSeverity, Set<String> consequences, Composite outerGrid) {
        Label icon = new Label(outerGrid, 0);
        icon.setLayoutData((Object)new GridData(2, 1, false, false));
        icon.setBackground(this.backgroundColor);
        if (currentSeverity >= 4) {
            icon.setImage(EclipseIcons16x16.INFO);
        } else if (currentSeverity == 3) {
            icon.setImage(EclipseIcons16x16.WARNING);
        } else {
            icon.setImage(EclipseIcons16x16.ERROR);
        }
        Composite innerGrid = new Composite(outerGrid, 0);
        innerGrid.setLayoutData((Object)new GridData(4, 1, true, false));
        innerGrid.setLayout((Layout)new GridLayout(1, false));
        innerGrid.setBackground(this.backgroundColor);
        StyledText line1 = new StyledText(innerGrid, 72);
        line1.setBackground(this.backgroundColor);
        line1.setLayoutData((Object)new GridData(4, 1, true, false));
        if (consequences.size() == 1) {
            if (currentSeverity >= 4) {
                line1.setText(Messages.getString("ModificationProblem.Info"));
            } else if (currentSeverity == 3) {
                line1.setText(Messages.getString("ModificationProblem.Warning"));
            } else {
                line1.setText(Messages.getString("ModificationProblem.Error"));
            }
        } else if (currentSeverity >= 4) {
            line1.setText(Messages.getString("ModificationProblem.Infos"));
        } else if (currentSeverity == 3) {
            line1.setText(Messages.getString("ModificationProblem.Warnings"));
        } else {
            line1.setText(Messages.getString("ModificationProblem.Errors"));
        }
        StyleRange styleRange1 = new StyleRange();
        styleRange1.length = line1.getText().length();
        styleRange1.fontStyle = 1;
        styleRange1.underline = true;
        line1.setStyleRange(styleRange1);
        for (String consequence : consequences) {
            StyledText line2 = new StyledText(innerGrid, 72);
            line2.setBackground(this.backgroundColor);
            line2.setLayoutData((Object)new GridData(4, 1, true, false));
            line2.setText(consequence);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

