/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class DecoratedImageDescriptor
extends CompositeImageDescriptor {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private final ImageData baseImageData;
    private final ImageDescriptor[] overlays = new ImageDescriptor[4];

    public DecoratedImageDescriptor(ImageDescriptor base) {
        this.baseImageData = base.getImageData();
    }

    public DecoratedImageDescriptor(Image base) {
        this.baseImageData = base.getImageData();
    }

    public void addDecorator(ImageDescriptor imageDescriptor, int corner) {
        this.overlays[corner] = imageDescriptor;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.baseImageData, 0, 0);
        this.drawOverlays(this.overlays);
    }

    private void drawOverlays(ImageDescriptor[] overlays) {
        int i = 0;
        while (i < overlays.length) {
            ImageDescriptor overlay = overlays[i];
            if (overlay != null) {
                ImageData overlayData = overlay.getImageData();
                if (overlayData == null) {
                    overlayData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                switch (i) {
                    case 0: {
                        this.drawImage(overlayData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(overlayData, this.baseImageData.width - overlayData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(overlayData, 0, this.baseImageData.height - overlayData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(overlayData, this.baseImageData.width - overlayData.width, this.baseImageData.height - overlayData.height);
                    }
                }
            }
            ++i;
        }
    }

    public Point getSize() {
        return new Point(this.baseImageData.width, this.baseImageData.height);
    }
}

