/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui;

import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class CheckboxImages {
    private static final int BUTTON_SIZE = 16;
    private static final HashMap<String, Image> images = new HashMap(8);

    public static Image getCheckboxImage(Display display, boolean selected, boolean grayed, boolean enabled) {
        return CheckboxImages.getCheckboxImage(display, selected, grayed, enabled, 16);
    }

    public static Image getCheckboxImage(Display display, boolean selected, boolean grayed, boolean enabled, int width) {
        String key = CheckboxImages.generateKey(selected, grayed, enabled, width);
        Image image = images.get(key);
        if (image == null || image.isDisposed()) {
            image = CheckboxImages.createCheckboxImage(display, selected, grayed, enabled, width);
            images.put(key, image);
        }
        return image;
    }

    private static Image createCheckboxImage(Display display, boolean selected, boolean grayed, boolean enabled, int width) {
        if (display == null || display.isDisposed()) {
            return null;
        }
        Control focusedControl = display.getFocusControl();
        Color transparentColor = new Color((Device)display, 16, 16, 16);
        Shell shell = new Shell(display, 525552);
        shell.setSize(width + 40, 56);
        shell.setBackground(transparentColor);
        Button button = new Button((Composite)shell, 0x40000020);
        button.setSelection(selected);
        button.setEnabled(enabled);
        button.setGrayed(grayed);
        button.setSize(width, 16);
        button.setLocation(0, 0);
        button.setBackground(transparentColor);
        Image image = new Image((Device)display, width, 16);
        image.setBackground(transparentColor);
        Transform move = new Transform((Device)display);
        move.translate((float)((width - 16) / 2), 0.0f);
        GC gc = new GC((Drawable)image);
        gc.setAdvanced(true);
        gc.setBackground(transparentColor);
        gc.fillRectangle(0, 0, width, 16);
        gc.setTransform(move);
        shell.open();
        button.print(gc);
        shell.close();
        ImageData data = image.getImageData();
        data.transparentPixel = data.palette.getPixel(transparentColor.getRGB());
        Image realImage = new Image((Device)display, data);
        if (focusedControl != null) {
            int tries = 10;
            while (!focusedControl.isFocusControl() && tries > 0) {
                focusedControl.setFocus();
                --tries;
            }
        }
        transparentColor.dispose();
        gc.dispose();
        image.dispose();
        move.dispose();
        shell.dispose();
        return realImage;
    }

    private static String generateKey(boolean selected, boolean grayed, boolean enabled, int width) {
        return String.valueOf(String.valueOf(selected)) + String.valueOf(grayed) + String.valueOf(enabled) + String.valueOf(width);
    }
}

