/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics.print;

import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.eclipse.graphics.print.ISWTPrinterRequiringDispose;
import com.arcway.lib.eclipse.graphics.print.SWTPrinter;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.print.IImagePrinterPageDescription;
import com.arcway.lib.graphics.print.IPrinter;
import com.arcway.lib.graphics.print.ImagePrinter;
import com.arcway.lib.graphics.print.ImagePrinterPageDescription;
import com.arcway.lib.graphics.print.PrintingFailure;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;

public class SWTPrinterWithImagePrintFallback
implements IPrinter,
ISWTPrinterRequiringDispose {
    private static final int DPI_TRESHOLD = 150;
    private static final int EMULATED_DPI = 300;
    private final Printer printer;
    private final IImagePrinterPageDescription imageInfoInMM;
    private final com.arcway.lib.geometry.Rectangle pageSizeRectangleInMM;
    private final com.arcway.lib.geometry.Rectangle drawingAreaRectangleInMM;
    private final int printerCopyPara_srcX;
    private final int printerCopyPara_srcY;
    private final int printerCopyPara_srcWidth;
    private final int printerCopyPara_srcHeight;
    private final int printerCopyPara_destX;
    private final int printerCopyPara_destY;
    private final int printerCopyPara_destWidth;
    private final int printerCopyPara_destHeight;
    private ImagePrinter imagePrinter;
    private int pageCounter = 0;

    public static IPrinter createSWTPrinter(PrinterData swtPrinterData) {
        boolean printerResolutionIsGarbled;
        assert (swtPrinterData != null) : "printer data is null";
        Printer swtPrinter = new Printer(swtPrinterData);
        if ("win32".equals(Platform.getOS())) {
            printerResolutionIsGarbled = false;
        } else {
            int printer_dpi_hor = swtPrinter.getDPI().x;
            int printer_dpi_ver = swtPrinter.getDPI().y;
            boolean bl = printerResolutionIsGarbled = Math.max(printer_dpi_hor, printer_dpi_ver) < 150;
        }
        if (printerResolutionIsGarbled) {
            return new SWTPrinterWithImagePrintFallback(swtPrinter);
        }
        return new SWTPrinter(swtPrinter);
    }

    public SWTPrinterWithImagePrintFallback(Printer p_printer) {
        int imageDPI_h = 300;
        int imageDPI_v = 300;
        this.printer = p_printer;
        int printer_dpi_hor = this.printer.getDPI().x;
        int printer_dpi_ver = this.printer.getDPI().y;
        Rectangle paperBounds = this.printer.getBounds();
        int paper_width = paperBounds.width;
        int paper_height = paperBounds.height;
        Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
        int left_trim = -trim.x;
        int right_trim = trim.x + trim.width;
        int top_trim = -trim.y;
        int bottom_trim = trim.y + trim.height;
        int h_trim = left_trim + right_trim;
        int v_trim = top_trim + bottom_trim;
        Rectangle clientArea = this.printer.getClientArea();
        int printable_width = clientArea.width;
        int printable_heigth = clientArea.height;
        int h_margins = paper_width - printable_width;
        int v_margins = paper_height - printable_heigth;
        double avg_h_margin = (double)h_margins / 2.0;
        double avg_v_margin = (double)v_margins / 2.0;
        double imageToPrinterDpiRatio_h = 300.0 / (double)printer_dpi_hor;
        double imageToPrinterDpiRatio_v = 300.0 / (double)printer_dpi_ver;
        this.printerCopyPara_srcX = (int)Math.floor((double)left_trim * imageToPrinterDpiRatio_h);
        this.printerCopyPara_srcY = (int)Math.floor((double)top_trim * imageToPrinterDpiRatio_v);
        this.printerCopyPara_srcWidth = (int)Math.ceil((double)printable_width * imageToPrinterDpiRatio_h);
        this.printerCopyPara_srcHeight = (int)Math.ceil((double)printable_heigth * imageToPrinterDpiRatio_v);
        this.printerCopyPara_destX = 0;
        this.printerCopyPara_destY = 0;
        this.printerCopyPara_destWidth = printable_width;
        this.printerCopyPara_destHeight = printable_heigth;
        double wInMM = 25.4 * (double)paper_width / (double)printer_dpi_hor;
        double hInMM = 25.4 * (double)paper_height / (double)printer_dpi_ver;
        this.imageInfoInMM = ImagePrinterPageDescription.createImageInfoInMM((double)wInMM, (double)hInMM, (Insets)new Insets(0.0, 0.0, 0.0, 0.0), (double)300.0, (double)300.0, (Color)Color.WHITE);
        this.pageSizeRectangleInMM = new com.arcway.lib.geometry.Rectangle(0.0, 0.0, this.imageInfoInMM.getPageDimension().width, this.imageInfoInMM.getPageDimension().height);
        this.drawingAreaRectangleInMM = new com.arcway.lib.geometry.Rectangle(25.4 / (double)printer_dpi_hor * (double)left_trim, 25.4 / (double)printer_dpi_ver * (double)top_trim, 25.4 / (double)printer_dpi_hor * (double)(left_trim + printable_width - 1), 25.4 / (double)printer_dpi_ver * (double)(top_trim + printable_heigth - 1));
    }

    public com.arcway.lib.geometry.Rectangle getPageSize() {
        return this.pageSizeRectangleInMM;
    }

    public com.arcway.lib.geometry.Rectangle getDrawingArea() {
        return this.drawingAreaRectangleInMM;
    }

    public void performJob(String jobName, IPrinter.IPrintingJobProcessor jobProcessor) throws PrintingFailure {
        this.printer.startJob(jobName);
        jobProcessor.processPrintingJob(new IPrinter.IPrintingJob(){

            public void drawPage(final com.arcway.lib.geometry.Rectangle totalDrawingHint, final IPrinter.IPagePrinter pagePrinter) throws PrintingFailure {
                SWTPrinterWithImagePrintFallback sWTPrinterWithImagePrintFallback = SWTPrinterWithImagePrintFallback.this;
                sWTPrinterWithImagePrintFallback.pageCounter = sWTPrinterWithImagePrintFallback.pageCounter + 1;
                SWTPrinterWithImagePrintFallback.this.imagePrinter = new ImagePrinter(SWTPrinterWithImagePrintFallback.this.imageInfoInMM);
                SWTPrinterWithImagePrintFallback.this.imagePrinter.performJob("ImagePrint-" + SWTPrinterWithImagePrintFallback.this.pageCounter, new IPrinter.IPrintingJobProcessor(){

                    public void processPrintingJob(IPrinter.IPrintingJob printingJob) throws PrintingFailure {
                        printingJob.drawPage(totalDrawingHint, new IPrinter.IPagePrinter(){

                            public void printPage(com.arcway.lib.graphics.device.Device device) throws PrintingFailure {
                                pagePrinter.printPage(device);
                            }
                        });
                    }
                });
                Collection createdImages = SWTPrinterWithImagePrintFallback.this.imagePrinter.getCreatedImages();
                for (Image pageImage : createdImages) {
                    IOffscreenBitmap offscreenBitmap = pageImage.getOffscreenBitmap();
                    if (!(offscreenBitmap instanceof SWTOffscreenBitmap)) continue;
                    SWTOffscreenBitmap swtOffscreenBitmap = (SWTOffscreenBitmap)offscreenBitmap;
                    org.eclipse.swt.graphics.Image offscreenImage = swtOffscreenBitmap.getWrappedSWTImage();
                    ImageData imageData = offscreenImage.getImageData();
                    org.eclipse.swt.graphics.Image printImage = new org.eclipse.swt.graphics.Image((Device)SWTPrinterWithImagePrintFallback.this.printer, imageData);
                    imageData = null;
                    if (SWTPrinterWithImagePrintFallback.this.printer.startPage()) {
                        GC gc = new GC((Drawable)SWTPrinterWithImagePrintFallback.this.printer);
                        gc.drawImage(printImage, SWTPrinterWithImagePrintFallback.this.printerCopyPara_srcX, SWTPrinterWithImagePrintFallback.this.printerCopyPara_srcY, SWTPrinterWithImagePrintFallback.this.printerCopyPara_srcWidth, SWTPrinterWithImagePrintFallback.this.printerCopyPara_srcHeight, SWTPrinterWithImagePrintFallback.this.printerCopyPara_destX, SWTPrinterWithImagePrintFallback.this.printerCopyPara_destY, SWTPrinterWithImagePrintFallback.this.printerCopyPara_destWidth, SWTPrinterWithImagePrintFallback.this.printerCopyPara_destHeight);
                        gc.dispose();
                        SWTPrinterWithImagePrintFallback.this.printer.endPage();
                    }
                    printImage.dispose();
                }
                SWTPrinterWithImagePrintFallback.this.imagePrinter.disposeImages();
            }
        });
        this.printer.endJob();
    }

    @Override
    public void dispose() {
        this.printer.dispose();
    }
}

