/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics.image;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.IOException;
import java.io.InputStream;

public class BMPResolutionFetcher {
    private static final ILogger LOGGER = Logger.getLogger(BMPResolutionFetcher.class);
    static final int BMPFileHeaderSize = 14;
    static final int BMPHeaderFixedSize = 40;

    public static Point fetchResolutionInPixelsPerMeter(InputStream bmpStream) throws EXImageDataTypeNotSupported, JvmExternalResourceInteractionException, EXCorruptImageFileContent {
        try {
            int[] header = new int[]{BMPResolutionFetcher.readShort(bmpStream), BMPResolutionFetcher.readInt(bmpStream), BMPResolutionFetcher.readShort(bmpStream), BMPResolutionFetcher.readShort(bmpStream), BMPResolutionFetcher.readInt(bmpStream)};
            if (header[0] != 19778) {
                throw new EXImageDataTypeNotSupported("Invalid BMP file header. Wrong \"type\" value: " + Integer.toHexString(header[0]));
            }
            byte[] infoHeader = new byte[40];
            int readInfoHeaderBytes = bmpStream.read(infoHeader);
            if (readInfoHeaderBytes != 40) {
                throw new EXCorruptImageFileContent("No or incomplete BMP Info Header detected (numInfoHeaderBytes=" + readInfoHeaderBytes + ").");
            }
            int xPelsPerMeter = infoHeader[24] & 0xFF | (infoHeader[25] & 0xFF) << 8 | (infoHeader[26] & 0xFF) << 16 | (infoHeader[27] & 0xFF) << 24;
            int yPelsPerMeter = infoHeader[28] & 0xFF | (infoHeader[29] & 0xFF) << 8 | (infoHeader[30] & 0xFF) << 16 | (infoHeader[31] & 0xFF) << 24;
            if (xPelsPerMeter == 0 || yPelsPerMeter == 0) {
                return null;
            }
            Point point = new Point((double)xPelsPerMeter, (double)yPelsPerMeter);
            return point;
        }
        catch (IOException e) {
            try {
                bmpStream.close();
            }
            catch (IOException e1) {
                LOGGER.error("IOException in exception handling", (Throwable)e1);
            }
            throw new JvmExternalResourceInteractionException((Throwable)e);
        }
        finally {
            if (bmpStream != null) {
                try {
                    bmpStream.close();
                }
                catch (IOException e1) {
                    LOGGER.error("Unable to close BMP image data Stream", (Throwable)e1);
                }
            }
        }
    }

    private static int readInt(InputStream leDataInputStream) throws IOException {
        byte[] buf = new byte[4];
        leDataInputStream.read(buf);
        return (buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
    }

    private static short readShort(InputStream leDataInputStream) throws IOException {
        byte[] buf = new byte[2];
        leDataInputStream.read(buf);
        return (short)((buf[1] & 0xFF) << 8 | buf[0] & 0xFF);
    }

    private BMPResolutionFetcher() {
    }
}

