/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics.devicedrivers;

import com.arcway.lib.eclipse.graphics.SWTDefaultRendererManager;
import com.arcway.lib.eclipse.graphics.SWTFont;
import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.eclipse.graphics.SWTRenderer;
import com.arcway.lib.eclipse.graphics.devicedrivers.DeviceDriverSWTGCFitter;
import com.arcway.lib.eclipse.graphics.devicedrivers.ISWTOffscreenBitmapBackdoor;
import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TransformationAffiliate;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.device.IDeviceRunnable;
import com.arcway.lib.graphics.devicedrivers.DeviceDriverInterpolating;
import com.arcway.lib.graphics.devicedrivers.IDeviceDriverOffscreenBitmap;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.text.EXFontSizeTooSmall;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.lib.java.To;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Transform;

public class DeviceDriverSWTGC
extends DeviceDriverInterpolating
implements IDeviceDriverOffscreenBitmap {
    private static final ILogger logger = Logger.getLogger(DeviceDriverSWTGC.class);
    public static final boolean USE_SCALING_TO_CORRECT_FONT_SIZE_ROUNDING_ERROR = false;
    private final Device device;
    private final GC gc;
    private final DeviceDriverSWTGCFitter fitter;
    private Color swtForegroundColor = null;
    private Color swtBackgroundColor = null;
    private Font currentFont = null;
    private String currentFontName = "";
    private int currentFontStyle = 0;
    private double currentLineHeight = 0.0;
    private final boolean disposeGC;
    private final ISWTOffscreenBitmapBackdoor swtOffscreenBitmapBackdoor;
    private Transform currentSwtTrafo = null;
    private TransformationAffiliate currentTransformation = TransformationAffiliate.newTransformationNOP();

    public DeviceDriverSWTGC(Device device, GC gc, boolean canUseAdvancedGraphicsAPI) {
        this(device, gc, false, canUseAdvancedGraphicsAPI, null);
    }

    public DeviceDriverSWTGC(Device device, Drawable drawable, boolean canUseAdvancedGraphicsAPI) {
        this(device, new GC(drawable), true, canUseAdvancedGraphicsAPI, null);
    }

    public DeviceDriverSWTGC(Device device, Drawable drawable, boolean canUseAdvancedGraphicsAPI, ISWTOffscreenBitmapBackdoor swtOffscreenBitmapBackdoor) {
        this(device, new GC(drawable), true, canUseAdvancedGraphicsAPI, swtOffscreenBitmapBackdoor);
    }

    private DeviceDriverSWTGC(Device device, GC gc, boolean disposeGC, boolean canUseAdvancedGraphicsAPI, ISWTOffscreenBitmapBackdoor swtOffscreenBitmapBackdoor) {
        assert (gc != null) : "graphics = null";
        this.device = device;
        this.gc = gc;
        this.disposeGC = disposeGC;
        this.fitter = new DeviceDriverSWTGCFitter();
        this.swtOffscreenBitmapBackdoor = swtOffscreenBitmapBackdoor;
        if (canUseAdvancedGraphicsAPI) {
            gc.setAdvanced(true);
            if (gc.getAdvanced()) {
                gc.setAntialias(1);
                gc.setTextAntialias(1);
                gc.setInterpolation(0);
                gc.setAlpha(255);
            }
        }
        gc.setLineCap(2);
        gc.setLineJoin(2);
        gc.setLineStyle(1);
        this.setLineWidth(To.toDouble((int)gc.getLineWidth()));
        this.setLineScale(this.getLineWidth());
        this.setLineColor(this.colorFromSWT(gc.getForeground()));
        this.setTextColor(this.colorFromSWT(gc.getForeground()));
        this.setFillAttributes(new com.arcway.lib.graphics.Color(this.colorFromSWT(gc.getBackground())), 255);
    }

    public <T extends Throwable> void subElement(String elementName, String elementTypeID, String elementID, TransformationAffiliate optionalTransformation, IDeviceRunnable<T> runnable) throws T {
        if (optionalTransformation != null) {
            this.withTransformation(optionalTransformation, runnable);
        } else {
            runnable.run();
        }
    }

    private <T extends Throwable> void withTransformation(TransformationAffiliate transformation, IDeviceRunnable<T> runnable) throws T {
        TransformationAffiliate resultingTrafo;
        TransformationAffiliate currentTrafo = this.currentTransformation;
        this.currentTransformation = resultingTrafo = transformation.transform(currentTrafo);
        this.setTransformation(resultingTrafo);
        try {
            runnable.run();
        }
        finally {
            this.setTransformation(currentTrafo);
            this.currentTransformation = currentTrafo;
        }
    }

    private void setTransformation(TransformationAffiliate transformation) {
        this.disposeTrafo();
        if (!transformation.isNOPTransformation()) {
            this.currentSwtTrafo = new Transform(this.gc.getDevice(), (float)transformation.getM11(), (float)transformation.getM21(), (float)transformation.getM12(), (float)transformation.getM22(), (float)transformation.getDx(), (float)transformation.getDy());
        }
        this.gc.setTransform(this.currentSwtTrafo);
    }

    public void setLineColor(com.arcway.lib.graphics.Color lineColor) {
        super.setLineColor(lineColor);
        this.updateForegroundColorForLineDrawing();
    }

    public void setLineWidth(double lineWidth) {
        super.setLineWidth(lineWidth);
        this.gc.setLineWidth((int)this.fitter.lineWidthFit(lineWidth));
    }

    public void setFillAttributes(com.arcway.lib.graphics.Color fillColor, int fillAlpha) {
        super.setFillAttributes(fillColor, fillAlpha);
        this.updateBackgroundColorForFillDrawing();
    }

    public void setTextFontName(String fontName) {
        super.setTextFontName(fontName);
    }

    public void setTextSize(double height, double textTop, double textAscent, double textDescent) {
        super.setTextSize(height, textTop, textAscent, textDescent);
    }

    public void setTextBold(boolean bold) {
        super.setTextBold(bold);
    }

    public void setTextItalic(boolean italic) {
        super.setTextItalic(italic);
    }

    protected void fillPoints(Points points) {
        assert (points != null) : "points = null";
        boolean advanced = this.gc.getAdvanced();
        if (this.getFillAlpha() == 255 || advanced && this.getFillAlpha() > 0) {
            if (advanced) {
                this.gc.setAlpha(this.getFillAlpha());
            }
            this.gc.fillPolygon(this.convertToSWTPointList(points));
            if (advanced) {
                this.gc.setAlpha(255);
            }
        }
    }

    public void dispose(byte[] pngOrJpgFileData) {
        if (this.swtOffscreenBitmapBackdoor != null) {
            this.swtOffscreenBitmapBackdoor.setOptionalPngOrJpgFileData(pngOrJpgFileData);
        }
        this.dispose();
    }

    public void dispose() {
        this.disposeForegroundColor();
        this.disposeBackgroundColor();
        this.disposeFont();
        this.disposeTrafo();
        if (this.disposeGC) {
            this.gc.dispose();
        }
    }

    private void disposeTrafo() {
        if (this.currentSwtTrafo != null) {
            this.currentSwtTrafo.dispose();
            this.currentSwtTrafo = null;
        }
    }

    public void plot(Point point) {
        double lineWidth = this.getLineWidth();
        int lineWidthInt = (int)Math.round(lineWidth);
        int sub = (int)Math.round(lineWidth / 2.0);
        int x = (int)this.fitter.pointFitX(point.x) - sub;
        int y = (int)this.fitter.pointFitY(point.y) - sub;
        this.updateBackgroundColorForLineDrawing();
        this.gc.fillOval(x, y, lineWidthInt, lineWidthInt);
        this.updateBackgroundColorForFillDrawing();
    }

    public void line(Line line) {
        if (line.isZeroLengthLine()) {
            this.plot(line.start);
        } else {
            this.gc.drawLine((int)this.fitter.pointFitX(line.start.x), (int)this.fitter.pointFitY(line.start.y), (int)this.fitter.pointFitX(line.end.x), (int)this.fitter.pointFitY(line.end.y));
        }
    }

    public void arc(Arc arc) {
        Points points = arc.getPointsApproximated(50, 1.0);
        this.gc.drawPolyline(this.convertToSWTPointList(points));
    }

    public void skipPlot(Point point) {
    }

    public void skipLine(Line line) {
    }

    public void skipArc(Arc arc) {
    }

    public boolean isNotInterestedInRealTextDrawing() {
        return false;
    }

    public void text(Point p, double textLength, String text, TurnedRectangle turnedClippingHint) {
        assert (p != null) : "p = null";
        assert (text != null) : "text = null";
        assert (turnedClippingHint != null) : "turnedClippingHint = null";
        if (this.getTextLineHeight() > 1.0E-10) {
            this.updateFont();
            if (this.currentFont != null) {
                double textLengthSWT = this.getTextLength(text);
                double textTopSWT = this.getTextTopSWT();
                this.updateForegroundColorForTextDrawing();
                if (this.gc.getAdvanced()) {
                    Transform trafo = new Transform(this.device);
                    if (this.currentSwtTrafo != null) {
                        trafo.multiply(this.currentSwtTrafo);
                    }
                    double fX = 1.0;
                    double fY = 1.0;
                    Point textBasePoint = this.calculateTextBasePoint(p, textLengthSWT * fX, textTopSWT * fY);
                    trafo.translate((float)textBasePoint.x, (float)textBasePoint.y);
                    if (!(!(textLength > 1.0E-10) || Geo.equals((double)fX, (double)1.0) && Geo.equals((double)fY, (double)1.0))) {
                        trafo.scale((float)fX, (float)fY);
                    }
                    Direction direction = this.getTextDirection();
                    double angle = direction.getAngle();
                    float angleSWT = (float)(-angle);
                    trafo.rotate(angleSWT);
                    this.gc.setTransform(trafo);
                    this.gc.drawString(text, 0, 0, true);
                    this.gc.setTransform(this.currentSwtTrafo);
                    trafo.dispose();
                } else {
                    Point textBasePoint = this.calculateTextBasePoint(p, textLengthSWT, textTopSWT);
                    this.gc.drawString(text, (int)this.fitter.pointFitX(textBasePoint.x), (int)this.fitter.pointFitY(textBasePoint.y), true);
                }
                this.updateForegroundColorForLineDrawing();
            }
        }
    }

    private Point calculateTextBasePoint(Point p, double textLenght, double textTop) {
        GeoVector textOffset = this.calculateTextOffset(textLenght, textTop);
        Direction direction = this.getTextDirection();
        return p.movePoint(textOffset.turn(direction));
    }

    private GeoVector calculateTextOffset(double textLength, double textTop) {
        double xOff;
        switch (this.getTextAlignment()) {
            case 2: {
                xOff = -textLength / 2.0;
                break;
            }
            case 4: {
                xOff = -textLength;
                break;
            }
            default: {
                xOff = 0.0;
            }
        }
        return new GeoVector(xOff, -textTop);
    }

    private double getTextTopSWT() {
        this.updateFont();
        if (this.currentFont == null) {
            return 0.0;
        }
        return SWTFont.getTextTop(this.gc, this.currentFont);
    }

    private double getTextDescentSWT() {
        this.updateFont();
        if (this.currentFont == null) {
            return 0.0;
        }
        return SWTFont.getTextDescent(this.gc, this.currentFont);
    }

    private double getTextLength(String text) {
        this.updateFont();
        if (this.currentFont == null) {
            return 0.0;
        }
        return SWTFont.getTextLength(this.gc, this.currentFont, text);
    }

    private void updateForegroundColorForLineDrawing() {
        this.setForegroundColor(this.getLineColor());
    }

    private void updateForegroundColorForTextDrawing() {
        this.setForegroundColor(this.getTextColor());
    }

    private void setForegroundColor(com.arcway.lib.graphics.Color color) {
        if (!color.equalsColor(this.colorFromSWT(this.gc.getForeground()))) {
            this.disposeForegroundColor();
        }
        if (this.swtForegroundColor == null) {
            this.swtForegroundColor = this.createSWTColor(color);
            this.gc.setForeground(this.swtForegroundColor);
        }
    }

    private void disposeForegroundColor() {
        if (this.swtForegroundColor != null) {
            if (this.gc.getForeground() == this.swtForegroundColor) {
                this.gc.setForeground(null);
            }
            this.swtForegroundColor.dispose();
            this.swtForegroundColor = null;
        }
    }

    private void updateBackgroundColorForFillDrawing() {
        this.setBackgroundColor(this.getFillColor());
    }

    private void updateBackgroundColorForLineDrawing() {
        this.setBackgroundColor(this.getLineColor());
    }

    private void setBackgroundColor(com.arcway.lib.graphics.Color fillColor) {
        if (!fillColor.equalsColor(this.colorFromSWT(this.gc.getBackground()))) {
            this.disposeBackgroundColor();
        }
        if (this.swtBackgroundColor == null) {
            this.swtBackgroundColor = this.createSWTColor(fillColor);
            this.gc.setBackground(this.swtBackgroundColor);
        }
    }

    private void disposeBackgroundColor() {
        if (this.swtBackgroundColor != null) {
            if (this.gc.getBackground() == this.swtBackgroundColor) {
                this.gc.setBackground(null);
            }
            this.swtBackgroundColor.dispose();
            this.swtBackgroundColor = null;
        }
    }

    private void updateFont() {
        this.setFont(this.getTextFontName(), this.isTextBold(), this.isTextItalic());
    }

    private void setFont(String newFontName, boolean bold, boolean italic) {
        int newFontStyle = this.calculateSWTFontStyle(bold, italic);
        if (!(this.currentFont == null || newFontStyle == this.currentFontStyle && Geo.equals((double)this.getTextLineHeight(), (double)this.currentLineHeight) && newFontName.equals(this.currentFontName))) {
            this.disposeFont();
        }
        if (this.currentFont == null) {
            this.currentFontName = newFontName;
            this.currentFontStyle = newFontStyle;
            this.currentLineHeight = this.getTextLineHeight();
            try {
                try {
                    this.currentFont = SWTFont.createSWTFont(this.device, this.gc, this.currentLineHeight, new TextStyle(newFontName, bold, italic));
                }
                catch (EXFontSizeTooSmall e) {
                    this.currentFont = null;
                }
            }
            catch (EXNoMoreHandles e) {
                this.currentFont = null;
            }
        }
        if (this.currentFont != null) {
            this.gc.setFont(this.currentFont);
        }
    }

    private void disposeFont() {
        if (this.currentFont != null) {
            if (this.gc.getFont() == this.currentFont) {
                this.gc.setFont(null);
            }
            this.currentFont.dispose();
            this.currentFont = null;
        }
    }

    private com.arcway.lib.graphics.Color colorFromSWT(Color swtColor) {
        return new com.arcway.lib.graphics.Color(swtColor.getRed(), swtColor.getGreen(), swtColor.getBlue());
    }

    private Color createSWTColor(com.arcway.lib.graphics.Color color) {
        return new Color(this.device, color.r, color.g, color.b);
    }

    private int calculateSWTFontStyle(boolean bold, boolean italic) {
        int style = 0;
        if (bold) {
            style |= 1;
        }
        if (italic) {
            style |= 2;
        }
        return style;
    }

    private int[] convertToSWTPointList(Points points) {
        int size = points.size();
        ArrayList<org.eclipse.swt.graphics.Point> pointList = new ArrayList<org.eclipse.swt.graphics.Point>(size);
        int index = 0;
        while (index < size) {
            Point point = points.get(index);
            int toAddX = (int)this.fitter.pointFitX(point.x);
            int toAddY = (int)this.fitter.pointFitY(point.y);
            boolean toAdd = true;
            if (pointList.size() > 0) {
                org.eclipse.swt.graphics.Point lastPoint = (org.eclipse.swt.graphics.Point)pointList.get(pointList.size() - 1);
                if (lastPoint.x == toAddX && lastPoint.y == toAddY) {
                    toAdd = false;
                }
            }
            if (toAdd) {
                pointList.add(new org.eclipse.swt.graphics.Point(toAddX, toAddY));
            }
            ++index;
        }
        int[] swtPoints = new int[pointList.size() * 2];
        int s = 0;
        int d = 0;
        while (s < pointList.size()) {
            org.eclipse.swt.graphics.Point sourcePoint = (org.eclipse.swt.graphics.Point)pointList.get(s);
            swtPoints[d] = sourcePoint.x;
            swtPoints[++d] = sourcePoint.y;
            ++s;
            ++d;
        }
        return swtPoints;
    }

    public void drawImage(IOffscreenBitmap offscreenBitmap, int sourceX, int sourceY, int sourceW, int sourceH, TurnedRectangle scaleToRectangle, int alpha) {
        IOffscreenBitmap offscreenBitmapTemp = offscreenBitmap;
        assert (offscreenBitmapTemp != null);
        assert (sourceX >= 0);
        assert (sourceY >= 0);
        assert (sourceX < offscreenBitmapTemp.getWidthInPixels());
        assert (sourceY < offscreenBitmapTemp.getHeightInPixels());
        assert (sourceW > 0);
        assert (sourceH > 0);
        assert (sourceW <= offscreenBitmapTemp.getWidthInPixels() - sourceX);
        assert (sourceH <= offscreenBitmapTemp.getHeightInPixels() - sourceY);
        assert (scaleToRectangle != null);
        int destX = (int)this.fitter.pointFitX(scaleToRectangle.getUpperLeft().x);
        int destY = (int)this.fitter.pointFitY(scaleToRectangle.getUpperLeft().y);
        int destW = (int)this.fitter.pointFitX(scaleToRectangle.getW().abs());
        int destH = (int)this.fitter.pointFitY(scaleToRectangle.getH().abs());
        if (destW > 0 && destH > 0) {
            boolean created;
            SWTOffscreenBitmap swtOffscreenBitmap;
            if (offscreenBitmapTemp instanceof SWTOffscreenBitmap) {
                swtOffscreenBitmap = (SWTOffscreenBitmap)offscreenBitmapTemp;
                created = false;
            } else {
                SWTRenderer renderer = SWTDefaultRendererManager.getDefaultSWTRendererOfCurrentThread();
                try {
                    swtOffscreenBitmap = renderer.createSWTOffscreenBitmap(offscreenBitmapTemp);
                    created = true;
                }
                catch (EXImageDataTypeNotSupported e) {
                    swtOffscreenBitmap = null;
                    created = false;
                }
                catch (EXImageTooBig e) {
                    swtOffscreenBitmap = null;
                    created = false;
                }
                catch (EXNoMoreHandles e) {
                    swtOffscreenBitmap = null;
                    created = false;
                }
            }
            if (swtOffscreenBitmap != null) {
                Image wrappedImage;
                Image imageToDraw = wrappedImage = swtOffscreenBitmap.getWrappedSWTImage();
                int oldAlpha = 255;
                Transform transform = null;
                if (this.gc.getAdvanced()) {
                    oldAlpha = this.gc.getAlpha();
                    this.gc.setAlpha(alpha);
                    float angle = -((float)scaleToRectangle.getDirection().getAngle());
                    if (!Geo.isZero((double)(Geo.getNormalizedAngle((double)((double)angle + 1.0E-10)) % 360.0 - 1.0E-10))) {
                        transform = new Transform(this.gc.getDevice());
                        if (this.currentSwtTrafo != null) {
                            transform.multiply(this.currentSwtTrafo);
                        }
                        float offsetX = (float)scaleToRectangle.getUpperLeft().x;
                        float offsetY = (float)scaleToRectangle.getUpperLeft().y;
                        transform.translate(offsetX, offsetY);
                        transform.rotate(angle);
                        transform.translate(-offsetX, -offsetY);
                        this.gc.setTransform(transform);
                    }
                }
                this.gc.drawImage(imageToDraw, sourceX, sourceY, sourceW, sourceH, destX, destY, destW, destH);
                if (this.gc.getAdvanced()) {
                    if (transform != null) {
                        this.gc.setTransform(this.currentSwtTrafo);
                        transform.dispose();
                    }
                    this.gc.setAlpha(oldAlpha);
                }
                if (imageToDraw != wrappedImage) {
                    imageToDraw.dispose();
                }
                if (created) {
                    swtOffscreenBitmap.dispose();
                }
            }
        }
    }

    public boolean supportsNullImage() {
        return false;
    }

    public Rectangle setClipping(Rectangle clippingRectangle) {
        Rectangle set;
        if (clippingRectangle != null) {
            double x1Floor = Math.floor(clippingRectangle.upperLeft.x + 1.0E-10);
            double y1Floor = Math.floor(clippingRectangle.upperLeft.y + 1.0E-10);
            double x2Ceil = Math.ceil(clippingRectangle.lowerRight.x + 1.0 - 1.0E-10);
            double y2Ceil = Math.ceil(clippingRectangle.lowerRight.y + 1.0 - 1.0E-10);
            int x1 = (int)x1Floor;
            int y1 = (int)y1Floor;
            int w = (int)(x2Ceil - x1Floor);
            int h = (int)(y2Ceil - y1Floor);
            this.gc.setClipping(x1, y1, w, h);
            set = new Rectangle((double)x1, (double)y1, (double)(x1 + w), (double)(y1 + h));
        } else {
            this.gc.setClipping(null);
            set = null;
        }
        return set;
    }

    public boolean driverSupportsTransformationForSubElements() {
        return true;
    }
}

