/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics;

import com.arcway.lib.eclipse.graphics.SWTFont;
import com.arcway.lib.eclipse.graphics.SWTImageData;
import com.arcway.lib.eclipse.graphics.SWTOffscreenBitmap;
import com.arcway.lib.eclipse.graphics.image.PNGResolutionFetcher;
import com.arcway.lib.eclipse.resources.DecoratedImage;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.EXNoMoreHandles;
import com.arcway.lib.graphics.IRenderer;
import com.arcway.lib.graphics.image.EXCorruptImageFileContent;
import com.arcway.lib.graphics.image.EXImageDataTypeNotSupported;
import com.arcway.lib.graphics.image.EXImageTooBig;
import com.arcway.lib.graphics.image.EXUnspecifiedImageLoadingError;
import com.arcway.lib.graphics.image.EXUnsupportedColorDepth;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IOffscreenBitmap;
import com.arcway.lib.graphics.image.IPalette;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.PixelData;
import com.arcway.lib.graphics.text.IFont;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class SWTRenderer
implements IRenderer {
    private static final ILogger LOGGER = Logger.getLogger(SWTRenderer.class);
    private final Device wrappedSWTDevice;
    private final Map<Runnable, Long> job2TriggerTime = new HashMap<Runnable, Long>();
    private WaitThread waitThread = null;
    private Runnable eventQueueRunner = null;
    private static final PixelData bitDepth = new PixelData();

    static {
        SWTRenderer.bitDepth.r = 8;
        SWTRenderer.bitDepth.g = 8;
        SWTRenderer.bitDepth.b = 8;
        SWTRenderer.bitDepth.alpha = 8;
    }

    SWTRenderer() {
        Display swtDevice = Display.getCurrent();
        if (swtDevice == null) {
            swtDevice = new Display();
        }
        this.wrappedSWTDevice = swtDevice;
    }

    public SWTRenderer(Device swtDevice) {
        this.wrappedSWTDevice = swtDevice;
    }

    public Device getWrappedSWTDevice() {
        return this.wrappedSWTDevice;
    }

    public SWTOffscreenBitmap createSWTOffscreenBitmap(int widthInPixels, int heightInPixels, com.arcway.lib.graphics.Color backgroundColor, boolean isLossyImage) throws EXImageTooBig, EXNoMoreHandles {
        SWTOffscreenBitmap swtOffscreenBitmap = new SWTOffscreenBitmap(this, widthInPixels, heightInPixels, backgroundColor, isLossyImage);
        return swtOffscreenBitmap;
    }

    public SWTOffscreenBitmap createSWTOffscreenBitmap(IImageData imageData) throws EXImageTooBig, EXNoMoreHandles {
        if (!(imageData instanceof SWTImageData)) {
            int widthInPixels = imageData.getWidthInPixels();
            int heightInPixels = imageData.getHeightInPixels();
            Display display = Display.getDefault();
            Image canvas = SWTOffscreenBitmap.createSWTImage((Device)display, widthInPixels, heightInPixels, com.arcway.lib.graphics.Color.TRANSPARENT);
            GC gc = new GC((Drawable)canvas);
            IPalette palette = imageData.getPalette();
            com.arcway.lib.graphics.Color[] colors = palette != null ? palette.getColors() : null;
            PixelData pixelData = new PixelData();
            int y = 0;
            while (y < heightInPixels) {
                int x = 0;
                while (x < widthInPixels) {
                    Color color;
                    imageData.getPixel(x, y, pixelData);
                    if (colors == null) {
                        color = new Color((Device)display, pixelData.r, pixelData.g, pixelData.b);
                    } else {
                        com.arcway.lib.graphics.Color sourceColor = colors[pixelData.colorIndex];
                        color = new Color((Device)display, sourceColor.r, sourceColor.g, sourceColor.b);
                    }
                    gc.setForeground(color);
                    gc.setAlpha(pixelData.alpha);
                    gc.drawPoint(x, y);
                    color.dispose();
                    ++x;
                }
                ++y;
            }
            gc.dispose();
            Image createdSWTImage = new Image((Device)display, canvas.getImageData());
            canvas.dispose();
            SWTOffscreenBitmap swtOffscreenBitmap = new SWTOffscreenBitmap(createdSWTImage, imageData.isLossyImage(), imageData.getOptionalPngOrJpgFileData());
            return swtOffscreenBitmap;
        }
        SWTImageData swtImageData = (SWTImageData)imageData;
        SWTOffscreenBitmap swtOffscreenBitmap = new SWTOffscreenBitmap(this, swtImageData);
        return swtOffscreenBitmap;
    }

    public SWTOffscreenBitmap createSWTOffscreenBitmap(IOffscreenBitmap offscreenBitmapToCopy) throws EXImageDataTypeNotSupported, EXImageTooBig, EXNoMoreHandles {
        IImageData imageData = offscreenBitmapToCopy.getSnapshot();
        SWTOffscreenBitmap offscreenBitmap = this.createSWTOffscreenBitmap(imageData);
        return offscreenBitmap;
    }

    public SWTFont createSWTFont(TextStyle textStyle) throws EXNoMoreHandles {
        SWTFont swtFont = new SWTFont(textStyle);
        return swtFont;
    }

    public SWTOffscreenBitmap createOffscreenBitmap(int widthInPixels, int heightInPixels, com.arcway.lib.graphics.Color backgroundColor, boolean isLossyImage) throws EXImageTooBig, EXNoMoreHandles {
        return this.createSWTOffscreenBitmap(widthInPixels, heightInPixels, backgroundColor, isLossyImage);
    }

    public IOffscreenBitmap createOffscreenBitmap(IImageData imageData) throws EXImageDataTypeNotSupported, EXImageTooBig, EXNoMoreHandles {
        return this.createSWTOffscreenBitmap(imageData);
    }

    public IOffscreenBitmap createOffscreenBitmap(IOffscreenBitmap offscreenBitmapToCopy) throws EXImageDataTypeNotSupported, EXImageTooBig, EXNoMoreHandles {
        return this.createSWTOffscreenBitmap(offscreenBitmapToCopy);
    }

    public IFont createFont(TextStyle textStyle) throws EXNoMoreHandles {
        return this.createSWTFont(textStyle);
    }

    public IImageData loadImageData(IStreamResource imageResoruce) throws EXImageDataTypeNotSupported, EXImageTooBig, EXUnspecifiedImageLoadingError, EXCorruptImageFileContent, JvmExternalResourceInteractionException {
        byte[] optionalPngOrJpgFileData;
        ImageData imageData;
        try {
            imageData = new ImageData(imageResoruce.toInputStream());
            try (InputStream inputStream = imageResoruce.toInputStream();){
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(Math.max(32, inputStream.available()));
                DataCopyHelper.copyFile((InputStream)inputStream, (OutputStream)outputStream);
                optionalPngOrJpgFileData = outputStream.toByteArray();
            }
        }
        catch (IOException e) {
            throw new JvmExternalResourceInteractionException((Throwable)e);
        }
        catch (SWTException e) {
            switch (e.code) {
                case 40: {
                    throw new EXCorruptImageFileContent((Exception)((Object)e));
                }
                case 39: {
                    throw new JvmExternalResourceInteractionException((Throwable)e);
                }
                case 42: {
                    throw new EXImageDataTypeNotSupported((Throwable)e);
                }
            }
            throw new EXUnspecifiedImageLoadingError((Throwable)e);
        }
        catch (OutOfMemoryError e) {
            throw new EXImageTooBig();
        }
        SWTImageData swtImageData = new SWTImageData(imageData, ImageCoDec.isLossyImage((String)imageResoruce.getName()), optionalPngOrJpgFileData);
        return swtImageData;
    }

    public com.arcway.lib.graphics.image.Image loadImage(IStreamResource imageResoruce) throws EXImageDataTypeNotSupported, EXImageTooBig, JvmExternalResourceInteractionException, EXNoMoreHandles, EXCorruptImageFileContent, EXUnsupportedColorDepth, EXUnspecifiedImageLoadingError {
        Point pixelsPerMeter;
        byte[] optionalPngOrJpgFileData;
        Image wrappedSWTImage;
        try {
            InputStream inputStream = imageResoruce.toInputStream();
            wrappedSWTImage = new Image(this.wrappedSWTDevice, inputStream);
            inputStream = imageResoruce.toInputStream();
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(Math.max(32, inputStream.available()));
                DataCopyHelper.copyFile((InputStream)inputStream, (OutputStream)outputStream);
                optionalPngOrJpgFileData = outputStream.toByteArray();
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new JvmExternalResourceInteractionException((Throwable)e);
        }
        catch (SWTException e) {
            switch (e.code) {
                case 40: {
                    throw new EXCorruptImageFileContent((Exception)((Object)e));
                }
                case 39: {
                    throw new JvmExternalResourceInteractionException((Throwable)e);
                }
                case 38: {
                    throw new EXUnsupportedColorDepth((Exception)((Object)e));
                }
                case 42: {
                    throw new EXImageDataTypeNotSupported((Throwable)e);
                }
            }
            throw new EXUnspecifiedImageLoadingError((Throwable)e);
        }
        catch (SWTError e) {
            switch (e.code) {
                case 2: {
                    throw new EXNoMoreHandles((Throwable)e);
                }
            }
            throw e;
        }
        catch (OutOfMemoryError e) {
            throw new EXImageTooBig();
        }
        SWTOffscreenBitmap swtOffscreenBitmap = new SWTOffscreenBitmap(wrappedSWTImage, ImageCoDec.isLossyImage((String)imageResoruce.getName()), optionalPngOrJpgFileData);
        try {
            pixelsPerMeter = PNGResolutionFetcher.fetchResolutionInPixelsPerMeter(imageResoruce.toInputStream());
        }
        catch (Exception e) {
            pixelsPerMeter = null;
        }
        if (pixelsPerMeter == null) {
            int dpiX = this.wrappedSWTDevice.getDPI().x;
            double pixelPerMeterX = (double)dpiX * 39.37007874015748;
            pixelsPerMeter = new Point(pixelPerMeterX, pixelPerMeterX);
        }
        return com.arcway.lib.graphics.image.Image.wrapImage((IOffscreenBitmap)swtOffscreenBitmap, (double)pixelsPerMeter.x, (double)pixelsPerMeter.y);
    }

    public com.arcway.lib.graphics.image.Image createDecoratedImage(com.arcway.lib.graphics.image.Image baseImage, com.arcway.lib.graphics.image.Image decoratorImage) {
        Alignment positionOnBase = new Alignment(4, 32);
        return this.createDecoratedImage(baseImage, decoratorImage, positionOnBase, positionOnBase.getInverse(), 0, 0);
    }

    public com.arcway.lib.graphics.image.Image createDecoratedImage(com.arcway.lib.graphics.image.Image baseImage, com.arcway.lib.graphics.image.Image decoratorImage, Alignment positionOnBase, Alignment layoutDirection, int offsetX, int offsetY) {
        try {
            assert (baseImage.getOffscreenBitmap() instanceof SWTOffscreenBitmap);
            assert (decoratorImage.getOffscreenBitmap() instanceof SWTOffscreenBitmap);
            Image baseSWTImage = ((SWTOffscreenBitmap)baseImage.getOffscreenBitmap()).getWrappedSWTImage();
            Image decoratorSWTImage = ((SWTOffscreenBitmap)decoratorImage.getOffscreenBitmap()).getWrappedSWTImage();
            Image decoratedSWTImage = DecoratedImage.createImage(Display.getDefault(), new DecoratedImage(baseSWTImage, decoratorSWTImage, positionOnBase, layoutDirection, offsetX, offsetY));
            return new com.arcway.lib.graphics.image.Image((IOffscreenBitmap)new SWTOffscreenBitmap(decoratedSWTImage, baseImage.isLossyImage(), null), baseImage.getPixelPerMeterX(), baseImage.getPixelPerMeterY());
        }
        catch (EXNoMoreHandles eNMH) {
            assert (false);
            return null;
        }
        catch (EXImageTooBig e) {
            assert (false);
            return null;
        }
    }

    private static int machMichAnnasch(int woher, int wohin, double wieWeit) {
        return Math.max(0, Math.min(255, (int)((double)wohin - (double)(wohin - woher) * (1.0 - wieWeit))));
    }

    public com.arcway.lib.graphics.image.Image createGrayImage(com.arcway.lib.graphics.image.Image baseImage, final double toGray) throws EXImageTooBig, EXNoMoreHandles {
        return this.createAnnaschImage(baseImage, new IAnnaschMacher(){

            @Override
            public void machMichAnnasch(PixelData targetPixelData, int r, int g, int b, int a) {
                int gray = Math.round((r + g + b) / 3);
                targetPixelData.r = SWTRenderer.machMichAnnasch(r, gray, toGray);
                targetPixelData.g = SWTRenderer.machMichAnnasch(g, gray, toGray);
                targetPixelData.b = SWTRenderer.machMichAnnasch(b, gray, toGray);
                targetPixelData.alpha = a;
            }
        });
    }

    public com.arcway.lib.graphics.image.Image createTransparentImage(com.arcway.lib.graphics.image.Image baseImage, final double toTransparent) throws EXImageTooBig, EXNoMoreHandles {
        return this.createAnnaschImage(baseImage, new IAnnaschMacher(){

            @Override
            public void machMichAnnasch(PixelData targetPixelData, int r, int g, int b, int a) {
                targetPixelData.r = r;
                targetPixelData.g = g;
                targetPixelData.b = b;
                targetPixelData.alpha = SWTRenderer.machMichAnnasch(a, 0, toTransparent);
            }
        });
    }

    private com.arcway.lib.graphics.image.Image createAnnaschImage(com.arcway.lib.graphics.image.Image baseImage, final IAnnaschMacher annaschMacher) throws EXImageTooBig, EXNoMoreHandles {
        final IImageData sourceImageData = baseImage.getSnapshot();
        SWTOffscreenBitmap swtOffscreenBitmap = this.createSWTOffscreenBitmap(new IImageData(){
            private final com.arcway.lib.graphics.Color[] colors;
            private final PixelData sourceBitDepth;
            private final PixelData sourcePixelData;
            {
                IPalette palette = iImageData.getPalette();
                this.colors = palette != null ? palette.getColors() : null;
                this.sourceBitDepth = iImageData.getBitDepth();
                this.sourcePixelData = new PixelData();
            }

            public IPalette getPalette() {
                return null;
            }

            public PixelData getBitDepth() {
                return bitDepth;
            }

            public int getWidthInPixels() {
                return sourceImageData.getWidthInPixels();
            }

            public int getHeightInPixels() {
                return sourceImageData.getHeightInPixels();
            }

            public boolean isLossyImage() {
                return sourceImageData.isLossyImage();
            }

            public byte[] getOptionalPngOrJpgFileData() {
                return null;
            }

            public void getPixel(int x, int y, PixelData targetPixelData) {
                int a;
                int b;
                int g;
                int r;
                sourceImageData.getPixel(x, y, this.sourcePixelData);
                if (this.colors == null) {
                    r = this.sourcePixelData.r;
                    g = this.sourcePixelData.g;
                    b = this.sourcePixelData.b;
                    a = this.sourceBitDepth.alpha == 0 ? 255 : com.arcway.lib.graphics.Color.convertBitDepth((int)this.sourcePixelData.alpha, (int)this.sourceBitDepth.alpha, (int)bitDepth.alpha);
                } else {
                    int colorIndex = this.sourcePixelData.colorIndex;
                    if (colorIndex >= 0) {
                        com.arcway.lib.graphics.Color sourceColor = this.colors[colorIndex];
                        r = sourceColor.r;
                        g = sourceColor.g;
                        b = sourceColor.b;
                        a = this.sourceBitDepth.alpha == 0 ? 255 : com.arcway.lib.graphics.Color.convertBitDepth((int)this.sourcePixelData.alpha, (int)this.sourceBitDepth.alpha, (int)bitDepth.alpha);
                    } else {
                        r = 0;
                        g = 0;
                        b = 0;
                        a = 0;
                    }
                }
                r = com.arcway.lib.graphics.Color.convertBitDepth((int)r, (int)this.sourceBitDepth.r, (int)bitDepth.r);
                g = com.arcway.lib.graphics.Color.convertBitDepth((int)g, (int)this.sourceBitDepth.g, (int)bitDepth.g);
                b = com.arcway.lib.graphics.Color.convertBitDepth((int)b, (int)this.sourceBitDepth.b, (int)bitDepth.b);
                annaschMacher.machMichAnnasch(targetPixelData, r, g, b, a);
            }
        });
        com.arcway.lib.graphics.image.Image grayImage = new com.arcway.lib.graphics.image.Image((IOffscreenBitmap)swtOffscreenBitmap, baseImage.getPixelPerMeterX(), baseImage.getPixelPerMeterY());
        swtOffscreenBitmap.dispose();
        return grayImage;
    }

    public byte[] encodeIntoJPGByteArray(IImageData imageData, double pixelsPerMeterX, double pixelsPerMeterY) throws EXImageTooBig, EXNoMoreHandles {
        ImageData wrappedSWTImageData;
        if (imageData instanceof SWTImageData) {
            SWTImageData swtImageData = (SWTImageData)imageData;
            wrappedSWTImageData = swtImageData.getWrappedSWTImageData();
        } else {
            SWTOffscreenBitmap swtOffscreenBitmap = this.createSWTOffscreenBitmap(imageData);
            Image wrappedSWTImage = swtOffscreenBitmap.getWrappedSWTImage();
            wrappedSWTImageData = wrappedSWTImage.getImageData();
            swtOffscreenBitmap.dispose();
        }
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{wrappedSWTImageData};
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageLoader.save((OutputStream)byteArrayOutputStream, 4);
        byte[] content = byteArrayOutputStream.toByteArray();
        return content;
    }

    public synchronized void processInEventLoop(long waitInMilliseconds, Runnable runnable) {
        this.job2TriggerTime.put(runnable, System.currentTimeMillis() + waitInMilliseconds);
        if (this.waitThread == null) {
            this.waitThread = new WaitThread();
            this.waitThread.start();
        } else {
            this.notify();
        }
    }

    public synchronized void synchronouslyProcessInEventLoopIfOutstanding(Runnable runnable) {
        if (this.job2TriggerTime.remove(runnable) != null) {
            Display.getDefault().syncExec(runnable);
        }
    }

    private synchronized void activateEventQueueRunner() {
        if (this.eventQueueRunner == null) {
            this.eventQueueRunner = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SWTRenderer sWTRenderer = SWTRenderer.this;
                    synchronized (sWTRenderer) {
                        long currentTime = System.currentTimeMillis();
                        Iterator i = SWTRenderer.this.job2TriggerTime.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry jobAndTriggerTime = i.next();
                            long jobTriggerTime = (Long)jobAndTriggerTime.getValue();
                            if (currentTime < jobTriggerTime) continue;
                            Runnable job = (Runnable)jobAndTriggerTime.getKey();
                            try {
                                job.run();
                            }
                            catch (Throwable t) {
                                LOGGER.error(t);
                            }
                            i.remove();
                        }
                        SWTRenderer.this.eventQueueRunner = null;
                        SWTRenderer.this.notify();
                    }
                }
            };
            Display.getDefault().asyncExec(this.eventQueueRunner);
        }
    }

    private static interface IAnnaschMacher {
        public void machMichAnnasch(PixelData var1, int var2, int var3, int var4, int var5);
    }

    private class WaitThread
    extends Thread {
        private WaitThread() {
            super("Event Loop Enqueuer");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SWTRenderer sWTRenderer = SWTRenderer.this;
            synchronized (sWTRenderer) {
                long timeToWaitForNextFutureJob = this.triggerPresentJobsAndGetTimeToWaitForNextFutureJob();
                while (timeToWaitForNextFutureJob < Long.MAX_VALUE) {
                    try {
                        SWTRenderer.this.wait(timeToWaitForNextFutureJob);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("interrupt", (Throwable)e);
                    }
                    timeToWaitForNextFutureJob = this.triggerPresentJobsAndGetTimeToWaitForNextFutureJob();
                }
                SWTRenderer.this.waitThread = null;
            }
        }

        private long triggerPresentJobsAndGetTimeToWaitForNextFutureJob() {
            boolean presentJobs = false;
            long timeToWaitForNextFutureJob = Long.MAX_VALUE;
            long currentTime = System.currentTimeMillis();
            for (Map.Entry jobAndTriggerTime : SWTRenderer.this.job2TriggerTime.entrySet()) {
                long jobTriggerTime = (Long)jobAndTriggerTime.getValue();
                if (currentTime >= jobTriggerTime) {
                    presentJobs = true;
                    continue;
                }
                timeToWaitForNextFutureJob = Math.min(timeToWaitForNextFutureJob, jobTriggerTime - currentTime);
            }
            if (presentJobs) {
                SWTRenderer.this.activateEventQueueRunner();
            }
            return timeToWaitForNextFutureJob;
        }
    }
}

