/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.graphics;

import com.arcway.lib.eclipse.graphics.SWTPalette;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.image.IImageData;
import com.arcway.lib.graphics.image.IPalette;
import com.arcway.lib.graphics.image.PixelData;
import com.arcway.lib.java.Assert;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class SWTImageData
implements IImageData {
    private static final int ALPHAMODE_MASK = 1;
    private static final int ALPHAMODE_1 = 2;
    private static final int ALPHAMODE_DATA = 3;
    private static final int ALPHAMODE_0 = 4;
    private final ImageData wrappedSWTImageData;
    private final ImageData transparencyMask;
    private final int transparentColorIndex;
    private final SWTPalette swtPalette;
    private final int redShift;
    private final int greenShift;
    private final int blueShift;
    private final int alphaMode;
    private final boolean isLossyImage;
    private final byte[] optionalPngOrJpgFileData;

    public SWTImageData(ImageData imageData, boolean isLossyImage, byte[] optionalPngOrJpgFileData) {
        Assert.checkArgumentBeeingNotNull((Object)imageData);
        this.wrappedSWTImageData = imageData;
        if (imageData.maskData != null) {
            this.transparencyMask = imageData.getTransparencyMask();
            this.transparentColorIndex = -1;
        } else {
            this.transparencyMask = null;
            this.transparentColorIndex = imageData.transparentPixel;
        }
        PaletteData paletteData = imageData.palette;
        if (paletteData.isDirect) {
            this.swtPalette = null;
            this.redShift = SWTImageData.lowestBit(paletteData.redMask);
            this.greenShift = SWTImageData.lowestBit(paletteData.greenMask);
            this.blueShift = SWTImageData.lowestBit(paletteData.blueMask);
        } else {
            this.swtPalette = new SWTPalette(paletteData);
            this.redShift = 0;
            this.greenShift = 0;
            this.blueShift = 0;
        }
        this.alphaMode = this.transparencyMask != null ? 1 : (this.transparentColorIndex != -1 ? 2 : (this.wrappedSWTImageData.alphaData != null ? 3 : 4));
        this.isLossyImage = isLossyImage && this.alphaMode == 4;
        this.optionalPngOrJpgFileData = optionalPngOrJpgFileData;
    }

    public ImageData getWrappedSWTImageData() {
        return this.wrappedSWTImageData;
    }

    public IPalette getPalette() {
        return this.swtPalette;
    }

    public int getWidthInPixels() {
        return this.wrappedSWTImageData.width;
    }

    public int getHeightInPixels() {
        return this.wrappedSWTImageData.height;
    }

    public PixelData getBitDepth() {
        PixelData bitDepth = new PixelData();
        if (this.swtPalette == null) {
            PaletteData palette = this.wrappedSWTImageData.palette;
            bitDepth.r = SWTImageData.bits(palette.redMask);
            bitDepth.g = SWTImageData.bits(palette.greenMask);
            bitDepth.b = SWTImageData.bits(palette.blueMask);
        } else {
            Color[] paletteColors = this.swtPalette.getColors();
            int highestColorIndex = paletteColors.length - 1;
            bitDepth.colorIndex = SWTImageData.highestBit(highestColorIndex) + 1;
        }
        bitDepth.alpha = this.transparencyMask != null ? 1 : (this.transparentColorIndex != -1 ? 1 : (this.wrappedSWTImageData.alphaData != null ? 8 : 0));
        return bitDepth;
    }

    public boolean isLossyImage() {
        return this.isLossyImage;
    }

    public byte[] getOptionalPngOrJpgFileData() {
        return this.optionalPngOrJpgFileData;
    }

    public void getPixel(int x, int y, PixelData pixelData) {
        PaletteData palette = this.wrappedSWTImageData.palette;
        int pixelValue = this.wrappedSWTImageData.getPixel(x, y);
        if (palette.isDirect) {
            pixelData.colorIndex = -1;
            pixelData.r = (pixelValue & palette.redMask) >>> this.redShift;
            pixelData.g = (pixelValue & palette.greenMask) >>> this.greenShift;
            pixelData.b = (pixelValue & palette.blueMask) >>> this.blueShift;
            pixelData.alpha = this.alphaMode == 1 ? this.transparencyMask.getPixel(x, y) : (this.alphaMode == 2 ? (this.transparentColorIndex == pixelValue ? 0 : 1) : (this.alphaMode == 3 ? this.wrappedSWTImageData.getAlpha(x, y) : 0));
        } else {
            pixelData.r = 255;
            pixelData.g = 255;
            pixelData.b = 255;
            pixelData.colorIndex = pixelValue;
            pixelData.alpha = this.alphaMode == 1 ? this.transparencyMask.getPixel(x, y) : (this.alphaMode == 2 ? (pixelValue == this.transparentColorIndex ? 0 : 1) : (this.alphaMode == 3 ? this.wrappedSWTImageData.getAlpha(x, y) : 0));
        }
    }

    private static int bits(int mask) {
        int maskTemp = mask;
        int bits = 0;
        while (maskTemp != 0) {
            if ((maskTemp & 1) == 1) {
                ++bits;
            }
            maskTemp >>>= 1;
        }
        return bits;
    }

    private static int highestBit(int mask) {
        int highestBit = 0;
        int bit = 0;
        while (bit < 32) {
            if ((mask & 1 << bit) != 0) {
                highestBit = bit;
            }
            ++bit;
        }
        return highestBit;
    }

    private static int lowestBit(int mask) {
        int lowestBit = 32;
        int bit = 31;
        while (bit >= 0) {
            if ((mask & 1 << bit) != 0) {
                lowestBit = bit;
            }
            --bit;
        }
        return lowestBit;
    }
}

