/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.file.tmp;

import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.xml.XMLCoDecForData;
import com.arcway.lib.codec.xml.XMLFormatMode;
import com.arcway.lib.eclipse.file.tmp.DTSessionTempDirectoryCreationInfo;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryCreationInfo;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.io.JvmExternalResourceInteractionExceptionFactory;
import com.arcway.lib.java.date.RFC1123DateFormatter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.network.HostNameRetriever;
import com.arcway.lib.operating.IExceptionFactory;
import com.arcway.lib.operating.SafeRunner;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;

public class SessionTempDirectoryManager {
    private static final ILogger logger = Logger.getLogger(SessionTempDirectoryManager.class);
    private static final String SESSION_TMP_DIRECTORY_NAME_PREFIX = "aest_";
    private static final String TMP_DIR_FILE_SUFFIX = ".atd";
    private static final String CREATION_INFO_FILENAME = "creation-info.xml";
    private static final String CREATION_INFO_XML_TAG = "CreationInfo";
    private static SessionTempDirectory sessionTempRootDirectory;

    private SessionTempDirectoryManager() {
    }

    public static File createSessionTempFile(File masterCopy) throws JvmExternalResourceInteractionException {
        String extension;
        String basename;
        String fileName = masterCopy.getName();
        int dotPosition = fileName.lastIndexOf(46);
        if (dotPosition == -1) {
            basename = fileName;
            extension = "";
        } else {
            basename = fileName.substring(0, dotPosition);
            extension = fileName.substring(dotPosition + 1);
        }
        assert (extension.equals(FileHelper.getFileExtension((File)masterCopy))) : "Please implement FileExtension handling consistently.";
        int basenameLinit = 12;
        if (basename.length() < 3) {
            basename = "copy" + basename;
        } else if (basename.length() > 12) {
            basename = basename.substring(0, 12);
        }
        File copy = SessionTempDirectoryManager.createSessionTempFile(basename, String.valueOf('.') + extension);
        try {
            DataCopyHelper.copyFile((File)masterCopy, (File)copy);
        }
        catch (JvmExternalResourceInteractionException e) {
            try {
                FileHelper.deleteExistingFileOrDirectory((File)copy);
            }
            catch (Exception e2) {
                logger.debug("Unable to delete obsolete SessionTempFile: " + copy, (Throwable)e2);
            }
            throw e;
        }
        return copy;
    }

    public static File createSessionTempFile(final String prefix, final String suffix) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while creating temporary file (prefix={0}).", prefix);
        JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.Runnable<File> runnable = new SafeRunner.Runnable<File>(){

            public File run() throws Throwable {
                return SessionTempDirectoryManager.createSessionTempFile_internal(prefix, suffix, SessionTempDirectoryManager.getSessionTempRootDirectory());
            }
        };
        return (File)SafeRunner.safeExecute((SafeRunner.Runnable)runnable, (IExceptionFactory)exceptionFactory);
    }

    public static File createSessionTempFile(final String prefix, final String suffix, final SessionTempDirectory parent) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while creating temporary file (prefix={0}) in the directory {1} .", prefix, parent.getPath());
        JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.Runnable<File> runnable = new SafeRunner.Runnable<File>(){

            public File run() throws Throwable {
                return SessionTempDirectoryManager.createSessionTempFile_internal(prefix, suffix, parent);
            }
        };
        return (File)SafeRunner.safeExecute((SafeRunner.Runnable)runnable, (IExceptionFactory)exceptionFactory);
    }

    private static File createSessionTempFile_internal(String prefix, String suffix, SessionTempDirectory parent) throws IOException {
        String p;
        if (prefix == null) {
            p = "file";
            logger.debug("File Prefix string was null");
        } else if (prefix.length() < 3) {
            p = "file" + prefix;
            logger.debug("File Prefix string too short");
        } else {
            p = prefix;
        }
        return File.createTempFile(p, suffix, parent);
    }

    public static SessionTempDirectory createSessionTempSubDirectory(final String prefix) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while creating temporary subdirectory for this session (prefix={0}).", prefix);
        JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.Runnable<SessionTempDirectory> runnable = new SafeRunner.Runnable<SessionTempDirectory>(){

            public SessionTempDirectory run() throws Throwable {
                return SessionTempDirectoryManager.createSessionTempSubDirectory_internal(prefix, SessionTempDirectoryManager.getSessionTempRootDirectory());
            }
        };
        return (SessionTempDirectory)SafeRunner.safeExecute((SafeRunner.Runnable)runnable, (IExceptionFactory)exceptionFactory);
    }

    public static SessionTempDirectory createSessionTempSubDirectory(final String prefix, final SessionTempDirectory parent) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while creating temporary subdirectory (prefix={0}) for this session in the directory {1} .", prefix, parent.getPath());
        JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.Runnable<SessionTempDirectory> runnable = new SafeRunner.Runnable<SessionTempDirectory>(){

            public SessionTempDirectory run() throws Throwable {
                return SessionTempDirectoryManager.createSessionTempSubDirectory_internal(prefix, parent);
            }
        };
        return (SessionTempDirectory)SafeRunner.safeExecute((SafeRunner.Runnable)runnable, (IExceptionFactory)exceptionFactory);
    }

    private static SessionTempDirectory createSessionTempSubDirectory_internal(String prefix, SessionTempDirectory parent) throws Exception {
        String p;
        if (prefix == null) {
            p = "file";
            logger.debug("Directory Prefix string was null");
        } else if (prefix.length() < 3) {
            p = "file" + prefix;
            logger.debug("Directory Prefix string too short");
        } else {
            p = prefix;
        }
        int MAX_ATTEMPTS = 1000;
        File tempDir = null;
        int attemptNumber = 0;
        while (attemptNumber < MAX_ATTEMPTS) {
            File tempFile = File.createTempFile(p, TMP_DIR_FILE_SUFFIX, parent);
            tempFile.deleteOnExit();
            tempFile.delete();
            String tempFileName = tempFile.getName();
            String tempFileBasename = tempFileName.substring(0, tempFileName.length() - TMP_DIR_FILE_SUFFIX.length());
            tempDir = new File(tempFile.getParentFile(), tempFileBasename);
            if (!tempDir.exists()) {
                if (attemptNumber <= 0) break;
                logger.warn("Several attempts (" + attemptNumber + ") were required to allocate a unique tmp directory name inside the parent directory: " + parent.toString() + " Using prefix: " + p);
                break;
            }
            tempDir = null;
            ++attemptNumber;
        }
        if (tempDir == null) {
            throw new Exception("Could not allocate temp directory after " + MAX_ATTEMPTS + " attempts.");
        }
        if (!tempDir.mkdir()) {
            throw new Exception("Could not create directory: " + tempDir.getPath());
        }
        return new SessionTempDirectory(tempDir.getAbsolutePath());
    }

    private static synchronized SessionTempDirectory getSessionTempRootDirectory() throws IOException {
        if (sessionTempRootDirectory == null) {
            SessionTempDirectoryCreationInfo currentCreationInfo = SessionTempDirectoryManager.calculateCurrentCreationInfo();
            SessionTempDirectoryManager.deleteObsoleteTmpDirectories(currentCreationInfo);
            Throwable lastFailureReason = null;
            int maxTrials = 50;
            int trialNumber = 0;
            while (sessionTempRootDirectory == null && trialNumber < 50) {
                try {
                    String suffix = "00000" + Long.toString(System.currentTimeMillis(), 32);
                    suffix = suffix.substring(suffix.length() - 5);
                    String sessionTempDirName = SESSION_TMP_DIRECTORY_NAME_PREFIX + suffix;
                    File java_io_tmpdir = new File(System.getProperty("java.io.tmpdir"));
                    File tempDir = new File(java_io_tmpdir, sessionTempDirName);
                    if (tempDir.exists()) {
                        lastFailureReason = new IOException("Unable to use the file or directory with the name \"" + tempDir.getPath() + "\" because it already exists and may be in use by another session.");
                    } else if (tempDir.mkdirs()) {
                        sessionTempRootDirectory = new SessionTempDirectory(tempDir.getAbsolutePath());
                    } else {
                        lastFailureReason = new IOException("Unable to create directory with the name \"" + tempDir.getPath() + "\" for some unkown reason.");
                    }
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable th) {
                    lastFailureReason = th;
                }
                ++trialNumber;
            }
            if (sessionTempRootDirectory != null) {
                SessionTempDirectoryManager.markNewTmpDirWithCreationInfoFile(sessionTempRootDirectory, currentCreationInfo);
            } else {
                IOException cause;
                String message = "Made 50 unsuccessful attempts to create a suitable temporary directory for this session.";
                logger.error(message, lastFailureReason);
                if (lastFailureReason != null) {
                    message = String.valueOf(message) + " The last of these attempts failed for the following reason: " + lastFailureReason.getClass().getName() + "(" + (lastFailureReason.getLocalizedMessage() != null ? lastFailureReason.getLocalizedMessage() : " <unknown reason>.") + ")";
                    cause = new IOException(message);
                    cause.setStackTrace(lastFailureReason.getStackTrace());
                } else {
                    cause = new IOException(message);
                }
                throw cause;
            }
        }
        return sessionTempRootDirectory;
    }

    private static void deleteObsoleteTmpDirectories(SessionTempDirectoryCreationInfo currentCreationInfo) {
        File[] obsoleteTmpDirectoryCandidates = null;
        try {
            File systemTmp = new File(System.getProperty("java.io.tmpdir"));
            obsoleteTmpDirectoryCandidates = systemTmp.listFiles();
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable th) {
            logger.debug("Unable to determine obsolete tmp directories of previous sessions.", th);
        }
        if (obsoleteTmpDirectoryCandidates != null) {
            File[] fileArray = obsoleteTmpDirectoryCandidates;
            int n = obsoleteTmpDirectoryCandidates.length;
            int n2 = 0;
            while (n2 < n) {
                File candidate = fileArray[n2];
                File candidateCreationInfoFile = new File(candidate, CREATION_INFO_FILENAME);
                try {
                    SessionTempDirectoryCreationInfo candidateCreationInfo;
                    if (candidate.getName().startsWith(SESSION_TMP_DIRECTORY_NAME_PREFIX) && candidate.isDirectory() && candidate.canRead() && candidateCreationInfoFile.canRead() && (candidateCreationInfo = SessionTempDirectoryManager.readCreationInfo(candidateCreationInfoFile)) != null && candidateCreationInfo.getHostname() != null && candidateCreationInfo.getUsername() != null && candidateCreationInfo.getWorkspace() != null && candidateCreationInfo.getHostname().trim().length() > 0 && candidateCreationInfo.getUsername().trim().length() > 0 && candidateCreationInfo.getWorkspace().trim().length() > 0 && !candidateCreationInfo.getHostname().equals("") && candidateCreationInfo.getHostname().equals(currentCreationInfo.getHostname()) && candidateCreationInfo.getUsername().equals(currentCreationInfo.getUsername()) && candidateCreationInfo.getWorkspace().equals(currentCreationInfo.getWorkspace()) && candidateCreationInfo.getCreationMillis() < currentCreationInfo.getCreationMillis()) {
                        File[] dirContent = candidate.listFiles();
                        boolean tmpDirEmpty = true;
                        File[] fileArray2 = dirContent;
                        int n3 = dirContent.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File item = fileArray2[n4];
                            if (!item.equals(candidateCreationInfoFile)) {
                                FileHelper.deleteExistingFileOrDirectory((File)item);
                            }
                            ++n4;
                        }
                        if (tmpDirEmpty) {
                            candidateCreationInfoFile.delete();
                            candidate.delete();
                        }
                    }
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable th) {
                    logger.debug("Error while trying to delete obsolete tmp directory \"" + candidate.getPath() + "\" of previous session. ", th);
                }
                ++n2;
            }
        }
    }

    private static SessionTempDirectoryCreationInfo readCreationInfo(File creationInfoFile) {
        Error firstError = null;
        FileInputStream is = null;
        try {
            is = new FileInputStream(creationInfoFile);
            SessionTempDirectoryCreationInfo result = (SessionTempDirectoryCreationInfo)XMLCoDecForData.decodeIntoObject((InputStream)is, (IDataType)DTSessionTempDirectoryCreationInfo.getInstance());
            is = null;
            SessionTempDirectoryCreationInfo sessionTempDirectoryCreationInfo = result;
            return sessionTempDirectoryCreationInfo;
        }
        catch (Error e) {
            firstError = e;
            throw e;
        }
        catch (Throwable th) {
            logger.error("Unable to read creation info file located in the session temp directory \"" + creationInfoFile.getPath() + "\". - " + th.getClass().getName(), th);
            return null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Error e) {
                    if (firstError != null) {
                        throw firstError;
                    }
                    throw e;
                }
                catch (Throwable th) {
                    logger.error("Unable to close creation info filestream. - " + th.getClass().getName(), th);
                }
            }
        }
    }

    private static void markNewTmpDirWithCreationInfoFile(File dir, SessionTempDirectoryCreationInfo creationInfo) {
        try {
            File creationInfoFile = new File(dir, CREATION_INFO_FILENAME);
            FileOutputStream creationInfoFileStream = new FileOutputStream(creationInfoFile);
            XMLCoDecForData.encodeIntoOutputStream((OutputStream)creationInfoFileStream, (Object)creationInfo, (IDataType)DTSessionTempDirectoryCreationInfo.getInstance(), (String)CREATION_INFO_XML_TAG, null, (String)"UTF-8", (XMLFormatMode)XMLFormatMode.WITH_INDENTION);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable th) {
            logger.error("Unable to mark session temp directory with information about current session. - " + th.getClass().getName(), th);
        }
    }

    private static SessionTempDirectoryCreationInfo calculateCurrentCreationInfo() {
        String hostname;
        long currentTimeMillis = System.currentTimeMillis();
        String userName = "";
        try {
            userName = System.getProperty("user.name");
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable th) {
            logger.error("Unable to read system property \"user.name\". - " + th.getClass().getName(), th);
        }
        try {
            hostname = HostNameRetriever.getHostname();
        }
        catch (HostNameRetriever.UnableToRetrieveHostnameException e) {
            hostname = "";
        }
        SessionTempDirectoryCreationInfo result = new SessionTempDirectoryCreationInfo(currentTimeMillis, RFC1123DateFormatter.getRFC1123String((Date)new Date(currentTimeMillis)), hostname, userName, Platform.getInstanceLocation().getURL().toString());
        return result;
    }

    public static class SessionTempDirectory
    extends File {
        private SessionTempDirectory(String pathname) {
            super(pathname);
        }
    }
}

