/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.file;

import com.arcway.lib.eclipse.Messages;
import com.arcway.lib.eclipse.file.EclipseFileHelper;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.stringtools.TextTemplateMerger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UrlLauncher {
    private static final ILogger LOGGER = Logger.getLogger(UrlLauncher.class);
    private static final String REDIRECTPAGE_RESOURCENAME = "UrlLauncherRedirect.html";
    private static final String REDIRECTPAGE_ENCODING = "ISO-8859-1";
    private static final String REDIRECTPAGE_VARIABLENAME_URL = "REDIRECT-URL";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String PROTOCOL_FILE = "file";

    public static void launchFile_noEx(File file, IWorkbenchPage page) {
        try {
            UrlLauncher.launchUrl(new FileOrURL(file), page);
        }
        catch (Exception e) {
            UrlLauncher.showErrorMsg(null, file.toString(), e);
        }
    }

    public static void launchUrl_noEx(URL url, IWorkbenchPage page) {
        try {
            UrlLauncher.launchUrl(new FileOrURL(url), page);
        }
        catch (Exception e) {
            UrlLauncher.showErrorMsg(null, url.toExternalForm(), e);
        }
    }

    public static void launchUrl_noEx(String urlAsString, IWorkbenchPage page) {
        try {
            UrlLauncher.launchUrl(new FileOrURL(urlAsString), page);
        }
        catch (Exception e) {
            UrlLauncher.showErrorMsg(null, urlAsString, e);
        }
    }

    public static void launchUrl(FileOrURL fileOrURL, IWorkbenchPage page) throws JvmExternalResourceInteractionException, FileNotFoundException, UnsupportedEncodingException, DataCopyHelper.ResourceNotFoundException, ExProgramLaunchFailed {
        String fileOrUrl4EclipseLauncher;
        String protocol = fileOrURL.getProtocol().toLowerCase();
        if (PROTOCOL_HTTP.equals(protocol) || PROTOCOL_HTTPS.equals(protocol)) {
            fileOrUrl4EclipseLauncher = fileOrURL.toLauncherForm();
        } else if (PROTOCOL_FILE.equals(protocol)) {
            if (!fileOrURL.hasFragmentOrQueryPart()) {
                boolean successfullyOpenedInternalEditor;
                if (page != null && (successfullyOpenedInternalEditor = EclipseFileHelper.openFileInInternalEditorIfAvailable(fileOrURL.toFile(), page))) {
                    return;
                }
                fileOrUrl4EclipseLauncher = fileOrURL.toLauncherForm();
            } else {
                File htmlFile = SessionTempDirectoryManager.createSessionTempFile("redir", ".html");
                UrlLauncher.createRedirectPage(htmlFile, fileOrURL.toRedirectTargetUrl());
                fileOrUrl4EclipseLauncher = new FileOrURL(htmlFile).toLauncherForm();
            }
        } else {
            fileOrUrl4EclipseLauncher = fileOrURL.toLauncherForm();
        }
        Program.launch((String)fileOrUrl4EclipseLauncher);
    }

    private static void createRedirectPage(File htmlFile, String redirecttargetURLAsString) throws DataCopyHelper.ResourceNotFoundException, JvmExternalResourceInteractionException, FileNotFoundException, UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataCopyHelper.extractResourceToStream(UrlLauncher.class, (String)REDIRECTPAGE_RESOURCENAME, (OutputStream)baos);
        String redirectpageTemplateContent = new String(baos.toByteArray(), REDIRECTPAGE_ENCODING);
        HashMap<String, String> replacementsMap = new HashMap<String, String>();
        replacementsMap.put(REDIRECTPAGE_VARIABLENAME_URL, redirecttargetURLAsString);
        String redirectpageContent = TextTemplateMerger.replaceVariables((String)redirectpageTemplateContent, replacementsMap);
        PrintWriter printWriter = new PrintWriter(htmlFile, REDIRECTPAGE_ENCODING);
        printWriter.write(redirectpageContent);
        printWriter.flush();
        printWriter.close();
    }

    private static void showErrorMsg(Shell p_shell, String fileOrUrlAsString, Exception cause) {
        String dialogMessage;
        String dialogTitle;
        if (cause != null) {
            LOGGER.debug("Unable to open file or url " + fileOrUrlAsString, (Throwable)cause);
        }
        Shell shell = p_shell == null ? EclipseSWTHelper.getShell() : p_shell;
        if (cause instanceof ExProgramLaunchFailed) {
            ExProgramLaunchFailed exProgramLaunchFailed = (ExProgramLaunchFailed)cause;
            if (exProgramLaunchFailed.canNotReadFile()) {
                dialogTitle = Messages.getString("UrlLauncher.OpenFileOrUrlErrorTitle_File");
                dialogMessage = NLS.bind((String)Messages.getString("UrlLauncher.OpenFileOrUrlErrorMsg_FileCanNotRead"), (Object)fileOrUrlAsString);
            } else if (PROTOCOL_FILE.equals(exProgramLaunchFailed.getProtocol())) {
                dialogTitle = Messages.getString("UrlLauncher.OpenFileOrUrlErrorTitle_File");
                dialogMessage = NLS.bind((String)Messages.getString("UrlLauncher.OpenFileOrUrlErrorMsg_File"), (Object)fileOrUrlAsString);
            } else {
                dialogTitle = Messages.getString("UrlLauncher.OpenFileOrUrlErrorTitle_URL");
                dialogMessage = NLS.bind((String)Messages.getString("UrlLauncher.OpenFileOrUrlErrorMsg_URL"), (Object)fileOrUrlAsString);
            }
        } else {
            dialogTitle = Messages.getString("UrlLauncher.OpenFileOrUrlErrorTitle");
            dialogMessage = NLS.bind((String)Messages.getString("UrlLauncher.OpenFileOrUrlErrorMsg"), (Object)fileOrUrlAsString);
        }
        MessageDialog mDialog = new MessageDialog(shell, dialogTitle, null, dialogMessage, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        mDialog.open();
    }

    private static class ExProgramLaunchFailed
    extends Exception {
        private final String protocol;
        private final boolean canNotReadFile;

        public ExProgramLaunchFailed(String protocol, boolean canNotReadFile) {
            this.canNotReadFile = canNotReadFile;
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public boolean canNotReadFile() {
            return this.canNotReadFile;
        }
    }

    private static class FileOrURL {
        private final File file;
        private final String launcherForm;
        private final String protocol;
        private final boolean hasFragmentOrQueryPart;

        private FileOrURL(File p_file) {
            assert (p_file != null);
            this.launcherForm = p_file.getAbsolutePath();
            this.protocol = UrlLauncher.PROTOCOL_FILE;
            this.hasFragmentOrQueryPart = false;
            this.file = p_file;
        }

        private FileOrURL(URL p_url) {
            assert (p_url != null);
            this.launcherForm = p_url.toExternalForm();
            this.protocol = p_url.getProtocol();
            this.hasFragmentOrQueryPart = !FileOrURL.isNullOrWhitespace(p_url.getQuery()) || !FileOrURL.isNullOrWhitespace(p_url.getRef());
            File f = null;
            if (UrlLauncher.PROTOCOL_FILE.equals(this.protocol) && !this.hasFragmentOrQueryPart) {
                try {
                    f = URIUtil.toFile((URI)URIUtil.toURI((URL)p_url));
                }
                catch (URISyntaxException e) {
                    assert (false);
                    LOGGER.error("unhandled catch block", (Throwable)e);
                }
            }
            this.file = f;
        }

        private FileOrURL(String urlInExternalForm) {
            assert (urlInExternalForm != null);
            int protocolDelimiterIndex = urlInExternalForm.indexOf(58);
            assert (protocolDelimiterIndex != -1);
            this.launcherForm = urlInExternalForm;
            this.protocol = urlInExternalForm.substring(0, protocolDelimiterIndex);
            this.hasFragmentOrQueryPart = urlInExternalForm.indexOf(63) != -1 || urlInExternalForm.indexOf(35) != -1;
            this.file = UrlLauncher.PROTOCOL_FILE.equals(this.protocol) && !this.hasFragmentOrQueryPart ? new File(urlInExternalForm.substring(5)) : null;
        }

        public String toLauncherForm() {
            return this.launcherForm;
        }

        public String toRedirectTargetUrl() {
            return this.launcherForm;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public File toFile() {
            assert (UrlLauncher.PROTOCOL_FILE.equals(this.protocol) && !this.hasFragmentOrQueryPart);
            return this.file;
        }

        public boolean hasFragmentOrQueryPart() {
            return this.hasFragmentOrQueryPart;
        }

        private static boolean isNullOrWhitespace(String s) {
            return s == null || s.trim().length() == 0;
        }
    }
}

