/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.file;

import com.arcway.lib.eclipse.file.IOSDependentDefaultPathsProvider;
import com.arcway.lib.eclipse.file.OSDependentDefaultPathsMac;
import com.arcway.lib.eclipse.file.OSDependentDefaultPathsWindows;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import org.eclipse.core.runtime.Platform;

public class OSIndependentDefaultPaths {
    private static final ILogger LOGGER = Logger.getLogger(OSIndependentDefaultPaths.class);
    private static final String UNKNOWN_PATH = System.getProperty("user.home");
    private static final IOSDependentDefaultPathsProvider provider;

    static {
        String os = Platform.getOS();
        provider = "win32".equals(os) ? OSDependentDefaultPathsWindows.getDefault() : ("macosx".equals(os) ? OSDependentDefaultPathsMac.getDefault() : ("linux".equals(os) ? null : null));
    }

    private OSIndependentDefaultPaths() {
    }

    public static File getPath(IOSDependentDefaultPathsProvider.DirType dirType) {
        File dirAsFile;
        String dir = null;
        String os = Platform.getOS();
        if (provider != null) {
            dir = provider.getOSDependentPath(dirType);
        } else {
            LOGGER.warn("Unknown OS " + os);
        }
        File dirToReturn = null;
        if (dir != null && (dirAsFile = new File(dir)).isDirectory()) {
            dirToReturn = dirAsFile;
        }
        if (dirToReturn == null) {
            dirToReturn = new File(UNKNOWN_PATH);
            LOGGER.warn("No path returned for OS " + os + " and directory type " + (Object)((Object)dirType) + ". Using default path from \"user.home\" java property");
        }
        return dirToReturn;
    }
}

