/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.file;

import com.arcway.lib.eclipse.file.IOSDependentDefaultPathsProvider;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class OSDependentDefaultPathsWindows
implements IOSDependentDefaultPathsProvider {
    private static final ILogger LOGGER = Logger.getLogger(OSDependentDefaultPathsWindows.class);
    public static final int CSIDL_PERSONAL = 5;
    public static final int CSIDL_DESKTOP = 16;
    public static final int CSIDL_PROFILE = 40;
    private static final HashMap<IOSDependentDefaultPathsProvider.DirType, Integer> mapping = new HashMap();
    private static Boolean initSuccessful;
    private static Class<?> OS_CLASS;
    private static int OS_FIELD_MAX_PATH;
    private static int OS_FIELD_SHGFP_TYPE_CURRENT;
    private static int OS_FIELD_S_OK;
    private static Method OS_METHOD_shGetFolderPath;
    private static Class<?> TCHAR_CLASS;
    private static Constructor<?> TCHAR_CONSTRUCTOR;
    private static Method TCHAR_METHOD_toString;
    private static Method TCHAR_METHOD_strlen;

    static {
        mapping.put(IOSDependentDefaultPathsProvider.DirType.USER_HOME, 40);
        mapping.put(IOSDependentDefaultPathsProvider.DirType.DOCUMENTS, 5);
        mapping.put(IOSDependentDefaultPathsProvider.DirType.DESKTOP, 16);
        mapping.put(null, 5);
        initSuccessful = null;
        OS_CLASS = null;
        OS_FIELD_MAX_PATH = 0;
        OS_FIELD_SHGFP_TYPE_CURRENT = 0;
        OS_FIELD_S_OK = 0;
        OS_METHOD_shGetFolderPath = null;
        TCHAR_CLASS = null;
        TCHAR_CONSTRUCTOR = null;
        TCHAR_METHOD_toString = null;
        TCHAR_METHOD_strlen = null;
    }

    private OSDependentDefaultPathsWindows() {
    }

    public static OSDependentDefaultPathsWindows getDefault() {
        return new OSDependentDefaultPathsWindows();
    }

    private static boolean init() {
        if (initSuccessful == null) {
            initSuccessful = Boolean.FALSE;
            try {
                OS_CLASS = Class.forName("org.eclipse.swt.internal.win32.OS");
                Field field = OS_CLASS.getDeclaredField("MAX_PATH");
                if (field != null) {
                    OS_FIELD_MAX_PATH = field.getInt(null);
                }
                if ((field = OS_CLASS.getDeclaredField("SHGFP_TYPE_CURRENT")) != null) {
                    OS_FIELD_SHGFP_TYPE_CURRENT = field.getInt(null);
                }
                if ((field = OS_CLASS.getDeclaredField("S_OK")) != null) {
                    OS_FIELD_S_OK = field.getInt(null);
                }
                TCHAR_CLASS = Class.forName("org.eclipse.swt.internal.win32.TCHAR");
                OS_METHOD_shGetFolderPath = OS_CLASS.getMethod("SHGetFolderPath", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, TCHAR_CLASS);
                TCHAR_METHOD_toString = TCHAR_CLASS.getMethod("toString", Integer.TYPE, Integer.TYPE);
                TCHAR_METHOD_strlen = TCHAR_CLASS.getMethod("strlen", null);
                TCHAR_CONSTRUCTOR = TCHAR_CLASS.getConstructor(Integer.TYPE, Integer.TYPE);
                initSuccessful = Boolean.TRUE;
            }
            catch (IllegalAccessException e) {
                OSDependentDefaultPathsWindows.logInitError(e);
            }
            catch (SecurityException e) {
                OSDependentDefaultPathsWindows.logInitError(e);
            }
            catch (NoSuchFieldException e) {
                OSDependentDefaultPathsWindows.logInitError(e);
            }
            catch (ClassNotFoundException e) {
                OSDependentDefaultPathsWindows.logInitError(e);
            }
            catch (NoSuchMethodException e) {
                OSDependentDefaultPathsWindows.logInitError(e);
            }
        }
        return initSuccessful;
    }

    @Override
    public String getOSDependentPath(IOSDependentDefaultPathsProvider.DirType dirType) {
        if (OSDependentDefaultPathsWindows.init()) {
            try {
                Integer returnCode;
                Integer internalDirType = OSDependentDefaultPathsWindows.getInternalDirTyp(dirType);
                Object tCharBuffer = TCHAR_CONSTRUCTOR.newInstance(0, OS_FIELD_MAX_PATH);
                Object returnedObject = OS_METHOD_shGetFolderPath.invoke(null, 0, internalDirType, 0, OS_FIELD_SHGFP_TYPE_CURRENT, tCharBuffer);
                if (returnedObject instanceof Integer && (returnCode = (Integer)returnedObject) == OS_FIELD_S_OK) {
                    return (String)TCHAR_METHOD_toString.invoke(tCharBuffer, 0, TCHAR_METHOD_strlen.invoke(tCharBuffer, null));
                }
            }
            catch (IllegalArgumentException e) {
                OSDependentDefaultPathsWindows.logRuntimeError(e);
            }
            catch (InstantiationException e) {
                OSDependentDefaultPathsWindows.logRuntimeError(e);
            }
            catch (IllegalAccessException e) {
                OSDependentDefaultPathsWindows.logRuntimeError(e);
            }
            catch (InvocationTargetException e) {
                OSDependentDefaultPathsWindows.logRuntimeError(e);
            }
        }
        return null;
    }

    private static Integer getInternalDirTyp(IOSDependentDefaultPathsProvider.DirType dirType) {
        Integer internalDirType = mapping.get((Object)dirType);
        if (internalDirType == null) {
            internalDirType = mapping.get(null);
        }
        return internalDirType;
    }

    private static void logInitError(Exception e) {
        LOGGER.error("Error initialising.", (Throwable)e);
    }

    private static void logRuntimeError(Exception e) {
        LOGGER.error("Error retrieving path.", (Throwable)e);
    }
}

