/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.extensions;

import com.arcway.lib.java.collectionmaps.ListMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExtensionMgr {
    private static final ILogger logger = Logger.getLogger(ExtensionMgr.class);
    private static final Map<String, ExtensionPointContent> allExtensionPointsContent = new HashMap<String, ExtensionPointContent>();
    private static IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
    private static ExtensionMgr singelton = new ExtensionMgr();

    private ExtensionMgr() {
    }

    public static ExtensionMgr getDefault() {
        return singelton;
    }

    public List<?> getExtension(String pluginID, String extensionPointID, String elementName, String attributeName) {
        String globallyUniqueExtensionPointID = String.valueOf(pluginID) + "\n" + extensionPointID;
        if (!allExtensionPointsContent.containsKey(globallyUniqueExtensionPointID)) {
            allExtensionPointsContent.put(globallyUniqueExtensionPointID, new ExtensionPointContent(pluginID, extensionPointID));
        }
        ExtensionPointContent epc = allExtensionPointsContent.get(globallyUniqueExtensionPointID);
        return epc.getExtensions(elementName, attributeName);
    }

    public <T> List<T> getExtension(String pluginID, String extensionPointID, String elementName, String attributeName, Class<T> type) {
        return ExtensionMgr.getTypedExtensions(this.getExtension(pluginID, extensionPointID, elementName, attributeName), type, String.valueOf(pluginID) + "/" + extensionPointID + "/" + elementName + "/" + attributeName);
    }

    public List<?> getNewInstanceOfExtension(String pluginID, String extensionPointID, String elementName, String attributeName) {
        ExtensionPointContent epc = new ExtensionPointContent(pluginID, extensionPointID);
        return epc.getExtensions(elementName, attributeName);
    }

    public <T> List<T> getNewInstanceOfExtension(String pluginID, String extensionPointID, String elementName, String attributeName, Class<T> type) {
        return ExtensionMgr.getTypedExtensions(this.getNewInstanceOfExtension(pluginID, extensionPointID, elementName, attributeName), type, String.valueOf(pluginID) + "/" + extensionPointID + "/" + elementName + "/" + attributeName);
    }

    private static <T> List<T> getTypedExtensions(List<?> extensions, Class<T> type, String humanReadableIdentifier) {
        ArrayList<T> typedExtensions = new ArrayList<T>(extensions.size());
        for (Object extension : extensions) {
            if (type.isInstance(extension)) {
                typedExtensions.add(type.cast(extension));
                continue;
            }
            logger.error("The extension of type \"" + extension.getClass().getName() + "\" for the extension point \"" + humanReadableIdentifier + "\" is not compatible with the requested type  \"" + type.getName() + "\".");
            return Collections.emptyList();
        }
        return typedExtensions;
    }

    class ExtensionPointContent {
        private final HashMap<String, ListMap<String, Object>> extensions = new HashMap();

        public ExtensionPointContent(String pluginID, String extensionPointID) {
            IExtension[] allExtensions;
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(pluginID, extensionPointID);
            IExtension[] iExtensionArray = allExtensions = extensionPoint.getExtensions();
            int n = allExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension currentExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = currentExtension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] attributeNames;
                    IConfigurationElement currentConfigElement = iConfigurationElementArray[n4];
                    String[] stringArray = attributeNames = currentConfigElement.getAttributeNames();
                    int n5 = attributeNames.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String element = stringArray[n6];
                        if (!element.equals("id")) {
                            try {
                                Object extension = currentConfigElement.createExecutableExtension(element);
                                this.addExtension(currentConfigElement.getName(), element, extension);
                            }
                            catch (CoreException e) {
                                logger.warn("Couldn't create executable extension.", (Throwable)e);
                            }
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }

        public List<?> getExtensions(String elementName, String attributeName) {
            ListMap<String, Object> elements = this.extensions.get(elementName);
            if (elements == null) {
                return new ArrayList();
            }
            return elements.get((Object)attributeName);
        }

        private void addExtension(String elementName, String attributeName, Object provider) {
            if (!this.extensions.containsKey(elementName)) {
                this.extensions.put(elementName, (ListMap<String, Object>)new ListMap());
            }
            ListMap<String, Object> elements = this.extensions.get(elementName);
            elements.add((Object)attributeName, provider);
        }
    }
}

