/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.data.codec.memento;

import com.arcway.lib.codec.data.EXDataCreationFailed;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.IElementaryDataFactory;
import com.arcway.lib.codec.data.IElementaryDataType;
import com.arcway.lib.codec.data.IKey;
import com.arcway.lib.codec.data.IStructuredDataFactory;
import com.arcway.lib.codec.data.IStructuredDataType;
import com.arcway.lib.codec.data.Key;
import com.arcway.lib.codec.data.SubDataType;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.stringtools.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.ui.IMemento;

public class MementoCoDecForData {
    private static final String NULL = "null";

    public static void encodeIntoMemento(Object data, IDataType dataType, IMemento targetMemento) {
        Class type = dataType.getStructureType();
        if (IElementaryDataType.class.isAssignableFrom(type)) {
            if (dataType.isNull(data)) {
                targetMemento.createChild(NULL);
            } else {
                IElementaryDataType elementaryDataType = (IElementaryDataType)dataType.getConcreteDataType();
                String valueAsString = elementaryDataType.getValueAsString(data);
                targetMemento.putTextData(valueAsString);
            }
        }
        if (IStructuredDataType.class.isAssignableFrom(type)) {
            if (dataType.isNull(data)) {
                targetMemento.putTextData(NULL);
            } else {
                IStructuredDataType structuredDataType = (IStructuredDataType)dataType.getConcreteDataType();
                IList_ propertyAndChildRoles = structuredDataType.getFlagAndPropertyAndChildRoles(data);
                for (IKey flagOrPropertyOrChildRole : propertyAndChildRoles) {
                    String flagOrPropertyOrChildRoleAsString = flagOrPropertyOrChildRole.toCanonicalString();
                    SubDataType subDataType = structuredDataType.getSubDataType(flagOrPropertyOrChildRole);
                    if (subDataType.isFlag()) {
                        targetMemento.createChild(flagOrPropertyOrChildRoleAsString);
                        continue;
                    }
                    if (subDataType.isProperty() || subDataType.isChild()) {
                        IDataType childDataType = structuredDataType.getDataTypeOfPropertyOrChildren(data, flagOrPropertyOrChildRole);
                        if (subDataType.isProperty()) {
                            Object property = structuredDataType.getProperty(data, flagOrPropertyOrChildRole);
                            IMemento propertyTargetMemento = targetMemento.createChild(flagOrPropertyOrChildRoleAsString);
                            MementoCoDecForData.encodeIntoMemento(property, childDataType, propertyTargetMemento);
                            continue;
                        }
                        IList_ children = structuredDataType.getChildren(data, flagOrPropertyOrChildRole);
                        for (Object child : children) {
                            IMemento childTargetMemento = targetMemento.createChild(flagOrPropertyOrChildRoleAsString);
                            MementoCoDecForData.encodeIntoMemento(child, childDataType, childTargetMemento);
                        }
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public static Object decodeFromMemento(IMemento sourceMemento, IDataType dataType) throws Exception {
        Object data;
        Class type = dataType.getStructureType();
        if (IElementaryDataType.class.isAssignableFrom(type)) {
            IElementaryDataType elementaryDataType = (IElementaryDataType)dataType.getConcreteDataType();
            data = MementoCoDecForData.decodeElementaryDataFromMemento(sourceMemento, dataType, elementaryDataType);
        } else {
            IStructuredDataType structuredDataType = (IStructuredDataType)dataType.getConcreteDataType();
            data = MementoCoDecForData.decodeStructuredDataFromMemento(sourceMemento, dataType, structuredDataType);
        }
        return data;
    }

    private static Object decodeElementaryDataFromMemento(IMemento sourceMemento, IDataType dataType, IElementaryDataType elementaryDataType) throws Exception {
        Object elementaryData;
        try {
            if (sourceMemento.getChild(NULL) != null) {
                elementaryData = dataType.createNullDataElement();
            } else {
                IElementaryDataFactory elementaryDataFactory = elementaryDataType.createDataFactory();
                String characters = sourceMemento.getTextData();
                elementaryDataFactory.setCharacters(characters);
                elementaryData = elementaryDataFactory.createDataElement();
            }
        }
        catch (EXDataCreationFailed e) {
            throw e.getCausingException();
        }
        return elementaryData;
    }

    private static Object decodeStructuredDataFromMemento(IMemento sourceMemento, IDataType dataType, IStructuredDataType structuredDataType) throws Exception {
        Object structuredData;
        try {
            if (StringUtil.equals((String)sourceMemento.getTextData(), (String)NULL)) {
                structuredData = dataType.createNullDataElement();
            } else {
                IStructuredDataFactory structuredDataFactory = structuredDataType.createDataFactory();
                ArrayList<String> childKeys_sorted = new ArrayList<String>();
                IMemento[] children = sourceMemento.getChildren();
                HashSet<String> childKeys = new HashSet<String>();
                IMemento[] iMementoArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento child = iMementoArray[n2];
                    String type = child.getType();
                    if (!childKeys.contains(type)) {
                        childKeys.add(type);
                        childKeys_sorted.add(type);
                    }
                    ++n2;
                }
                for (String flagOrPropertyOrChildRoleAsString : childKeys_sorted) {
                    IMemento[] propertiesAndChildern;
                    Key flagOrPropertyOrChildRole = Key.getCanonicalKeyInstance((String)flagOrPropertyOrChildRoleAsString);
                    SubDataType subDataType = structuredDataType.getSubDataType((IKey)flagOrPropertyOrChildRole);
                    if (subDataType.isFlag()) {
                        if (sourceMemento.getChild(flagOrPropertyOrChildRoleAsString) == null) continue;
                        structuredDataFactory.setFlag((IKey)flagOrPropertyOrChildRole);
                        continue;
                    }
                    if (!subDataType.isProperty() && !subDataType.isChild()) continue;
                    IDataType dataTypeOfPropertyOrChildren = structuredDataFactory.getDataTypeOfPropertyOrChildren((IKey)flagOrPropertyOrChildRole);
                    IMemento[] iMementoArray2 = propertiesAndChildern = sourceMemento.getChildren(flagOrPropertyOrChildRoleAsString);
                    int n3 = propertiesAndChildern.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento propertyOrChildMemento = iMementoArray2[n4];
                        Object propertyOrChild = MementoCoDecForData.decodeFromMemento(propertyOrChildMemento, dataTypeOfPropertyOrChildren);
                        structuredDataFactory.addPropertyOrChild((IKey)flagOrPropertyOrChildRole, propertyOrChild);
                        ++n4;
                    }
                }
                structuredData = structuredDataFactory.createDataElement();
            }
        }
        catch (EXDataCreationFailed e) {
            throw e.getCausingException();
        }
        return structuredData;
    }
}

