/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.word.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import com.arcway.lib.eclipse.ole.word.OCXEvents;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class OCXEventsListener
extends AbstractOleEventsListener {
    private Set<OCXEvents> listeners = new HashSet<OCXEvents>();

    public OCXEventsListener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(OCXEvents listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(OCXEvents listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        switch (oleEvent.type) {
            case -2147417888: {
                this.fireGotFocus(oleEvent);
                break;
            }
            case -2147417887: {
                this.fireLostFocus(oleEvent);
            }
        }
        Variant[] arguments = oleEvent.arguments;
        int i = 0;
        while (i < arguments.length) {
            arguments[i].dispose();
            ++i;
        }
    }

    private void fireGotFocus(OleEvent oleEvent) {
        for (OCXEvents l : this.listeners) {
            l.GotFocus();
        }
    }

    private void fireLostFocus(OleEvent oleEvent) {
        for (OCXEvents l : this.listeners) {
            l.LostFocus();
        }
    }
}

