/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.word.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import com.arcway.lib.eclipse.ole.word.DocumentEvents;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class DocumentEventsListener
extends AbstractOleEventsListener {
    private Set<DocumentEvents> listeners = new HashSet<DocumentEvents>();

    public DocumentEventsListener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(DocumentEvents listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(DocumentEvents listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        switch (oleEvent.type) {
            case 4: {
                this.fireNew(oleEvent);
                break;
            }
            case 5: {
                this.fireOpen(oleEvent);
                break;
            }
            case 6: {
                this.fireClose(oleEvent);
            }
        }
        Variant[] arguments = oleEvent.arguments;
        int i = 0;
        while (i < arguments.length) {
            arguments[i].dispose();
            ++i;
        }
    }

    private void fireNew(OleEvent oleEvent) {
        for (DocumentEvents l : this.listeners) {
            l.New();
        }
    }

    private void fireOpen(OleEvent oleEvent) {
        for (DocumentEvents l : this.listeners) {
            l.Open();
        }
    }

    private void fireClose(OleEvent oleEvent) {
        for (DocumentEvents l : this.listeners) {
            l.Close();
        }
    }
}

