/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.word.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import au.com.swz.swttocom.swt.types.pointer.BooleanPointer;
import com.arcway.lib.eclipse.ole.word.ApplicationEvents4;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.impl.SelectionImpl;
import com.arcway.lib.eclipse.ole.word.impl.WindowImpl;
import com.arcway.lib.eclipse.ole.word.impl.XMLNodeImpl;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class ApplicationEvents4Listener
extends AbstractOleEventsListener {
    private Set<ApplicationEvents4> listeners = new HashSet<ApplicationEvents4>();

    public ApplicationEvents4Listener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(ApplicationEvents4 listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ApplicationEvents4 listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        switch (oleEvent.type) {
            case 2: {
                this.fireQuit(oleEvent);
                break;
            }
            case 3: {
                this.fireDocumentChange(oleEvent);
                break;
            }
            case 4: {
                this.fireDocumentOpen(oleEvent);
                break;
            }
            case 6: {
                this.fireDocumentBeforeClose(oleEvent);
                break;
            }
            case 7: {
                this.fireDocumentBeforePrint(oleEvent);
                break;
            }
            case 8: {
                this.fireDocumentBeforeSave(oleEvent);
                break;
            }
            case 9: {
                this.fireNewDocument(oleEvent);
                break;
            }
            case 10: {
                this.fireWindowActivate(oleEvent);
                break;
            }
            case 11: {
                this.fireWindowDeactivate(oleEvent);
                break;
            }
            case 12: {
                this.fireWindowSelectionChange(oleEvent);
                break;
            }
            case 13: {
                this.fireWindowBeforeRightClick(oleEvent);
                break;
            }
            case 14: {
                this.fireWindowBeforeDoubleClick(oleEvent);
                break;
            }
            case 15: {
                this.fireEPostagePropertyDialog(oleEvent);
                break;
            }
            case 16: {
                this.fireEPostageInsert(oleEvent);
                break;
            }
            case 17: {
                this.fireMailMergeAfterMerge(oleEvent);
                break;
            }
            case 18: {
                this.fireMailMergeAfterRecordMerge(oleEvent);
                break;
            }
            case 19: {
                this.fireMailMergeBeforeMerge(oleEvent);
                break;
            }
            case 20: {
                this.fireMailMergeBeforeRecordMerge(oleEvent);
                break;
            }
            case 21: {
                this.fireMailMergeDataSourceLoad(oleEvent);
                break;
            }
            case 22: {
                this.fireMailMergeDataSourceValidate(oleEvent);
                break;
            }
            case 23: {
                this.fireMailMergeWizardSendToCustom(oleEvent);
                break;
            }
            case 24: {
                this.fireMailMergeWizardStateChange(oleEvent);
                break;
            }
            case 25: {
                this.fireWindowSize(oleEvent);
                break;
            }
            case 26: {
                this.fireXMLSelectionChange(oleEvent);
                break;
            }
            case 27: {
                this.fireXMLValidationError(oleEvent);
                break;
            }
            case 28: {
                this.fireDocumentSync(oleEvent);
                break;
            }
            case 29: {
                this.fireEPostageInsertEx(oleEvent);
            }
        }
        Variant[] arguments = oleEvent.arguments;
        int i = 0;
        while (i < arguments.length) {
            arguments[i].dispose();
            ++i;
        }
    }

    private void fireQuit(OleEvent oleEvent) {
        for (ApplicationEvents4 l : this.listeners) {
            l.Quit();
        }
    }

    private void fireDocumentChange(OleEvent oleEvent) {
        for (ApplicationEvents4 l : this.listeners) {
            l.DocumentChange();
        }
    }

    private void fireDocumentOpen(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.DocumentOpen(doc);
        }
    }

    private void fireDocumentBeforeClose(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[1].getByRef(), this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.DocumentBeforeClose(doc, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireDocumentBeforePrint(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[1].getByRef(), this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.DocumentBeforePrint(doc, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireDocumentBeforeSave(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        boolean saveAsUI = oleEvent.arguments[1].getBoolean();
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[2].getByRef(), this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.DocumentBeforeSave(doc, saveAsUI, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireNewDocument(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.NewDocument(doc);
        }
    }

    private void fireWindowActivate(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.WindowActivate(doc, wn);
        }
    }

    private void fireWindowDeactivate(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.WindowDeactivate(doc, wn);
        }
    }

    private void fireWindowSelectionChange(OleEvent oleEvent) {
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.WindowSelectionChange(sel);
        }
    }

    private void fireWindowBeforeRightClick(OleEvent oleEvent) {
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[0], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[1].getByRef(), this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.WindowBeforeRightClick(sel, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireWindowBeforeDoubleClick(OleEvent oleEvent) {
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[0], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[1].getByRef(), this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.WindowBeforeDoubleClick(sel, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireEPostagePropertyDialog(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.EPostagePropertyDialog(doc);
        }
    }

    private void fireEPostageInsert(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.EPostageInsert(doc);
        }
    }

    private void fireMailMergeAfterMerge(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        Document docResult = new Document(oleEvent.arguments[1], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.MailMergeAfterMerge(doc, docResult);
        }
    }

    private void fireMailMergeAfterRecordMerge(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.MailMergeAfterRecordMerge(doc);
        }
    }

    private void fireMailMergeBeforeMerge(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        int startRecord = oleEvent.arguments[1].getInt();
        int endRecord = oleEvent.arguments[2].getInt();
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[3].getByRef(), this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.MailMergeBeforeMerge(doc, startRecord, endRecord, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireMailMergeBeforeRecordMerge(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        BooleanPointer cancel = new BooleanPointer(oleEvent.arguments[1].getByRef(), this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.MailMergeBeforeRecordMerge(doc, cancel);
        }
        cancel.setAddress(0);
    }

    private void fireMailMergeDataSourceLoad(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.MailMergeDataSourceLoad(doc);
        }
    }

    private void fireMailMergeDataSourceValidate(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        boolean handled = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents4 l : this.listeners) {
            l.MailMergeDataSourceValidate(doc, handled);
        }
    }

    private void fireMailMergeWizardSendToCustom(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.MailMergeWizardSendToCustom(doc);
        }
    }

    private void fireMailMergeWizardStateChange(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        int fromState = oleEvent.arguments[1].getInt();
        int toState = oleEvent.arguments[2].getInt();
        boolean handled = oleEvent.arguments[3].getBoolean();
        for (ApplicationEvents4 l : this.listeners) {
            l.MailMergeWizardStateChange(doc, fromState, toState, handled);
        }
    }

    private void fireWindowSize(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.WindowSize(doc, wn);
        }
    }

    private void fireXMLSelectionChange(OleEvent oleEvent) {
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[0], this.getResourceManager());
        XMLNodeImpl oldXMLNode = new XMLNodeImpl(oleEvent.arguments[1], this.getResourceManager());
        XMLNodeImpl newXMLNode = new XMLNodeImpl(oleEvent.arguments[2], this.getResourceManager());
        int reason = oleEvent.arguments[3].getInt();
        for (ApplicationEvents4 l : this.listeners) {
            l.XMLSelectionChange(sel, oldXMLNode, newXMLNode, reason);
        }
    }

    private void fireXMLValidationError(OleEvent oleEvent) {
        XMLNodeImpl xMLNode = new XMLNodeImpl(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.XMLValidationError(xMLNode);
        }
    }

    private void fireDocumentSync(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        int syncEventType = oleEvent.arguments[1].getInt();
        for (ApplicationEvents4 l : this.listeners) {
            l.DocumentSync(doc, syncEventType);
        }
    }

    private void fireEPostageInsertEx(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        int cpDeliveryAddrStart = oleEvent.arguments[1].getInt();
        int cpDeliveryAddrEnd = oleEvent.arguments[2].getInt();
        int cpReturnAddrStart = oleEvent.arguments[3].getInt();
        int cpReturnAddrEnd = oleEvent.arguments[4].getInt();
        int xaWidth = oleEvent.arguments[5].getInt();
        int yaHeight = oleEvent.arguments[6].getInt();
        String bstrPrinterName = oleEvent.arguments[7].getString();
        String bstrPaperFeed = oleEvent.arguments[8].getString();
        boolean fPrint = oleEvent.arguments[9].getBoolean();
        BooleanPointer fCancel = new BooleanPointer(oleEvent.arguments[10].getByRef(), this.getResourceManager());
        for (ApplicationEvents4 l : this.listeners) {
            l.EPostageInsertEx(doc, cpDeliveryAddrStart, cpDeliveryAddrEnd, cpReturnAddrStart, cpReturnAddrEnd, xaWidth, yaHeight, bstrPrinterName, bstrPaperFeed, fPrint, fCancel);
        }
        fCancel.setAddress(0);
    }
}

