/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.word.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import com.arcway.lib.eclipse.ole.word.ApplicationEvents3;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.impl.SelectionImpl;
import com.arcway.lib.eclipse.ole.word.impl.WindowImpl;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class ApplicationEvents3Listener
extends AbstractOleEventsListener {
    private Set<ApplicationEvents3> listeners = new HashSet<ApplicationEvents3>();

    public ApplicationEvents3Listener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(ApplicationEvents3 listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ApplicationEvents3 listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        switch (oleEvent.type) {
            case 2: {
                this.fireQuit(oleEvent);
                break;
            }
            case 3: {
                this.fireDocumentChange(oleEvent);
                break;
            }
            case 4: {
                this.fireDocumentOpen(oleEvent);
                break;
            }
            case 6: {
                this.fireDocumentBeforeClose(oleEvent);
                break;
            }
            case 7: {
                this.fireDocumentBeforePrint(oleEvent);
                break;
            }
            case 8: {
                this.fireDocumentBeforeSave(oleEvent);
                break;
            }
            case 9: {
                this.fireNewDocument(oleEvent);
                break;
            }
            case 10: {
                this.fireWindowActivate(oleEvent);
                break;
            }
            case 11: {
                this.fireWindowDeactivate(oleEvent);
                break;
            }
            case 12: {
                this.fireWindowSelectionChange(oleEvent);
                break;
            }
            case 13: {
                this.fireWindowBeforeRightClick(oleEvent);
                break;
            }
            case 14: {
                this.fireWindowBeforeDoubleClick(oleEvent);
                break;
            }
            case 15: {
                this.fireEPostagePropertyDialog(oleEvent);
                break;
            }
            case 16: {
                this.fireEPostageInsert(oleEvent);
                break;
            }
            case 17: {
                this.fireMailMergeAfterMerge(oleEvent);
                break;
            }
            case 18: {
                this.fireMailMergeAfterRecordMerge(oleEvent);
                break;
            }
            case 19: {
                this.fireMailMergeBeforeMerge(oleEvent);
                break;
            }
            case 20: {
                this.fireMailMergeBeforeRecordMerge(oleEvent);
                break;
            }
            case 21: {
                this.fireMailMergeDataSourceLoad(oleEvent);
                break;
            }
            case 22: {
                this.fireMailMergeDataSourceValidate(oleEvent);
                break;
            }
            case 23: {
                this.fireMailMergeWizardSendToCustom(oleEvent);
                break;
            }
            case 24: {
                this.fireMailMergeWizardStateChange(oleEvent);
                break;
            }
            case 25: {
                this.fireWindowSize(oleEvent);
            }
        }
        Variant[] arguments = oleEvent.arguments;
        int i = 0;
        while (i < arguments.length) {
            arguments[i].dispose();
            ++i;
        }
    }

    private void fireQuit(OleEvent oleEvent) {
        for (ApplicationEvents3 l : this.listeners) {
            l.Quit();
        }
    }

    private void fireDocumentChange(OleEvent oleEvent) {
        for (ApplicationEvents3 l : this.listeners) {
            l.DocumentChange();
        }
    }

    private void fireDocumentOpen(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.DocumentOpen(doc);
        }
    }

    private void fireDocumentBeforeClose(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents3 l : this.listeners) {
            l.DocumentBeforeClose(doc, cancel);
        }
    }

    private void fireDocumentBeforePrint(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents3 l : this.listeners) {
            l.DocumentBeforePrint(doc, cancel);
        }
    }

    private void fireDocumentBeforeSave(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        boolean saveAsUI = oleEvent.arguments[1].getBoolean();
        boolean cancel = oleEvent.arguments[2].getBoolean();
        for (ApplicationEvents3 l : this.listeners) {
            l.DocumentBeforeSave(doc, saveAsUI, cancel);
        }
    }

    private void fireNewDocument(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.NewDocument(doc);
        }
    }

    private void fireWindowActivate(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.WindowActivate(doc, wn);
        }
    }

    private void fireWindowDeactivate(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.WindowDeactivate(doc, wn);
        }
    }

    private void fireWindowSelectionChange(OleEvent oleEvent) {
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.WindowSelectionChange(sel);
        }
    }

    private void fireWindowBeforeRightClick(OleEvent oleEvent) {
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents3 l : this.listeners) {
            l.WindowBeforeRightClick(sel, cancel);
        }
    }

    private void fireWindowBeforeDoubleClick(OleEvent oleEvent) {
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents3 l : this.listeners) {
            l.WindowBeforeDoubleClick(sel, cancel);
        }
    }

    private void fireEPostagePropertyDialog(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.EPostagePropertyDialog(doc);
        }
    }

    private void fireEPostageInsert(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.EPostageInsert(doc);
        }
    }

    private void fireMailMergeAfterMerge(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        Document docResult = new Document(oleEvent.arguments[1], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.MailMergeAfterMerge(doc, docResult);
        }
    }

    private void fireMailMergeAfterRecordMerge(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.MailMergeAfterRecordMerge(doc);
        }
    }

    private void fireMailMergeBeforeMerge(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        int startRecord = oleEvent.arguments[1].getInt();
        int endRecord = oleEvent.arguments[2].getInt();
        boolean cancel = oleEvent.arguments[3].getBoolean();
        for (ApplicationEvents3 l : this.listeners) {
            l.MailMergeBeforeMerge(doc, startRecord, endRecord, cancel);
        }
    }

    private void fireMailMergeBeforeRecordMerge(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents3 l : this.listeners) {
            l.MailMergeBeforeRecordMerge(doc, cancel);
        }
    }

    private void fireMailMergeDataSourceLoad(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.MailMergeDataSourceLoad(doc);
        }
    }

    private void fireMailMergeDataSourceValidate(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        boolean handled = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents3 l : this.listeners) {
            l.MailMergeDataSourceValidate(doc, handled);
        }
    }

    private void fireMailMergeWizardSendToCustom(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.MailMergeWizardSendToCustom(doc);
        }
    }

    private void fireMailMergeWizardStateChange(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        int fromState = oleEvent.arguments[1].getInt();
        int toState = oleEvent.arguments[2].getInt();
        boolean handled = oleEvent.arguments[3].getBoolean();
        for (ApplicationEvents3 l : this.listeners) {
            l.MailMergeWizardStateChange(doc, fromState, toState, handled);
        }
    }

    private void fireWindowSize(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (ApplicationEvents3 l : this.listeners) {
            l.WindowSize(doc, wn);
        }
    }
}

