/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.word.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import com.arcway.lib.eclipse.ole.word.ApplicationEvents2;
import com.arcway.lib.eclipse.ole.word.Document;
import com.arcway.lib.eclipse.ole.word.impl.SelectionImpl;
import com.arcway.lib.eclipse.ole.word.impl.WindowImpl;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class ApplicationEvents2Listener
extends AbstractOleEventsListener {
    private Set<ApplicationEvents2> listeners = new HashSet<ApplicationEvents2>();

    public ApplicationEvents2Listener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(ApplicationEvents2 listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ApplicationEvents2 listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        switch (oleEvent.type) {
            case 2: {
                this.fireQuit(oleEvent);
                break;
            }
            case 3: {
                this.fireDocumentChange(oleEvent);
                break;
            }
            case 4: {
                this.fireDocumentOpen(oleEvent);
                break;
            }
            case 6: {
                this.fireDocumentBeforeClose(oleEvent);
                break;
            }
            case 7: {
                this.fireDocumentBeforePrint(oleEvent);
                break;
            }
            case 8: {
                this.fireDocumentBeforeSave(oleEvent);
                break;
            }
            case 9: {
                this.fireNewDocument(oleEvent);
                break;
            }
            case 10: {
                this.fireWindowActivate(oleEvent);
                break;
            }
            case 11: {
                this.fireWindowDeactivate(oleEvent);
                break;
            }
            case 12: {
                this.fireWindowSelectionChange(oleEvent);
                break;
            }
            case 13: {
                this.fireWindowBeforeRightClick(oleEvent);
                break;
            }
            case 14: {
                this.fireWindowBeforeDoubleClick(oleEvent);
            }
        }
        Variant[] arguments = oleEvent.arguments;
        int i = 0;
        while (i < arguments.length) {
            arguments[i].dispose();
            ++i;
        }
    }

    private void fireQuit(OleEvent oleEvent) {
        for (ApplicationEvents2 l : this.listeners) {
            l.Quit();
        }
    }

    private void fireDocumentChange(OleEvent oleEvent) {
        for (ApplicationEvents2 l : this.listeners) {
            l.DocumentChange();
        }
    }

    private void fireDocumentOpen(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents2 l : this.listeners) {
            l.DocumentOpen(doc);
        }
    }

    private void fireDocumentBeforeClose(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents2 l : this.listeners) {
            l.DocumentBeforeClose(doc, cancel);
        }
    }

    private void fireDocumentBeforePrint(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents2 l : this.listeners) {
            l.DocumentBeforePrint(doc, cancel);
        }
    }

    private void fireDocumentBeforeSave(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        boolean saveAsUI = oleEvent.arguments[1].getBoolean();
        boolean cancel = oleEvent.arguments[2].getBoolean();
        for (ApplicationEvents2 l : this.listeners) {
            l.DocumentBeforeSave(doc, saveAsUI, cancel);
        }
    }

    private void fireNewDocument(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents2 l : this.listeners) {
            l.NewDocument(doc);
        }
    }

    private void fireWindowActivate(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (ApplicationEvents2 l : this.listeners) {
            l.WindowActivate(doc, wn);
        }
    }

    private void fireWindowDeactivate(OleEvent oleEvent) {
        Document doc = new Document(oleEvent.arguments[0], this.getResourceManager());
        WindowImpl wn = new WindowImpl(oleEvent.arguments[1], this.getResourceManager());
        for (ApplicationEvents2 l : this.listeners) {
            l.WindowDeactivate(doc, wn);
        }
    }

    private void fireWindowSelectionChange(OleEvent oleEvent) {
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[0], this.getResourceManager());
        for (ApplicationEvents2 l : this.listeners) {
            l.WindowSelectionChange(sel);
        }
    }

    private void fireWindowBeforeRightClick(OleEvent oleEvent) {
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents2 l : this.listeners) {
            l.WindowBeforeRightClick(sel, cancel);
        }
    }

    private void fireWindowBeforeDoubleClick(OleEvent oleEvent) {
        SelectionImpl sel = new SelectionImpl(oleEvent.arguments[0], this.getResourceManager());
        boolean cancel = oleEvent.arguments[1].getBoolean();
        for (ApplicationEvents2 l : this.listeners) {
            l.WindowBeforeDoubleClick(sel, cancel);
        }
    }
}

