/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.word;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.eclipse.ole.word.OCXEvents;
import com.arcway.lib.eclipse.ole.word._OLEControl;
import com.arcway.lib.eclipse.ole.word.impl.OCXEventsListener;
import com.arcway.lib.eclipse.ole.word.impl._OLEControlImpl;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class OLEControl
extends _OLEControlImpl {
    private static final ILogger logger = Logger.getLogger(OLEControl.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{000209F2-0000-0000-C000-000000000046}");
    private OCXEventsListener oCXEvents;

    public OLEControl(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public OLEControl(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static _OLEControl create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new _OLEControlImpl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            _OLEControlImpl _OLEControlImpl2 = new _OLEControlImpl(appVariant, resourceManager);
            return _OLEControlImpl2;
        }
        finally {
            objIUnknown.Release();
        }
    }

    public boolean addOCXEventsListener(OCXEvents listener) {
        if (this.oCXEvents == null) {
            this.oCXEvents = new OCXEventsListener(this.getResourceManager());
            this.addEventListener(OCXEvents.IID, -2147417888, (OleListener)this.oCXEvents);
            this.addEventListener(OCXEvents.IID, -2147417887, (OleListener)this.oCXEvents);
        }
        return this.oCXEvents.addListener(listener);
    }

    public boolean removeOCXEventsListener(OCXEvents listener) {
        boolean bRtn = this.oCXEvents.removeListener(listener);
        if (this.oCXEvents.isEmpty()) {
            this.removeEventListener(OCXEvents.IID, -2147417888, (OleListener)this.oCXEvents);
            this.removeEventListener(OCXEvents.IID, -2147417887, (OleListener)this.oCXEvents);
            this.oCXEvents = null;
        }
        return bRtn;
    }
}

