/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.ole.word;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.lib.eclipse.ole.word.DocumentEvents;
import com.arcway.lib.eclipse.ole.word.DocumentEvents2;
import com.arcway.lib.eclipse.ole.word._Document;
import com.arcway.lib.eclipse.ole.word.impl.DocumentEvents2Listener;
import com.arcway.lib.eclipse.ole.word.impl.DocumentEventsListener;
import com.arcway.lib.eclipse.ole.word.impl._DocumentImpl;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.text.MessageFormat;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class Document
extends _DocumentImpl {
    private static final ILogger logger = Logger.getLogger(Document.class);
    public static final GUID CLSID = TypeUtils.IIDFromString((String)"{00020906-0000-0000-C000-000000000046}");
    private DocumentEventsListener documentEvents;
    private DocumentEvents2Listener documentEvents2;

    public Document(OleAutomation oleAutomation, ResourceManager resourceManager) {
        super(oleAutomation, resourceManager);
    }

    public Document(Variant variant, ResourceManager resourceManager) {
        super(variant, resourceManager);
    }

    public static _Document create(int dwClsContext, ResourceManager resourceManager, boolean callingOleRunIsRequired) {
        if (!callingOleRunIsRequired) {
            int[] ppv = new int[1];
            int result = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIDispatch, (int[])ppv);
            if (result != 0) {
                OLE.error((int)1001, (int)result);
            }
            Variant v = new Variant(new IDispatch(ppv[0]));
            return new _DocumentImpl(v, resourceManager);
        }
        int[] ppv = new int[1];
        int coCreateInstanceResult = COM.CoCreateInstance((GUID)CLSID, (int)0, (int)dwClsContext, (GUID)COM.IIDIUnknown, (int[])ppv);
        if (coCreateInstanceResult != 0) {
            OLE.error((int)1001, (int)coCreateInstanceResult);
        }
        IUnknown objIUnknown = new IUnknown(ppv[0]);
        try {
            int[] ppvObject;
            int queryIDispatchResult;
            int oleRunResult = COM.OleRun((int)objIUnknown.getAddress());
            if (oleRunResult != 0) {
                logger.debug(MessageFormat.format("Initialisation of COM Server CLSID={0} failed. (errorcode={1}). ", CLSID.toString(), oleRunResult));
                OLE.error((int)1014, (int)coCreateInstanceResult);
            }
            if ((queryIDispatchResult = objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject = new int[1])) != 0) {
                try {
                    OLE.error((int)1003, (int)queryIDispatchResult);
                }
                catch (SWTException e) {
                    try {
                        Exception cause = new Exception(MessageFormat.format("Additional Information: Problem occured while trying to initialise COM Server CLSID={0}, objIUnknown.getAddress()={1}.). ", CLSID.toString(), String.valueOf(objIUnknown.getAddress())));
                        e.initCause((Throwable)cause);
                    }
                    catch (Exception e1) {
                        throw e;
                    }
                }
            }
            IDispatch disp = new IDispatch(ppvObject[0]);
            Variant appVariant = new Variant(disp);
            _DocumentImpl _DocumentImpl2 = new _DocumentImpl(appVariant, resourceManager);
            return _DocumentImpl2;
        }
        finally {
            objIUnknown.Release();
        }
    }

    public boolean addDocumentEventsListener(DocumentEvents listener) {
        if (this.documentEvents == null) {
            this.documentEvents = new DocumentEventsListener(this.getResourceManager());
            this.addEventListener(DocumentEvents.IID, 4, (OleListener)this.documentEvents);
            this.addEventListener(DocumentEvents.IID, 5, (OleListener)this.documentEvents);
            this.addEventListener(DocumentEvents.IID, 6, (OleListener)this.documentEvents);
        }
        return this.documentEvents.addListener(listener);
    }

    public boolean removeDocumentEventsListener(DocumentEvents listener) {
        boolean bRtn = this.documentEvents.removeListener(listener);
        if (this.documentEvents.isEmpty()) {
            this.removeEventListener(DocumentEvents.IID, 4, (OleListener)this.documentEvents);
            this.removeEventListener(DocumentEvents.IID, 5, (OleListener)this.documentEvents);
            this.removeEventListener(DocumentEvents.IID, 6, (OleListener)this.documentEvents);
            this.documentEvents = null;
        }
        return bRtn;
    }

    public boolean addDocumentEvents2Listener(DocumentEvents2 listener) {
        if (this.documentEvents2 == null) {
            this.documentEvents2 = new DocumentEvents2Listener(this.getResourceManager());
            this.addEventListener(DocumentEvents2.IID, 4, (OleListener)this.documentEvents2);
            this.addEventListener(DocumentEvents2.IID, 5, (OleListener)this.documentEvents2);
            this.addEventListener(DocumentEvents2.IID, 6, (OleListener)this.documentEvents2);
            this.addEventListener(DocumentEvents2.IID, 7, (OleListener)this.documentEvents2);
            this.addEventListener(DocumentEvents2.IID, 8, (OleListener)this.documentEvents2);
            this.addEventListener(DocumentEvents2.IID, 9, (OleListener)this.documentEvents2);
        }
        return this.documentEvents2.addListener(listener);
    }

    public boolean removeDocumentEvents2Listener(DocumentEvents2 listener) {
        boolean bRtn = this.documentEvents2.removeListener(listener);
        if (this.documentEvents2.isEmpty()) {
            this.removeEventListener(DocumentEvents2.IID, 4, (OleListener)this.documentEvents2);
            this.removeEventListener(DocumentEvents2.IID, 5, (OleListener)this.documentEvents2);
            this.removeEventListener(DocumentEvents2.IID, 6, (OleListener)this.documentEvents2);
            this.removeEventListener(DocumentEvents2.IID, 7, (OleListener)this.documentEvents2);
            this.removeEventListener(DocumentEvents2.IID, 8, (OleListener)this.documentEvents2);
            this.removeEventListener(DocumentEvents2.IID, 9, (OleListener)this.documentEvents2);
            this.documentEvents2 = null;
        }
        return bRtn;
    }
}

