/*
 * Decompiled with CFR 0.152.
 */
package au.com.swz.swttocom.swt.types;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.HRESULT;
import au.com.swz.swttocom.swt.types.IFontDisp;
import au.com.swz.swttocom.swt.types.IPictureDisp;
import au.com.swz.swttocom.swt.types.OleColor;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.Variant;

public final class TypeUtils {
    public static OleColor convertToOleColor(Variant v) {
        return new OleColor(v);
    }

    public static FontData convertToFontData(Variant v, ResourceManager resourceManager) {
        IFontDisp font = new IFontDisp(v.getAutomation(), resourceManager);
        int style = 0;
        if (font.getBold()) {
            style = font.getItalic() ? 3 : 1;
        } else if (font.getItalic()) {
            style = 2;
        }
        FontData fontData = new FontData(font.getName(), font.getSize(), style);
        font.dispose();
        return fontData;
    }

    public static IPictureDisp convertToIPictureDisp(Variant v, ResourceManager resourceManager) {
        return new IPictureDisp(v.getAutomation(), resourceManager);
    }

    public static Date convertToDate(Variant v) {
        return TypeUtils.convertToDate(v.getDouble());
    }

    public static Date convertToDate(double date) {
        GregorianCalendar cal = new GregorianCalendar();
        int offset = -(cal.get(15) + cal.get(16)) / 60000;
        long l = (long)((date - 25569.0) * 8.64E7) + (long)offset * 60000L;
        return new Date(l);
    }

    public static BigDecimal convertToBigDecimal(Variant v) {
        return new BigDecimal(v.getString());
    }

    public static HRESULT convertToHRESULT(Variant v) {
        return new HRESULT(v.getInt());
    }

    public static Variant convertFromOleColor(OleColor oleColor) {
        return new Variant(oleColor.getOleColor());
    }

    public static Variant convertFromFontData(FontData fontData, ResourceManager resourceManager) {
        IFontDisp font = new IFontDisp(resourceManager);
        font.setName(fontData.getName());
        if ((fontData.getStyle() & 1) != 0) {
            font.setBold(true);
        }
        if ((fontData.getStyle() & 2) != 0) {
            font.setItalic(true);
        }
        font.setSize(fontData.getHeight());
        return new Variant(font.getOleAutomation());
    }

    public static Variant convertFromIPictureDisp(IPictureDisp picture) {
        return new Variant(picture.getOleAutomation());
    }

    public static Variant convertFromDate(Date date) {
        return new Variant(TypeUtils.convertFromDateToDouble(date));
    }

    public static double convertFromDateToDouble(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        long millis = date.getTime() + (long)cal.get(15) + (long)cal.get(16);
        return (double)millis / 8.64E7 + 25569.0;
    }

    public static Variant convertFromHRESULT(HRESULT hresult) {
        return new Variant(hresult.getInt());
    }

    public static Variant convertFromBigDecimal(BigDecimal db) {
        return new Variant(db.toString());
    }

    public static GUID IIDFromString(String lpsz) {
        int length = lpsz.length();
        char[] buffer = new char[length + 1];
        lpsz.getChars(0, length, buffer, 0);
        GUID lpiid = new GUID();
        int hr = COM.IIDFromString((char[])buffer, (GUID)lpiid);
        if (hr != 0) {
            OLE.error((int)1004, (int)hr);
        }
        return lpiid;
    }
}

