/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.Attribute;
import org.w3c.tidy.AttributeTable;
import org.w3c.tidy.CheckAttribs;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Report;

public class CheckAttribsImpl {
    private static CheckAttribs _checkHTML = new CheckHTML();
    private static CheckAttribs _checkSCRIPT = new CheckSCRIPT();
    private static CheckAttribs _checkTABLE = new CheckTABLE();
    private static CheckAttribs _checkCaption = new CheckCaption();
    private static CheckAttribs _checkIMG = new CheckIMG();
    private static CheckAttribs _checkAREA = new CheckAREA();
    private static CheckAttribs _checkAnchor = new CheckAnchor();
    private static CheckAttribs _checkMap = new CheckMap();
    private static CheckAttribs _checkStyle = new CheckSTYLE();
    private static CheckAttribs _checkTableCell = new CheckTableCell();
    private static CheckAttribs _checkLINK = new CheckLINK();
    private static CheckAttribs _checkHR = new CheckHR();

    public static CheckAttribs getCheckHTML() {
        return _checkHTML;
    }

    public static CheckAttribs getCheckSCRIPT() {
        return _checkSCRIPT;
    }

    public static CheckAttribs getCheckTABLE() {
        return _checkTABLE;
    }

    public static CheckAttribs getCheckCaption() {
        return _checkCaption;
    }

    public static CheckAttribs getCheckIMG() {
        return _checkIMG;
    }

    public static CheckAttribs getCheckAREA() {
        return _checkAREA;
    }

    public static CheckAttribs getCheckAnchor() {
        return _checkAnchor;
    }

    public static CheckAttribs getCheckMap() {
        return _checkMap;
    }

    public static CheckAttribs getCheckSTYLE() {
        return _checkStyle;
    }

    public static CheckAttribs getCheckTableCell() {
        return _checkTableCell;
    }

    public static CheckAttribs getCheckLINK() {
        return _checkLINK;
    }

    public static CheckAttribs getCheckHR() {
        return _checkHR;
    }

    public static class CheckAREA
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            boolean hasAlt = false;
            boolean hasHref = false;
            node.checkUniqueAttributes(lexer);
            AttVal attval = node.attributes;
            while (attval != null) {
                Attribute attribute = attval.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrAlt) {
                    hasAlt = true;
                } else if (attribute == AttributeTable.attrHref) {
                    hasHref = true;
                }
                attval = attval.next;
            }
            if (!hasAlt) {
                lexer.badAccess = (short)(lexer.badAccess | 2);
                Report.attrError(lexer, node, "alt", (short)2);
            }
            if (!hasHref) {
                Report.attrError(lexer, node, "href", (short)2);
            }
        }
    }

    public static class CheckAnchor
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            node.checkUniqueAttributes(lexer);
            lexer.fixId(node);
        }
    }

    public static class CheckCaption
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            String value = null;
            node.checkUniqueAttributes(lexer);
            AttVal attval = node.attributes;
            while (attval != null) {
                if (Lexer.wstrcasecmp(attval.attribute, "align") == 0) {
                    value = attval.value;
                    break;
                }
                attval = attval.next;
            }
            if (value != null) {
                if (Lexer.wstrcasecmp(value, "left") == 0 || Lexer.wstrcasecmp(value, "right") == 0) {
                    lexer.versions = (short)(lexer.versions & 0x18);
                } else if (Lexer.wstrcasecmp(value, "top") == 0 || Lexer.wstrcasecmp(value, "bottom") == 0) {
                    lexer.versions = (short)(lexer.versions & 0x1E);
                } else {
                    Report.attrError(lexer, node, value, (short)4);
                }
            }
        }
    }

    public static class CheckHR
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            if (node.getAttrByName("src") != null) {
                Report.attrError(lexer, node, "src", (short)6);
            }
        }
    }

    public static class CheckHTML
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            node.checkUniqueAttributes(lexer);
            AttVal attval = node.attributes;
            while (attval != null) {
                Attribute attribute = attval.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrXmlns) {
                    lexer.isvoyager = true;
                }
                attval = attval.next;
            }
        }
    }

    public static class CheckIMG
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            boolean hasAlt = false;
            boolean hasSrc = false;
            boolean hasUseMap = false;
            boolean hasIsMap = false;
            boolean hasDataFld = false;
            node.checkUniqueAttributes(lexer);
            AttVal attval = node.attributes;
            while (attval != null) {
                Attribute attribute = attval.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrAlt) {
                    hasAlt = true;
                } else if (attribute == AttributeTable.attrSrc) {
                    hasSrc = true;
                } else if (attribute == AttributeTable.attrUsemap) {
                    hasUseMap = true;
                } else if (attribute == AttributeTable.attrIsmap) {
                    hasIsMap = true;
                } else if (attribute == AttributeTable.attrDatafld) {
                    hasDataFld = true;
                } else if (attribute == AttributeTable.attrWidth || attribute == AttributeTable.attrHeight) {
                    lexer.versions = (short)(lexer.versions & 0xFFFFFFFE);
                }
                attval = attval.next;
            }
            if (!hasAlt) {
                lexer.badAccess = (short)(lexer.badAccess | 1);
                Report.attrError(lexer, node, "alt", (short)2);
                if (lexer.configuration.altText != null) {
                    node.addAttribute("alt", lexer.configuration.altText);
                }
            }
            if (!hasSrc && !hasDataFld) {
                Report.attrError(lexer, node, "src", (short)2);
            }
            if (hasIsMap && !hasUseMap) {
                Report.attrError(lexer, node, "ismap", (short)8);
            }
        }
    }

    public static class CheckLINK
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            AttVal type;
            AttVal rel = node.getAttrByName("rel");
            node.checkUniqueAttributes(lexer);
            if (rel != null && rel.value != null && rel.value.equals("stylesheet") && (type = node.getAttrByName("type")) == null) {
                Report.attrError(lexer, node, "type", (short)2);
                node.addAttribute("type", "text/css");
            }
        }
    }

    public static class CheckMap
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            node.checkUniqueAttributes(lexer);
            lexer.fixId(node);
        }
    }

    public static class CheckSCRIPT
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            node.checkUniqueAttributes(lexer);
            AttVal lang = node.getAttrByName("language");
            AttVal type = node.getAttrByName("type");
            if (type == null) {
                Report.attrError(lexer, node, "type", (short)2);
                if (lang != null) {
                    String str = lang.value;
                    if (str.length() > 10) {
                        str = str.substring(0, 10);
                    }
                    if (Lexer.wstrcasecmp(str, "javascript") == 0 || Lexer.wstrcasecmp(str, "jscript") == 0) {
                        node.addAttribute("type", "text/javascript");
                    }
                } else {
                    node.addAttribute("type", "text/javascript");
                }
            }
        }
    }

    public static class CheckSTYLE
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            AttVal type = node.getAttrByName("type");
            node.checkUniqueAttributes(lexer);
            if (type == null) {
                Report.attrError(lexer, node, "type", (short)2);
                node.addAttribute("type", "text/css");
            }
        }
    }

    public static class CheckTABLE
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            boolean hasSummary = false;
            node.checkUniqueAttributes(lexer);
            AttVal attval = node.attributes;
            while (attval != null) {
                Attribute attribute = attval.checkAttribute(lexer, node);
                if (attribute == AttributeTable.attrSummary) {
                    hasSummary = true;
                }
                attval = attval.next;
            }
            if (!hasSummary && lexer.doctype != 1 && lexer.doctype != 2) {
                lexer.badAccess = (short)(lexer.badAccess | 4);
                Report.attrError(lexer, node, "summary", (short)2);
            }
            if (lexer.configuration.XmlOut && (attval = node.getAttrByName("border")) != null && attval.value == null) {
                attval.value = "1";
            }
        }
    }

    public static class CheckTableCell
    implements CheckAttribs {
        @Override
        public void check(Lexer lexer, Node node) {
            node.checkUniqueAttributes(lexer);
            if (node.getAttrByName("width") != null || node.getAttrByName("height") != null) {
                lexer.versions = (short)(lexer.versions & 0xFFFFFFFB);
            }
        }
    }
}

