/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import org.w3c.tidy.AttVal;
import org.w3c.tidy.AttrCheck;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Node;
import org.w3c.tidy.Report;

public class AttrCheckImpl {
    private static AttrCheck _checkUrl = new CheckUrl();
    private static AttrCheck _checkScript = new CheckScript();
    private static AttrCheck _checkAlign = new CheckAlign();
    private static AttrCheck _checkValign = new CheckValign();
    private static AttrCheck _checkBool = new CheckBool();
    private static AttrCheck _checkId = new CheckId();
    private static AttrCheck _checkName = new CheckName();

    public static AttrCheck getCheckUrl() {
        return _checkUrl;
    }

    public static AttrCheck getCheckScript() {
        return _checkScript;
    }

    public static AttrCheck getCheckAlign() {
        return _checkAlign;
    }

    public static AttrCheck getCheckValign() {
        return _checkValign;
    }

    public static AttrCheck getCheckBool() {
        return _checkBool;
    }

    public static AttrCheck getCheckId() {
        return _checkId;
    }

    public static AttrCheck getCheckName() {
        return _checkName;
    }

    public static class CheckAlign
    implements AttrCheck {
        @Override
        public void check(Lexer lexer, Node node, AttVal attval) {
            if (node.tag != null && (node.tag.model & 0x10000) != 0) {
                AttrCheckImpl.getCheckValign().check(lexer, node, attval);
                return;
            }
            String value = attval.value;
            if (value == null) {
                Report.attrError(lexer, node, attval.attribute, (short)3);
            } else if (Lexer.wstrcasecmp(value, "left") != 0 && Lexer.wstrcasecmp(value, "center") != 0 && Lexer.wstrcasecmp(value, "right") != 0 && Lexer.wstrcasecmp(value, "justify") != 0) {
                Report.attrError(lexer, node, attval.value, (short)4);
            }
        }
    }

    public static class CheckBool
    implements AttrCheck {
        @Override
        public void check(Lexer lexer, Node node, AttVal attval) {
        }
    }

    public static class CheckId
    implements AttrCheck {
        @Override
        public void check(Lexer lexer, Node node, AttVal attval) {
        }
    }

    public static class CheckName
    implements AttrCheck {
        @Override
        public void check(Lexer lexer, Node node, AttVal attval) {
        }
    }

    public static class CheckScript
    implements AttrCheck {
        @Override
        public void check(Lexer lexer, Node node, AttVal attval) {
        }
    }

    public static class CheckUrl
    implements AttrCheck {
        @Override
        public void check(Lexer lexer, Node node, AttVal attval) {
            if (attval.value == null) {
                Report.attrError(lexer, node, attval.attribute, (short)3);
            } else if (lexer.configuration.FixBackslash) {
                attval.value = attval.value.replace('\\', '/');
            }
        }
    }

    public static class CheckValign
    implements AttrCheck {
        @Override
        public void check(Lexer lexer, Node node, AttVal attval) {
            String value = attval.value;
            if (value == null) {
                Report.attrError(lexer, node, attval.attribute, (short)3);
            } else if (Lexer.wstrcasecmp(value, "top") != 0 && Lexer.wstrcasecmp(value, "middle") != 0 && Lexer.wstrcasecmp(value, "bottom") != 0 && Lexer.wstrcasecmp(value, "baseline") != 0) {
                if (Lexer.wstrcasecmp(value, "left") == 0 || Lexer.wstrcasecmp(value, "right") == 0) {
                    if (node.tag == null || (node.tag.model & 0x10000) == 0) {
                        Report.attrError(lexer, node, value, (short)4);
                    }
                } else if (Lexer.wstrcasecmp(value, "texttop") == 0 || Lexer.wstrcasecmp(value, "absmiddle") == 0 || Lexer.wstrcasecmp(value, "absbottom") == 0 || Lexer.wstrcasecmp(value, "textbottom") == 0) {
                    lexer.versions = (short)(lexer.versions & 0x1C0);
                    Report.attrError(lexer, node, value, (short)6);
                } else {
                    Report.attrError(lexer, node, value, (short)4);
                }
            }
        }
    }
}

