/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.widgetAdapter;

import com.arcway.frontend.definition.lib.Messages;
import com.arcway.frontend.definition.lib.ui.widgetAdapter.AbstractSubWidgetAdapter;
import com.arcway.frontend.definition.lib.ui.widgetAdapter.IPrefixIDFormatPropertyTypeInformation;
import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.collections.ISortedSetRW_;
import com.arcway.lib.java.collections.SortedSet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.EnumerationItem;
import com.arcway.lib.ui.editor.WidgetFactoryController;
import com.arcway.lib.ui.editor.datatype.ConstantTextProvider;
import com.arcway.lib.ui.editor.datatype.ICompositeLayoutWidget;
import com.arcway.lib.ui.editor.datatype.IDataWidget;
import com.arcway.lib.ui.editor.datatype.IEditorMessage;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.INonPageWidget;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.parameters.WidgetParameters;
import com.arcway.lib.ui.editor.playground.IEditorPlayground;
import com.arcway.lib.ui.editor.playground.IPropertyTypeInformation;
import com.arcway.lib.ui.editor.playground.PlaygroundError;
import com.arcway.lib.ui.editor.playground.PropertyPlayground;
import com.arcway.lib.ui.editor.widgetAdapter.AbstractComplexWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IComplexWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IDataWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapter;
import com.arcway.lib.ui.editor.widgetAdapter.IWidgetAdapterManager;
import com.arcway.repository.interFace.prefixidformat.PrefixIDFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PrefixWidgetPrefixPropertyWidgetAdapter
extends AbstractComplexWidgetAdapter {
    private static final ILogger logger = Logger.getLogger(PrefixWidgetPrefixPropertyWidgetAdapter.class);
    private final PropertyPlayground<?, ?, ?, ?> prefixPlayground;
    private IDataWidgetAdapter numberOfDigitsAdapter;
    private IDataWidgetAdapter prefixStringAdapter;
    private IDataWidgetAdapter constructionModeAdapter;
    private IDataWidgetAdapter exampleLabelAdapter;
    private String[] numberOfDigitsStrings;
    private int lastNumberOfDigits;
    private String[] constructionModeStrings;
    private final boolean error = false;

    public PrefixWidgetPrefixPropertyWidgetAdapter(IWidgetAdapterManager widgetAdapterManager, Collection<IEditorPlayground> playgrounds) {
        super(widgetAdapterManager, playgrounds);
        this.prefixPlayground = (PropertyPlayground)playgrounds.iterator().next();
    }

    protected List<INonPageWidget> createSubWidgets(WidgetFactoryController widgetFactoryController, WidgetParameters widgetParameters) {
        return Collections.emptyList();
    }

    public void initialize(IDataWidget constructionModeWidget, IDataWidget prefixStringWidget, IDataWidget numberOfDigitsWidget, IDataWidget exampleLabelWidget) {
        this.setConstructionModeWidget(constructionModeWidget);
        this.setPrefixStringWidget(prefixStringWidget);
        this.setNumberOfDigitsWidget(numberOfDigitsWidget);
        this.setExampleLabelWidget(exampleLabelWidget);
        Object value = this.getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
        PrefixIDFormat format = (PrefixIDFormat)value;
        int mode = format.getConstructionMode();
        this.setWidgetsEnabledState(mode);
    }

    public String getLockMessage() {
        IEditorMessage playgroundError = this.prefixPlayground.getError();
        if (playgroundError != null) {
            return playgroundError.getMessageText(this.getCurrentPresentationContext());
        }
        return null;
    }

    public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
        Object value = this.prefixPlayground.getValue();
        return value;
    }

    public void widgetModified() {
        PrefixIDFormat prefixIDFormat;
        int constructionMode = 0;
        Object constructionModeObj = this.constructionModeAdapter.getWidget().getCurrentValue();
        Integer constructionModeInt = (Integer)constructionModeObj;
        constructionMode = constructionModeInt;
        this.removeWidgetAdapterError();
        if (constructionMode == 0) {
            try {
                prefixIDFormat = PrefixIDFormat.createInheritedIDPrefix();
            }
            catch (Exception e) {
                this.setWidgetAdapterError(null);
                this.prefixPlayground.setError(new PlaygroundError(IMessageLevel.NORMAL, (ITextProvider)new ConstantTextProvider(e.getLocalizedMessage())));
                logger.error("Couldn't resolve value for inherited id prefix.", (Throwable)e);
                this.getExampleLabelAdapter().getWidget().updateWidget(IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE);
                return;
            }
        }
        Object numberOfDigitsObj = this.numberOfDigitsAdapter.getWidget().getCurrentValue();
        Integer numberOfDigitsInt = (Integer)numberOfDigitsObj;
        int numberOfDigits = -1;
        if (numberOfDigitsInt != null) {
            numberOfDigits = numberOfDigitsInt;
        }
        if (numberOfDigits == -1) {
            numberOfDigits = this.lastNumberOfDigits;
        }
        if (constructionMode == 1) {
            try {
                prefixIDFormat = PrefixIDFormat.createStandardIDPrefix((int)numberOfDigits);
            }
            catch (Exception e) {
                this.prefixPlayground.setError(new PlaygroundError(IMessageLevel.NORMAL, (ITextProvider)new ConstantTextProvider(e.getLocalizedMessage())));
                this.setWidgetAdapterError(null);
                logger.error("Couldn't resolve value for standard id prefix.", (Throwable)e);
                this.getExampleLabelAdapter().getWidget().updateWidget(IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE);
                return;
            }
        }
        Object prefixStrObj = this.prefixStringAdapter.getWidget().getCurrentValue();
        String prefixStr = (String)prefixStrObj;
        try {
            prefixIDFormat = PrefixIDFormat.createIndividualPrefix((String)prefixStr, (int)numberOfDigits);
        }
        catch (Exception e) {
            this.prefixPlayground.setError(new PlaygroundError(IMessageLevel.NORMAL, (ITextProvider)new ConstantTextProvider(e.getLocalizedMessage())));
            this.setWidgetAdapterError(null);
            logger.error("Couldn't resolve value for individual id prefix.", (Throwable)e);
            this.getExampleLabelAdapter().getWidget().updateWidget(IWidgetAdapter.WidgetUpdateMode.DONT_UPDATE_VALUE);
            return;
        }
        this.prefixPlayground.setValue((Object)prefixIDFormat, (IWidgetAdapter)this);
    }

    private boolean isRoot() {
        return this.prefixPlayground.getParentsValue() == null;
    }

    public IDataWidgetAdapter getConstructionModeAdapter() {
        if (this.constructionModeAdapter == null) {
            this.constructionModeAdapter = new ConstructionModeAdapterSubWidgetAdapter((IComplexWidgetAdapter)this);
        }
        return this.constructionModeAdapter;
    }

    private void setConstructionModeWidget(IDataWidget widget) {
        ((AbstractSubWidgetAdapter)this.getConstructionModeAdapter()).setWidget(widget);
    }

    public IDataWidgetAdapter getPrefixStringAdapter() {
        if (this.prefixStringAdapter == null) {
            this.prefixStringAdapter = new PrefixStringSubWidgetAdapter((IComplexWidgetAdapter)this);
        }
        return this.prefixStringAdapter;
    }

    private void setPrefixStringWidget(IDataWidget widget) {
        ((AbstractSubWidgetAdapter)this.getPrefixStringAdapter()).setWidget(widget);
    }

    public IDataWidgetAdapter getNumberOfDigitsAdapter() {
        if (this.numberOfDigitsAdapter == null) {
            this.numberOfDigitsAdapter = new NumberOfDigitsSubWidgetAdapter((IComplexWidgetAdapter)this);
        }
        return this.numberOfDigitsAdapter;
    }

    private void setNumberOfDigitsWidget(IDataWidget widget) {
        ((AbstractSubWidgetAdapter)this.getNumberOfDigitsAdapter()).setWidget(widget);
    }

    public IDataWidgetAdapter getExampleLabelAdapter() {
        if (this.exampleLabelAdapter == null) {
            this.exampleLabelAdapter = new ExampleLabelAdapterSubWidgetAdapter((IComplexWidgetAdapter)this);
        }
        return this.exampleLabelAdapter;
    }

    private void setExampleLabelWidget(IDataWidget widget) {
        ((AbstractSubWidgetAdapter)this.getExampleLabelAdapter()).setWidget(widget);
    }

    private String[] getNumberOfDigitsStrings() {
        if (this.numberOfDigitsStrings == null) {
            this.numberOfDigitsStrings = new String[]{"0", "00", "000", "0000", "00000", "000000"};
        }
        return this.numberOfDigitsStrings;
    }

    private String[] getConstructionModeStrings() {
        if (this.constructionModeStrings == null) {
            this.constructionModeStrings = new String[]{Messages.getString("PWPPWA.Inherited", this.getContentLocale()), Messages.getString("PWPPWA.Standard", this.getContentLocale()), Messages.getString("PWPPWA.Individual", this.getContentLocale())};
        }
        return this.constructionModeStrings;
    }

    public void update(IWidgetAdapter.WidgetUpdateMode mode) {
        this.exampleLabelAdapter.update(mode);
    }

    private void setWidgetsEnabledState(int mode) {
        IDataWidget numberOfDigitsWidget = this.getNumberOfDigitsAdapter().getWidget();
        IDataWidget prefixStringWidget = this.getPrefixStringAdapter().getWidget();
        if (mode == 0) {
            numberOfDigitsWidget.setEditable(false);
            prefixStringWidget.setEditable(false);
        } else if (mode == 1) {
            numberOfDigitsWidget.setEditable(true);
            prefixStringWidget.setEditable(false);
        } else {
            numberOfDigitsWidget.setEditable(true);
            prefixStringWidget.setEditable(true);
        }
        ICompositeLayoutWidget compound = this.getWidget();
        if (compound != null) {
            compound.refreshWidget();
        } else {
            numberOfDigitsWidget.refreshWidget();
            prefixStringWidget.refreshWidget();
        }
    }

    private String getDefaultIDPrefix() {
        IPrefixIDFormatPropertyTypeInformation prefixIDFormatPropertyTypeInformation;
        IPropertyTypeInformation propertyTypeInformation = this.prefixPlayground.getPropertyTypeInformation();
        if (propertyTypeInformation instanceof IPrefixIDFormatPropertyTypeInformation && (prefixIDFormatPropertyTypeInformation = (IPrefixIDFormatPropertyTypeInformation)propertyTypeInformation).getDefaultPrefix() != null) {
            return prefixIDFormatPropertyTypeInformation.getDefaultPrefix();
        }
        return "ID";
    }

    private class ConstructionModeAdapterSubWidgetAdapter
    extends AbstractSubWidgetAdapter {
        public ConstructionModeAdapterSubWidgetAdapter(IComplexWidgetAdapter parentWidgetAdapter) {
            super(parentWidgetAdapter);
        }

        @Override
        public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
            Object value = this.getParentWidgetAdapter().getValue(mode);
            PrefixIDFormat format = (PrefixIDFormat)value;
            int constructionMode = format.getConstructionMode();
            if (PrefixWidgetPrefixPropertyWidgetAdapter.this.isRoot() && constructionMode == 0) {
                constructionMode = 1;
                PrefixWidgetPrefixPropertyWidgetAdapter.this.prefixPlayground.setValue((Object)new PrefixIDFormat(constructionMode, format.getPrefixString(), format.getNumberOfDigits()), (IWidgetAdapter)PrefixWidgetPrefixPropertyWidgetAdapter.this);
            }
            String[] valueRange = PrefixWidgetPrefixPropertyWidgetAdapter.this.getConstructionModeStrings();
            SortedSet_ enumerationItems = new SortedSet_((IComparator_)new IComparator_<EnumerationItem>(){

                public int getHashCode(EnumerationItem enumerationItem) {
                    return enumerationItem.hashCode();
                }

                public int sgn(EnumerationItem enumerationItem1, EnumerationItem enumerationItem2) {
                    return 1;
                }
            });
            boolean checked = false;
            if (!PrefixWidgetPrefixPropertyWidgetAdapter.this.isRoot()) {
                if (constructionMode == 0) {
                    checked = true;
                }
                enumerationItems.add((Object)new EnumerationItem((Object)0, valueRange[0], null, checked));
            }
            checked = false;
            if (constructionMode == 1) {
                checked = true;
            }
            enumerationItems.add((Object)new EnumerationItem((Object)1, valueRange[1], null, checked));
            checked = false;
            if (constructionMode == 2) {
                checked = true;
            }
            enumerationItems.add((Object)new EnumerationItem((Object)2, valueRange[2], null, checked));
            return enumerationItems;
        }

        @Override
        public void widgetModified() {
            this.getParentWidgetAdapter().widgetModified();
            Object value = this.getParentWidgetAdapter().getValue(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE);
            PrefixIDFormat format = (PrefixIDFormat)value;
            int mode = format.getConstructionMode();
            PrefixWidgetPrefixPropertyWidgetAdapter.this.setWidgetsEnabledState(mode);
        }
    }

    private class ExampleLabelAdapterSubWidgetAdapter
    extends AbstractSubWidgetAdapter {
        public ExampleLabelAdapterSubWidgetAdapter(IComplexWidgetAdapter parentWidgetAdapter) {
            super(parentWidgetAdapter);
        }

        @Override
        public void update(IWidgetAdapter.WidgetUpdateMode mode) {
            this.getWidget().updateWidget(IWidgetAdapter.WidgetUpdateMode.UPDATE_VALUE_IF_PLAYGROUND_VALUE_DIFFERS);
        }

        @Override
        public IEditorMessage getErrorMessage() {
            return null;
        }

        @Override
        public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
            String prefixStr = (String)PrefixWidgetPrefixPropertyWidgetAdapter.this.prefixStringAdapter.getValue(mode);
            ISortedSetRW_ digits = (ISortedSetRW_)PrefixWidgetPrefixPropertyWidgetAdapter.this.numberOfDigitsAdapter.getValue(mode);
            String digitStr = null;
            for (EnumerationItem item : digits) {
                if (!item.isChecked()) continue;
                digitStr = item.getLabel();
            }
            String resultStr = String.valueOf(prefixStr) + "_" + digitStr;
            return resultStr;
        }
    }

    private class NumberOfDigitsSubWidgetAdapter
    extends AbstractSubWidgetAdapter {
        public NumberOfDigitsSubWidgetAdapter(IComplexWidgetAdapter parentWidgetAdapter) {
            super(parentWidgetAdapter);
        }

        @Override
        public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
            int numberOfDigits;
            int constructionMode;
            block6: {
                block5: {
                    Object value = this.getParentWidgetAdapter().getValue(mode);
                    PrefixIDFormat format = (PrefixIDFormat)value;
                    constructionMode = format.getConstructionMode();
                    numberOfDigits = 0;
                    if (constructionMode == 0) break block5;
                    numberOfDigits = format.getNumberOfDigits();
                    if (numberOfDigits <= 6) break block6;
                    numberOfDigits = 6;
                    break block6;
                }
                List parentsValues = PrefixWidgetPrefixPropertyWidgetAdapter.this.prefixPlayground.getParentsValues();
                for (Object currentFormat : parentsValues) {
                    int parentConstructionMode = ((PrefixIDFormat)currentFormat).getConstructionMode();
                    if (parentConstructionMode == 0) continue;
                    numberOfDigits = ((PrefixIDFormat)currentFormat).getNumberOfDigits();
                    break;
                }
            }
            String[] valueRange = PrefixWidgetPrefixPropertyWidgetAdapter.this.getNumberOfDigitsStrings();
            PrefixWidgetPrefixPropertyWidgetAdapter.this.lastNumberOfDigits = numberOfDigits;
            SortedSet_ enumerationItems = new SortedSet_((IComparator_)new IComparator_<EnumerationItem>(){

                public int getHashCode(EnumerationItem enumerationItem) {
                    return 0;
                }

                public int sgn(EnumerationItem enumerationItem1, EnumerationItem enumerationItem2) {
                    return 1;
                }
            });
            int i = 0;
            while (i < valueRange.length) {
                boolean checked = false;
                if (PrefixWidgetPrefixPropertyWidgetAdapter.this.lastNumberOfDigits == i + 1) {
                    checked = true;
                }
                enumerationItems.add((Object)new EnumerationItem((Object)(i + 1), valueRange[i], null, checked));
                ++i;
            }
            if (constructionMode == 0) {
                this.getWidget().setEditable(false);
            } else {
                this.getWidget().setEditable(true);
            }
            return enumerationItems;
        }
    }

    private class PrefixStringSubWidgetAdapter
    extends AbstractSubWidgetAdapter {
        public PrefixStringSubWidgetAdapter(IComplexWidgetAdapter parentWidgetAdapter) {
            super(parentWidgetAdapter);
        }

        @Override
        public Object getValue(IWidgetAdapter.WidgetUpdateMode mode) {
            String result = "";
            Object value = this.getParentWidgetAdapter().getValue(mode);
            PrefixIDFormat format = (PrefixIDFormat)value;
            int constructionMode = format.getConstructionMode();
            if (constructionMode == 2) {
                result = format.getPrefixString();
            } else if (constructionMode == 1) {
                result = PrefixWidgetPrefixPropertyWidgetAdapter.this.getDefaultIDPrefix();
            } else {
                if (PrefixWidgetPrefixPropertyWidgetAdapter.this.isRoot()) {
                    result = PrefixWidgetPrefixPropertyWidgetAdapter.this.getDefaultIDPrefix();
                } else {
                    boolean parentFormatFound = false;
                    List parentsValues = PrefixWidgetPrefixPropertyWidgetAdapter.this.prefixPlayground.getParentsValues();
                    for (Object currentFormat : parentsValues) {
                        int currentConstructionMode = ((PrefixIDFormat)currentFormat).getConstructionMode();
                        if (currentConstructionMode == 2) {
                            result = ((PrefixIDFormat)currentFormat).getPrefixString();
                            parentFormatFound = true;
                            break;
                        }
                        if (currentConstructionMode != 1) continue;
                        result = PrefixWidgetPrefixPropertyWidgetAdapter.this.getDefaultIDPrefix();
                        parentFormatFound = true;
                        break;
                    }
                    if (!parentFormatFound) {
                        result = PrefixWidgetPrefixPropertyWidgetAdapter.this.getDefaultIDPrefix();
                    }
                }
                assert (!result.equals(""));
            }
            return result;
        }
    }
}

