/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.treeviews.dnd;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollectionRW_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.dnd.IDragContributor;
import com.arcway.lib.ui.dnd.IDragNDropContributorExtension;
import com.arcway.lib.ui.dnd.IDropContributor;
import com.arcway.lib.ui.dnd.IModelDragHandler;
import com.arcway.lib.ui.dnd.IModelDropHandler;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.object.DTCollection_ExtendedRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.ExtendedObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.manager.EXCannotSerializeRepositoryInterfaces;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.Collection;

public class TestDragNDropContributorExtension
implements IDragNDropContributorExtension {
    private static final ILogger logger = Logger.getLogger(TestDragNDropContributorExtension.class);

    public ICollection_<IDropContributor> getDropContributors() {
        return new ArrayList_((Object)new IDropContributor(){

            public IDataType[] getSupportedDataTypes(int operations) {
                if ((operations & 2) != 0) {
                    try {
                        return new IDataType[]{DTCollection_ExtendedRepositoryObjectReference.getInstance()};
                    }
                    catch (EXCannotSerializeRepositoryInterfaces e) {
                        return new IDataType[0];
                    }
                }
                return new IDataType[0];
            }

            public IModelDropHandler getModelDropHandler(Object droppedElements, Object targetFolderElement, int operation) {
                if (droppedElements instanceof ICollection_ && targetFolderElement instanceof IRepositoryAttributeSet) {
                    ICollection_ iCollectionElements = (ICollection_)droppedElements;
                    IRepositoryAttributeSet targetAttributeSet = (IRepositoryAttributeSet)targetFolderElement;
                    ArrayList_ collection = new ArrayList_();
                    boolean onlyReferences = true;
                    for (Object element : iCollectionElements) {
                        if (element instanceof ExtendedObjectReference) {
                            collection.add((Object)((ExtendedObjectReference)element));
                            continue;
                        }
                        onlyReferences = false;
                        break;
                    }
                    if (onlyReferences) {
                        return new IModelDropHandler((ICollectionRW_)collection, targetAttributeSet){
                            private final /* synthetic */ ICollectionRW_ val$collection;
                            private final /* synthetic */ IRepositoryAttributeSet val$targetAttributeSet;
                            {
                                this.val$collection = iCollectionRW_;
                                this.val$targetAttributeSet = iRepositoryAttributeSet;
                            }

                            public boolean performDrop(int position) {
                                System.out.println("Performing Drop: ");
                                System.out.print("Dropping ");
                                for (ExtendedObjectReference objectReference : this.val$collection) {
                                    IRepositoryInterfaceRO repositoryInterface = objectReference.getRepositoryInterface();
                                    IRepositoryTypeManagerRO repositoryTypeManager = repositoryInterface.getTypeManager();
                                    IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
                                    IRepositorySnapshotRO snapshot = null;
                                    try {
                                        try {
                                            snapshot = repositoryInterface.openSnapshot(repositoryInterface.sampleCurrentSnapshotInformation().getPropertySetSample());
                                            IRepositoryObject repositoryObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)objectReference, (IRepositorySnapshotRO)snapshot);
                                            IExpiringFrontendLabel label = frontendTypeManager.getLabelForObject(repositoryObject, PresentationContext.getVirtualMachineUserLocaleForNow());
                                            System.out.print("'" + label.getText() + "' ");
                                        }
                                        catch (EXNotReproducibleSnapshot e) {
                                            if (snapshot != null) {
                                                snapshot.closeSnapshot();
                                            }
                                            return false;
                                        }
                                        catch (EXObjectReferenceCannotBeResolved e) {
                                            if (snapshot != null) {
                                                snapshot.closeSnapshot();
                                            }
                                            return false;
                                        }
                                    }
                                    finally {
                                        if (snapshot != null) {
                                            snapshot.closeSnapshot();
                                        }
                                    }
                                }
                                System.out.println();
                                IRepositoryInterfaceRO repositoryInterface = this.val$targetAttributeSet.getSnapshot().getRepositoryInterface();
                                IRepositoryTypeManagerRO repositoryTypeManager = repositoryInterface.getTypeManager();
                                IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(repositoryTypeManager);
                                String target = frontendTypeManager.getFrontendAttributeSetType(this.val$targetAttributeSet.getAttributeSetType()).getLabel().getText();
                                System.out.println("into '" + target + "' at position " + position + ".");
                                return true;
                            }
                        };
                    }
                }
                return null;
            }
        });
    }

    public ICollection_<IDragContributor> getDragContributors() {
        return new ArrayList_((Object)new IDragContributor(){

            public IDataType[] getSupportedDataTypes(int operations) {
                if ((operations & 2) != 0) {
                    try {
                        return new IDataType[]{DTCollection_ExtendedRepositoryObjectReference.getInstance()};
                    }
                    catch (EXCannotSerializeRepositoryInterfaces e) {
                        return new IDataType[0];
                    }
                }
                return new IDataType[0];
            }

            public IModelDragHandler getModelDragHandler(Collection<Object> droppedElements, int operation) {
                if ((operation & 2) != 0) {
                    ArrayList_ collection = new ArrayList_();
                    boolean onlyReferences = true;
                    for (Object element : droppedElements) {
                        if (element instanceof IRepositoryObject) {
                            IRepositoryObject repositoryObject = (IRepositoryObject)element;
                            try {
                                collection.add((Object)new ExtendedObjectReference((IRepositoryObjectReference)new RepositoryObjectReference(repositoryObject), repositoryObject.getSnapshot().getRepositoryInterface()));
                            }
                            catch (EXNotReproducibleSnapshot e) {
                                logger.error((Throwable)e);
                            }
                            continue;
                        }
                        onlyReferences = false;
                        break;
                    }
                    if (onlyReferences) {
                        return new IModelDragHandler((ICollectionRW_)collection){
                            private final /* synthetic */ ICollectionRW_ val$collection;
                            {
                                this.val$collection = iCollectionRW_;
                            }

                            public Object getDragData() {
                                return this.val$collection;
                            }
                        };
                    }
                }
                return null;
            }
        });
    }
}

