/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.treeviews;

import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.treeviews.ITreeViewModelAccessAgent;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryAttributeSetNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryDataItemNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryModuleTypeNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryObjectSampleNode;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class RepositoryObjectNode
extends RepositoryDataItemNode {
    private final IRepositoryObjectReference repositoryObjectReference;
    private IRepositoryObject cachedRepositoryObject;
    private static final ILogger logger = Logger.getLogger(RepositoryObjectNode.class);

    public RepositoryObjectNode(IRepositoryObject repositoryObject, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
        super(treeViewModelAccessAgent, snapshotID);
        this.repositoryObjectReference = new RepositoryObjectReference(repositoryObject);
        this.cachedRepositoryObject = null;
    }

    public RepositoryObjectNode(IRepositoryObjectReference repositoryObjectReference, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) {
        super(treeViewModelAccessAgent, snapshotID);
        this.repositoryObjectReference = repositoryObjectReference;
        this.cachedRepositoryObject = null;
    }

    @Override
    public RepositoryDataItemNode getParentNode(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryObjectIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getParentNode() )");
            return null;
        }
        IRepositoryAttributeSet parentAttributeSet = this.cachedRepositoryObject.getParentAttributeSet();
        if (parentAttributeSet == null) {
            return new RepositoryObjectSampleNode(repositorySnapshot.getSnapshotInformation(), this.getTreeViewModelAccessAgent(), this.snapshotID);
        }
        return new RepositoryAttributeSetNode(parentAttributeSet, this.getTreeViewModelAccessAgent(), this.snapshotID);
    }

    @Override
    public boolean hasChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryObjectIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in hasChildNodes() )");
            return false;
        }
        ICollection_ attributeSetTypes = this.cachedRepositoryObject.getObjectType().getAttributeSetTypes();
        IIterator_ attributeSetTypeIterator = attributeSetTypes.iterator();
        return attributeSetTypeIterator.hasNext();
    }

    @Override
    public Object[] getChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryObjectIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getChildNodes() )");
            return new Object[0];
        }
        ArrayList<RepositoryModuleTypeNode> children = new ArrayList<RepositoryModuleTypeNode>();
        ICollection_ attributeSetTypes = this.cachedRepositoryObject.getObjectType().getAttributeSetTypes();
        for (IRepositoryAttributeSetType type : attributeSetTypes) {
            IRepositoryModuleTypeID moduleTypeID = type.getDefiningItemType().getModuleType().getRepositoryModuleTypeID();
            Iterator iterator = children.iterator();
            boolean notFound = true;
            while (iterator.hasNext()) {
                IRepositoryModuleTypeID otherModuleTypeID = ((RepositoryModuleTypeNode)iterator.next()).getModuleTypID();
                if (!IRepositoryModuleTypeID.IS_EQUAL_MODULE_TYPE_ID_HASHER.isEqual((Object)moduleTypeID, (Object)otherModuleTypeID)) continue;
                notFound = false;
                break;
            }
            if (!notFound) continue;
            children.add(new RepositoryModuleTypeNode(this.repositoryObjectReference, moduleTypeID, this.getTreeViewModelAccessAgent(), this.snapshotID));
        }
        return children.toArray();
    }

    @Override
    public String getNodeText(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryObjectIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getNodeText() )");
            return "";
        }
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendTypeManager frontendTypeManager = treeView.getFrontendTypeManager();
        IExpiringFrontendLabel label = frontendTypeManager.getLabelForObject(this.cachedRepositoryObject, treeView.getPresentationContext());
        Date expires = label.expires();
        if (expires != null) {
            treeView.updateTimeOfRefresh(expires.getTime());
        }
        return label.getText();
    }

    @Override
    public IStreamResource getNodeImage(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryObjectIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved!( in getNodeImage() )");
            return null;
        }
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendTypeManager frontendTypeManager = treeView.getFrontendTypeManager();
        IExpiringFrontendLabel label = frontendTypeManager.getLabelForObject(this.cachedRepositoryObject, treeView.getPresentationContext());
        Date expires = label.expires();
        if (expires != null) {
            treeView.updateTimeOfRefresh(expires.getTime());
        }
        return label.getIcon16x16();
    }

    @Override
    public boolean equals(Object node) {
        if (!(node instanceof RepositoryObjectNode)) {
            return false;
        }
        if (!super.equals(node)) {
            return false;
        }
        return IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER.isEqual((Object)this.repositoryObjectReference, (Object)((RepositoryObjectNode)node).repositoryObjectReference);
    }

    @Override
    public int hashCode() {
        return IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER.getHashCode((Object)this.repositoryObjectReference);
    }

    private void resolveRepositoryObjectIntoCache(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot, EXObjectReferenceCannotBeResolved {
        if (this.cachedRepositoryObject != null && this.cachedRepositoryObject.getSnapshot() == repositorySnapshot) {
            return;
        }
        this.cachedRepositoryObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)this.repositoryObjectReference, (IRepositorySnapshotRO)repositorySnapshot);
    }

    @Override
    public Object getItem(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryObjectIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getItem() )");
            return null;
        }
        return this.cachedRepositoryObject;
    }

    public IRepositoryObjectReference getObjectReference() {
        return this.repositoryObjectReference;
    }
}

