/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.treeviews;

import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.treeviews.ITreeViewModelAccessAgent;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryAttributeSetNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryDataItemNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryModuleTypeItem;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryObjectNode;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.module.IRepositoryModuleType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.ArrayList;

public class RepositoryModuleTypeNode
extends RepositoryDataItemNode {
    private final IRepositoryObjectReference parentObjectReference;
    private IRepositoryObject cachedParentObject;
    private final IRepositoryModuleTypeID modulTypeID;
    private static final ILogger logger = Logger.getLogger(RepositoryModuleTypeNode.class);

    public RepositoryModuleTypeNode(IRepositoryObjectReference repositoryObjectReference, IRepositoryModuleTypeID modulTypeID, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) {
        super(treeViewModelAccessAgent, snapshotID);
        this.parentObjectReference = repositoryObjectReference;
        this.modulTypeID = modulTypeID;
        this.cachedParentObject = null;
    }

    public RepositoryModuleTypeNode(IRepositoryObject repositoryObject, IRepositoryModuleTypeID modulTypeID, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
        super(treeViewModelAccessAgent, snapshotID);
        this.parentObjectReference = new RepositoryObjectReference(repositoryObject);
        this.modulTypeID = modulTypeID;
        this.cachedParentObject = repositoryObject;
    }

    @Override
    public RepositoryDataItemNode getParentNode(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        return new RepositoryObjectNode(this.parentObjectReference, this.getTreeViewModelAccessAgent(), this.snapshotID);
    }

    @Override
    public boolean hasChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryObjectIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in hasChildNodes() )");
            return false;
        }
        ICollection_ attributeSetTypes = this.cachedParentObject.getObjectType().getAttributeSetTypes();
        for (IRepositoryAttributeSetType type : attributeSetTypes) {
            IRepositoryModuleTypeID moduleTypeID = type.getDefiningItemType().getModuleType().getRepositoryModuleTypeID();
            if (!IRepositoryModuleTypeID.IS_EQUAL_MODULE_TYPE_ID_HASHER.isEqual((Object)moduleTypeID, (Object)this.modulTypeID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryObjectIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getChildNodes() )");
            return new Object[0];
        }
        ArrayList<RepositoryAttributeSetNode> children = new ArrayList<RepositoryAttributeSetNode>();
        ICollection_ attributeSetTypes = this.cachedParentObject.getObjectType().getAttributeSetTypes();
        for (IRepositoryAttributeSetType type : attributeSetTypes) {
            IRepositoryModuleTypeID moduleTypeID = type.getDefiningItemType().getModuleType().getRepositoryModuleTypeID();
            if (!IRepositoryModuleTypeID.IS_EQUAL_MODULE_TYPE_ID_HASHER.isEqual((Object)moduleTypeID, (Object)this.modulTypeID)) continue;
            children.add(new RepositoryAttributeSetNode(this.cachedParentObject.getAttributeSet(type), this.getTreeViewModelAccessAgent(), this.snapshotID));
        }
        return children.toArray();
    }

    @Override
    public IStreamResource getNodeImage(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IRepositoryTypeManagerRO typeManager = treeView.getRepositoryTypeManager();
        IRepositoryModuleType moduleType = typeManager.getModuleType(this.modulTypeID);
        IFrontendTypeManager frontendTypeManager = treeView.getFrontendTypeManager();
        IFrontendLabel label = frontendTypeManager.getFrontendModuleType(moduleType).getLabel();
        return label.getIcon16x16();
    }

    @Override
    public String getNodeText(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IRepositoryTypeManagerRO typeManager = treeView.getRepositoryTypeManager();
        IRepositoryModuleType moduleType = typeManager.getModuleType(this.modulTypeID);
        IFrontendTypeManager frontendTypeManager = treeView.getFrontendTypeManager();
        IFrontendLabel label = frontendTypeManager.getFrontendModuleType(moduleType).getLabel();
        return label.getText();
    }

    public IRepositoryModuleTypeID getModuleTypID() {
        return this.modulTypeID;
    }

    @Override
    public boolean equals(Object node) {
        if (!(node instanceof RepositoryModuleTypeNode)) {
            return false;
        }
        if (!super.equals(node)) {
            return false;
        }
        RepositoryModuleTypeNode repositoryModuleTypeNode = (RepositoryModuleTypeNode)node;
        if (!IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER.isEqual((Object)this.parentObjectReference, (Object)repositoryModuleTypeNode.parentObjectReference)) {
            return false;
        }
        return IRepositoryModuleTypeID.IS_EQUAL_MODULE_TYPE_ID_HASHER.isEqual((Object)this.modulTypeID, (Object)repositoryModuleTypeNode.modulTypeID);
    }

    @Override
    public int hashCode() {
        return IRepositoryModuleTypeID.IS_EQUAL_MODULE_TYPE_ID_HASHER.getHashCode((Object)this.modulTypeID);
    }

    private void resolveRepositoryObjectIntoCache(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot, EXObjectReferenceCannotBeResolved {
        if (this.cachedParentObject != null && this.cachedParentObject.getSnapshot() == repositorySnapshot) {
            return;
        }
        this.cachedParentObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)this.parentObjectReference, (IRepositorySnapshotRO)repositorySnapshot);
    }

    @Override
    public Object getItem(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryObjectIntoCache(repositorySnapshot);
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getItem() )");
            return null;
        }
        return new RepositoryModuleTypeItem(this.cachedParentObject, this.modulTypeID);
    }
}

