/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.treeviews;

import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.treeviews.ITreeViewModelAccessAgent;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryCrossLinkRelationNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryDataItemNode;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContributionReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRelationContributionReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRelationReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationContributionReference;

public class RepositoryCrossLinkRelationContributionNode
extends RepositoryDataItemNode {
    private final ICrossLinkRepositoryRelationContributionReference repositoryRelationContributionReference;
    private final IRepositoryRelationContributionRoleID parentRelationContributionRoleID;
    private ICrossLinkRepositoryRelationContribution cachedRepositoryRelationContribution = null;
    private static final ILogger logger = Logger.getLogger(RepositoryCrossLinkRelationContributionNode.class);

    public RepositoryCrossLinkRelationContributionNode(ICrossLinkRepositoryRelationContribution repositoryRelationContribution, IRepositoryRelationContributionRoleID parentRelationContributionRoleID, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
        super(treeViewModelAccessAgent, snapshotID);
        this.repositoryRelationContributionReference = new CrossLinkRepositoryRelationContributionReference(repositoryRelationContribution);
        this.parentRelationContributionRoleID = parentRelationContributionRoleID;
    }

    public RepositoryCrossLinkRelationContributionNode(ICrossLinkRepositoryRelationContributionReference repositoryRelationContributionReference, IRepositoryRelationContributionRoleID parentRelationContributionRoleID, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) {
        super(treeViewModelAccessAgent, snapshotID);
        this.repositoryRelationContributionReference = repositoryRelationContributionReference;
        this.parentRelationContributionRoleID = parentRelationContributionRoleID;
    }

    @Override
    public RepositoryDataItemNode getParentNode(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryRelationContributionIntoCache(repositorySnapshot);
        }
        catch (EXMissingCrossLinkTarget e) {
            logger.debug("Object(s) part of relation (contribution belongs to) could not be found! ( in getParentNode() )");
            return null;
        }
        catch (EXCrossLinkRelationContributionReferenceCannotBeResolved e) {
            logger.debug("Relation contribution reference could not be resolved! ( in getParentNode() )");
            return null;
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            logger.debug("Relation reference contribution reference is part of could not be resolved! ( in getParentNode() )");
            return null;
        }
        CrossLinkRepositoryRelationContributionReference parentRepositoryRelationContributionReference = new CrossLinkRepositoryRelationContributionReference(this.repositoryRelationContributionReference.getRelationReference(), this.parentRelationContributionRoleID);
        return new RepositoryCrossLinkRelationNode((ICrossLinkRepositoryRelationContributionReference)parentRepositoryRelationContributionReference, this.getTreeViewModelAccessAgent(), this.snapshotID);
    }

    @Override
    public boolean hasChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        return false;
    }

    @Override
    public Object[] getChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        return null;
    }

    @Override
    public String getNodeText(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryRelationContributionIntoCache(repositorySnapshot);
        }
        catch (EXMissingCrossLinkTarget e) {
            logger.debug("Object(s) part of relation (contribution belongs to) could not be found! ( in getNodeText() )");
            return "";
        }
        catch (EXCrossLinkRelationContributionReferenceCannotBeResolved e) {
            logger.debug("Relation contribution reference could not be resolved! ( in getNodeText() )");
            return "";
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            logger.debug("Relation reference contribution reference is part of could not be resolved! ( in getNodeText() )");
            return "";
        }
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendTypeManager frontendTypeManager = treeView.getFrontendTypeManager();
        IExpiringFrontendLabel label = frontendTypeManager.getLabelForObject(this.cachedRepositoryRelationContribution.getAttributeSet().getObject(), treeView.getPresentationContext());
        return label.getText();
    }

    @Override
    public IStreamResource getNodeImage(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryRelationContributionIntoCache(repositorySnapshot);
        }
        catch (EXMissingCrossLinkTarget e) {
            logger.debug("Object(s) part of relation (contribution belongs to) could not be found! ( in getNodeImage() )");
            return null;
        }
        catch (EXCrossLinkRelationContributionReferenceCannotBeResolved e) {
            logger.debug("Relation contribution reference could not be resolved! ( in getNodeImage() )");
            return null;
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            logger.debug("Relation reference contribution reference is part of could not be resolved! ( in getNodeImage() )");
            return null;
        }
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendTypeManager frontendTypeManager = treeView.getFrontendTypeManager();
        IExpiringFrontendLabel label = frontendTypeManager.getLabelForObject(this.cachedRepositoryRelationContribution.getAttributeSet().getObject(), treeView.getPresentationContext());
        return label.getIcon16x16();
    }

    @Override
    public boolean equals(Object node) {
        if (!(node instanceof RepositoryCrossLinkRelationContributionNode)) {
            return false;
        }
        if (!super.equals(node)) {
            return false;
        }
        return ICrossLinkRepositoryRelationContributionReference.REPRESENTS_EQUAL_RELATIONCONTRIBUTIONS_HASHER.isEqual((Object)this.repositoryRelationContributionReference, (Object)((RepositoryCrossLinkRelationContributionNode)node).repositoryRelationContributionReference);
    }

    @Override
    public int hashCode() {
        return ICrossLinkRepositoryRelationContributionReference.REPRESENTS_EQUAL_RELATIONCONTRIBUTIONS_HASHER.getHashCode((Object)this.repositoryRelationContributionReference);
    }

    private void resolveRepositoryRelationContributionIntoCache(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot, EXMissingCrossLinkTarget, EXCrossLinkRelationContributionReferenceCannotBeResolved, EXCrossLinkRelationReferenceCannotBeResolved {
        if (this.cachedRepositoryRelationContribution != null && this.cachedRepositoryRelationContribution.getSnapshot() == repositorySnapshot) {
            return;
        }
        this.cachedRepositoryRelationContribution = RepositoryReferences.getRelationContributionFromReference((ICrossLinkRepositoryRelationContributionReference)this.repositoryRelationContributionReference, (IRepositorySnapshotRO)repositorySnapshot);
    }

    @Override
    public Object getItem(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryRelationContributionIntoCache(repositorySnapshot);
        }
        catch (EXMissingCrossLinkTarget e) {
            logger.debug("Object(s) part of relation (contribution belongs to) could not be found! ( in getItem() )");
            return null;
        }
        catch (EXCrossLinkRelationContributionReferenceCannotBeResolved e) {
            logger.debug("Relation contribution reference could not be resolved! ( in getItem() )");
            return null;
        }
        catch (EXCrossLinkRelationReferenceCannotBeResolved e) {
            logger.debug("Relation reference contribution reference is part of could not be resolved! ( in getItem() )");
            return null;
        }
        return this.cachedRepositoryRelationContribution.getAttributeSet().getObject();
    }
}

