/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.treeviews;

import com.arcway.frontend.definition.lib.interFace.label.IFrontendLabel;
import com.arcway.frontend.definition.lib.ui.treeviews.ITreeViewModelAccessAgent;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryCrossLinkRelationNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryDataItemNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryModuleTypeNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryObjectNode;
import com.arcway.frontend.definition.lib.ui.treeviews.RepositoryPropertyNode;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSet;
import com.arcway.repository.interFace.data.attributeset.IRepositoryAttributeSetReference;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.relationcontribution.ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.data.relationcontribution.IRepositoryIterator_ICrossLinkRepositoryRelationContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.module.IRepositoryModuleTypeID;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXAttributeSetReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.implementation.access.RepositoryAttributeSetReference;
import java.util.ArrayList;

public class RepositoryAttributeSetNode
extends RepositoryDataItemNode {
    private final IRepositoryAttributeSetReference repositoryAttributesetReference;
    private IRepositoryAttributeSet cachedRepositoryAttributeSet;
    private static final ILogger logger = Logger.getLogger(RepositoryAttributeSetNode.class);

    public RepositoryAttributeSetNode(IRepositoryAttributeSet repositoryAttributeSet, ITreeViewModelAccessAgent treeViewModelAccessAgent, IRepositoryPropertySetSample snapshotID) throws EXNotReproducibleSnapshot {
        super(treeViewModelAccessAgent, snapshotID);
        this.repositoryAttributesetReference = new RepositoryAttributeSetReference(repositoryAttributeSet);
        this.cachedRepositoryAttributeSet = null;
    }

    @Override
    public RepositoryDataItemNode getParentNode(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryAttributeSetIntoCache(repositorySnapshot);
        }
        catch (EXAttributeSetReferenceCannotBeResolved e) {
            logger.debug("Attribute set reference could not be resolved! ( in getParentNode() )");
            return null;
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getParentNode() )");
            return null;
        }
        IRepositoryModuleTypeID moduleTypeID = this.cachedRepositoryAttributeSet.getAttributeSetType().getDefiningItemType().getModuleType().getRepositoryModuleTypeID();
        return new RepositoryModuleTypeNode(this.cachedRepositoryAttributeSet.getObject(), moduleTypeID, this.getTreeViewModelAccessAgent(), this.snapshotID);
    }

    @Override
    public boolean hasChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryAttributeSetIntoCache(repositorySnapshot);
        }
        catch (EXAttributeSetReferenceCannotBeResolved e) {
            logger.debug("Attribute set reference could not be resolved! ( in hasChildNodes() )");
            return false;
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in hasChildNodes() )");
            return false;
        }
        IRepositoryAttributeSetType attributeSetType = this.cachedRepositoryAttributeSet.getAttributeSetType();
        ICollection_ propertyTypes = attributeSetType.getPropertyTypes();
        IIterator_ propertyTypeIterator = propertyTypes.iterator();
        if (propertyTypeIterator.hasNext()) {
            return true;
        }
        ICollection_ childObjectTypes = attributeSetType.getChildObjectTypes();
        for (IRepositoryObjectType possibleChildObjectType : childObjectTypes) {
            IRepositoryIterator_IRepositoryObject childRCIterator = this.cachedRepositoryAttributeSet.childObjectIterator(possibleChildObjectType);
            if (!childRCIterator.hasNext()) continue;
            childRCIterator.abortIteration();
            return true;
        }
        ICollection_ rcTypes = attributeSetType.getCrossLinkRelationContributionTypesToConcreteRelationTypes();
        for (ICrossLinkRepositoryRelationContributionType possibleRCType : rcTypes) {
            IRepositoryIterator_ICrossLinkRepositoryRelationContribution rcIterator = this.cachedRepositoryAttributeSet.relationContributionIterator(possibleRCType);
            if (!rcIterator.hasNext()) continue;
            rcIterator.abortIteration();
            return true;
        }
        return false;
    }

    @Override
    public Object[] getChildNodes(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        ArrayList<RepositoryDataItemNode> children = new ArrayList<RepositoryDataItemNode>();
        try {
            this.resolveRepositoryAttributeSetIntoCache(repositorySnapshot);
        }
        catch (EXAttributeSetReferenceCannotBeResolved e) {
            logger.debug("Attribute set reference could not be resolved! ( in getChildNodes() )");
            return new Object[0];
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getChildNodes() )");
            return new Object[0];
        }
        IRepositoryAttributeSetType attributeSetType = this.cachedRepositoryAttributeSet.getAttributeSetType();
        ICollection_ propertyTypes = attributeSetType.getPropertyTypes();
        for (IRepositoryPropertyType type : propertyTypes) {
            children.add(new RepositoryPropertyNode(this.cachedRepositoryAttributeSet.getProperty(type), this.getTreeViewModelAccessAgent(), this.snapshotID));
        }
        ICollection_ childObjectTypes = attributeSetType.getChildObjectTypes();
        for (IRepositoryObjectType possibleChildObjectType : childObjectTypes) {
            IRepositoryIterator_IRepositoryObject childObjectIterator = this.cachedRepositoryAttributeSet.childObjectIterator(possibleChildObjectType);
            while (childObjectIterator.hasNext()) {
                IRepositoryObject childObject = childObjectIterator.nextIRepositoryObject();
                children.add(new RepositoryObjectNode(childObject, this.getTreeViewModelAccessAgent(), this.snapshotID));
            }
        }
        ICollection_ rcTypes = attributeSetType.getCrossLinkRelationContributionTypesToConcreteRelationTypes();
        for (ICrossLinkRepositoryRelationContributionType possibleRCType : rcTypes) {
            IRepositoryIterator_ICrossLinkRepositoryRelationContribution rcIterator = this.cachedRepositoryAttributeSet.relationContributionIterator(possibleRCType);
            while (rcIterator.hasNext()) {
                ICrossLinkRepositoryRelationContribution relationContribution = rcIterator.nextIRepositoryRelationContribution();
                children.add(new RepositoryCrossLinkRelationNode(relationContribution, this.getTreeViewModelAccessAgent(), this.snapshotID));
            }
        }
        return children.toArray();
    }

    @Override
    public String getNodeText(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryAttributeSetIntoCache(repositorySnapshot);
        }
        catch (EXAttributeSetReferenceCannotBeResolved e) {
            logger.debug("Attribute set reference could not be resolved! ( in getNodeText() )");
            return "";
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getNodeText() )");
            return "";
        }
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendLabel label = treeView.getFrontendTypeManager().getFrontendAttributeSetType(this.cachedRepositoryAttributeSet.getAttributeSetType()).getLabel();
        return label.getText();
    }

    @Override
    public IStreamResource getNodeImage(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryAttributeSetIntoCache(repositorySnapshot);
        }
        catch (EXAttributeSetReferenceCannotBeResolved e) {
            logger.debug("Attribute set reference could not be resolved! ( in getNodeImage() )");
            return null;
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getNodeImage() )");
            return null;
        }
        ITreeViewModelAccessAgent treeView = this.getTreeViewModelAccessAgent();
        if (treeView == null) {
            return null;
        }
        IFrontendLabel label = treeView.getFrontendTypeManager().getFrontendAttributeSetType(this.cachedRepositoryAttributeSet.getAttributeSetType()).getLabel();
        return label.getIcon16x16();
    }

    @Override
    public boolean equals(Object node) {
        if (!(node instanceof RepositoryAttributeSetNode)) {
            return false;
        }
        if (!super.equals(node)) {
            return false;
        }
        return IRepositoryAttributeSetReference.REFERENCES_EQUAL_ATTRIBUTE_SETS_HASHER.isEqual((Object)this.repositoryAttributesetReference, (Object)((RepositoryAttributeSetNode)node).repositoryAttributesetReference);
    }

    @Override
    public int hashCode() {
        return IRepositoryAttributeSetReference.REFERENCES_EQUAL_ATTRIBUTE_SETS_HASHER.getHashCode((Object)this.repositoryAttributesetReference);
    }

    private void resolveRepositoryAttributeSetIntoCache(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot, EXAttributeSetReferenceCannotBeResolved, EXObjectReferenceCannotBeResolved {
        if (this.cachedRepositoryAttributeSet != null && this.cachedRepositoryAttributeSet.getSnapshot() == repositorySnapshot) {
            return;
        }
        this.cachedRepositoryAttributeSet = RepositoryReferences.getAttributeSetFromReference((IRepositoryAttributeSetReference)this.repositoryAttributesetReference, (IRepositorySnapshotRO)repositorySnapshot);
    }

    @Override
    public Object getItem(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
        try {
            this.resolveRepositoryAttributeSetIntoCache(repositorySnapshot);
        }
        catch (EXAttributeSetReferenceCannotBeResolved e) {
            logger.debug("Attribute set reference could not be resolved! ( in getItem() )");
            return null;
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.debug("Object reference could not be resolved! ( in getItem() )");
            return null;
        }
        return this.cachedRepositoryAttributeSet;
    }

    public IRepositoryAttributeSetReference getAttributeSetReference() {
        return this.repositoryAttributesetReference;
    }
}

