/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess;

import com.arcway.frontend.definition.lib.interFace.type.exceptions.RepositoryAccessExceptionLabelProvider;
import com.arcway.frontend.definition.lib.ui.editor.repository.EditorJob;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.ModelAccess;
import com.arcway.lib.java.Assert;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXPermissionDenied;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.editor.exception.EEXTransactionExecution;
import com.arcway.lib.ui.modelaccess.agent.IModelChangeExecutionAgent;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRO;
import com.arcway.repository.interFace.implementation.workspace.IRepositoryWorkspaceRW;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.transactions.AbstractRepositoryAction;
import com.arcway.repository.interFace.transactions.IRepositoryTransaction;
import com.arcway.repository.interFace.transactions.IRepositoryTransactionManager;
import com.arcway.repository.interFace.transactions.exceptions.EXTransactionExecution;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RSAComplexGenericModification;

public class TransactionForm
implements IModelChangeExecutionAgent {
    private final IRepositoryInterfaceRO repositoryInterface;
    private final ModelAccess repositoryAccessAgent;
    private final EditorJob job;

    public TransactionForm(IRepositoryInterfaceRO repositoryInterface, ModelAccess repositoryAccessAgent, EditorJob editorJob) {
        this.repositoryInterface = repositoryInterface;
        this.repositoryAccessAgent = repositoryAccessAgent;
        this.job = editorJob;
    }

    public void executeTransactions() throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXTransactionExecution, EEXPermissionDenied, EEXLockDenied {
        IRepositoryTransaction transaction;
        RSAComplexGenericModification action;
        if (!this.job.getCreatedObjects().isEmpty()) {
            this.job.extendObjectSamples();
            action = new RSAComplexGenericModification(this.job.getDeletedRelations(), this.job.getDeletedObjects(), this.job.getCreatedObjects(), this.job.getNewRelations(), null, null, null, null);
        } else {
            action = new RSAComplexGenericModification(this.job.getDeletedRelations(), this.job.getDeletedObjects(), this.job.getCreatedObjects(), this.job.getNewRelations(), this.job.getObjectTypeCategoriesToBeChanged_forTransactionExecution(), this.job.getModifiedProperties(), null, null);
        }
        try {
            transaction = this.openTransaction();
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        try {
            try {
                transaction.appendAction((AbstractRepositoryAction)action);
            }
            catch (EXTransactionExecution e) {
                throw new EEXTransactionExecution((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
            }
            catch (EXPermissionDenied e) {
                throw new EEXPermissionDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
            }
            catch (EXLockDenied e) {
                throw new EEXLockDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
            }
            catch (EXNotReproducibleSnapshot e) {
                throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
            }
        }
        finally {
            this.closeTransaction(transaction);
            this.job.clearObjectSamples();
        }
        this.job.clear();
    }

    private void closeTransaction(IRepositoryTransaction transaction) {
        assert (transaction != null) : "Transaction must exist";
        transaction.closeTransaction();
    }

    private IRepositoryTransactionManager getTransactionManager() {
        IRepositoryWorkspaceRO workspace = this.repositoryInterface.getWorkspace();
        Assert.checkOperationSupport((boolean)(workspace instanceof IRepositoryWorkspaceRW));
        IRepositoryWorkspaceRW workspaceRW = (IRepositoryWorkspaceRW)workspace;
        return workspaceRW.getTransactionManager();
    }

    private IRepositoryTransaction openTransaction() throws EXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        IRepositoryObjectSample snapshotInformation = snapshot.getSnapshotInformation();
        IRepositoryTypeManagerRO typeManager = snapshot.getTypeManager();
        IRepositoryTransaction transaction = this.getTransactionManager().openTransaction(RepositorySamples.getSnapshotID((IRepositoryObjectSample)snapshotInformation, (IRepositoryTypeManagerRO)typeManager));
        return transaction;
    }

    public void dispose() {
        this.job.disposeAllPropertySamples();
    }

    public void reset() {
        this.job.reset();
    }
}

