/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess;

import com.arcway.frontend.definition.lib.interFace.FrontendRepositoryProperties;
import com.arcway.frontend.definition.lib.ui.editor.general.modelaccess.RepositoryAccessAgent;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.ui.editor.playground.IPropertyTypeInformation;
import com.arcway.lib.ui.modelaccess.agent.IContentReferenceInterpreter;
import com.arcway.lib.ui.modelaccess.agent.ICurrentModelAndModificationsAccessAgent;
import com.arcway.repository.interFace.data.IRepositoryPropertyOrCategoryReference;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.DTCollection_RepositoryObjectReference;
import com.arcway.repository.interFace.data.object.DTRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.attributeset.IRepositoryAttributeSetType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.implementation.access.RepositoryPropertyReference;
import com.arcway.repository.lib.high.registration.data.lib.RDTBoolean;
import com.arcway.repository.lib.high.registration.data.lib.RDTCounter64Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTDateUTC64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTDisplayName;
import com.arcway.repository.lib.high.registration.data.lib.RDTDuration64Bitmsec;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import com.arcway.repository.lib.high.registration.data.lib.RDTFloat64BitIEEE754;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeString;
import com.arcway.repository.lib.high.registration.data.lib.RDTFreeText;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger32Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTInteger64Bit;
import com.arcway.repository.lib.high.registration.data.lib.RDTLocale;
import com.arcway.repository.lib.high.registration.data.lib.RDTMultipleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTPrefixIDFormat;
import com.arcway.repository.lib.high.registration.data.lib.RDTSingleChoice;
import com.arcway.repository.lib.high.registration.data.lib.RDTUID;
import com.arcway.repository.lib.high.registration.data.lib.RDTURL;
import com.arcway.repository.lib.high.registration.data.lib.RDTUserReference;
import java.util.HashMap;

public class RepositoryReferenceInterpreter
implements IContentReferenceInterpreter<IRepositoryPropertyOrCategoryReference, IRepositoryPropertyReference, IRepositoryObjectTypeCategoryReference, IRepositoryObjectReference> {
    private static HashMap<Class<?>, String> EDITOR_DATA_TYPES = new HashMap();
    private final IRepositoryInterfaceRO repositoryInterface;

    static {
        EDITOR_DATA_TYPES.put(RDTBoolean.class, "boolean");
        EDITOR_DATA_TYPES.put(RDTCounter64Bit.class, "counter64bit");
        EDITOR_DATA_TYPES.put(RDTDateUTC64Bitmsec.class, "dateutc64bitmsec");
        EDITOR_DATA_TYPES.put(RDTDisplayName.class, "displayname");
        EDITOR_DATA_TYPES.put(RDTDuration64Bitmsec.class, "duration64mbitsec");
        EDITOR_DATA_TYPES.put(RDTFloat64BitIEEE754.class, "float64bitieee754");
        EDITOR_DATA_TYPES.put(RDTFreeString.class, "freestring");
        EDITOR_DATA_TYPES.put(RDTFreeText.class, "freetext");
        EDITOR_DATA_TYPES.put(RDTInteger32Bit.class, "integer32bit");
        EDITOR_DATA_TYPES.put(RDTInteger64Bit.class, "integer64bit");
        EDITOR_DATA_TYPES.put(RDTLocale.class, "locale");
        EDITOR_DATA_TYPES.put(RDTMultipleChoice.class, "multiplechoice");
        EDITOR_DATA_TYPES.put(RDTSingleChoice.class, "singlechoice");
        EDITOR_DATA_TYPES.put(RDTUID.class, "uid");
        EDITOR_DATA_TYPES.put(RDTURL.class, "url");
        EDITOR_DATA_TYPES.put(RDTUserReference.class, "userreference");
        EDITOR_DATA_TYPES.put(RDTFile.class, "file");
        EDITOR_DATA_TYPES.put(RDTPrefixIDFormat.class, "prefixidformat");
    }

    public RepositoryReferenceInterpreter(IRepositoryInterfaceRO repositoryInterface) {
        this.repositoryInterface = repositoryInterface;
    }

    public String getEditorDataTypeID(Object reference) {
        String editorDataTypeID = "relation";
        if (reference instanceof RepositoryPropertyReference) {
            IRepositoryObjectTypeID objectTypeID = ((RepositoryPropertyReference)reference).getObjectReference().getObjectTypeID();
            IRepositoryObjectType objectType = this.repositoryInterface.getTypeManager().getObjectType(objectTypeID);
            IRepositoryPropertyTypeID propertyTypeID = ((RepositoryPropertyReference)reference).getPropertyTypeID();
            IRepositoryAttributeSetType repositoryAttributeSetType = objectType.getAttributeSetType(propertyTypeID);
            IRepositoryPropertyType repositoryPropertyType = repositoryAttributeSetType.getPropertyType(propertyTypeID);
            IRepositoryDataType repositoryDataType = repositoryPropertyType.getDataType();
            editorDataTypeID = EDITOR_DATA_TYPES.get(repositoryDataType.getClass());
        }
        return editorDataTypeID;
    }

    public boolean referenceIsPropertyReference(Object reference) {
        return reference instanceof IRepositoryPropertyReference;
    }

    public boolean referenceIsObjectTypeCategoryReference(Object reference) {
        return reference instanceof IRepositoryObjectTypeCategoryReference;
    }

    public boolean referenceIsRelationsReference(Object reference) {
        return reference instanceof ICrossLinkRepositoryRelationsReference;
    }

    public IPropertyTypeInformation getPropertyTypeInformation(Object propertyReference) {
        return RepositoryAccessAgent.getPropertyTypeInformation(this.repositoryInterface.getTypeManager().getObjectType(((IRepositoryPropertyReference)propertyReference).getObjectReference().getObjectTypeID()), ((IRepositoryPropertyReference)propertyReference).getPropertyTypeID());
    }

    public IHasher_<Object> getPropertyValueHasher(IRepositoryPropertyReference propertyReference) {
        return FrontendRepositoryProperties.getPropertyValueHasher(this.repositoryInterface.getTypeManager(), this.repositoryInterface.getTypeManager().getObjectType(propertyReference.getObjectReference().getObjectTypeID()), propertyReference.getPropertyTypeID());
    }

    public IHasher_<? super ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference>> getCategoryValueHasher(IRepositoryObjectTypeCategoryReference categoryReference) {
        return ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor.EQUALS_HASHER;
    }

    public Object getRelationTypeIDFromRelationsReference(Object relationsReference) {
        return ((ICrossLinkRepositoryRelationsReference)relationsReference).getRelationTypeID();
    }

    public ISet_<Object> getSubRelationTypes(Object relationTypeID) {
        HashSet_ subRelationTypes = new HashSet_(IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_HASHER);
        ICrossLinkRepositoryRelationType relationType = this.repositoryInterface.getTypeManager().findCrossLinkRelationType((IRepositoryRelationTypeID)relationTypeID);
        if (relationType != null) {
            for (ICrossLinkRepositoryRelationType subRelationType : relationType.getDirectSubRelationTypes()) {
                subRelationTypes.add((Object)subRelationType.getRepositoryRelationTypeID());
            }
        }
        return subRelationTypes;
    }

    public Object getConcreteRelationTypeID(Object abstractRelationTypeID, Object roleID, Object objectID, Object relationRef) {
        IRepositoryObjectTypeID objectTypeID2 = ((IRepositoryObjectReference)relationRef).getObjectTypeID();
        IRepositoryObjectType objectType2 = this.repositoryInterface.getTypeManager().getObjectType(objectTypeID2);
        ICrossLinkRepositoryRelationType abstractRelationType = this.repositoryInterface.getTypeManager().getCrossLinkRelationType((IRepositoryRelationTypeID)abstractRelationTypeID);
        for (ICrossLinkRepositoryRelationType concreteRelationType : abstractRelationType.getAllInstanciableRelationTypesOfThisType()) {
            ICrossLinkRepositoryRelationContributionType contributionType2 = RepositoryAccessAgent.getSecondContributionType(concreteRelationType, (IRepositoryRelationContributionRoleID)roleID);
            if (!contributionType2.getRelatedObjectType().isSuperTypeOf(objectType2)) continue;
            return concreteRelationType.getRepositoryRelationTypeID();
        }
        return null;
    }

    public Object getRoleIDFromRelationsReference(Object relationsReference) {
        IRepositoryRelationContributionRoleID roleID2 = null;
        ICrossLinkRepositoryRelationsReference reference = (ICrossLinkRepositoryRelationsReference)relationsReference;
        ISet_ roleIDs = reference.getRoleID2ObjectIDMap().keySet();
        for (IRepositoryRelationContributionRoleID roleID2 : roleIDs) {
        }
        return roleID2;
    }

    public Object getObjectIDFromRelationsReference(Object relationsReference) {
        IRepositoryRelationContributionRoleID roleID = (IRepositoryRelationContributionRoleID)this.getRoleIDFromRelationsReference(relationsReference);
        return ((ICrossLinkRepositoryRelationsReference)relationsReference).getRoleID2ObjectIDMap().getByKey((Object)roleID);
    }

    public IHasher_<IRepositoryPropertyReference> getPropertyReferenceHasher() {
        return IRepositoryPropertyReference.REFERENCES_EQUAL_PROPERTY_HASHER;
    }

    public IHasher_<IRepositoryObjectTypeCategoryReference> getObjectTypeCategoryReferenceHasher() {
        return IRepositoryObjectTypeCategoryReference.REFERENCES_EQUAL_OBJECT_TYPE_CATGEORIES_HASHER;
    }

    public IHasher_<Object> getRelationTypeIDHasher() {
        return IRepositoryRelationTypeID.IS_EQUAL_RELATION_TYPE_ID_AS_JAVA_OBJECT_HASHER;
    }

    public IHasher_<IRepositoryObjectReference> getObjectReferenceHasher() {
        return IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER;
    }

    public IHasher_<Object> getRelationReferenceHasher() {
        return IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_AS_JAVA_OBJECT_HASHER;
    }

    public IHasher_<Object> getObjectIDHasher() {
        return IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER;
    }

    public IHasher_<Object> getRoleIDHasher() {
        return IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER;
    }

    public Object getRelationTypeIDFromRelationSample(Object relationSample) {
        ICrossLinkRepositoryRelationSample repositoryRelationSample = (ICrossLinkRepositoryRelationSample)relationSample;
        return repositoryRelationSample.getRelationTypeID();
    }

    public IDataType getObjectReferenceDataType() {
        return DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)this.repositoryInterface.getTypeManager());
    }

    public IDataType getObjectReferenceCollectionDataType() {
        return DTCollection_RepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)this.repositoryInterface.getTypeManager());
    }

    public IRepositoryObjectReference getObjectReferenceFromPropertyReference(IRepositoryPropertyReference propertyReference) {
        return propertyReference.getObjectReference();
    }

    public IRepositoryObjectReference getObjectReferenceFromObjectTypeCategoryReference(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference) {
        return objectTypeCategoryReference.getObjectReference();
    }

    public Object getObjectReferenceFromRelationsReference(Object roleID, Object objectID) {
        return objectID;
    }
}

