/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess;

import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.exception.IFrontendException;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.frontend.definition.lib.ui.editor.repository.EditorJob;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.CurrentModelAndModificationsAccessAgent;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.EditorJobAccessAgent;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.LockAndPermissionProvider;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.RepositoryReferenceInterpreter;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.TransactionForm;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.datatype.IEditorModelAccess;
import com.arcway.lib.ui.editor.datatype.IMessageLevel;
import com.arcway.lib.ui.editor.datatype.ITextProvider;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.editor.exception.EEXRepositoryException;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.modelaccess.IModelAccessListener;
import com.arcway.repository.interFace.data.IRepositoryPropertyOrCategoryReference;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceListener;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.exceptions.ExceptionLevel;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.exceptions.RepositoryException;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.lib.high.genericmodifications.implementation.type.manager.GenericModificationTypeManager;
import java.util.Locale;

public class ModelAccess
implements IEditorModelAccess<IRepositoryPropertyOrCategoryReference, IRepositoryPropertyReference, IRepositoryObjectTypeCategoryReference, IRepositoryObjectReference> {
    private static final ILogger logger = Logger.getLogger(ModelAccess.class);
    private final ListenerKey listenerKey = new ListenerKey();
    private final IRepositoryInterfaceListener repositoryInterfaceListener = new IRepositoryInterfaceListener(){

        public void dispose() {
            ModelAccess.this.dispose();
        }

        public void repositoryNewCurrentSnapshot(IRepositoryObjectSample newCurrentSnapshotInformation) {
            ModelAccess.this.closeSnapshot();
            try {
                ModelAccess.this.openSnapshot();
            }
            catch (EEXNotReproducibleSnapshot e) {
                logger.error("EEXNotReproducibleSnapshot", (Throwable)e);
                ModelAccess.this.listener.closeModelAccessUI(false);
            }
            try {
                ModelAccess.this.lockAndPermissionProvider.refreshLocks();
            }
            catch (EEXNotReproducibleSnapshot e) {
                logger.error("EEXNotReproducibleSnapshot", (Throwable)e);
                ModelAccess.this.listener.closeModelAccessUI(false);
            }
            catch (EEXSnapshotClosed e) {
                logger.error("EEXNotReproducibleSnapshot", (Throwable)e);
                ModelAccess.this.listener.closeModelAccessUI(false);
            }
            catch (EEXLockDenied e) {
                logger.error("unhandled catch block", (Throwable)e);
            }
            if (ModelAccess.this.listener != null) {
                ModelAccess.this.listener.newSnapshotAvailable();
            }
        }

        public void repositorySnapshotListModified() {
        }
    };
    private IRepositoryInterfaceRO repositoryInterface;
    private final TransactionForm transactionForm;
    private final CurrentModelAndModificationsAccessAgent currentModelAndModificationsAccessAgent;
    private final RepositoryReferenceInterpreter contentReferenceInterpreter;
    private final LockAndPermissionProvider lockAndPermissionProvider;
    private IModelAccessListener listener;
    private IRepositorySnapshotRO snapshot;
    private ICollection_<? extends Object> initialRelationSamples;

    public ModelAccess(IRepositoryInterfaceRO repositoryInterface) throws EEXNotReproducibleSnapshot {
        this.repositoryInterface = repositoryInterface;
        repositoryInterface.getListenerManager().addListener(this.listenerKey, (IDisposeListener)this.repositoryInterfaceListener);
        FrontendTypeManager.getFrontendTypeManager(repositoryInterface.getTypeManager()).getListenerManager().addListener(this.listenerKey, (IDisposeListener)this.repositoryInterfaceListener);
        GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)repositoryInterface.getTypeManager()).getListenerManager().addListener(this.listenerKey, (IDisposeListener)this.repositoryInterfaceListener);
        EditorJob editorJob = new EditorJob(repositoryInterface);
        EditorJobAccessAgent editorJobAccessAgent = new EditorJobAccessAgent(repositoryInterface, this, editorJob);
        this.transactionForm = new TransactionForm(repositoryInterface, this, editorJob);
        this.lockAndPermissionProvider = new LockAndPermissionProvider(repositoryInterface, this);
        this.currentModelAndModificationsAccessAgent = new CurrentModelAndModificationsAccessAgent(repositoryInterface, editorJobAccessAgent, this);
        this.contentReferenceInterpreter = new RepositoryReferenceInterpreter(repositoryInterface);
        this.openSnapshot();
    }

    protected IRepositoryObjectReference getParentObjectReferenceForNewObject(IRepositoryObjectReference objectToCreate) {
        return this.currentModelAndModificationsAccessAgent.getParentObjectReferenceForNewObject(objectToCreate);
    }

    public void addObject(IRepositoryObjectReference objectReference, IRepositoryObjectReference parentObjectReference) {
        this.currentModelAndModificationsAccessAgent.addObject(objectReference, parentObjectReference);
    }

    public ITextProvider getMessageForException(EEXRepositoryException e) {
        final RepositoryException repositoryAccessException = (RepositoryException)e.getCause();
        return new ITextProvider(){

            public String getText(PresentationContext presentationContext) {
                return ModelAccess.this.getMessageForException(repositoryAccessException, presentationContext);
            }
        };
    }

    private String getMessageForException(RepositoryException repositoryAccessException, PresentationContext presentationContext) {
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager(this.repositoryInterface.getTypeManager());
        IFrontendException frontendException = frontendTypeManager.getFrontendException((Exception)repositoryAccessException);
        return frontendException.getExceptionMessage(presentationContext);
    }

    public IMessageLevel getErrorLevelForException(EEXRepositoryAccessException e) {
        RepositoryAccessException repositoryAccessException = (RepositoryAccessException)e.getCause();
        return ModelAccess.getErrorLevelForException(repositoryAccessException);
    }

    private static IMessageLevel getErrorLevelForException(RepositoryAccessException repositoryAccessException) {
        ExceptionLevel level = repositoryAccessException.getExceptionLevel();
        IMessageLevel errorLevel = null;
        switch (level) {
            case EXCEPTION: {
                errorLevel = IMessageLevel.NORMAL;
                break;
            }
            case WARNING: {
                errorLevel = IMessageLevel.WARNING;
                break;
            }
            case INFORMATION: {
                errorLevel = IMessageLevel.INFORMATION;
            }
        }
        return errorLevel;
    }

    public IRepositoryInterfaceRO getRepositoryInterface() {
        return this.repositoryInterface;
    }

    public Locale getContentLocale() {
        return FrontendTypeManager.getFrontendTypeManager(this.repositoryInterface.getTypeManager()).getRepositoryLocale();
    }

    public void dispose() {
        if (this.repositoryInterface != null) {
            GenericModificationTypeManager.getGenericModificationTypeManager((IRepositoryTypeManagerRO)this.repositoryInterface.getTypeManager()).getListenerManager().removeListener(this.listenerKey);
            FrontendTypeManager.getFrontendTypeManager(this.repositoryInterface.getTypeManager()).getListenerManager().removeListener(this.listenerKey);
            this.repositoryInterface.getListenerManager().removeListener(this.listenerKey);
            this.transactionForm.dispose();
            this.closeSnapshot();
            if (this.listener != null) {
                this.listener.closeModelAccessUI(true);
                this.listener = null;
            }
            this.lockAndPermissionProvider.releaseAllLocks();
            this.snapshot = null;
            this.repositoryInterface = null;
        }
    }

    public void setupModelAccessListener(IModelAccessListener modelAccessAgentListener) {
        this.listener = modelAccessAgentListener;
    }

    public Object getSnapshot() throws EEXSnapshotClosed {
        return this.getSnapshotTyped();
    }

    public IRepositorySnapshotRO getSnapshotTyped() throws EEXSnapshotClosed {
        if (this.snapshot == null || !this.snapshot.isOpen()) {
            throw new EEXSnapshotClosed();
        }
        return this.snapshot;
    }

    private void openSnapshot() throws EEXNotReproducibleSnapshot {
        if (this.repositoryInterface != null) {
            try {
                this.snapshot = this.repositoryInterface.openSnapshot(RepositorySamples.getSnapshotID((IRepositoryObjectSample)this.repositoryInterface.sampleCurrentSnapshotInformation(), (IRepositoryTypeManagerRO)this.repositoryInterface.getTypeManager()));
            }
            catch (EXNotReproducibleSnapshot e) {
                throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
            }
        }
    }

    private void closeSnapshot() {
        if (this.snapshot != null && this.snapshot.isOpen()) {
            this.snapshot.closeSnapshot();
        }
    }

    public void addInitialRelationSamples(ICollection_<? extends Object> samples) {
        this.initialRelationSamples = samples;
    }

    public ICollection_<? extends Object> getInitialRelationSamples() {
        return this.initialRelationSamples;
    }

    public RepositoryReferenceInterpreter getContentReferenceInterpreter() {
        return this.contentReferenceInterpreter;
    }

    public CurrentModelAndModificationsAccessAgent getCurrentModelAndModificationsAccessAgent() {
        return this.currentModelAndModificationsAccessAgent;
    }

    public LockAndPermissionProvider getLockAndPermissionProvider() {
        return this.lockAndPermissionProvider;
    }

    public TransactionForm getModelChangeExecutionAgent() {
        return this.transactionForm;
    }
}

