/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess;

import com.arcway.frontend.definition.lib.interFace.type.exceptions.RepositoryAccessExceptionLabelProvider;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.ModelAccess;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IIteratorRW_;
import com.arcway.lib.java.collections.IIterator_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXPermissionDenied;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.modelaccess.agent.ILockAndPermissionProvider;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.data.property.IRepositoryProperty;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ICrossLinkRepositoryRelationsReferenceForPermissionCheck;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.IIDSampleAndLockDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILockDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILocksAndPermissionsManagerDeprecated;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.PermissionCheckRelationContribution;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXLockDenied;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.exceptions.EXPermissionDenied;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.RepositoryTypes;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.HashMap;
import java.util.Map;

public class LockAndPermissionProvider
implements ILockAndPermissionProvider<IRepositoryPropertyReference, IRepositoryObjectTypeCategoryReference> {
    private static final ILogger logger = Logger.getLogger(LockAndPermissionProvider.class);
    private final IRepositoryInterfaceRO repositoryInterface;
    private final ModelAccess repositoryAccessAgent;
    private final IMapRW_<IRepositoryObjectReference, Object> createLocks;
    private final IMapRW_<IRepositoryPropertyReference, Object> sampleAndIDLocks;
    private final IMapRW_<IRepositoryObjectReference, Object> modifyLocks;
    private final IMapRW_<ICrossLinkRepositoryRelationsReference, Object> relationLocks;

    public LockAndPermissionProvider(IRepositoryInterfaceRO repositoryInterface, ModelAccess repositoryAccessAgent) {
        this.repositoryInterface = repositoryInterface;
        this.repositoryAccessAgent = repositoryAccessAgent;
        this.createLocks = new HashMap_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        this.sampleAndIDLocks = new HashMap_(IRepositoryPropertyReference.REFERENCES_EQUAL_PROPERTY_HASHER);
        this.modifyLocks = new HashMap_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        this.relationLocks = new HashMap_(ICrossLinkRepositoryRelationsReference.REFERECING_EQUAL_SET_OF_RELATIONS_HASHER);
    }

    public void checkPermissionForModifyProperty(IRepositoryPropertyReference propertyReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXPermissionDenied {
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            IRepositoryProperty property = RepositoryReferences.getPropertyFromReference((IRepositoryPropertyReference)propertyReference, (IRepositorySnapshotRO)snapshot);
            ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
            locksAndPermissionsMgr.checkPermissionForModifyCockpitDataProperty(property);
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXObjectReferenceCannotBeResolved e) {
        }
        catch (EXPermissionDenied e) {
            throw new EEXPermissionDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
    }

    public void checkPermissionForModifyObjectTypeCategory(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXPermissionDenied {
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            IRepositoryObject object = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)objectTypeCategoryReference.getObjectReference(), (IRepositorySnapshotRO)snapshot);
            ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
            locksAndPermissionsMgr.checkPermissionForModifyCockpitDataObjectTypeCategory(object);
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXObjectReferenceCannotBeResolved e) {
        }
        catch (EXPermissionDenied e) {
            throw new EEXPermissionDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
    }

    public void checkPermissionForCreateOrDeleteRelation(Object relationTypeID, Object roleID, Object objectID) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXPermissionDenied {
        IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
        ICrossLinkRepositoryRelationType relationType = typeManager.getCrossLinkRelationType((IRepositoryRelationTypeID)relationTypeID);
        ICrossLinkRepositoryRelationContributionType relationContributionType = relationType.getRelationContributionType((IRepositoryRelationContributionRoleID)roleID);
        IRepositoryObjectType objectType = relationContributionType.getRelatedObjectType();
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            IRepositoryObject object = snapshot.findRepositoryObject(objectType, (IRepositoryPropertySetSample)objectID);
            if (object == null) {
                return;
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        ICollection_ concreteRelationTypes = relationType.getAllInstanciableRelationTypesOfThisType();
        int exceptionCounter = 0;
        int numberOfConcreteRelationTypes = concreteRelationTypes.size();
        for (ICrossLinkRepositoryRelationType concreteRelationType : concreteRelationTypes) {
            ICrossLinkRepositoryRelationsReference relationsReference = this.getRelationsReference(concreteRelationType.getRepositoryRelationTypeID(), (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID, null);
            ICrossLinkRepositoryRelationsReferenceForPermissionCheck relationsReferenceForPermissionCheck = this.toRelationsReferenceForPermissionCheck(relationsReference);
            ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
            try {
                locksAndPermissionsMgr.checkPermissionForCreateOrDeleteLink(relationsReferenceForPermissionCheck, snapshot);
            }
            catch (EXNotReproducibleSnapshot e) {
                throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
            }
            catch (EXPermissionDenied e) {
                if (++exceptionCounter != numberOfConcreteRelationTypes) continue;
                throw new EEXPermissionDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
            }
        }
    }

    public void checkPermissionForCreateOrDeleteRelation(Object relationTypeID, Object roleID, Object objectID1, Object objectReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXPermissionDenied {
        IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
        ICrossLinkRepositoryRelationType relationType = typeManager.getCrossLinkRelationType((IRepositoryRelationTypeID)relationTypeID);
        ICrossLinkRepositoryRelationContributionType relationContributionType = relationType.getRelationContributionType((IRepositoryRelationContributionRoleID)roleID);
        IRepositoryPropertySetSample firstObjectObjectID = (IRepositoryPropertySetSample)objectID1;
        IRepositoryPropertySetSample secondObjectObjectID = ((IRepositoryObjectReference)objectReference).getObjectID();
        IRepositoryObjectType firstObjectObjectType = relationContributionType.getRelatedObjectType();
        IRepositoryObjectType secondObjectObjectType = typeManager.getObjectType(((IRepositoryObjectReference)objectReference).getObjectTypeID());
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            IRepositoryObject object = snapshot.findRepositoryObject(firstObjectObjectType, firstObjectObjectID);
            if (object == null) {
                return;
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        IList_ possibleRelationContributionTypes = RepositoryTypes.findPossibleRelationContributionTypes((ICrossLinkRepositoryRelationContributionType)relationContributionType, (IRepositoryObjectType)secondObjectObjectType);
        Assert.checkArgument((possibleRelationContributionTypes.size() > 0 ? 1 : 0) != 0);
        if (possibleRelationContributionTypes.size() > 1) {
            logger.warn("There were more than one possible relation contribution types found");
        }
        ICrossLinkRepositoryRelationContributionType choosenRelationContributionType = (ICrossLinkRepositoryRelationContributionType)possibleRelationContributionTypes.get(0);
        ICrossLinkRepositoryRelationType concreteRelationType = choosenRelationContributionType.getRelatedRelationType();
        IRepositoryRelationTypeID concreteRelationTypeID = concreteRelationType.getRepositoryRelationTypeID();
        ICrossLinkRepositoryRelationsReference relationsReference = this.getRelationsReference(concreteRelationTypeID, (IRepositoryRelationContributionRoleID)roleID, firstObjectObjectID, secondObjectObjectID);
        ICrossLinkRepositoryRelationsReferenceForPermissionCheck relationsReferenceForPermissionCheck = this.toRelationsReferenceForPermissionCheck(relationsReference);
        ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
        try {
            locksAndPermissionsMgr.checkPermissionForCreateOrDeleteLink(relationsReferenceForPermissionCheck, snapshot);
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXPermissionDenied e) {
            throw new EEXPermissionDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
    }

    private ICrossLinkRepositoryRelationsReferenceForPermissionCheck toRelationsReferenceForPermissionCheck(ICrossLinkRepositoryRelationsReference relationsReference) {
        IMap_ roleID2ObjectIDMap = relationsReference.getRoleID2ObjectIDMap();
        final IRepositoryRelationTypeID relationTypeID = relationsReference.getRelationTypeID();
        final HashMap<IRepositoryRelationContributionRoleID, PermissionCheckRelationContribution> relationContributionsForPermissionsCheck = new HashMap<IRepositoryRelationContributionRoleID, PermissionCheckRelationContribution>(roleID2ObjectIDMap.size());
        ICrossLinkRepositoryRelationType relationType = this.repositoryInterface.getTypeManager().getCrossLinkRelationType(relationTypeID);
        for (IEntry_ roleID2ObjectID : roleID2ObjectIDMap) {
            IRepositoryRelationContributionRoleID roleID = (IRepositoryRelationContributionRoleID)roleID2ObjectID.getKey();
            IRepositoryObjectType concreteParentObjectType = null;
            IRepositoryPropertySetSample objectID = (IRepositoryPropertySetSample)roleID2ObjectID.getValue();
            IRepositoryObjectReference parentObjectReference = null;
            IRepositoryObjectType abstractObjectType = relationType.getRelationContributionType(roleID).getRelatedObjectType();
            IIterator_ j = abstractObjectType.getAllInstanciableObjectTypesOfThisType().iterator();
            while (parentObjectReference == null && j.hasNext()) {
                IRepositoryObjectType concreteObjectType = (IRepositoryObjectType)j.next();
                parentObjectReference = this.findParentObjectReferenceViaListOfObjectsToCreate(objectID, concreteObjectType);
            }
            IRepositoryPropertySetSample permissionOperandParentObjectID = null;
            while (parentObjectReference != null) {
                concreteParentObjectType = this.repositoryInterface.getTypeManager().getObjectType(parentObjectReference.getObjectTypeID());
                permissionOperandParentObjectID = parentObjectReference.getObjectID();
                parentObjectReference = this.findParentObjectReferenceViaListOfObjectsToCreate(permissionOperandParentObjectID, concreteParentObjectType);
            }
            PermissionCheckRelationContribution permissionCheckRelationContribution = concreteParentObjectType == null ? new PermissionCheckRelationContribution(objectID) : new PermissionCheckRelationContribution(concreteParentObjectType.getRepositoryObjectTypeID(), permissionOperandParentObjectID, objectID);
            relationContributionsForPermissionsCheck.put(roleID, permissionCheckRelationContribution);
        }
        ICrossLinkRepositoryRelationsReferenceForPermissionCheck relationsReferenceForPermissionCheck = new ICrossLinkRepositoryRelationsReferenceForPermissionCheck(){

            public IRepositoryRelationTypeID getRelationTypeID() {
                return relationTypeID;
            }

            public Map<IRepositoryRelationContributionRoleID, PermissionCheckRelationContribution> getRelationContributions() {
                return relationContributionsForPermissionsCheck;
            }
        };
        return relationsReferenceForPermissionCheck;
    }

    private IRepositoryObjectReference findParentObjectReferenceViaListOfObjectsToCreate(IRepositoryPropertySetSample objectID, IRepositoryObjectType concreteObjectType) {
        RepositoryObjectReference objectReference = new RepositoryObjectReference(concreteObjectType.getRepositoryObjectTypeID(), objectID);
        IRepositoryObjectReference parentObjectReference = this.repositoryAccessAgent.getParentObjectReferenceForNewObject((IRepositoryObjectReference)objectReference);
        return parentObjectReference;
    }

    private void acquireModifyLockForObject(IRepositoryObjectReference reference) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            IRepositoryObject repositoryObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)reference, (IRepositorySnapshotRO)snapshot);
            ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
            ILockDeprecated lock = locksAndPermissionsMgr.getLockForModifyCockpitData(repositoryObject);
            this.modifyLocks.put((Object)reference, (Object)lock);
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            throw new RuntimeException(e);
        }
        catch (EXLockDenied e) {
            throw new EEXLockDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
    }

    public void acquireModifyLockForProperty(IRepositoryPropertyReference propertyReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXLockDenied {
        IRepositoryObjectReference objectReference = propertyReference.getObjectReference();
        if (this.createLocks.getByKey((Object)objectReference) != null) {
            IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
            IRepositoryPropertyTypeID propertyTypeID = propertyReference.getPropertyTypeID();
            IRepositoryObjectTypeID objectTypeID = propertyReference.getObjectReference().getObjectTypeID();
            IRepositoryObjectType objectType = typeManager.getObjectType(objectTypeID);
            IRepositoryPropertyType repositoryPropertyType = RepositoryObjectTypes.getPropertyType((IRepositoryObjectType)objectType, (IRepositoryPropertyTypeID)propertyTypeID);
            if (repositoryPropertyType.getIDType().isID() && !this.sampleAndIDLocks.containsKey((Object)propertyReference)) {
                EXLockDenied e = new EXLockDenied(new String[0]);
                throw new EEXLockDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
            }
            return;
        }
        if (this.modifyLocks.getByKey((Object)objectReference) == null) {
            this.acquireModifyLockForObject(objectReference);
        }
    }

    public void acquireModifyLockForObjectTypeCategory(IRepositoryObjectTypeCategoryReference reference) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
        IRepositoryObjectReference objectReference = reference.getObjectReference();
        if (this.createLocks.getByKey((Object)objectReference) != null) {
            return;
        }
        if (this.modifyLocks.getByKey((Object)objectReference) == null) {
            this.acquireModifyLockForObject(objectReference);
        }
    }

    public IIDSampleAndLockDeprecated getSampleAndIDLockForProperty(IRepositoryPropertyReference propertyReference) {
        return (IIDSampleAndLockDeprecated)this.sampleAndIDLocks.getByKey((Object)propertyReference);
    }

    public void storeSampleAndIDLock(IRepositoryPropertyReference propertyReference, IIDSampleAndLockDeprecated sampleAndLock) {
        Assert.checkState((!this.sampleAndIDLocks.containsKey((Object)propertyReference) ? 1 : 0) != 0, (String)("PropertyReference " + propertyReference.toString() + " has already stored a idLock!"));
        this.sampleAndIDLocks.put((Object)propertyReference, (Object)sampleAndLock);
    }

    public void acquireCreateLockForObject(IRepositoryObjectReference parentObjectReference, IRepositoryObjectTypeID objectTypeID, IRepositoryPropertySetSample objectID) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            IRepositoryObject parentObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)parentObjectReference, (IRepositorySnapshotRO)snapshot);
            ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
            ILockDeprecated lock = locksAndPermissionsMgr.getLockForCreateCockpitData(parentObject, this.repositoryInterface.getTypeManager().getObjectType(objectTypeID));
            RepositoryObjectReference objectReference = new RepositoryObjectReference(objectTypeID, objectID);
            this.createLocks.put((Object)objectReference, (Object)lock);
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.error("EXObjectReferenceCannotBeResolved", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (EXLockDenied e) {
            throw new EEXLockDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
    }

    private ILockDeprecated getCreateLockForObject(IRepositoryObjectReference objectReference) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            IRepositoryObjectReference parentObjectReference = this.repositoryAccessAgent.getParentObjectReferenceForNewObject(objectReference);
            IRepositoryObject parentObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)parentObjectReference, (IRepositorySnapshotRO)snapshot);
            ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
            ILockDeprecated lock = locksAndPermissionsMgr.getLockForCreateCockpitData(parentObject, this.repositoryInterface.getTypeManager().getObjectType(objectReference.getObjectTypeID()));
            return lock;
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXObjectReferenceCannotBeResolved e) {
            logger.error("EXObjectReferenceCannotBeResolved", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (EXLockDenied e) {
            throw new EEXLockDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
    }

    public void acquireLockForCreateOrDeleteRelation(Object relationTypeID, Object roleID, Object objectID1, Object objectReference) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXLockDenied {
        ICrossLinkRepositoryRelationsReference relationsReference;
        IRepositoryPropertySetSample objectID2 = null;
        if (objectReference != null) {
            objectID2 = ((IRepositoryObjectReference)objectReference).getObjectID();
        }
        if (this.relationLocks.containsKey((Object)(relationsReference = this.getRelationsReference((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID1, objectID2)))) {
            return;
        }
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
            ILockDeprecated lock = locksAndPermissionsMgr.getLockForCreateOrDeleteLink(relationsReference, snapshot);
            this.relationLocks.put((Object)relationsReference, (Object)lock);
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXLockDenied e) {
            throw new EEXLockDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
    }

    public void acquireLockForCreateOrDeleteRelation(Object relationSample) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXLockDenied {
        ICrossLinkRepositoryRelationSample repositoryRelationSample = (ICrossLinkRepositoryRelationSample)relationSample;
        ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        CrossLinkRepositoryRelationsReference relationsReference = new CrossLinkRepositoryRelationsReference(repositoryRelationSample.getRelationTypeID(), repositoryRelationSample.getRoleID2ObjectIDMap());
        if (this.relationLocks.containsKey((Object)relationsReference)) {
            return;
        }
        try {
            ILockDeprecated lock = locksAndPermissionsMgr.getLockForCreateOrDeleteLink((ICrossLinkRepositoryRelationsReference)relationsReference, snapshot);
            this.relationLocks.put((Object)relationsReference, (Object)lock);
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        catch (EXLockDenied e) {
            throw new EEXLockDenied((Exception)((Object)e), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
        }
    }

    private ILockDeprecated getLockForCreateOrDeleteRelation(ICrossLinkRepositoryRelationsReference relationsReference) throws EEXNotReproducibleSnapshot, EXLockDenied, EEXSnapshotClosed {
        ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        try {
            ILockDeprecated lock = locksAndPermissionsMgr.getLockForCreateOrDeleteLink(relationsReference, snapshot);
            return lock;
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
    }

    public void releaseAllLocks() {
        ILockDeprecated lock;
        IIteratorRW_ it = this.modifyLocks.iterator();
        while (it.hasNext()) {
            lock = (ILockDeprecated)((IEntry_)it.next()).getValue();
            if (lock == null) continue;
            lock.release();
        }
        it = this.createLocks.iterator();
        while (it.hasNext()) {
            lock = (ILockDeprecated)((IEntry_)it.next()).getValue();
            if (lock == null) continue;
            lock.release();
        }
        it = this.relationLocks.iterator();
        while (it.hasNext()) {
            lock = (ILockDeprecated)((IEntry_)it.next()).getValue();
            if (lock == null) continue;
            lock.release();
        }
        it = this.sampleAndIDLocks.iterator();
        while (it.hasNext()) {
            IIDSampleAndLockDeprecated sampleAndLock = (IIDSampleAndLockDeprecated)((IEntry_)it.next()).getValue();
            ILockDeprecated lock2 = sampleAndLock.getTemporaryLock();
            if (lock2 == null) continue;
            lock2.release();
        }
        this.modifyLocks.clear();
        this.createLocks.clear();
        this.relationLocks.clear();
        this.sampleAndIDLocks.clear();
    }

    private void releaseModifyLockForObject(Object reference) {
        if (this.modifyLocks.getByKey((Object)((IRepositoryObjectReference)reference)) != null) {
            ILockDeprecated lock = (ILockDeprecated)this.modifyLocks.getByKey((Object)((IRepositoryObjectReference)reference));
            lock.release();
            this.modifyLocks.removeAsEntry((Object)((IRepositoryObjectReference)reference));
        }
    }

    public void releaseModifyLockForProperty(IRepositoryPropertyReference propertyReference) {
        IRepositoryObjectReference objectReference = propertyReference.getObjectReference();
        this.releaseModifyLockForObject(objectReference);
    }

    public void releaseModifyLockForObjectTypeCategory(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference) {
        IRepositoryObjectReference objectReference = objectTypeCategoryReference.getObjectReference();
        this.releaseModifyLockForObject(objectReference);
    }

    public void releaseRelationLock(Object relationTypeID, Object roleID, Object objectID1, Object objectReference) {
        IRepositoryPropertySetSample objectID2 = null;
        if (objectReference != null) {
            objectID2 = ((IRepositoryObjectReference)objectReference).getObjectID();
        }
        ICrossLinkRepositoryRelationsReference relationsReference = this.getRelationsReference((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID1, objectID2);
        ILockDeprecated lock = null;
        if (this.relationLocks.containsKey((Object)relationsReference)) {
            lock = (ILockDeprecated)this.relationLocks.getByKey((Object)relationsReference);
        }
        if (lock != null) {
            lock.release();
            this.relationLocks.removeAsEntry((Object)relationsReference);
        }
    }

    public void releaseRelationLock(Object relationSample) {
        ICrossLinkRepositoryRelationSample repositoryRelationSample = (ICrossLinkRepositoryRelationSample)relationSample;
        CrossLinkRepositoryRelationsReference relationsReference = new CrossLinkRepositoryRelationsReference(repositoryRelationSample.getRelationTypeID(), repositoryRelationSample.getRoleID2ObjectIDMap());
        ILockDeprecated lock = null;
        if (this.relationLocks.containsKey((Object)relationsReference)) {
            lock = (ILockDeprecated)this.relationLocks.getByKey((Object)relationsReference);
        }
        if (lock != null) {
            lock.release();
            this.relationLocks.removeAsEntry((Object)relationsReference);
        }
    }

    private ICrossLinkRepositoryRelationsReference getRelationsReference(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID, IRepositoryPropertySetSample objectID1, IRepositoryPropertySetSample objectID2) {
        HashMap_ roleID2ObjectID = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        roleID2ObjectID.put((Object)roleID, (Object)objectID1);
        if (objectID2 != null) {
            ICrossLinkRepositoryRelationType relationType = this.repositoryInterface.getTypeManager().getCrossLinkRelationType(relationTypeID);
            ICollection_ relationContributionTypes = relationType.getAllRelationContributionTypes();
            for (ICrossLinkRepositoryRelationContributionType relationContributionType : relationContributionTypes) {
                IRepositoryRelationContributionRoleID secondRelationContributionRoleID = relationContributionType.getRepositoryRelationContributionRoleID();
                if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)roleID, (Object)secondRelationContributionRoleID)) continue;
                roleID2ObjectID.put((Object)secondRelationContributionRoleID, (Object)objectID2);
            }
        }
        CrossLinkRepositoryRelationsReference relationsReference = new CrossLinkRepositoryRelationsReference(relationTypeID, (IMap_)roleID2ObjectID);
        return relationsReference;
    }

    private void turnCreateLockToEditLock(IRepositoryObjectReference repositoryObjectReference) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
        ILockDeprecated lock = (ILockDeprecated)this.createLocks.getByKey((Object)repositoryObjectReference);
        lock.release();
        this.acquireModifyLockForObject(repositoryObjectReference);
        this.createLocks.removeAsEntry((Object)repositoryObjectReference);
        for (IRepositoryPropertyReference propertyReference : this.sampleAndIDLocks.keySet()) {
            if (!IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER.isEqual((Object)propertyReference.getObjectReference(), (Object)repositoryObjectReference)) continue;
            IIDSampleAndLockDeprecated sampleAndIDLock = (IIDSampleAndLockDeprecated)this.sampleAndIDLocks.getByKey((Object)propertyReference);
            ILockDeprecated idLock = sampleAndIDLock.getTemporaryLock();
            idLock.release();
            this.sampleAndIDLocks.removeAsEntry((Object)propertyReference);
        }
    }

    public boolean shallEditorsSupportViewMode() {
        ILocksAndPermissionsManagerDeprecated locksAndPermissionsMgr = this.repositoryInterface.getLocksAndPermissionsManagerDeprecated();
        return locksAndPermissionsMgr.shallEditorsSupportViewMode();
    }

    public void refreshLocks() throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, EEXLockDenied {
        ISet_ modifyLocksKeySet = this.modifyLocks.keySet();
        ISet_ createLocksKeySet = this.createLocks.keySet();
        for (IRepositoryObjectReference objectReference : createLocksKeySet) {
            try {
                IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
                Assert.checkArgumentBeeingNotNull((Object)snapshot);
                IRepositoryObject object = snapshot.findRepositoryObject(this.repositoryInterface.getTypeManager().getObjectType(objectReference.getObjectTypeID()), objectReference.getObjectID());
                if (object == null) {
                    ILockDeprecated oldLock2 = (ILockDeprecated)this.createLocks.getByKey((Object)objectReference);
                    try {
                        ILockDeprecated newLock = this.getCreateLockForObject(objectReference);
                        oldLock2.release();
                        this.createLocks.put((Object)objectReference, (Object)newLock);
                    }
                    catch (EEXLockDenied e) {
                        oldLock2.release();
                        this.createLocks.removeAsEntry((Object)objectReference);
                    }
                    continue;
                }
                this.turnCreateLockToEditLock(objectReference);
            }
            catch (EXNotReproducibleSnapshot e) {
                throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
            }
        }
        for (IRepositoryObjectReference objectReference : modifyLocksKeySet) {
            ILockDeprecated oldLock = (ILockDeprecated)this.modifyLocks.getByKey((Object)objectReference);
            try {
                try {
                    this.modifyLocks.removeAsEntry((Object)objectReference);
                    this.acquireModifyLockForObject(objectReference);
                }
                catch (RuntimeException object) {
                    oldLock.release();
                    continue;
                }
            }
            catch (Throwable oldLock2) {
                oldLock.release();
                throw oldLock2;
            }
            oldLock.release();
        }
        ISet_ relationLocksKeySet = this.relationLocks.keySet();
        for (ICrossLinkRepositoryRelationsReference relationsReference : relationLocksKeySet) {
            ILockDeprecated oldLock = (ILockDeprecated)this.relationLocks.getByKey((Object)relationsReference);
            try {
                ILockDeprecated newLock = this.getLockForCreateOrDeleteRelation(relationsReference);
                oldLock.release();
                this.relationLocks.put((Object)relationsReference, (Object)newLock);
            }
            catch (EXLockDenied e) {
                oldLock.release();
                this.relationLocks.removeAsEntry((Object)relationsReference);
            }
        }
    }
}

