/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess;

import com.arcway.frontend.definition.lib.interFace.FrontendRepositoryProperties;
import com.arcway.frontend.definition.lib.interFace.type.exceptions.RepositoryAccessExceptionLabelProvider;
import com.arcway.frontend.definition.lib.ui.editor.general.modelaccess.RepositoryAccessAgent;
import com.arcway.frontend.definition.lib.ui.editor.repository.EditorJob;
import com.arcway.frontend.definition.lib.ui.editor.repository.modelaccess.ModelAccess;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.ui.editor.exception.EEXDataValidation;
import com.arcway.lib.ui.editor.exception.EEXLockDenied;
import com.arcway.lib.ui.editor.exception.EEXNotReproducibleSnapshot;
import com.arcway.lib.ui.editor.exception.EEXRelationCardinalityViolation;
import com.arcway.lib.ui.editor.exception.EEXRepositoryAccessException;
import com.arcway.lib.ui.editor.exception.EEXSnapshotClosed;
import com.arcway.lib.ui.modelaccess.agent.ICurrentModelAndModificationsAccessAgent;
import com.arcway.repository.interFace.data.RepositoryReferences;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategory;
import com.arcway.repository.interFace.data.object.IRepositoryObjectTypeCategoryReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertyReference;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution;
import com.arcway.repository.interFace.data.relation.IRepositoryIterator_ICrossLinkRepositoryRelation;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.UniquePropertyChecker;
import com.arcway.repository.interFace.declaration.type.data.IRepositoryObjectTypeCategoryID;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.RepositoryRelationContributionTypeCardinality;
import com.arcway.repository.interFace.exceptions.RepositoryAccessException;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.RepositoryTypes;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.interFace.transactions.exceptions.EXCrossLinkRCTypeCardinalityViolated;
import com.arcway.repository.interFace.transactions.exceptions.EXMissingCrossLinkTarget;
import com.arcway.repository.interFace.transactions.exceptions.EXObjectReferenceCannotBeResolved;
import com.arcway.repository.interFace.transactions.exceptions.EXUniqueObjectPropertyAlreadyInUse;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationReference;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationSample;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import com.arcway.repository.lib.high.implementation.access.EXInvalidObjectTypeCategoryID;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.registration.data.lib.exceptions.DataValidationException;
import java.util.ArrayList;

public class EditorJobAccessAgent {
    private static final ILogger logger = Logger.getLogger(EditorJobAccessAgent.class);
    private final EditorJob job;
    private final ModelAccess repositoryAccessAgent;
    private final IRepositoryInterfaceRO repositoryInterface;

    public EditorJobAccessAgent(IRepositoryInterfaceRO repositoryInterface, ModelAccess repositoryAccesAgent, EditorJob editorJob) {
        this.repositoryInterface = repositoryInterface;
        this.repositoryAccessAgent = repositoryAccesAgent;
        this.job = editorJob;
    }

    public void addObject(Object objectReference, Object parentObjectReference) {
        IRepositoryObjectReference newObject = (IRepositoryObjectReference)objectReference;
        IRepositoryObjectReference parentObject = (IRepositoryObjectReference)parentObjectReference;
        this.job.addObject(newObject, parentObject);
    }

    public IRepositoryObjectReference getParentObjectReferenceForNewObject(IRepositoryObjectReference newObject) {
        return this.job.getParentObjectReferenceForNewObject(newObject);
    }

    public void setPropertyValue(Object propertyReference, Object newValue, boolean checkOnly) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed, JvmExternalResourceInteractionException, EEXRepositoryAccessException, EEXDataValidation {
        IRepositoryPropertyReference typedReference = (IRepositoryPropertyReference)propertyReference;
        FrontendRepositoryProperties.FrontendRepositoryPropertyContext propertyContext = FrontendRepositoryProperties.getPropertyContext(typedReference, this.repositoryInterface);
        IRepositoryObjectReference objectReference = typedReference.getObjectReference();
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        EXUniqueObjectPropertyAlreadyInUse uniquePropertyException = null;
        IRepositoryPropertySample propertySample = FrontendRepositoryProperties.getPropertySampleForEditorValue(propertyContext, newValue);
        try {
            try {
                IRepositoryObject repositoryObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)objectReference, (IRepositorySnapshotRO)snapshot);
                UniquePropertyChecker.checkForExistingObjectsWithProperty((IRepositoryPropertySample)propertySample, (IRepositoryPropertyType)propertyContext.getRepositoryPropertyType(), (IRepositoryObject)repositoryObject, (IRepositorySnapshotRO)snapshot);
            }
            catch (EXObjectReferenceCannotBeResolved e) {
                try {
                    IRepositoryObjectReference parentRepositoryObjectReferenceForNewObject = this.job.getParentObjectReferenceForNewObject(objectReference);
                    if (parentRepositoryObjectReferenceForNewObject != null) {
                        IRepositoryObject parentRepositoryObject = RepositoryReferences.getObjectFromReference((IRepositoryObjectReference)parentRepositoryObjectReferenceForNewObject, (IRepositorySnapshotRO)snapshot);
                        UniquePropertyChecker.checkForExistingObjectsWithProperty((IRepositoryPropertySample)propertySample, (IRepositoryPropertyType)propertyContext.getRepositoryPropertyType(), (IRepositoryObjectReference)objectReference, (IRepositoryObject)parentRepositoryObject, (IRepositorySnapshotRO)snapshot);
                    }
                }
                catch (EXObjectReferenceCannotBeResolved exORCBR) {
                    logger.error("EXObjectReferenceCannotBeResolved", (Throwable)exORCBR);
                    throw new RuntimeException(exORCBR);
                }
            }
        }
        catch (EXUniqueObjectPropertyAlreadyInUse e) {
            uniquePropertyException = e;
        }
        catch (EXNotReproducibleSnapshot e) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        if (!checkOnly) {
            this.job.addProperty(propertyReference, propertySample);
        }
        try {
            propertyContext.getRepositoryDataType().snapAndCheckData(propertySample.getValue(), propertyContext.getRepositoryDataTypeParameters());
        }
        catch (DataValidationException e) {
            throw new EEXDataValidation((Exception)((Object)e));
        }
        if (uniquePropertyException != null) {
            throw new EEXRepositoryAccessException((Exception)((Object)uniquePropertyException), RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)uniquePropertyException));
        }
    }

    public boolean isPropertyModified(Object propertyReference) {
        return this.job.getModifiedProperties().containsKey((Object)((IRepositoryPropertyReference)propertyReference));
    }

    public Object getModifiedPropertyValue(IRepositoryPropertyReference propertyReference) {
        IRepositoryPropertySample propertySampleOfModifiedProperty = (IRepositoryPropertySample)this.job.getModifiedProperties().getByKey((Object)propertyReference);
        return FrontendRepositoryProperties.getEditorValueForPropertySample(FrontendRepositoryProperties.getPropertyContext(propertyReference, this.repositoryInterface), propertySampleOfModifiedProperty);
    }

    public void resetPropertyValue(IRepositoryPropertyReference propertyReference, Object newValue) throws EEXDataValidation, JvmExternalResourceInteractionException {
        this.job.removeProperty(propertyReference);
        FrontendRepositoryProperties.checkAndSnapEditorValue(FrontendRepositoryProperties.getPropertyContext(propertyReference, this.repositoryInterface), newValue);
    }

    public boolean isObjectTypeCategoryModified(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference) {
        return this.job.getObjectTypeCategoriesToBeChanged().containsKey((Object)objectTypeCategoryReference.getObjectReference());
    }

    public ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> getModifiedObjectTypeCategoryValue(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference) {
        IRepositoryObjectTypeCategoryID currentCategoryID = (IRepositoryObjectTypeCategoryID)this.job.getObjectTypeCategoriesToBeChanged().getByKey((Object)objectTypeCategoryReference.getObjectReference());
        if (currentCategoryID != EditorJob.MARKER_FOR_DEFAULT_CATEGORY) {
            return new ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor((Object)objectTypeCategoryReference, currentCategoryID.toCanonicalString());
        }
        return RepositoryAccessAgent.getDefaultObjectTypeCategoryAsEditorValue(objectTypeCategoryReference);
    }

    public void setObjectTypeCategoryValue(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> newValue, boolean checkOnly) throws EEXDataValidation, EEXSnapshotClosed {
        IRepositoryObjectTypeCategoryID categoryID = this.retrieveAndCheckObjectTypeCategoryValue(newValue);
        if (!checkOnly) {
            IRepositoryObjectReference objectReference = objectTypeCategoryReference.getObjectReference();
            this.job.changeCategory(objectReference, categoryID);
        }
    }

    public void resetObjectTypeCategoryValue(IRepositoryObjectTypeCategoryReference objectTypeCategoryReference, ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> newValue) throws EEXDataValidation, EEXSnapshotClosed {
        this.retrieveAndCheckObjectTypeCategoryValue(newValue);
        IRepositoryObjectReference objectReference = objectTypeCategoryReference.getObjectReference();
        this.job.removeCategory(objectReference);
    }

    private IRepositoryObjectTypeCategoryID retrieveAndCheckObjectTypeCategoryValue(final ICurrentModelAndModificationsAccessAgent.ObjectTypeCategoryKeyForEditor<IRepositoryObjectTypeCategoryReference> newValue) throws EEXSnapshotClosed, EEXDataValidation {
        IRepositoryObjectTypeCategory objectTypeCategory;
        IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
        Assert.checkArgumentBeeingNotNull((Object)snapshot);
        IRepositoryObjectTypeCategoryID categoryID = EditorJob.MARKER_FOR_DEFAULT_CATEGORY;
        if (newValue != null && !RepositoryAccessAgent.isDefaultObjectTypeCategory(newValue) && (objectTypeCategory = snapshot.getObjectTypeCategory(categoryID = new IRepositoryObjectTypeCategoryID(){

            public String toCanonicalString() {
                return newValue.getKey();
            }
        })) == null) {
            throw new EEXDataValidation((Exception)new EXInvalidObjectTypeCategoryID(categoryID));
        }
        return categoryID;
    }

    public void addNewRelation(Object relationTypeID, Object newRelationSample) {
        this.job.addNewRelation((IRepositoryRelationTypeID)relationTypeID, (ICrossLinkRepositoryRelationSample)newRelationSample);
    }

    public void addNewRelation(Object relationTypeID, Object roleID1, Object objectID, Object objectReference) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
        IRepositoryRelationTypeID repositoryRelationTypeID = (IRepositoryRelationTypeID)relationTypeID;
        IRepositoryRelationContributionRoleID firstObjectRoleID = (IRepositoryRelationContributionRoleID)roleID1;
        IRepositoryPropertySetSample firstObjectID = (IRepositoryPropertySetSample)objectID;
        IRepositoryObjectReference secondObjectReference = (IRepositoryObjectReference)objectReference;
        ICollection_<ICrossLinkRepositoryRelationReference> relationsToBeDeleted = this.job.getDeletedRelations(repositoryRelationTypeID);
        ICrossLinkRepositoryRelationSample newRelationSample = this.getRelationSampleForEditorValue(repositoryRelationTypeID, firstObjectRoleID, firstObjectID, secondObjectReference);
        for (ICrossLinkRepositoryRelationReference deletedRelation : relationsToBeDeleted) {
            CrossLinkRepositoryRelationSample relationSample = new CrossLinkRepositoryRelationSample((IRepositoryRelationTypeID)relationTypeID, deletedRelation.getRoleID2ObjectIDMap());
            if (!EditorJobAccessAgent.equalRelationSamples((ICrossLinkRepositoryRelationSample)relationSample, newRelationSample)) continue;
            this.removeDeletedRelation(repositoryRelationTypeID, newRelationSample);
            this.repositoryAccessAgent.getLockAndPermissionProvider().releaseRelationLock(newRelationSample);
            break;
        }
        boolean existsInPlayground = false;
        ICollection_<ICrossLinkRepositoryRelationSample> relationsToBeAdded = this.job.getNewRelations(repositoryRelationTypeID);
        for (ICrossLinkRepositoryRelationSample existingRelationSample : relationsToBeAdded) {
            if (!EditorJobAccessAgent.equalRelationSamples(newRelationSample, existingRelationSample)) continue;
            existsInPlayground = true;
        }
        boolean exists = this.repositoryAccessAgent.getCurrentModelAndModificationsAccessAgent().relationExists(newRelationSample);
        if (!existsInPlayground && !exists) {
            this.repositoryAccessAgent.getLockAndPermissionProvider().acquireLockForCreateOrDeleteRelation(newRelationSample);
            this.job.addNewRelation(repositoryRelationTypeID, newRelationSample);
        } else if (existsInPlayground && exists) {
            this.job.removeNewRelation(repositoryRelationTypeID, newRelationSample);
            this.repositoryAccessAgent.getLockAndPermissionProvider().releaseRelationLock(newRelationSample);
        }
    }

    public ISet_<? extends IRepositoryObjectReference> getNewRelations(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID1, IRepositoryPropertySetSample objectID1) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        ICollection_<ICrossLinkRepositoryRelationSample> allCreatedRelations = this.job.getNewRelations(relationTypeID);
        HashSet_ createdRelations = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        try {
            IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
            Assert.checkArgumentBeeingNotNull((Object)snapshot);
            for (ICrossLinkRepositoryRelationSample relationSample : allCreatedRelations) {
                ICrossLinkRepositoryRelationType relationType = this.repositoryInterface.getTypeManager().getCrossLinkRelationType(relationTypeID);
                ICollection_ relationContributionTypes = relationType.getAllRelationContributionTypes();
                for (ICrossLinkRepositoryRelationContributionType relationContributionType : relationContributionTypes) {
                    IRepositoryObjectType objectType;
                    IRepositoryObject object;
                    IRepositoryPropertySetSample repositoryObjectID;
                    IRepositoryRelationContributionRoleID secondContributionRoleID = relationContributionType.getRepositoryRelationContributionRoleID();
                    if (EditorJobAccessAgent.equalRelationControbutionRoleIDs(roleID1, secondContributionRoleID) || EditorJobAccessAgent.equalPropertySetSamples(objectID1, repositoryObjectID = relationSample.getObjectID(secondContributionRoleID)) || (object = snapshot.findRepositoryObject(objectType = relationContributionType.getRelatedObjectType(), repositoryObjectID)) == null) continue;
                    createdRelations.add((Object)new RepositoryObjectReference(object));
                }
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error("EXNotReproducibleSnapshot", (Throwable)e);
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        return createdRelations;
    }

    public void addDeletedRelation(Object relationTypeID, Object roleID, Object objectID, Object objectReference) throws EEXNotReproducibleSnapshot, EEXLockDenied, EEXSnapshotClosed {
        CrossLinkRepositoryRelationReference relationReference;
        IRepositoryRelationTypeID repositoryRelationTypeID = (IRepositoryRelationTypeID)relationTypeID;
        IRepositoryRelationContributionRoleID firstObjectRoleID = (IRepositoryRelationContributionRoleID)roleID;
        IRepositoryPropertySetSample firstObjectID = (IRepositoryPropertySetSample)objectID;
        IRepositoryObjectReference secondObjectReference = (IRepositoryObjectReference)objectReference;
        ICrossLinkRepositoryRelationSample newRelationSample = this.getRelationSampleForEditorValue(repositoryRelationTypeID, firstObjectRoleID, firstObjectID, secondObjectReference);
        ICollection_<ICrossLinkRepositoryRelationSample> relationsToBeAdded = this.job.getNewRelations(repositoryRelationTypeID);
        ICollection_<ICrossLinkRepositoryRelationReference> relationsToBeDeleted = this.job.getDeletedRelations(repositoryRelationTypeID);
        for (ICrossLinkRepositoryRelationSample relationSampleToCompare : relationsToBeAdded) {
            if (!EditorJobAccessAgent.equalRelationSamples(newRelationSample, relationSampleToCompare)) continue;
            this.removeNewRelation(repositoryRelationTypeID, relationSampleToCompare);
            this.repositoryAccessAgent.getLockAndPermissionProvider().releaseRelationLock(repositoryRelationTypeID, firstObjectRoleID, firstObjectID, secondObjectReference);
            break;
        }
        boolean existsInPlayground = false;
        for (ICrossLinkRepositoryRelationReference existingRelation : relationsToBeDeleted) {
            ICrossLinkRepositoryRelationReference newRelation;
            if (!EditorJobAccessAgent.equalRelationReferences(existingRelation, newRelation = EditorJobAccessAgent.getRelationReferenceForRelationSample(newRelationSample))) continue;
            existsInPlayground = true;
        }
        boolean exists = this.repositoryAccessAgent.getCurrentModelAndModificationsAccessAgent().relationExists(newRelationSample);
        if (existsInPlayground && !exists) {
            relationReference = new CrossLinkRepositoryRelationReference(newRelationSample.getRelationTypeID(), newRelationSample.getRoleID2ObjectIDMap());
            this.job.removeDeletedRelation(repositoryRelationTypeID, (ICrossLinkRepositoryRelationReference)relationReference);
            this.repositoryAccessAgent.getLockAndPermissionProvider().releaseRelationLock(repositoryRelationTypeID, firstObjectRoleID, firstObjectID, secondObjectReference);
        } else if (!existsInPlayground && exists) {
            this.repositoryAccessAgent.getLockAndPermissionProvider().acquireLockForCreateOrDeleteRelation(repositoryRelationTypeID, firstObjectRoleID, firstObjectID, secondObjectReference);
            relationReference = new CrossLinkRepositoryRelationReference(newRelationSample.getRelationTypeID(), newRelationSample.getRoleID2ObjectIDMap());
            this.job.addDeletedRelation(repositoryRelationTypeID, (ICrossLinkRepositoryRelationReference)relationReference);
        }
    }

    public ISet_<? extends IRepositoryObjectReference> getDeletedRelations(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID1, IRepositoryPropertySetSample objectID1) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        HashSet_ deletedRelations = new HashSet_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        ICollection_<ICrossLinkRepositoryRelationReference> allDeletedRelations = this.job.getDeletedRelations(relationTypeID);
        try {
            IRepositorySnapshotRO snapshot = (IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot();
            Assert.checkArgumentBeeingNotNull((Object)snapshot);
            if (allDeletedRelations != null) {
                for (ICrossLinkRepositoryRelationReference deletedRelation : allDeletedRelations) {
                    ICrossLinkRepositoryRelationType relationType = this.repositoryInterface.getTypeManager().getCrossLinkRelationType(relationTypeID);
                    ICollection_ relationContributionTypes = relationType.getAllRelationContributionTypes();
                    for (ICrossLinkRepositoryRelationContributionType relationContributionType : relationContributionTypes) {
                        IRepositoryObjectType objectType;
                        IRepositoryObject object;
                        IRepositoryPropertySetSample repositoryObjectID;
                        IRepositoryRelationContributionRoleID secondObjectRoleID = relationContributionType.getRepositoryRelationContributionRoleID();
                        if (EditorJobAccessAgent.equalRelationControbutionRoleIDs(relationContributionType.getRepositoryRelationContributionRoleID(), roleID1) || EditorJobAccessAgent.equalPropertySetSamples(objectID1, repositoryObjectID = deletedRelation.getObjectID(secondObjectRoleID)) || (object = snapshot.findRepositoryObject(objectType = relationContributionType.getRelatedObjectType(), repositoryObjectID)) == null) continue;
                        deletedRelations.add((Object)new RepositoryObjectReference(object));
                    }
                }
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error("EXNotReproducibleSnapshot", (Throwable)e);
            throw new EEXNotReproducibleSnapshot((Exception)((Object)e));
        }
        return deletedRelations;
    }

    public boolean relationModified(Object relationTypeID, Object roleID, Object objectID) {
        IRepositoryPropertySetSample relationContributionObjectID;
        IEntry_ roleIDentry;
        IRepositoryRelationTypeID repositoryRelationTypeID = (IRepositoryRelationTypeID)relationTypeID;
        IRepositoryRelationContributionRoleID firstObjectRoleID = (IRepositoryRelationContributionRoleID)roleID;
        IRepositoryPropertySetSample firstObjectID = (IRepositoryPropertySetSample)objectID;
        ICollection_<ICrossLinkRepositoryRelationSample> createdRelations = this.job.getNewRelations(repositoryRelationTypeID);
        ICollection_<ICrossLinkRepositoryRelationReference> deletedRelations = this.job.getDeletedRelations(repositoryRelationTypeID);
        for (ICrossLinkRepositoryRelationSample relation : createdRelations) {
            roleIDentry = relation.getRoleID2ObjectIDMap().getEntryByKey((Object)firstObjectRoleID);
            relationContributionObjectID = (IRepositoryPropertySetSample)roleIDentry.getValue();
            if (!EditorJobAccessAgent.equalPropertySetSamples(relationContributionObjectID, firstObjectID)) continue;
            return true;
        }
        for (ICrossLinkRepositoryRelationSample relation : deletedRelations) {
            roleIDentry = relation.getRoleID2ObjectIDMap().getEntryByKey((Object)firstObjectRoleID);
            relationContributionObjectID = (IRepositoryPropertySetSample)roleIDentry.getValue();
            if (!EditorJobAccessAgent.equalPropertySetSamples(relationContributionObjectID, firstObjectID)) continue;
            return true;
        }
        return false;
    }

    public void checkRelationCardinality(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID roleID, IRepositoryPropertySetSample objectID) throws EEXRelationCardinalityViolation, EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        ICrossLinkRepositoryRelationType relationType = this.repositoryInterface.getTypeManager().getCrossLinkRelationType(relationTypeID);
        RepositoryRelationContributionTypeCardinality rcTypeCardinality = relationType.getRelationContributionType(roleID).getCardinality();
        try {
            int relationsCounter = 0;
            try {
                ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution relationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)roleID, (IRepositoryPropertySetSample)objectID);
                IRepositoryIterator_ICrossLinkRepositoryRelation existingRelations = RepositoryReferences.getAllRelationsFromReference((ICrossLinkRepositoryRelationsReference)relationsReference, (IRepositorySnapshotRO)((IRepositorySnapshotRO)this.repositoryAccessAgent.getSnapshot()));
                while (existingRelations.hasNext()) {
                    ++relationsCounter;
                    existingRelations.nextIRepositoryRelation();
                }
            }
            catch (EXMissingCrossLinkTarget relationsReference) {
                // empty catch block
            }
            ICollection_<ICrossLinkRepositoryRelationSample> newRelations = this.job.getNewRelations(relationTypeID);
            for (ICrossLinkRepositoryRelationSample newRelation : newRelations) {
                if (!IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)newRelation.getObjectID(roleID), (Object)objectID)) continue;
                ++relationsCounter;
            }
            ICollection_<ICrossLinkRepositoryRelationReference> deletedRelations = this.job.getDeletedRelations(relationTypeID);
            for (ICrossLinkRepositoryRelationReference deletedRelation : deletedRelations) {
                if (!IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)deletedRelation.getObjectID(roleID), (Object)objectID)) continue;
                --relationsCounter;
            }
            boolean checkFailed = false;
            if (rcTypeCardinality == RepositoryRelationContributionTypeCardinality.C0_1) {
                if (relationsCounter > 1) {
                    checkFailed = true;
                }
            } else if (rcTypeCardinality == RepositoryRelationContributionTypeCardinality.C1_1) {
                if (relationsCounter != 1) {
                    checkFailed = true;
                }
            } else if (rcTypeCardinality == RepositoryRelationContributionTypeCardinality.C1_n && relationsCounter < 1) {
                checkFailed = true;
            }
            if (checkFailed) {
                EXCrossLinkRCTypeCardinalityViolated e = new EXCrossLinkRCTypeCardinalityViolated(relationType, roleID, objectID, rcTypeCardinality);
                throw new EEXRelationCardinalityViolation((Exception)e, RepositoryAccessExceptionLabelProvider.getIconForException((RepositoryAccessException)e));
            }
        }
        catch (EXNotReproducibleSnapshot eNRS) {
            throw new EEXNotReproducibleSnapshot((Exception)((Object)eNRS));
        }
    }

    public void updateRelationChangeSetsAccordingToNewCurrentState(Object relationTypeID, Object roleID, Object objectID) throws EEXNotReproducibleSnapshot, EEXSnapshotClosed {
        IRepositoryRelationTypeID repositoryRelationTypeID = (IRepositoryRelationTypeID)relationTypeID;
        IRepositoryRelationContributionRoleID firstObjectRoleID = (IRepositoryRelationContributionRoleID)roleID;
        IRepositoryPropertySetSample firstObjectID = (IRepositoryPropertySetSample)objectID;
        ICollection_<ICrossLinkRepositoryRelationSample> relationsToBeAdded = this.job.getNewRelations(repositoryRelationTypeID);
        ICollection_<ICrossLinkRepositoryRelationReference> relationsToBeDeleted = this.job.getDeletedRelations(repositoryRelationTypeID);
        ArrayList<Object> relationSamples = new ArrayList<Object>();
        for (ICrossLinkRepositoryRelationSample relationSample : relationsToBeAdded) {
            boolean exists = this.repositoryAccessAgent.getCurrentModelAndModificationsAccessAgent().relationExists(relationSample);
            if (!exists) continue;
            relationSamples.add(relationSample);
        }
        int i = 0;
        while (i < relationSamples.size()) {
            this.removeNewRelation(repositoryRelationTypeID, (ICrossLinkRepositoryRelationSample)relationSamples.get(i));
            ++i;
        }
        relationSamples.clear();
        for (ICrossLinkRepositoryRelationReference relationReference : relationsToBeDeleted) {
            CrossLinkRepositoryRelationSample relationSample = new CrossLinkRepositoryRelationSample(repositoryRelationTypeID, relationReference.getRoleID2ObjectIDMap());
            boolean exists = this.repositoryAccessAgent.getCurrentModelAndModificationsAccessAgent().relationExists(relationSample);
            if (exists) continue;
            relationSamples.add(relationSample);
        }
        i = 0;
        while (i < relationSamples.size()) {
            this.removeDeletedRelation(repositoryRelationTypeID, (ICrossLinkRepositoryRelationSample)relationSamples.get(i));
            ++i;
        }
        relationSamples.clear();
        for (ICrossLinkRepositoryRelationSample relationSample : relationsToBeAdded) {
            if (this.repositoryAccessAgent.getCurrentModelAndModificationsAccessAgent().relationContributorExists(firstObjectRoleID, firstObjectID, relationSample)) continue;
            relationSamples.add(relationSample);
        }
        i = 0;
        while (i < relationSamples.size()) {
            this.removeNewRelation(repositoryRelationTypeID, (ICrossLinkRepositoryRelationSample)relationSamples.get(i));
            ++i;
        }
    }

    private void removeNewRelation(IRepositoryRelationTypeID relationTypeID, ICrossLinkRepositoryRelationSample newRelationSample) {
        this.job.removeNewRelation(relationTypeID, newRelationSample);
    }

    private void removeDeletedRelation(IRepositoryRelationTypeID relationTypeID, ICrossLinkRepositoryRelationSample relationSample) {
        ICrossLinkRepositoryRelationReference relationReference = EditorJobAccessAgent.getRelationReferenceForRelationSample(relationSample);
        this.job.removeDeletedRelation(relationTypeID, relationReference);
    }

    private ICrossLinkRepositoryRelationSample getRelationSampleForEditorValue(IRepositoryRelationTypeID relationTypeID, IRepositoryRelationContributionRoleID firstObjectRoleID, IRepositoryPropertySetSample firstObjectID, IRepositoryObjectReference secondObjectReference) {
        IRepositoryObjectTypeID secondObjectObjectTypeID;
        IRepositoryObjectType secondObjectObjectType;
        CrossLinkRepositoryRelationSample relationSample = null;
        IRepositoryTypeManagerRO typeManager = this.repositoryInterface.getTypeManager();
        IRepositoryRelationContributionRoleID firstObjectRelationContributionRoleID = firstObjectRoleID;
        IRepositoryPropertySetSample firstObjectObjectID = firstObjectID;
        IRepositoryPropertySetSample secondObjectObjectID = secondObjectReference.getObjectID();
        ICrossLinkRepositoryRelationType relationType = typeManager.getCrossLinkRelationType(relationTypeID);
        ICrossLinkRepositoryRelationContributionType firstRelationContributionType = relationType.getRelationContributionType(firstObjectRelationContributionRoleID);
        IList_ possibleRelationContributionTypes = RepositoryTypes.findPossibleRelationContributionTypes((ICrossLinkRepositoryRelationContributionType)firstRelationContributionType, (IRepositoryObjectType)(secondObjectObjectType = typeManager.getObjectType(secondObjectObjectTypeID = secondObjectReference.getObjectTypeID())));
        Assert.checkArgument((possibleRelationContributionTypes.size() > 0 ? 1 : 0) != 0);
        if (possibleRelationContributionTypes.size() > 1) {
            logger.warn("There were more than one possible relation contribution types found");
        }
        ICrossLinkRepositoryRelationContributionType choosenRelationContributionType = (ICrossLinkRepositoryRelationContributionType)possibleRelationContributionTypes.get(0);
        ICrossLinkRepositoryRelationType concreteRelationType = choosenRelationContributionType.getRelatedRelationType();
        IRepositoryRelationContributionRoleID secondObjectRelationContributionRoleID = choosenRelationContributionType.getRepositoryRelationContributionRoleID();
        HashMap_ newRelationContribution = new HashMap_(IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER);
        newRelationContribution.put((Object)firstObjectRelationContributionRoleID, (Object)firstObjectObjectID);
        newRelationContribution.put((Object)secondObjectRelationContributionRoleID, (Object)secondObjectObjectID);
        relationSample = new CrossLinkRepositoryRelationSample(concreteRelationType.getRepositoryRelationTypeID(), (IMap_)newRelationContribution);
        return relationSample;
    }

    private static ICrossLinkRepositoryRelationReference getRelationReferenceForRelationSample(ICrossLinkRepositoryRelationSample relationSample) {
        CrossLinkRepositoryRelationReference relationReference = null;
        relationReference = new CrossLinkRepositoryRelationReference(relationSample.getRelationTypeID(), relationSample.getRoleID2ObjectIDMap());
        return relationReference;
    }

    private static boolean equalRelationSamples(ICrossLinkRepositoryRelationSample relationSample1, ICrossLinkRepositoryRelationSample relationSample2) {
        return ICrossLinkRepositoryRelationSample.REPRESENTS_EQUAL_RELATIONS_HASHER.isEqual((Object)relationSample1, (Object)relationSample2);
    }

    private static boolean equalRelationControbutionRoleIDs(IRepositoryRelationContributionRoleID roleID1, IRepositoryRelationContributionRoleID roleID2) {
        return IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)roleID1, (Object)roleID2);
    }

    private static boolean equalRelationReferences(ICrossLinkRepositoryRelationReference reference1, ICrossLinkRepositoryRelationReference reference2) {
        return ICrossLinkRepositoryRelationReference.REFERENCING_EQUAL_RELATIONS_HASHER.isEqual((Object)reference1, (Object)reference2);
    }

    private static boolean equalPropertySetSamples(IRepositoryPropertySetSample sample1, IRepositoryPropertySetSample sample2) {
        return IRepositoryPropertySetSample.REPRESENTS_EQUAL_PROPERTY_SETS_HASHER.isEqual((Object)sample1, (Object)sample2);
    }
}

